import { create } from "zustand";
import { persist } from "zustand/middleware";
import type { User } from "../types";
import { users } from "../utils/users";
import createSelectors from "./create-selector";
// import { users } from "../utils/users";

type UsersStore = {
  users: User[];
  addUsers: (user: User) => void;
  updateUser: () => void;
  deleteUser: () => void;
};

const useUsersStore = create<UsersStore>()(
  persist(
    (set, get) => ({
      users: users,
      addUsers: (user: User) => {
        set({
          users: [user, ...get().users],
        });
      },
      updateUser: () => {},
      deleteUser: () => {},
    }),
    {
      name: "users",
    }
  )
);

export const usersSelector = createSelectors(useUsersStore);

export default useUsersStore;
