import { create } from "zustand";
import { devtools, persist } from "zustand/middleware";
import type { User } from "../types";
import { users } from "../utils/users";
import createSelectors from "./create-selector";

type UsersStore = {
  users: User[];
  addUsers: (user: User) => void;
  updateUser: () => void;
  deleteUser: (id: string) => void;
};

const useUsersStore = create<UsersStore>()(
  persist(
    devtools((set, get) => ({
      users: users,
      addUsers: (user: User) => {
        set({
          users: [user, ...get().users],
        });
      },
      updateUser: () => {},
      deleteUser: (id) => {
        set({
          users: get().users.filter((user) => user.id !== id),
        });
      },
    })),
    {
      name: "users",
    }
  )
);

export const usersSelector = createSelectors(useUsersStore);

export default useUsersStore;
