﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 39,41B ADJ /5502A
DATE:                  2015-04-27 16:57:38
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 11030 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       194
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        DAC,BHT
#
# Source(s):
#       Fluke 39 Power Meter / 41B Power Harmonics Analyzer
#       Service Manual. PN 601044 October 1995 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
# Additional Equipment and/or Accessories Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-                                                              V

  1.002  IF           NOT(VERSIONCHECK("8.1.4"))
  1.003  END
  1.004  ENDIF

  1.005  CALL         Sub Display Copyright

  1.006  HEAD         INITIAL INFORMATION
  1.007  CALL         Sub High Voltage Safety Warning

  1.008  HEAD         PRELIMINARY INSTRUCTIONS
  1.009  DISP         Allow the UUT to stablize in an environment
  1.009  DISP         with an ambient temperature of 18-28degC and relative
  1.009  DISP         relative humiditity of less than 70% for at least 4 hrs.

  1.010  DISP         [32]                     NOTE
  1.010  DISP         The Cal Enable switch is located in the battery
  1.010  DISP         compartment of the UUT beneath a calibration seal.
  1.010  DISP
  1.010  DISP         Remove the UUT's battery access lid and batteries.
  1.010  DISP         Remove the calibration seal to reveal the calibration
  1.010  DISP         access hole.

  1.011  DISP         In order for the UUT to remain on while replacing the
  1.011  DISP         battery door, remove the battery shunt spring and
  1.011  DISP         reinsert it with the spring's straight edge on the
  1.011  DISP         battery side of the plastic wall.  Place four fresh
  1.011  DISP         batteries in the UUT, taking care to ensure proper
  1.011  DISP         polarity.

  1.012  DISP         Press (|) to turn on the UUT and allow it to warm up for
  1.012  DISP         at least 2 minutes.

  1.013  DISP         [32]                     NOTE
  1.013  DISP         Contact bounce on the Cal Enable pads may advance the
  1.013  DISP         Cal Prompt beyond the 20A calibration range.  In the
  1.013  DISP         event this happens, turn the UUT off then on and enable
  1.013  DISP         calibration again.
  1.013  DISP
  1.013  DISP         With the instrument in an upright position, the Cal
  1.013  DISP         Enable switch pads are in the largest and leftmost hole.

  1.014  DISP         Using a small flat-blade screwdriver or equivalent
  1.014  DISP         blunt-tipped conductive object, short together the two
  1.014  DISP         Cal Enable pads.  The calibration mode is enabled when
  1.014  DISP         the UUT displays the "CAL AMP PROBE INPUT" menu and
  1.014  DISP         calibration factors.  A command arrow, on the left of
  1.014  DISP         the display, should point to the APPLY VRMS instruction
  1.014  DISP         line. Reinstall the battery access lid on the UUT.

  1.015  DISP         [32]                     NOTE
  1.015  DISP         Make sure each calibration step is complete before
  1.015  DISP         pressing ENTER on the UUT and Advance on the PC.
  1.015  DISP         Press ENTER only once for each calibration step or
  1.015  DISP         instruction.  There will be a slight delay before the
  1.015  DISP         arrow moves to the next prompt or instruction on the
  1.015  DISP         display after pressing ENTER.

  1.016  DISP         Upon completion of all calibration steps, you are
  1.016  DISP         instructed to accept the UUT's new calibration factors
  1.016  DISP         by pressing ENTER, or cancel the calibration by turning
  1.016  DISP         the UUT off.  All other button operations are ignored.

  1.017  DISP         To capture usable calibration factors, the UUT readings
  1.017  DISP         must settle to their final value.  Once the factor
  1.017  DISP         reading has stablized, press ENTER, to move to the next
  1.017  DISP         calibration step or instruction.

  1.018  DISP         If all of the calibration steps are completed and
  1.018  DISP         ACCEPT CALIBRATION is preformed by pressing ENTER, the
  1.018  DISP         new calibration factors are stored in nonvolatile
  1.018  DISP         calibration memory.

  1.019  HEAD         AMP PROBE INPUT: Zero
  1.020  DISP         Connect the Calibrator to the UUT as follows:
  1.020  DISP         [32] Calibrator NORMAL HI & LO to UUT Current Probe BNC
  1.020  DISP         [32] using a dual banana to BNC adapter.
  1.021  DISP         Press the ENTER button to start ZERO calibration.

  1.022  HEAD         -2 20 A Range
  1.023  5502E        +Voltage = 14 mV; Frequency = 60 Hz
  1.024  DISP         Press the ENTER button after the reading has settled.

  1.025  HEAD         -2 200 A Range
  1.026  5502E        +Voltage = 140 mV; Frequency = 60 Hz
  1.027  DISP         Press the ENTER button after the reading has settled.

  1.028  HEAD         -2 2000 A Range
  1.029  5502E        +Voltage = 1.4 V; Frequency = 60 Hz
  1.030  DISP         Press the ENTER button after the reading has settled.

  1.031  5502E        Standby

  1.032  HEAD         AMP PROBE INPUT: Gain
  1.033  DISP         Press the ENTER button to start GAIN calibration.

  1.034  HEAD         -2 20 A Range
  1.035  5502E        +Voltage = 14 mV; Frequency = 60 Hz
  1.036  DISP         Press the ENTER button after the reading has settled.

  1.037  HEAD         -2 200 A Range
  1.038  5502E        +Voltage = 140 mV; Frequency = 60 Hz
  1.039  DISP         Press the ENTER button after the reading has settled.

  1.040  HEAD         -2 2000 A Range
  1.041  5502E        +Voltage = 1.4 V; Frequency = 60 Hz
  1.042  DISP         Press the ENTER button after the reading has settled.

  1.043  5502E        Standby
  1.044  DISP         Disconnect the 5520A from the UUT

  1.045  HEAD         VOLTS INPUT: Zero
  1.046  DISP         Press the ENTER button to switch to Voltage calibration.
  1.047  DISP         Connect the Calibrator to the UUT as follows:
  1.047  DISP         [32] Calibrator NORMAL HI to UUT V Input.
  1.047  DISP         [32] Calibrator NORMAL LO to UUT COM Input.
  1.048  DISP         Press the ENTER button to start ZERO calibration.

  1.049  HEAD         -2 250 V Range
  1.050  5502E        +Voltage = 175 V; Frequency = 60 Hz
  1.051  DISP         Press the ENTER button after the reading has settled.

  1.052  HEAD         -2 500 V Range
  1.053  5502E        +Voltage = 350 V; Frequency = 60 Hz
  1.054  DISP         Press the ENTER button after the reading has settled.

  1.055  HEAD         -2 1000 V Range
  1.056  5502E        +Voltage = 600 V; Frequency = 60 Hz
  1.057  DISP         Press the ENTER button after the reading has settled.

  1.058  5502E        Standby

  1.059  HEAD         VOLTS INPUT: Gain
  1.060  DISP         Press the ENTER button to start GAIN calibration.

  1.061  HEAD         -2 250 V Range
  1.062  5502E        +Voltage = 175 V; Frequency = 60 Hz
  1.063  DISP         Press the ENTER button after the reading has settled.

  1.064  HEAD         -2 500 V Range
  1.065  5502E        +Voltage = 350 V; Frequency = 60 Hz
  1.066  DISP         Press the ENTER button after the reading has settled.

  1.067  HEAD         -2 1000 V Range
  1.068  5502E        +Voltage = 600 V; Frequency = 60 Hz
  1.069  DISP         Press the ENTER button after the reading has settled.

  1.070  5502E        Standby

  1.071  HEAD         -2
  1.072  DISP         Press the ENTER button to accept calibration factors or
  1.072  DISP         turn off the UUT to abort the calibration.
  1.073  END
