﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 175/177/179 (1 yr) AC Voltage VER /5502
INSTRUMENT:            Sub Fluke 175/177/179 (1 yr) Resistance VER /5502
INSTRUMENT:            Sub Fluke 175/177/179 (1 yr) Capacitance VER /5502
INSTRUMENT:            Sub Fluke 175/177/179 (1 yr) Continuity VER /5502
INSTRUMENT:            Sub Fluke 175/177/179 (1 yr) Diode Test VER /5502
DATE:                  2013-11-20 08:19:12
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       22
NUMBER OF LINES:       228
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        MSD, DAC, VY
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#        CAPACITANCE
#          900 nF; TUR 3.9385
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         AC_VOLTAGE                   PSUBI("AC Voltage")
  1.002  JMPL         RESISTANCE                   PSUBI("Resistance")
  1.003  JMPL         CAPACITANCE                  PSUBI("Capacitance")
  1.004  JMPL         CONTINUITY                   PSUBI("Continuity")
  1.005  JMPL         DIODE_TEST                   PSUBI("Diode Test")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub Fluke 175/177/179 (1 yr) ACV VER /5502  ========================

  2.001  LABEL        AC_VOLTAGE
  2.002  RSLT         =
  2.003  HEAD         {AC VOLTAGE}
  2.004  RSLT         =
  2.005  HEAD         -2{ 600 mV Range}
  2.006  TARGET       -p
  2.007  DISP         Rotate the UUT function switch to OFF then to VAC.
  2.008  PIC          5520_17x_2w.jpg
  2.009  5502E        +Voltage = 300.0 mV; Frequency = 45 Hz
  2.010  TARGET       -m
  2.011  MEMI         Enter UUT reading in millivolts AC:
  2.012  MEMCX  600   300.0mV        1% 0.3U       45Hz

  3.001  RSLT         =
  3.002  HEAD         -2{ 6 V Range}
  3.003  TARGET       -p
  3.004  5502E        +Voltage = 5.000 V; Frequency = 500 Hz
  3.005  TARGET       -m
  3.006  MEMI         Enter UUT reading in volts AC:
  3.007  MEMCX  6     5.000V         1% 0.003U     500Hz

  4.001  5502E        +Voltage = 5.000 V; Frequency = 1 kHz
  4.002  TARGET       -m
  4.003  MEMI         Enter UUT reading in volts AC:
  4.004  MEMCX  6     5.000V         2% 0.003U     1kHz

  5.001  RSLT         =
  5.002  HEAD         -2{ 60 V Range}
  5.003  TARGET       -p
  5.004  5502E        +Voltage = 50.00 V; Frequency = 45 Hz
  5.005  MEMI         Enter UUT reading in volts AC:
  5.006  MEMCX  60    50.00V         1% 0.03U      45Hz

  6.001  5502E        +Voltage = 50.00 V; Frequency = 1 kHz
  6.002  TARGET       -m
  6.003  MEMI         Enter UUT reading in volts AC:
  6.004  MEMCX  60    50.00V         2% 0.03U      1kHz

  7.001  RSLT         =
  7.002  HEAD         -2{ 600 V Range}
  7.003  TARGET       -p
  7.004  5502E        +Voltage = 300.0 V; Frequency = 45 Hz
  7.005  TARGET       -m
  7.006  MEMI         Enter UUT reading in volts AC:
  7.007  MEMCX  600   300.0V         1% 0.3U       45Hz

  8.001  5502E        +Voltage = 500.0 V; Frequency = 500 Hz
  8.002  TARGET       -m
  8.003  MEMI         Enter UUT reading in volts AC:
  8.004  MEMCX  600   500.0V         1% 0.3U       500Hz

  9.001  5502E        +Voltage = 500.0 V; Frequency = 1 kHz
  9.002  TARGET       -m
  9.003  MEMI         Enter UUT reading in volts AC:
  9.004  MEMCX  600   500.0V         2% 0.3U       1kHz

 10.001  RSLT         =
 10.002  HEAD         -2{ 1000 V Range}
 10.003  TARGET       -p
 10.004  5502E        +Voltage = 1000 V; Frequency = 45 Hz
 10.005  TARGET       -m
 10.006  MEMI         Enter UUT reading in volts AC:
 10.007  MEMCX  1000  1000V          1% 3U         45Hz

 11.001  HEAD         -2
 11.002  5502E        Standby

 11.003  RSLT         =
 11.004  HEAD         {AC VOLTAGE FREQUENCY}
 11.005  RSLT         =
 11.006  HEAD         -2{ 99.99 Hz Range}
 11.007  TARGET       -p
 11.008  DISP         Press the YELLOW button to select Hz.
 11.009  TARGET       -m
 11.010  5502E        +Frequency = 45.00 Hz; Voltage = 1 V
 11.011  TARGET       -m
 11.012  MEMI         Enter UUT reading in hertz:
 11.013  MEMCX  99.99 45.00H         0.1% 0.01U    1V

 12.001  RSLT         =
 12.002  HEAD         -2{ 99.99 kHz Range}
 12.003  TARGET
 12.004  5502E        +Frequency = 50.00 kHz; Voltage = 5 V
 12.005  TARGET       -m
 12.006  MEMI         Enter UUT reading in kilohertz:
 12.007  MEMCX  99.99 50.00kH        0.1% 0.01U    5V

 13.001  HEAD         -2
 13.002  HEAD
 13.003  5502E        Standby
 13.004  END

 13.005  EVAL   Increment step number

# =====  Sub Fluke 175/177/179 (1 yr) Resistance VER /5502  =================

 14.001  LABEL        RESISTANCE
 14.002  RSLT         =
 14.003  HEAD         {RESISTANCE}
 14.004  RSLT         =
 14.005  HEAD         -2{ 600 Ω Range}
 14.006  TARGET       -p
 14.007  DISP         Rotate the UUT function switch to Ohms.
 14.008  PIC          5520_17x_cw.jpg
 14.009  5502E        LeadCompensation = 2Wire;
 14.009  5502E        +Resistance = 500.0 Ohms
 14.010  TARGET       -m
 14.011  MEMI         Enter UUT reading in ohms:
 14.012  MEMCX  600   500.0Z         0.9% 0.2U

 15.001  RSLT         =
 15.002  HEAD         -2{ 50 MΩ Range}
 15.003  TARGET       -p
 15.004  5502E        +Resistance = 19.00 MOhms
 15.005  TARGET       -m
 15.006  MEMI         Enter UUT reading in megohms:
 15.007  MEMCX  50    19.00MZ        1.5% 0.03U

 16.001  HEAD         -2
 16.002  HEAD
 16.003  5502E        Standby
 16.004  END

 16.005  EVAL   Increment step number

# =====  Sub Fluke 175/177/179 (1 yr) Capacitance VER /5502  ================

 17.001  LABEL        CAPACITANCE
 17.002  RSLT         =
 17.003  HEAD         {CAPACITANCE}
 17.004  RSLT         =
 17.005  HEAD         -2{ 1000 nF Range}
 17.006  TARGET       -p
 17.007  DISP         Press the YELLOW button to select Capacitance.
 17.008  5502E        LeadCompensation = 2Wire;
 17.008  5502E        +Capacitance = 900 nF
 17.009  TARGET       -m
 17.010  MEMI         Enter UUT reading in nanofarads:
 17.011  MEMCX  1000  900nF          1.2% 2U
#! WARNING: Test Tol 1.28e-008, Sys Tol 3.25e-009 F, TUR 3.9385 (< 4.00).

 18.001  HEAD         -2
 18.002  HEAD
 18.003  5502E        Standby
 18.004  END

 18.005  EVAL   Increment step number

# =====  Sub Fluke 175/177/179 (1 yr) Continuity VER /5502  =================

 19.001  LABEL        CONTINUITY
 19.002  RSLT         =
 19.003  HEAD         CONTINUITY
 19.004  TARGET
 19.005  DISP         Rotate the UUT function switch to Continuity.
 19.006  5502E        LeadCompensation = 2Wire;
 19.006  5502E        +Resistance = 25 Ohms
 19.007  OPBR         -z Is the beeper on?
 19.008  MATH         L[1] = MEM1
 19.009  5502E        LeadCompensation = 2Wire;
 19.009  5502E        +Resistance = 250 Ohms
 19.010  OPBR         -z Is the beeper off?
 19.011  MATH         L[2] = MEM1
 19.012  EVAL   -e L[1] && L[2] : CONTINUITY

 20.001  HEAD
 20.002  5502E        Standby
 20.003  END

 20.004  EVAL   Increment step number

# =====  Sub Fluke 175/177/179 (1 yr) Diode Test VER /5502  =================

 21.001  LABEL        DIODE_TEST
 21.002  RSLT         =
 21.003  HEAD         {DIODE TEST}
 21.004  TARGET       -p
 21.005  DISP         Press the YELLOW button to select Diode Test.
 21.006  PIC          5520_17x_2w.jpg
 21.007  5502E        +Voltage = 2.000 V
 21.008  TARGET       -m
 21.009  MEMI         Enter UUT reading in volts DC:
 21.010  MEMCX        2.000V         1% 0.002U

 22.001  HEAD
 22.002  5502E        Standby
 22.003  END
