﻿© 2007 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub MET/CAL Version Check
DATE:                  2007-03-01 09:15:07
AUTHOR:                Fluke
REVISION:              $Revision: 6657 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       116
=============================================================================
#
#  Procedure Author:
#    DAC
#
#  Compatibility:
#    5500/CAL or MET/CAL V7.20 later
#
#  Subprocedures:
#    None
#
#  Required Files:
#    None
#
#  Example Usage:
#
#    1.001  MATH         @ReqMetCalVersion = "7.20"
#    1.003  CALL         Sub MET/CAL Version Check
#
#    1.004  IF           NOT(@MetCalVersionOK)
#    1.005  DISP         This procedure require MET/CAL or 5500/CAL 7.20 or
#    1.006  DISP         later.
#    1.007  END
#    1.008  ENDIF
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         MetCalVersion = VERS()

# If required version is greater than current version...
  1.002  IF           @ReqMetCalVersion > MetCalVersion
  1.003  MATH         @MetCalVersionOK = 0

# If required version is less than current version...
  1.004  ELSEIF       @ReqMetCalVersion < MetCalVersion
  1.005  MATH         @MetCalVersionOK = 1

# if required version is not an interim release...
  1.006  ELSEIF       LEN(@ReqMetCalVersion) < 5
  1.007  MATH         @MetCalVersionOK = 1

# if required version is an interim release and no interim version released...
  1.008  ELSEIF       LEN(MetCalVersion) < 5
  1.009  MATH         @MetCalVersionOK = 0

# Required version is an interim release and current version is an interim
# release.  Check version suffix.
  1.010  ELSE
  1.011  MATH         ReqMetCalVerSuffix = SUB(@ReqMetCalVersion, 5, 1)
  1.012  MATH         MetCalVerSuffix = SUB(MetCalVersion, 5, 1)

# Make sure required suffix is is a-z or A-Z.
  1.013  IF           LEN(ReqMetCalVerSuffix) == 1
  1.014  MATH         ReqSuffix = CTOI(ReqMetCalVerSuffix)
  1.015  MATH         L[1] = ReqSuffix >= CTOI("a")
  1.016  MATH         L[1] = ReqSuffix <= CTOI("z") && L[1]
  1.017  MATH         L[2] = ReqSuffix >= CTOI("A")
  1.018  MATH         L[2] = ReqSuffix <= CTOI("Z") && L[2]

  1.019  IF           L[1] || L[2]
  1.020  MATH         VersionSuffixOK = 1
  1.021  ELSE
  1.022  MATH         VersionSuffixOK = 0
  1.023  ENDIF

  1.024  ELSE
  1.025  MATH         VersionSuffixOK = 0
  1.026  ENDIF

  1.027  IF           NOT(VersionSuffixOK)
  1.028  DISP         Error in "Sub Check MET/CAL Version".
  1.028  DISP
  1.028  DISP         @ReqMetCalVersion suffix must be a-z or A-Z.
  1.029  MATH         @MetCalVersionOK = 0
  1.030  END
  1.031  ENDIF

  1.032  MATH         Suffix = CTOI(MetCalVerSuffix)

# MET/CAL considers a version with a capital letter suffix to be a later
# release than a service pack with a lowercase letter suffix. However, the
# SCII standard assigns a lower numeric value to capital letters than their
# lowercase equivalent.  To compensate for this in the numeric comparison
# below, uppercase letters are doubled for determination of minimum required
# version.

  1.033  IF           ReqSuffix < CTOI("a")
  1.034  MATH         ReqSuffix = ReqSuffix * 2
  1.035  ENDIF

  1.036  IF           Suffix < CTOI("a")
  1.037  MATH         Suffix = Suffix * 2
  1.038  ENDIF

  1.039  IF           ReqSuffix > Suffix
  1.040  MATH         @MetCalVersionOK = 0
  1.041  ELSE
  1.042  MATH         @MetCalVersionOK = 1
  1.043  ENDIF

  1.044  ENDIF

  1.045  END
