﻿Fluke                                                       MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Chan Delay IEEE /9500+4Hd
DATE:                  2009-07-01 13:46:38
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       2
NUMBER OF LINES:       134
CONFIGURATION:         Datron 9500 (C5)
CONFIGURATION:         Datron 9510 on channel 1
CONFIGURATION:         Datron 9510 on channel 2
CONFIGURATION:         Datron 9510 on channel 3
CONFIGURATION:         Datron 9510 on channel 4
=============================================================================
#
#  Procedure Author:
#        GCM, DFM, DAC, VY
#
#  Model(s) Covered:
#        TDS5000 Series:  TDS 5054, TDS 5104
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub Tek TDS5000 Channel Select IEEE
#        Sub Tek TDS5000 Read Time by Cursor Walker IEEE
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# 9500, four same type Active Heads:
# In the subsequent Channel delay tests, the 9500 dual leveled sine mode
# is used to supply an identical signal level simultaneously to the Channel 1
# and in turn to the Channel 2, 3, 4 inputs for 4 Channels models.

  1.001  RSLT         =
  1.002  HEAD         {CHECK DELAY BETWEEN CHANNELS}
  1.003  TSET         NTHROW = 0; NMEAS = 1
  1.004  TARGET
  1.005  CALL         Sub Tek TDS5000 Channel Select IEEE
  1.006  IEEE         SELECT:CH2 ON
  1.007  IEEE         CH1:TER 50;SCA 100E-3
  1.007  IEEE         CH2:TER 50;SCA 100E-3
  1.008  IEEE         ACQ:MODE AVE;NUMAV 16
  1.009  IEEE         HOR:SCA 500E-12

# 9500 works in dual sine mode and result in Channel 1 and Channel 2
# 8 division waveform on the screen with vertical attenuation set to
# 100 mV/div.
  1.010  M9500                       CH12
  1.011  9500         800mVpp                      250MH          LS    S  L

  1.012  IEEE         HOR:SCA 200E-12

# Save Channel 2 waveform into memory file
  1.013  IEEE         [D1000]SAVE:WAVE CH2,REF2
  1.014  IEEE         SELECT:CH2 OFF

# 9500 works in dual sine mode and result in Channel 1 and Channel 3
# 8 division waveform on the screen with vertical attenuation set to
# 100 mV/div.
  1.015  M9500                       CH13
  1.016  9500         800mVpp                      250MH          LS    S  L
# Save Channel 3 waveform into memory file
  1.017  IEEE         SELECT:CH3 ON
  1.018  IEEE         CH3:TER 50;SCA 100E-3
  1.019  IEEE         [D1000]SAVE:WAVE CH3,REF3
  1.020  IEEE         SELECT:CH3 OFF

# 9500 works in dual sine mode and result in Channel 1 and Channel 4
# 8 division waveform on the screen with vertical attenuation set to
# 100 mV/div.
  1.021  M9500                       CH14
  1.022  9500         800mVpp                      250MH          LS    S  L
  1.023  IEEE         SELECT:CH4 ON
  1.024  IEEE         CH4:TER 50;SCA 100E-3
# Recall the saved Channel 2 and 3 waveforms.
  1.025  IEEE         RECALL:WAVE "TDS_REF2.wfm",REF2
  1.025  IEEE         RECALL:WAVE "TDS_REF3.wfm",REF3

# Get the horizontal time of Channel 1 when the waveform cross the zero.
  1.026  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH1;STATE ON
  1.027  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  1.028  MATH         M[1] = @TimeVal
# Get the horizontal time of Channel 2 when the waveform cross the zero.
  1.029  IEEE         CURS:FUNC PAI;MOD IND;SOU1 REF2;STATE ON
  1.030  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  1.031  MATH         M[2] = @TimeVal

# Get the horizontal time of Channel 3 when the waveform cross the zero.
  1.032  IEEE         CURS:FUNC PAI;MOD IND;SOU1 REF3;STATE ON
  1.033  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  1.034  MATH         M[3] = @TimeVal

# Get the horizontal time of Channel 4 when the waveform cross the zero.
  1.035  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH4;STATE ON
  1.036  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  1.037  MATH         M[4] = @TimeVal

# Calculate the maximum delay between four Channels.
  1.038  MATH         MEM = MAX(1, 4) - MIN(1, 4)
# 25 ps is 9500 Dual Leveled-sine Head-to-Head time accuracy.
  1.039  ACC          ps             25U
  1.040  MEMCX        0.0ps          +100U

  2.001  HEAD
  2.002  M9500        *
  2.003  9500         *                                                 S
  2.004  END

