﻿Fluke                                                       MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5000 (1 yr) DCV Meas Acc IEEE /9500
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Channel Delay IEEE /9500
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Sample Rate IEEE /9500
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Signal Out IEEE /9500
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Probe Comp IEEE /9500
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Trig Time Acc IEEE /9500
DATE:                  2009-06-26 15:09:53
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       27
NUMBER OF LINES:       702
CONFIGURATION:         Datron 9500
CONFIGURATION:         Datron 9510 on channel 1
=============================================================================
#
#  Procedure Author:
#        GCM, DFM, DAC, VY
#
#  Model(s) Covered:
#        TDS5000 Series:  TDS 5052, TDS 5054, TDS 5104
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub Tek TDS5000 Channel Select IEEE
#        Sub Tek TDS5000 Read Time by Cursor Walker IEEE
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         DCV_MEAS_ACC                 PSUBI("DCV Meas Acc")
  1.002  JMPL         SAMPLE_RATE                  PSUBI("Sample Rate")
  1.003  JMPL         CHANNEL_DELAY                PSUBI("Channel Delay")
  1.004  JMPL         SIGNAL_OUT                   PSUBI("Signal Out")
  1.005  JMPL         PROBE_COMPENSATION_SIGNAL    PSUBI("Probe Comp")
  1.006  JMPL         TRIGGER_TIME_ACCURACY        PSUBI("Trig Time Acc")
  1.007  DISP         {Undefined subprocedure!}
  1.008  END

  1.009  EVAL   Increment step number

# ************************* DC Voltage Measurement  **************************

  2.001  LABEL        DCV_MEAS_ACC

  2.002  IF           @Chan == 1
  2.003  RSLT         =
  2.004  RSLT         =DC VOLTAGE MEASUREMENT ACCURACY
  2.005  ENDIF

  2.006  RSLT         =
  2.007  RSLT         =Channel [V @Chan]
  2.008  HEAD         DC VOLTAGE MEASUREMENT ACCURACY (CH [V @Chan])

  2.009  RSLT         =
  2.010  HEAD         -2{ 5 mV/div}
  2.011  TARGET       -p
  2.012  CALL         Sub Tek TDS5000 Channel Select IEEE
  2.013  IEEE         ACQ:MODE AVE;NUMAV 16
  2.014  IEEE         MEASU:MEAS1:SOURCE CH[V @Chan];TYPE MEAN;STATE ON
  2.015  IEEE         CH[V @Chan]:SCA 5E-3;POSITION -5;OFFS +1
  2.016  TSET         TDESC = 1.04 V Level, 1 V Offset
  2.017  9500         1.0400V                                           S
  2.018  WAIT         -t 2 Settling...
  2.019  TARGET       -m
  2.020  IEEE         MEASU:MEAS1:VAL?[I]
  2.021  MEMCX  0.005 1.0400V        0.0047U

  3.001  IEEE         CH[V @Chan]:POSITION +5;OFFS -1
  3.002  TSET         TDESC = -1.04 V Level, -1 V Offset
  3.003  9500         -1.0400V                                          S
  3.004  WAIT         -t 2 Settling...
  3.005  TARGET       -m
  3.006  IEEE         MEASU:MEAS1:VAL?[I]
  3.007  MEMCX  0.005 -1.0400V       0.0047U

  4.001  RSLT         =
  4.002  HEAD         -2{ 200 mV/div}
  4.003  TARGET       -p
  4.004  IEEE         CH[V @Chan]:SCA 200E-3;POSITION -5;OFFS +10
  4.005  TSET         TDESC = 11.6 V Level, 10 V Offset
  4.006  9500         11.6000V                                          S
  4.007  WAIT         -t 2 Settling...
  4.008  TARGET       -m
  4.009  IEEE         MEASU:MEAS1:VAL?[I]
  4.010  MEMCX  0.2   11.6000V       0.1011U

  5.001  IEEE         CH[V @Chan]:POSITION +5;OFFS -10
  5.002  TSET         TDESC = -11.6 V Level, -10 V Offset
  5.003  9500         -11.6000V                                         S
  5.004  WAIT         -t 2 Settling...
  5.005  TARGET       -m
  5.006  IEEE         MEASU:MEAS1:VAL?[I]
  5.007  MEMCX  0.2   -11.6000V      0.1011U

  6.001  RSLT         =
  6.002  HEAD         -2{ 1.01 V/div}
  6.003  TARGET       -p
  6.004  IEEE         CH[V @Chan]:SCA 1.01;POSITION -5;OFFS +10;
  6.005  TSET         TDESC = 18 V Level, 10 V Offset
  6.006  9500         18.000V                                           S
  6.007  WAIT         -t 2 Settling...
  6.008  TARGET       -m
  6.009  IEEE         MEASU:MEAS1:VAL?[I]
  6.010  MEMCX  1.01  18.000V        0.398U

  7.001  IEEE         CH[V @Chan]:POSITION +5;OFFS -10
  7.002  TSET         TDESC = -18 V Level, -10 V Offset
  7.003  9500         -18.000V                                          S
  7.004  WAIT         -t 2 Settling...
  7.005  TARGET       -m
  7.006  IEEE         MEASU:MEAS1:VAL?[I]
  7.007  MEMCX  1.01  -18.000V       0.398U

  8.001  HEAD
  8.002  HEAD         -2
  8.003  9500         *                                                 S
  8.004  END

  8.005  EVAL   Increment step number

# ******************************* Channel Delay *****************************

# 9500, single active head or multiple active heads:
# In the subsequent Channel delay tests, a power splitter is used to
# supply an identical signal level simultaneously to the Channel 1 and
# Channel 2 inputs for 2 channels models or Channel 1 and in turn to
# Channel 2, 3, 4 for 4 channels models. Because the power splitter
# output is 6 dB lower (½ the voltage input) than the input, the 9500
# output is initially set to twice the desired level at the Channel 1
# and Channel 2 inputs.

  9.001  LABEL        CHANNEL_DELAY
  9.002  RSLT         =
  9.003  HEAD         {CHECK DELAY BETWEEN CHANNELS}
  9.004  TARGET
  9.005  CALL         Sub Tek TDS5000 Channel Select IEEE
  9.006  DISP         Connect the CH 1 Active Head to the input of a 2 way
  9.006  DISP         power splitter via a BNC(f) to SMA(m) adapter.
  9.006  DISP
  9.006  DISP         Connect one output of the power splitter to UUT CH 1 via
  9.006  DISP         SMA(f) to SMA(f) and SMA(m) to BNC(f) adapters, and
  9.006  DISP         a BNC(m)-(m) cable.
  9.006  DISP
  9.006  DISP         Connect the other output of the power splitter to UUT
  9.006  DISP         CH 2 via SMA(f) to SMA(f) and SMA(m) to BNC(f) adapters,
  9.006  DISP         and a BNC(m)-(m) cable.
  9.006  DISP
  9.006  DISP         NOTE. To ensure that you do not introduce errors into
  9.006  DISP         the delay measurements, use cables that have a delay
  9.006  DISP         difference of less than 10 ps between each other. It is
  9.006  DISP         recommended that same type and length cables are used.
  9.007  IEEE         SELECT:CH2 ON
  9.008  IEEE         CH1:TER 50;SCA 100E-3
  9.008  IEEE         CH2:TER 50;SCA 100E-3
  9.009  IEEE         ACQ:MODE AVE;NUMAV 16
  9.010  IEEE         HOR:SCA 500E-12

# Set the 9500 amplitude to accommodate for the power splitter and result in a
# 8 division waveform on the screen with vertical attenuation set to
# 100 mV/div.
  9.011  9500         1600mVpp                     250MH          LS    S  L
  9.012  IEEE         [D1000]TRIG:A SETL
  9.013  IEEE         HOR:SCA 200E-12

  9.014  IF           @NumChan == 2
# Get the horizontal time of Channel 1 when the waveform cross the zero.
  9.015  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH1;STATE ON
  9.016  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.017  MATH         M[1] = @TimeVal

# Get the horizontal time of Channel 2 when the waveform cross the zero.
  9.018  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH2;STATE ON
  9.019  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.020  MATH         M[2] = @TimeVal

# Calculate the maximum delay between two Channels
  9.021  MATH         MEM = MAX(1, 2) - MIN(1, 2)

  9.022  ELSE
# Save Channel 2 waveform into memory file
  9.023  IEEE         [D1000]SAVE:WAVE CH2,REF2
  9.024  IEEE         SELECT:CH2 OFF

  9.025  DISP         Move the cable from CH 2 to CH 3, so that CH 1 and CH 3
  9.025  DISP         are driven.
# Save Channel 3 waveform into memory file
  9.026  IEEE         SELECT:CH3 ON
  9.027  IEEE         CH3:TER 50;SCA 100E-3
  9.028  IEEE         [D1000]SAVE:WAVE CH3,REF3
  9.029  IEEE         SELECT:CH3 OFF

  9.030  DISP         Move the cable from CH 3 to CH 4, so that CH 1 and CH 4
  9.030  DISP         are driven.
  9.031  IEEE         SELECT:CH4 ON
  9.032  IEEE         CH4:TER 50;SCA 100E-3

# Recall the saved Channel 2 and 3 waveforms.
  9.033  IEEE         RECALL:WAVE "TDS_REF2.wfm",REF2
  9.033  IEEE         RECALL:WAVE "TDS_REF3.wfm",REF3

# Get the horizontal time of Channel 1 when the waveform cross the zero.
  9.034  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH1;STATE ON
  9.035  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.036  MATH         M[1] = @TimeVal

# Get the horizontal time of Channel 2 when the waveform cross the zero.
  9.037  IEEE         CURS:FUNC PAI;MOD IND;SOU1 REF2;STATE ON
  9.038  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.039  MATH         M[2] = @TimeVal

# Get the horizontal time of Channel 3 when the waveform cross the zero.
  9.040  IEEE         CURS:FUNC PAI;MOD IND;SOU1 REF3;STATE ON
  9.041  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.042  MATH         M[3] = @TimeVal

# Get the horizontal time of Channel 4 when the waveform cross the zero.
  9.043  IEEE         CURS:FUNC PAI;MOD IND;SOU1 CH4;STATE ON
  9.044  CALL         Sub Tek TDS5000 Read Time by Cursor Walker IEEE
  9.045  MATH         M[4] = @TimeVal

# Calculate the maximum delay between four Channels.
  9.046  MATH         MEM = MAX(1, 4) - MIN(1, 4)
  9.047  ENDIF

  9.048  MATH         Result = FMT((MEM / 1E-12), "%.1f")
  9.049  MEM2         = Limit : <= 100 ps, Result: [V Result] ps
  9.050  EVAL   -e MEM <= 100E-12 : [MEM2]

 10.001  HEAD
 10.002  9500         *                                                 S

 10.003  IF           @NumChan == 2
 10.004  DISP         Remove the cable from the UUT CH 1, CH 2.

 10.005  ELSE
 10.006  DISP         Remove the cable from the UUT CH 1, CH 4.
 10.007  ENDIF

 10.008  END

 10.009  EVAL   Increment step number

# ******************************** Sample Rate *****************************

 11.001  LABEL        SAMPLE_RATE
 11.002  RSLT         =
 11.003  RSLT         =TIME BASE SYSTEM CHECKS
 11.004  RSLT         =
 11.005  HEAD         {SAMPLE RATE AND DELAY TIME ACCURACY}
 11.006  TARGET
 11.007  CALL         Sub Tek TDS5000 Channel Select IEEE
 11.008  IEEE         CH[V @Chan]:TER 50;SCA 200E-3
 11.009  IEEE         HOR:SCA 80E-9
 11.010  9500         10mT                         1Vpp           M2    S  L
 11.011  IEEE         [D200]TRIG:A SETL[D800]
 11.012  IEEE         TRIG:A:MOD NORM
 11.013  IEEE         CH[V @Chan]:POS 0
 11.014  WAIT         [D1000]
 11.015  IEEE         HOR:MAI:DEL:MOD ON;TIM 10E-3
 11.016  MESS         Does the rising edge of the marker cross the center
 11.016  MESS         horizontal graticule line within ±1.9 divisions of
 11.016  MESS         center graticule?
 11.017  MEM2         = Limit : ±1.9 div @ 80 ns/div, 10.0 ms delay time
 11.018  EVAL   -s MEM2 :

 12.001  MESS
 12.002  9500         *                                                 S
 12.003  END

 12.004  EVAL   Increment step number

# ******************************** Signal Out *****************************

 13.001  LABEL        SIGNAL_OUT
 13.002  RSLT         =
 13.003  RSLT         =OUTPUT SIGNAL CHECKS
 13.004  RSLT         =
 13.005  HEAD         { AUX TRIG OUT TEST}
 13.006  TARGET
 13.007  CALL         Sub Tek TDS5000 Channel Select IEEE
 13.008  DISP         Connect the CH 1 Active Head to the UUT CH 3.
# Get the current channel value under test for using in below subprocedures.
 13.009  IEEE         CH[V @Chan]:TER 50;SCA 100E-3
 13.010  IEEE         HOR:SCA 200E-6
 13.011  IEEE         TRIG:A:MOD NORM;TYPE EDGE
 13.012  IEEE         TRIG:A:EDGE:SOU CH[V @Chan]
 13.013  IEEE         MEASU:METH MINM
 13.014  9500         0.5Vpp                       1kH            SQ    S  L
 13.015  WAIT         -t 2 Settling...
 13.016  IEEE         TRIG:A SETL
 13.017  IEEE         ACQ:MODE AVE;NUMAV 64
 13.018  DISP         Connect the UUT AUX OUT(on rear) to the UUT CH 2 via
 13.018  DISP         a BNC(m)-(m) 50 ohm cable.
 13.018  DISP
 13.018  DISP         Leave the CH 1 Active Head connected to the UUT CH 3.
 13.019  IEEE         SELECT:CH[V @Chan] OFF;CH2 ON
 13.020  IEEE         CH2:SCA 1;POS 0
 13.021  IEEE         MEASU:MEAS1:SOU CH2;TYPE HIGH;STATE ON
 13.022  IEEE         MEASU:MEAS2:SOU CH2;TYPE LOW;STATE ON
 13.023  WAIT         -t 2 Settling...
 13.024  IEEE         TRIG:A SETL
 13.025  IEEE         MEASU:MEAS1:VAL?[I]
 13.026  MATH         S[10] = FMT(MEM, "%.1f")
 13.027  MEM2         = High Limit (Open Circuit) : >= 2.5 V, Result: [S10] V
 13.028  EVAL   -e MEM >= 2.5 : [MEM2]

 14.001  9500         0.5Vpp                       1kH            SQ    S  L
 14.002  WAIT         -t 2 Settling...
 14.003  IEEE         TRIG:A SETL
 14.004  IEEE         MEASU:MEAS2:VAL?[I]
 14.005  MATH         S[10] = FMT(MEM, "%.1f")
 14.006  MEM2         = LOW Limit (Open Circuit) : <= 0.7 V, Result: [S10] V
 14.007  EVAL   -e MEM <= 0.7 : [MEM2]

 15.001  9500         0.5Vpp                       1kH            SQ    S  L
 15.002  WAIT         -t 2 Settling...
 15.003  IEEE         TRIG:A SETL
 15.004  IEEE         CH2:TER 50
 15.005  IEEE         MEASU:MEAS1:VAL?[I]
 15.006  MATH         S[10] = FMT(MEM, "%.1f")
 15.007  MEM2         = High Limit (50 ohm) : >= 1.0 V, Result: [S10] V
 15.008  EVAL   -e MEM >= 1.0 : [MEM2]

 16.001  9500         0.5Vpp                       1kH            SQ    S  L
 16.002  WAIT         -t 2 Settling...
 16.003  IEEE         TRIG:A SETL
 16.004  IEEE         MEASU:MEAS2:VAL?[I]
 16.005  MATH         S[10] = FMT(MEM, "%.2f")
 16.006  MEM2         = LOW Limit (50 ohm) : <= 0.25 V, Result: [S10] V
 16.007  EVAL   -e MEM <= 0.25 : [MEM2]
 17.001  IEEE         MEASU:MEAS1:STATE OFF
 17.002  IEEE         MEASU:MEAS2:STATE OFF

 17.003  RSLT         =
 17.004  HEAD         { SIGNAL OUT TEST}
 17.005  TARGET
 17.006  DISP         Move the BNC(m)-(m) 50 ohm cable from the UUT AUX OUT
 17.006  DISP         to the UUT SIGNAL OUT
 17.006  DISP
 17.006  DISP         Leave the CH 1 Active Head connected to the UUT CH 3.
 17.007  IEEE         CH2:TER 1E+6;SCA 100E-3;POS 0
 17.008  IEEE         MEASU:MEAS1:SOU CH2;TYPE PK2P;STATE ON
 17.009  9500         0.5Vpp                       1kH            SQ    S  L
 17.010  WAIT         -t 2 Settling...
 17.011  IEEE         TRIG:A SETL
 17.012  IEEE         MEASU:MEAS1:VAL?[I]
 17.013  MATH         MEM = MEM / 1E-3
 17.014  MATH         S[10] = FMT(MEM, "%.0f")
 17.015  MEM2         = Limit(1 MOhm): 80 <= AMPL <= 120 mVpp
 17.016  MEM2         =[MEM2], Result: [S10] mVpp
 17.017  EVAL   -e  MEM >= 80 && MEM <= 120 : [MEM2]

 18.001  IEEE         CH2:TER 50
 18.002  9500         0.5Vpp                       1kH            SQ    S  L
 18.003  WAIT         -t 2 Settling...
 18.004  IEEE         TRIG:A SETL
 18.005  IEEE         MEASU:MEAS1:VAL?[I]
 18.006  MATH         MEM = MEM / 1E-3
 18.007  MATH         S[10] = FMT(MEM, "%.0f")
 18.008  MEM2         = Limit(50 ohm): 44 <= AMPL <= 66 mVpp
 18.009  MEM2         =[MEM2], Result: [S10] mVpp
 18.010  EVAL   -e MEM >= 44 && MEM <= 66 : [MEM2]

 19.001  HEAD
 19.002  9500         *                                                 S
 19.003  END

 19.004  EVAL   Increment step number

# ************************** Probe Compensation *****************************

 20.001  LABEL        PROBE_COMPENSATION_SIGNAL
 20.002  RSLT         =
 20.003  HEAD         {PROBE COMPENSATION SIGNAL TEST}
 20.004  TARGET
 20.005  CALL         Sub Tek TDS5000 Channel Select IEEE

 20.006  DO
 20.007  OPBR         -z Connect a 10X active oscilloscope probe, such as
 20.007  OPBR         Tektronix P5050, P6243, P6245 or a general 1X or 10X
 20.007  OPBR         oscilloscope probe to the UUT CH [V @Chan].
 20.007  OPBR         Connect the probe leads to the UUT PROBE COMP output.
 20.007  OPBR
 20.007  OPBR         It is recommended use the X1 rate of the probe in order
 20.007  OPBR         to have bigger resolution during the measurement.
 20.007  OPBR
 20.007  OPBR         Tektronix P5050, P6243, or P6245 have the circuit of
 20.007  OPBR         TEKPROBE interface that provides the communication
 20.007  OPBR         path between the probe and oscilloscope. Contact pins
 20.007  OPBR         provide power, signal, and data transfer for the probe
 20.007  OPBR         identification EEPROM. It can configure some parameters
 20.007  OPBR         of oscilloscope to the probe automatically.
 20.007  OPBR
 20.007  OPBR         Do the probe you connected have the TEKPROBE interface?

 20.008  IF           MEM1
 20.009  MATH         Probe = 1
 20.010  MATH         VerticalScale = 200E-3
 20.011  ELSE
 20.012  OPBR         -z Is your general oscilloscope probe 10X?

 20.013  IF           MEM1
 20.014  MATH         Probe = 10
 20.015  MATH         VerticalScale = 20E-3
 20.016  ELSE
 20.017  OPBR         -z Is your general oscilloscope probe 1X?

 20.018  IF           MEM1
 20.019  MATH         Probe = 1
 20.020  MATH         VerticalScale = 200E-3
 20.021  ELSE
 20.022  MATH         Probe = 0
 20.023  DISP         Your general oscilloscope probe must be 1X or 10X probe!
 20.023  DISP
 20.023  DISP         You should connect a proper one.
 20.024  ENDIF

 20.025  ENDIF

 20.026  ENDIF

 20.027  UNTIL        Probe > 0

 20.028  IEEE         CH[V @Chan]:SCA [V VerticalScale]
 20.029  IEEE         CH[V @Chan]:POS -2.5;TER 1E+6
 20.030  IEEE         HOR:SCA 200E-6
 20.031  IEEE         TRIG:A:MOD AUTO
 20.031  IEEE         TRIG:A SETL
 20.032  IEEE         ACQ:MODE AVE;NUMAV 128
 20.033  WAIT         -t 3 Settling...
# Get the high and low value of waveform, accurately shift the waveform to the
# center of the screen before saving it.
 20.034  IEEE         MEASU:MEAS1:SOU CH[V @Chan];TYPE HIGH;STATE ON
 20.035  WAIT         [D1000]
 20.036  IEEE         MEASU:MEAS1:VAL?[I]
 20.037  MATH         High = MEM / 1E-3

 20.038  IEEE         MEASU:MEAS1:SOU CH[V @Chan];TYPE LOW;STATE ON
 20.039  WAIT         [D1000]
 20.040  IEEE         MEASU:MEAS1:VAL?[I]
 20.041  MATH         Low = MEM / 1E-3

# Calculate the shift value of center the waveform on the screen based the
# vertical division.
 20.042  MATH         L[1] = -1 * (High - Low) / 2 / (VerticalScale / 1E-3)
 20.043  IEEE         CH[V @Chan]:POS [L1]
 20.044  WAIT         [D1000]
 20.045  IEEE         SAVE:WAVE CH[V @Chan],REF1
 20.046  IEEE         MEASU:MEAS1:STATE OFF

 20.047  DISP         Disconnect the oscilloscope probe from UUT CH [V @Chan]
 20.048  DISP         Connect the CH 1 Active Head to the UUT CH [V @Chan].
 20.049  IEEE         ACQ:MODE AVE;NUMAV 16
 20.050  IEEE         RECALL:WAVE "TDS_REF1.wfm",REF1
# Get the high measurement of recalled probe compensation signal.
 20.051  IEEE         MEASU:MEAS1:SOU REF1;TYPE HIGH;STATE ON
 20.052  WAIT         [D1000]
 20.053  IEEE         MEASU:MEAS1:VAL?[I]
 20.054  MATH         High = MEM / 1E-3

# Set the proper increment for loop control according the probe type.
 20.055  IF           Probe == 1
 20.056  MATH         Increment = 0.1
 20.057  ELSE
 20.058  MATH         Increment = 0.05
 20.059  ENDIF

 20.060  WAIT         [D1000]
 20.061  IEEE         MEASU:MEAS2:SOU CH[V @Chan];TYPE HIGH;STATE ON
# Set the output of the calibrator so the measurement is close to overlap
# the top (upper) level of recalled waveform.
 20.062  MATH         MEM = High; MEM1 = MEM

 20.063  DO
 20.064  MATH         MEM = MEM1 + (High - MEM) / 2

# Set the output limit trap in order to avoid calculated output exceed the
# display scale of screen too much and resulted query error because of
# unstable reading.
 20.065  MATH         L[6] = VerticalScale * 6 / 1E-3

 20.066  IF           MEM > L[6] || MEM < (-1 * L[6])
 20.067  MATH         MEM = High
 20.068  ENDIF

 20.069  9500         mV                                                S
 20.070  WAIT         [D1000]
 20.071  IEEE         MEASU:MEAS2:VAL?[I]
 20.072  MATH         MEM = MEM / 1E-3
 20.073  UNTIL        MEM >= (High - Increment) && MEM <= (High + Increment)

# Last calibrator amplitude setting is in MEM1.
 20.074  MATH         AmpHigh = MEM1

 20.075  IEEE         MEASU:MEAS1:SOU REF1;TYPE LOW;STATE ON
 20.076  WAIT         [D1000]
 20.077  IEEE         MEASU:MEAS1:VAL?[I]
 20.078  MATH         Low = MEM / 1E-3
 20.079  IEEE         MEASU:MEAS2:SOU CH[V @Chan];TYPE LOW;STATE ON
# Set the output of the calibrator so the measurement is close to overlap
# the base (below) level of recalled waveform.
 20.080  MATH         MEM = Low; MEM1 = MEM; Times = 0

 20.081  DO
 20.082  MATH         MEM = MEM1 + (Low - MEM) / 2

 20.083  IF           MEM < 0.888 && MEM > -0.888
 20.084  MATH         MEM = 0
 20.085  ENDIF

 20.086  9500         mV                                                S
 20.087  MATH         Ampl = MEM1
 20.088  WAIT         [D1000]
 20.089  IEEE         MEASU:MEAS2:VAL?[I]
 20.090  MATH         MEM = MEM / 1E-3
 20.091  MATH         Times = Times + 1
 20.092  MATH         X = MEM >= (Low - Increment) && MEM <= (Low + Increment)
 20.093  UNTIL        X || Times > 10

 20.094  MATH         AmpLow = MEM1
 20.095  MATH         MEM = (AmpHigh - AmpLow) * Probe
# Set significant digit of reading
 20.096  MATH         MEM = FRND(MEM, 5)
 20.097  MATH         Result = FMT(MEM, "%.1f")
 20.098  MEM2         = Limit: 990 <= AMPL <= 1010 mV
 20.099  MEM2         =[MEM2], Result: [V Result] mV
 20.100  EVAL   -e MEM >= 990 && MEM <= 1010 : [MEM2]

 21.001  IEEE         MEASU:MEAS1:SOU REF1;TYPE FREQ;STATE ON
 21.002  WAIT         [D1000]
 21.003  IEEE         MEASU:MEAS1:VAL?[I]
 21.004  MATH         MEM = MEM / 1E+3
 21.005  MATH         Result = FMT(MEM, "%.2f")
 21.006  MEM2         = Limit: 0.95 <= Freq <= 1.05 kHz
 21.007  MEM2         =[MEM2], Result: [V Result] kHz
 21.008  EVAL   -e MEM >= 0.95 && MEM <= 1.05 : [MEM2]

 22.001  HEAD
 22.002  9500         *                                                 S
 22.003  END

 22.004  EVAL   Increment step number

# **************************** Trigger Time Acc ************************

 23.001  LABEL        TRIGGER_TIME_ACCURACY

 23.002  IF           @Chan == 1
 23.003  RSLT         =
 23.004  RSLT         =TIME ACCURACY for PULSE,GLICH,TIMEOUT,WIDTH TRIGGERING
 23.005  ENDIF

 23.006  RSLT         =
 23.007  RSLT         =Channel [V @Chan]

 23.008  RSLT         =
 23.009  HEAD         { WIDTH TRIGGERING at 100 MHz}
 23.010  TARGET
 23.011  CALL         Sub Tek TDS5000 Channel Select IEEE
 23.012  IEEE         HOR:SCA 10E-9
 23.013  IEEE         CH[V @Chan]:TER 50;SCA 100E-3
 23.014  9500         500mVpp                      100MH          LS    S  L
 23.015  IEEE         TRIG:A:MOD NORM;TYP PUL
 23.016  IEEE         TRIG:A:PUL:SOU CH[V @Chan];CLA WID
 23.017  IEEE         TRIG:A:PUL:WID:HIGHL 10E-9;LOWL 2E-9
 23.018  IEEE         TRIG:A SETL

# Find the pulse width lower Limit setting that could make triggering lost.
 23.019  MATH         L[1] = 3.5E-9

 23.020  DO
 23.021  IEEE         TRIG:A:PUL:WID:LOWL [L1]
 23.022  CALL         Sub Tek TDS5000 Check Trig Status IEEE

 23.023  IF           @Trig
 23.024  MATH         L[1] = L[1] + 0.5E-9
 23.025  MATH         LowerLimit = 0
 23.026  ELSE
 23.027  MATH         LowerLimit = L[1]
 23.028  ENDIF

 23.029  UNTIL        L[1] > 6.5E-9 || LowerLimit != 0

 23.030  MATH         Result = FMT(L[1] / 1E-9, "%.1f") & " ns"
 23.031  MEM2         = Width Lower Limit: 3.5 ns to 6.5 ns, Result [V Result]
 23.032  EVAL   -e L[1] >= 3.5E-9 && L[1] <= 6.5E-9 :[MEM2]

# Set the pulse width lower limit back in order to reestablish triggering
 24.001  IEEE         TRIG:A:PUL:WID:LOWL 2E-9

# Find the pulse width upper Limit setting that could make triggering lost.
 24.002  MATH         L[1] = 6.5E-9

 24.003  DO
 24.004  IEEE         TRIG:A:PUL:WID:HIGHL [L1]
 24.005  CALL         Sub Tek TDS5000 Check Trig Status IEEE

 24.006  IF           @Trig
 24.007  MATH         L[1] = L[1] - 0.5E-9
 24.008  MATH         UpperLimit = 0
 24.009  ELSE
 24.010  MATH         UpperLimit = L[1]
 24.011  ENDIF

 24.012  UNTIL        L[1] < 3.5E-9 || UpperLimit != 0

 24.013  MATH         Result = FMT(L[1] / 1E-9, "%.1f") & " ns"
 24.014  MEM2         = Width Upper Limit: 3.5 ns to 6.5 ns, Result [V Result]
 24.015  EVAL   -e L[1] >= 3.5E-9 && L[1] <= 6.5E-9 : [MEM2]

# Set the pulse width upper limit back in order to reestablish triggering
 25.001  IEEE         TRIG:A:PUL:WID:HIGHL 10E-9

 25.002  9500         *                                                 S

 25.003  RSLT         =
 25.004  HEAD         { WIDTH TRIGGERING at 250 kHz}
 25.005  TARGET
 25.006  IEEE         TRIG:A:MOD NORM;TYP PUL
 25.007  IEEE         TRIG:A:PUL:SOU CH[V @Chan];CLA WID
 25.008  IEEE         TRIG:A:PUL:WID:HIGHL 4E-6;LOWL 500E-9
 25.009  IEEE         HOR:SCA 4E-6
 25.010  IEEE         CH[V @Chan]:SCA 20E-3
 25.011  9500         100mVpp                      250kH          LS    S  L
 25.012  IEEE         TRIG:A SETL

# Find the pulse width lower Limit setting that could make triggering lost.
 25.013  MATH         L[1] = 1.9E-6

 25.014  DO
 25.015  IEEE         TRIG:A:PUL:WID:LOWL [L1]
 25.016  CALL         Sub Tek TDS5000 Check Trig Status IEEE

 25.017  IF           @Trig
 25.018  MATH         L[1] = L[1] + 0.01E-6
 25.019  MATH         LowerLimit = 0
 25.020  ELSE
 25.021  MATH         LowerLimit = L[1]
 25.022  ENDIF

 25.023  UNTIL        L[1] > 2.1E-6 || LowerLimit != 0

 25.024  MATH         Result = FMT(L[1] / 1E-6, "%.1f") & " µs"
 25.025  MEM2         = Width Lower Limit: 1.9 µs to 2.1 µs, Result [V Result]
 25.026  EVAL   -e L[1] >= 1.9E-6 && L[1] <= 2.1E-6 : [MEM2]

# Set the pulse width lower limit back in order to reestablish triggering
 26.001  IEEE         TRIG:A:PUL:WID:LOWL 500E-9

# Find the pulse width upper Limit setting that could make triggering lost.
 26.002  MATH         L[1] = 2.1E-6

 26.003  DO
 26.004  IEEE         TRIG:A:PUL:WID:HIGHL [L1]
 26.005  CALL         Sub Tek TDS5000 Check Trig Status IEEE

 26.006  IF           @Trig
 26.007  MATH         L[1] = L[1] - 0.01E-6
 26.008  MATH         UpperLimit = 0
 26.009  ELSE
 26.010  MATH         UpperLimit = L[1]
 26.011  ENDIF

 26.012  UNTIL        L[1] > 2.1E-6 || UpperLimit != 0

 26.013  MATH         Result = FMT(L[1] / 1E-6, "%.1f") & " µs"
 26.014  MEM2         = Width Upper Limit: 1.9 µs to 2.1 µs, Result [V Result]
 26.015  EVAL   -e L[1] >= 1.9E-6 && L[1] <= 2.1E-6 : [MEM2]

# Set the pulse width upper limit back in order to reestablish triggering
 27.001  IEEE         TRIG:A:PUL:WID:HIGHL 4E-6

 27.002  HEAD
 27.003  9500         *                                                 S
 27.004  END
