﻿Fluke                                                       MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5000 (1 yr) Delta Time IEEE /9500
DATE:                  2009-06-26 10:18:07
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       141
CONFIGURATION:         Datron 9500
CONFIGURATION:         Datron 9510 on channel 1
=============================================================================
#
#  Procedure Author:
#        GCM, DFM, DAC, VY
#
#  Model(s) Covered:
#        TDS5000 Series:  TDS 5052, TDS 5054, TDS 5104
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub Tek TDS5000 Channel Select IEEE
#        Sub Tek TDS5000 Check Trig Status IEEE
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           @Chan == 1
  1.002  RSLT         =
  1.003  RSLT         =CHECK DELTA TIME MEASUREMENT ACCURACY
  1.004  ENDIF

  1.005  RSLT         =
  1.006  RSLT         =Channel [V @Chan]

  1.007  HEAD         CHECK DELTA TIME MEASUREMENT ACCURACY
  1.008  TARGET

  1.009  LABEL        DELTA_TIME_MEASUREMENT
  1.010  CALL         Sub Tek TDS5000 Channel Select IEEE
  1.011  IEEE         CH[V @Chan]:TER 50;SCA 100E-3
  1.012  DISP         Connect a BNC T(f-m-f) to UUT CH [V @Chan].
  1.012  DISP
  1.012  DISP         Connect the CH 1 Active Head to one side of the BNC T.
  1.012  DISP
  1.012  DISP         Connect a BNC(m) to SMA(f) adapter to the other side of
  1.012  DISP         the BNC T.
  1.012  DISP
  1.012  DISP         Connect a SMA T(f-m-f) to the BNC to SMA adapter.
  1.012  DISP
  1.012  DISP         Connect a 20" SMA (m-m) cable to each side of the SMA T.
  1.012  DISP
  1.012  DISP         Connect a SMA(f-f) adapter to the end of each SMA cable.
  1.012  DISP
  1.012  DISP         Connect a SMA(m) short to each SMA adapter.

  1.013  DO
  1.014  9500         0.5Vpp                       10kH           ED    S  L
  1.015  WAIT         -t 2 System Settling ...
  1.016  IEEE         AUTOS EXEC
  1.017  IEEE         CH[V @Chan]:BAN FUL
  1.018  IEEE         HOR:SCA 10E-9
  1.019  IEEE         ACQ:REPE OFF

# Set the trig level is 50% of rising edge of the positive pulse
  1.020  IEEE         TRIG:A:LEV 125E-3
  1.020  IEEE         CH[V @Chan]:SCA 50E-3;POS -2.5
  1.021  WAIT         -t 2 System Settling ...
  1.022  IEEE         TRIG:A:LEV 125E-3
  1.023  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  1.024  UNTIL        @Trig

# Setting the statistic parameters of measurement
  1.025  IEEE         ACQ:STATE STOP
  1.026  IEEE         MEASU:MEAS2:SOU CH[V @Chan];TYPE PWI;STATE ON
  1.027  IEEE         MEASU:STATI:MOD ALL;COUN RESET;WEI 1000
  1.028  IEEE         MEASU:REFL:METH PERC;PERC:MID 50
  1.029  IEEE         ACQ:STATE RUN
  1.030  WAIT         -t 30 Calculating Statistics...
  1.031  IEEE         ACQ:STATE STOP
  1.032  IEEE         MEASU:MEAS2:MEAN?[I]
  1.033  MATH         MeanVal = MEM / 1E-9

  1.034  IEEE         MEASU:MEAS2:MAX?[I]
  1.035  MATH         MaxVal = MEM / 1E-9

  1.036  IEEE         MEASU:MEAS2:MINI?[I]
  1.037  MATH         MinVal = MEM / 1E-9

  1.038  MATH         L[1] = MaxVal - MeanVal
  1.039  MATH         L[2] = MeanVal - MinVal
  1.040  MATH         High = FMT(L[1], "%.3f")
  1.041  MATH         Low  = FMT(L[2], "%.3f")

# The delta time measurement accuracy is 0.3 sample intervals, which sample
# intervals is equal to 1 / (real time sample rate).
#
# The real time sample rate is 5.00GS/s, so the delta time measurement
# accuracy is 0.060 ns.
  1.042  MATH         Lmt = "0.060"
  1.043  MEM2         = Limit: (Max - Mean) <= [V Lmt] ns, Result: [V High] ns
  1.044  EVAL   -e L[1] <= Lmt : [MEM2]
  2.001  JMPL         CHECK_LOW_LIMIT

# This TARGET statement is necessary, so a new measurement is taken, if the
# low limit fails, and the operator selects Repeat or Cancel in the Post Test
# dialog.
  2.002  TARGET
  2.003  JMPL         DELTA_TIME_MEASUREMENT

  2.004  LABEL        CHECK_LOW_LIMIT
  2.005  MEM2         = Limit: (Mean - Min) <= [V Lmt] ns, Result: [V Low] ns
  2.006  EVAL   -e L[2] <= Lmt : [MEM2]

  3.001  HEAD
  3.002  9500         *                                                 S
  3.003  END
