﻿© 2009 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5000 Setup IEEE
INSTRUMENT:            Sub Tek TDS5000 Set Bandwidth & Num_Chan
DATE:                  2009-06-30 09:54:29
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       83
=============================================================================
#
#  Procedure Author:  DAC, VY
#
#  Model(s) Covered:  TDS5000 Series
#                       TDS 5052, TDS 5054, TDS 5104
#
#  Compatibility:     MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:     Sub UUT Connection GPIB
#
#  Required Files:    None
#
#  Additional Equipment Required:
#                     None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SETUP                        PSUBI("Setup")
  1.002  JMPL         SET_BW_NUM_CH                PSUBI("Set Bandwidth")
  1.003  DISP         Undefined subprocedure!
  1.004  END

  1.005  EVAL   Increment step number

#********************************* Setup *************************************

  2.001  LABEL        SETUP
  2.002  DISP         Select GPIB Configuration... from the Utilities menu.
  2.002  DISP
  2.002  DISP         Click the Configuration Talk/Listen button.
  2.003  CALL         Sub UUT Connection GPIB
  2.004  END

  2.005  EVAL   Increment step number

#************************* Set Bandwidth & Num_Chan *************************

  3.001  LABEL        SET_BW_NUM_CH

  3.002  IF           ZCMPI(@ModelNum, "TDS5052")
  3.003  MATH         @Bandwidth = 500E+6; @NumChan = 2

  3.004  ELSEIF       ZCMPI(@ModelNum, "TDS5054")
  3.005  MATH         @Bandwidth = 500E+6; @NumChan = 4

  3.006  ELSEIF       ZCMPI(@ModelNum, "TDS5104")
  3.007  MATH         @Bandwidth = 1E+9;   @NumChan = 4

  3.008  ELSE
  3.009  DISP         Sub Tek TDS5000 Set Bandwidth & Num_Chan
  3.009  DISP
  3.009  DISP         Unsupported model number: [V @ModelNum]
  3.010  ENDIF

  3.011  END
