﻿© 2009 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5000 Self-Test IEEE
INSTRUMENT:            Sub Tek TDS5000 Sig Path Comp Cal IEEE
INSTRUMENT:            Sub Tek TDS5000 Channel Select IEEE
INSTRUMENT:            Sub Tek TDS5000 Check Trig Status IEEE
INSTRUMENT:            Sub Tek TDS5000 Adjust Trig Level IEEE
INSTRUMENT:            Sub Tek TDS5000 Read Time by Cursor Walker IEEE
DATE:                  2009-06-30 09:57:50
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       9
NUMBER OF LINES:       277
=============================================================================
#
#  Procedure Author:
#        DFM, DAC, VY
#
#  Model(s) Covered:
#        TDS5000 Series:  TDS 5052, TDS 5054, TDS 5104
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SELF_TEST                    PSUBI("Self-Test")
  1.002  JMPL         SIGNAL_PATH_COMPENSATION     PSUBI("Sig Path Comp")
  1.003  JMPL         CHANNEL_SELECT               PSUBI("Channel Select")
  1.004  JMPL         CHECK_TRIG_STATUS            PSUBI("Check Trig Status")
  1.005  JMPL         ADJUST_TRIG_LEVEL            PSUBI("Adjust Trig Level")
  1.006  JMPL         READ_TIME                    PSUBI("Read Time")
  1.007  DISP         Undefined subprocedure!
  1.008  END

  1.009  EVAL   Increment step number

#******************************* Self-Test ***********************************

  2.001  LABEL        SELF_TEST
  2.002  RSLT         =
  2.003  HEAD         SELF TEST
  2.004  TARGET
  2.005  DISP         Remove all input signals.
# Select all available diagnostics
  2.006  IEEE         DIA:SEL:ALL ALL
# Send commands to start the self-test.
# Here the IEEE FSC can only be used because if IEEE2 FSC were used the self
# test would be aborted in advance before it goes to last test item. Sending
# commands that alter the operating state will abort the diagnostics.
  2.007  IEEE         DIA:EXECUTE
  2.008  WAIT         -t 32 Self Test in progress...
# Return diagnostics result of Processor(0), Display(1), Acquisition(2) and
# Trigger(3). Test Misc/GPIB/Interface(4) is not available when Utility->GPIB
# Configuration is Talk/Listen.
  2.009  IEEE         DIA:ITEM:RESULT? 0[I$]
  2.010  MATH         Result = FINDI(MEM2, "Pass", 1)
  2.011  IEEE         DIA:ITEM:RESULT? 1[I$]
  2.012  MATH         Result = Result && FINDI(MEM2, "Pass", 1)
  2.013  IEEE         DIA:ITEM:RESULT? 2[I$]
  2.014  MATH         Result = Result && FINDI(MEM2, "Pass", 1)
  2.015  IEEE         DIA:ITEM:RESULT? 3[I$]
  2.016  MATH         Result = Result && FINDI(MEM2, "Pass", 1)
# Self Test evaluation
  2.017  EVAL   -e Result : SELF TEST
  3.001  IEEE         DIA:STATE OFF
  3.002  DISP         Click the Close button to close the diagnostic window.

  3.003  IF           FAIL()
  3.004  DISP         SELF TEST failed!
  3.004  DISP
  3.004  DISP         The UUT may need be serviced.
  3.004  DISP
  3.004  DISP         Press Advance to terminate the procedure.
  3.005  MATH         @Abort = 1
  3.006  ELSE
  3.007  MATH         @Abort = 0
  3.008  ENDIF

  3.009  END

  3.010  EVAL   Increment step number

#**************** Signal Path Compensation Calibration **********************

  4.001  LABEL        SIGNAL_PATH_COMPENSATION
# Ask the operator if they want to run the test.  It is not necessary to run
# this test again if already ran and the temperature is constant.
  4.002  OPBR         -z It is recommended that a Signal Path Compensation
  4.002  OPBR         Test be performed before running the performance Test.
  4.002  OPBR         It is only necessary to run this test one time.
  4.002  OPBR
  4.002  OPBR         Do you want to run the Signal Path Compensation Test?

  4.003  IF           MEM1
  4.004  IEEE         CAL:RES:SPC?[I$]

  4.005  IF           FINDI(MEM2, "WARMUP", 1)
  4.006  DISP         The UUT has not warmed up for the required 20 minutes
  4.006  DISP         to perform signal path calibration.
  4.006  DISP
  4.006  DISP         Press Advance to terminate the procedure.
  4.007  MATH         @Abort = 1
  4.008  ELSE
  4.009  MATH         @Abort = 0
  4.010  ENDIF

  4.011  IF           NOT(@Abort)
# Running the SPC test
  4.012  RSLT         =
  4.013  HEAD         SIGNAL PATH COMPENSATION
  4.014  DISP         Remove all connections from the UUT.
  4.015  IEEE         *CAL?
  4.016  MEM2         =Waiting for signal path compensation to complete...
  4.017  WAIT         -t [V @SPCTime] [MEM2]
  4.018  HEAD         SIGNAL PATH COMPENSATION COMPLETE
  4.019  IEEE         [T30000][I]
  4.020  EVAL   -e MEM == 0 : SIGNAL PATH COMPENSATION

  5.001  IF           FAIL()
  5.002  DISP         SIGNAL PATH COMPENSATION FAILED!
  5.002  DISP
  5.002  DISP         The UUT may need be serviced.
  5.002  DISP
  5.002  DISP         Press Advance to terminate the procedure.
  5.003  MATH         @Abort = 1
  5.004  ENDIF

  5.005  ENDIF

  5.006  ELSE         ; Choice of not running SPC is made by operator
# Set the procedure continued if signal path compensation is skipped.
  5.007  MATH         @Abort = 0
  5.008  ENDIF

  5.009  END

  5.010  EVAL   Increment step number

#*************************** Channel Select ****************************

  6.001  LABEL        CHANNEL_SELECT
  6.002  IEEE         *RST;HEADER OFF

# Select ON/OFF based on whether UUT is 2 or 4 channel.
  6.003  IF           @NumChan == 2

# Specify channel being tested.
  6.004  IF           @Chan == 1
  6.005  IEEE         SELECT:CH1 ON;CH2 OFF
  6.006  ELSE
  6.007  IEEE         SELECT:CH1 OFF;CH2 ON
  6.008  ENDIF

  6.009  ELSE

# Specify channel being tested.
  6.010  IF           @Chan == 1
  6.011  IEEE         SELECT:CH1 ON;CH2 OFF;CH3 OFF;CH4 OFF
  6.012  ELSEIF       @Chan == 2
  6.013  IEEE         SELECT:CH1 OFF;CH2 ON;CH3 OFF;CH4 OFF
  6.014  ELSEIF       @Chan == 3
  6.015  IEEE         SELECT:CH1 OFF;CH2 OFF;CH3 ON;CH4 OFF
  6.016  ELSE
  6.017  IEEE         SELECT:CH1 OFF;CH2 OFF;CH3 OFF;CH4 ON
  6.018  ENDIF

  6.019  ENDIF

  6.020  WAIT         -t 2 System Initializing...

  6.021  END

  6.022  EVAL   Increment step number

#*************************** Check Trig Status ****************************

  7.001  LABEL        CHECK_TRIG_STATUS
# Check the status of trigger
  7.002  IEEE         [D500]TRIG:STATE?[I$]
  7.003  MATH         @Trig = FINDI(MEM2, "TRIG", 1)

  7.004  END

  7.005  EVAL   Increment step number

#*************************** Adjust Trig Level *****************************

  8.001  LABEL        ADJUST_TRIG_LEVEL
  8.002  CALL         Sub Tek TDS5000 Check Trig Status IEEE

# If not trigged adjust the trigger level from 0 V to ±peak by adjust step.
  8.003  MATH         TrigLev = 0; Switch = 1

  8.004  WHILE        NOT(@Trig) && (ABS(TrigLev) <=  @PeakVal)

  8.005  IF           Switch
# Make the trigger level from negative to positive, then add adjust step.
  8.006  MATH         TrigLev = -1 * TrigLev + @StepVal
  8.007  MATH         Switch = Switch - 1
  8.008  ELSE
# Make the trigger level from positive to negative.
  8.009  MATH         TrigLev = -1 * TrigLev
  8.010  MATH         Switch = Switch + 1
  8.011  ENDIF

# Set new trigger level to the channel under test, then read the response.
  8.012  IEEE         TRIG:[V @TrigObj]:LEV [V TrigLev]
  8.013  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  8.014  ENDW

  8.015  END

  8.016  EVAL   Increment step number

# ************************ Read Time by Cursor Walker ***********************

  9.001  LABEL        READ_TIME
# Set the start of cursor walker.
  9.002  MATH         CursorWalker = -200E-12
# First locate the cursor at the start.
  9.003  IEEE         CURS:PAI:POS1 [V CursorWalker]
  9.004  WAIT         [D1000]

  9.005  DO
# Locate the cursor to the position of waveform.
  9.006  IEEE         CURS:PAI:POS1 [V CursorWalker][D50]
# Get the vertical reading of cursor located.
  9.007  IEEE         CURS:PAI:HPOS1?[I]
  9.008  MATH         MEM = MEM / 1E-3

# If found the reading is just crossing the zero, record the time value
  9.009  IF           MEM >= 0
  9.010  MATH         @CrossZero = 1; @TimeVal = CursorWalker

# If found the waveform reading is under the zero, adjust step value. As it is
# close to the zero, the step value becomes smaller in order more accurate.
  9.011  ELSEIF       (MEM >= -5)  &&  (MEM < 0)
  9.012  MATH         @CrossZero = 0; CursorWalker = CursorWalker + 0.1E-12

  9.013  ELSEIF       (MEM >= -50)  &&  (MEM < -5)
  9.014  MATH         @CrossZero = 0; CursorWalker = CursorWalker + 2E-12

  9.015  ELSE
  9.016  MATH         @CrossZero = 0; CursorWalker = CursorWalker + 10E-12
  9.017  ENDIF

  9.018  UNTIL        CursorWalker > 200E-12 || @CrossZero

  9.019  END
