﻿Fluke                                                       MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek TDS5104 (1 yr) Bandwidth IEEE /9500
INSTRUMENT:            Sub Tek TDS5104 (1 yr) Channels Iso IEEE /9500
INSTRUMENT:            Sub Tek TDS5104 (1 yr) Trig Sens IEEE /9500
DATE:                  2009-06-26 14:52:21
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       32
NUMBER OF LINES:       1100
CONFIGURATION:         Datron 9500 (G1)
CONFIGURATION:         Datron 9510 on channel 1
=============================================================================
#
#  Procedure Author:
#        GCM, DFM, DAC, VY
#
#  Model(s) Covered:
#        TDS 5104
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub Tek TDS5000 Channel Select IEEE
#        Sub Tek TDS5000 Check Trig Status IEEE
#        Sub Tek TDS5000 Adjust Trig Level IEEE
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         BANDWIDTH                    PSUBI("Bandwidth")
  1.002  JMPL         CHANNELS_ISOLATION           PSUBI("Channels Iso")
  1.003  JMPL         TRIGGER                      PSUBI("Trig Sens")
  1.004  DISP         {Undefined subprocedure!}
  1.005  END

  1.006  EVAL   Increment step number

# ********************************* Bandwidth  *******************************

  2.001  LABEL        BANDWIDTH

  2.002  IF           @Chan == 1
  2.003  RSLT         =
  2.004  RSLT         =ANALOG BANDWIDTH
  2.005  ENDIF

  2.006  HEAD         ANALOG BANDWIDTH (CH [V @Chan])
  2.007  RSLT         =
  2.008  RSLT         =Channel [V @Chan]
  2.009  RSLT         =
  2.010  HEAD         -2{ 100 mV/div}
  2.011  TARGET
  2.012  CALL         Sub Tek TDS5000 Channel Select IEEE
  2.013  IEEE         CH[V @Chan]:TER 50
  2.014  IEEE         ACQ:MODE AVE;NUMAV 16
  2.015  IEEE         ACQ:REPE ON
  2.016  IEEE         TRIG:A:MOD NORM;TYPE EDGE
  2.017  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC
  2.018  IEEE         MEASU:METH MINM
  2.019  IEEE         MEASU:MEAS1:SOU CH[V @Chan];TYPE FREQ;STATE ON
  2.020  IEEE         MEASU:MEAS2:SOU CH[V @Chan];TYP PK2P;STATE ON
  2.021  IEEE         HOR:SCA 40E-9
  2.022  IEEE         CH[V @Chan]:SCA 100E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 599 mV and 601 mV.
  2.023  MATH         MEM = 600; MEM1 = MEM

  2.024  DO
  2.025  MATH         MEM = MEM1 + (600 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  2.026  IF           MEM > 5560 || MEM < 4.44
  2.027  MATH         MEM = 600
  2.028  ENDIF

  2.029  9500         mVpp                         10MH           LS    S  L

  2.030  DO
  2.031  IEEE         [D250]TRIG:A SETL
  2.032  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  2.033  UNTIL        @Trig

  2.034  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  2.035  MATH         MEM = MEM / 1E-3
  2.036  UNTIL        (MEM >= 599) && (MEM <= 601)

  2.037  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  2.038  MATH         MEM = MEM1
  2.039  9500         mVpp                         1GH            LS    S  L
  2.040  IEEE         TRIG:A SETL
  2.041  WAIT         -t 2 Settling...
  2.042  IEEE         MEASU:MEAS2:VAL?[I]
  2.043  MATH         MEM = MEM / 1E-3
  2.044  MATH         MEM2 = FMT(MEM, "%.0f") & " mVpp"
  2.045  MEM2         = Limit: >= 424 mVpp @ 1 GHz, Result: [MEM2]
  2.046  EVAL   -e MEM >= 424 : [MEM2]

  3.001  9500         *                                                 S

# Only query once whether to do optional other scales bandwidth test when the
# channel 1 is tested, other channels test will take the same answer.
  3.002  IF           @Chan == 1
  3.003  HEAD         BANDWIDTH TESTS (OTHER SCALES)
  3.004  OPBR         -z Checking the bandwidth of each channel at all
  3.004  OPBR         vertical scale settings is time consuming and
  3.004  OPBR         unnecessary if Self Test, Self Path Compensation
  3.004  OPBR         and 100 mV scale bandwidth test have passed.
  3.004  OPBR
  3.004  OPBR         Do you want to SKIP the optional bandwidth test of other
  3.004  OPBR         scale settings?
  3.005  MATH         @OptBWSkipped =  MEM1
  3.006  ENDIF

  3.007  IF           NOT(@OptBWSkipped)
  3.008  RSLT         =
  3.009  HEAD         -2{ 1 mV/div}
  3.010  TARGET
  3.011  IEEE         HOR:SCA 40E-9
  3.012  IEEE         CH[V @Chan]:SCA 1E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 5.95 mV and 6.05 mV.
  3.013  MATH         MEM = 6; MEM1 = MEM

  3.014  DO
  3.015  MATH         MEM = MEM1 + (6 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  3.016  IF           MEM > 5560 || MEM < 4.44
  3.017  MATH         MEM = 6
  3.018  ENDIF

  3.019  9500         mVpp                         10MH           LS    S  L

  3.020  DO
  3.021  IEEE         [D250]TRIG:A SETL
  3.022  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  3.023  UNTIL        @Trig

  3.024  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  3.025  MATH         MEM = MEM / 1E-3
  3.026  UNTIL        (MEM >= 5.95) && (MEM <= 6.05)

  3.027  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  3.028  MATH         MEM = MEM1
  3.029  9500         mVpp                         175MH          LS    S  L
  3.030  IEEE         TRIG:A SETL
  3.031  WAIT         -t 2 Settling...
  3.032  IEEE         MEASU:MEAS2:VAL?[I]
  3.033  MATH         MEM = MEM / 1E-3
  3.034  MATH         MEM2 = FMT(MEM, "%.2f") & " mVpp"
  3.035  MEM2         = Limit: >= 4.24 mVpp @ 175 MHz, Result: [MEM2]
  3.036  EVAL   -e MEM >= 4.24 : [MEM2]

  4.001  RSLT         =
  4.002  HEAD         -2{ 2 mV/div}
  4.003  TARGET
  4.004  IEEE         HOR:SCA 40E-9
  4.005  IEEE         CH[V @Chan]:SCA 2E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 11.95 mV and 12.05 mV.
  4.006  MATH         MEM = 12; MEM1 = MEM

  4.007  DO
  4.008  MATH         MEM = MEM1 + (12 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  4.009  IF           MEM > 5560 || MEM < 4.44
  4.010  MATH         MEM = 12
  4.011  ENDIF

  4.012  9500         mVpp                         10MH           LS    S  L

  4.013  DO
  4.014  IEEE         [D250]TRIG:A SETL
  4.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  4.016  UNTIL        @Trig

  4.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  4.018  MATH         MEM = MEM / 1E-3
  4.019  UNTIL        (MEM >= 11.95) && (MEM <= 12.05)

  4.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  4.021  MATH         MEM = MEM1
  4.022  9500         mVpp                         1GH            LS    S  L
  4.023  IEEE         TRIG:A SETL
  4.024  WAIT         -t 2 Settling...
  4.025  IEEE         MEASU:MEAS2:VAL?[I]
  4.026  MATH         MEM = MEM / 1E-3
  4.027  MATH         MEM2 = FMT(MEM, "%.2f") & " mVpp"
  4.028  MEM2         = Limit: >= 8.48 mVpp @ 1 GHz, Result: [MEM2]
  4.029  EVAL   -e MEM >= 8.48 : [MEM2]

  5.001  RSLT         =
  5.002  HEAD         -2{ 5 mV/div}
  5.003  TARGET
  5.004  IEEE         HOR:SCA 40E-9
  5.005  IEEE         CH[V @Chan]:SCA 5E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 29.9 mV and 30.1 mV.
  5.006  MATH         MEM = 30; MEM1 = MEM

  5.007  DO
  5.008  MATH         MEM = MEM1 + (30 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  5.009  IF           MEM > 5560 || MEM < 4.44
  5.010  MATH         MEM = 30
  5.011  ENDIF

  5.012  9500         mVpp                         10MH           LS    S  L

  5.013  DO
  5.014  IEEE         [D250]TRIG:A SETL
  5.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  5.016  UNTIL        @Trig

  5.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  5.018  MATH         MEM = MEM / 1E-3
  5.019  UNTIL        (MEM >= 29.9) && (MEM <= 30.1)

  5.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  5.021  MATH         MEM = MEM1
  5.022  9500         mVpp                         1GH            LS    S  L
  5.023  IEEE         TRIG:A SETL
  5.024  WAIT         -t 2 Settling...
  5.025  IEEE         MEASU:MEAS2:VAL?[I]
  5.026  MATH         MEM = MEM / 1E-3
  5.027  MATH         MEM2 = FMT(MEM, "%.1f") & " mVpp"
  5.028  MEM2         = Limit: >= 21.2 mVpp @ 1 GHz, Result: [MEM2]
  5.029  EVAL   -e MEM >= 21.2 : [MEM2]

  6.001  RSLT         =
  6.002  HEAD         -2{ 10 mV/div}
  6.003  TARGET
  6.004  IEEE         HOR:SCA 40E-9
  6.005  IEEE         CH[V @Chan]:SCA 10E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 59.9 mV and 60.1 mV.
  6.006  MATH         MEM = 60; MEM1 = MEM

  6.007  DO
  6.008  MATH         MEM = MEM1 + (60 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  6.009  IF           MEM > 5560 || MEM < 4.44
  6.010  MATH         MEM = 60
  6.011  ENDIF

  6.012  9500         mVpp                         10MH           LS    S  L

  6.013  DO
  6.014  IEEE         [D250]TRIG:A SETL
  6.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  6.016  UNTIL        @Trig

  6.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  6.018  MATH         MEM = MEM / 1E-3
  6.019  UNTIL        (MEM >= 59.9) && (MEM <= 60.1)

  6.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  6.021  MATH         MEM = MEM1
  6.022  9500         mVpp                         1GH            LS    S  L
  6.023  IEEE         TRIG:A SETL
  6.024  WAIT         -t 2 Settling...
  6.025  IEEE         MEASU:MEAS2:VAL?[I]
  6.026  MATH         MEM = MEM / 1E-3
  6.027  MATH         MEM2 = FMT(MEM, "%.1f") & " mVpp"
  6.028  MEM2         = Limit: >= 42.4 mVpp @ 1 GHz, Result: [MEM2]
  6.029  EVAL   -e MEM >= 42.4 : [MEM2]

  7.001  RSLT         =
  7.002  HEAD         -2{ 20 mV/div}
  7.003  TARGET
  7.004  IEEE         HOR:SCA 40E-9
  7.005  IEEE         CH[V @Chan]:SCA 20E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 119.9 mV and 120.1 mV.
  7.006  MATH         MEM = 120; MEM1 = MEM

  7.007  DO
  7.008  MATH         MEM = MEM1 + (120 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  7.009  IF           MEM > 5560 || MEM < 4.44
  7.010  MATH         MEM = 120
  7.011  ENDIF

  7.012  9500         mVpp                         10MH           LS    S  L

  7.013  DO
  7.014  IEEE         [D250]TRIG:A SETL
  7.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  7.016  UNTIL        @Trig

  7.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  7.018  MATH         MEM = MEM / 1E-3
  7.019  UNTIL        (MEM >= 119.9) && (MEM <= 120.1)

  7.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  7.021  MATH         MEM = MEM1
  7.022  9500         mVpp                         1GH            LS    S  L
  7.023  IEEE         TRIG:A SETL
  7.024  WAIT         -t 2 Settling...
  7.025  IEEE         MEASU:MEAS2:VAL?[I]
  7.026  MATH         MEM = MEM / 1E-3
  7.027  MATH         MEM2 = FMT(MEM, "%.1f") & " mVpp"
  7.028  MEM2         = Limit: >= 84.8 mVpp @ 1 GHz, Result: [MEM2]
  7.029  EVAL   -e MEM >= 84.8 : [MEM2]

  8.001  RSLT         =
  8.002  HEAD         -2{ 50 mV/div}
  8.003  TARGET
  8.004  IEEE         HOR:SCA 40E-9
  8.005  IEEE         CH[V @Chan]:SCA 50E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 299 mV and 301 mV.
  8.006  MATH         MEM = 300; MEM1 = MEM

  8.007  DO
  8.008  MATH         MEM = MEM1 + (300 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  8.009  IF           MEM > 5560 || MEM < 4.44
  8.010  MATH         MEM = 300
  8.011  ENDIF

  8.012  9500         mVpp                         10MH           LS    S  L

  8.013  DO
  8.014  IEEE         [D250]TRIG:A SETL
  8.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  8.016  UNTIL        @Trig

  8.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  8.018  MATH         MEM = MEM / 1E-3
  8.019  UNTIL        (MEM >= 299) && (MEM <= 301)

  8.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  8.021  MATH         MEM = MEM1
  8.022  9500         mVpp                         1GH            LS    S  L
  8.023  IEEE         TRIG:A SETL
  8.024  WAIT         -t 2 Settling...
  8.025  IEEE         MEASU:MEAS2:VAL?[I]
  8.026  MATH         MEM = MEM / 1E-3
  8.027  MATH         MEM2 = FMT(MEM, "%.0f") & " mVpp"
  8.028  MEM2         = Limit: >= 212 mVpp @ 1 GHz, Result: [MEM2]
  8.029  EVAL   -e MEM >= 212 : [MEM2]

  9.001  RSLT         =
  9.002  HEAD         -2{ 200 mV/div}
  9.003  TARGET
  9.004  IEEE         HOR:SCA 40E-9
  9.005  IEEE         CH[V @Chan]:SCA 200E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 1199 mV and 1201 mV.
  9.006  MATH         MEM = 1200; MEM1 = MEM

  9.007  DO
  9.008  MATH         MEM = MEM1 + (1200 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  9.009  IF           MEM > 5560 || MEM < 4.44
  9.010  MATH         MEM = 1200
  9.011  ENDIF

  9.012  9500         mVpp                         10MH           LS    S  L

  9.013  DO
  9.014  IEEE         [D250]TRIG:A SETL
  9.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
  9.016  UNTIL        @Trig

  9.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
  9.018  MATH         MEM = MEM / 1E-3
  9.019  UNTIL        (MEM >= 1199) && (MEM <= 1201)

  9.020  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
  9.021  MATH         MEM = MEM1
  9.022  9500         mVpp                         1GH            LS    S  L
  9.023  IEEE         TRIG:A SETL
  9.024  WAIT         -t 2 Settling...
  9.025  IEEE         MEASU:MEAS2:VAL?[I]
  9.026  MATH         MEM = MEM / 1E-3
  9.027  MATH         MEM2 = FMT(MEM, "%.0f") & " mVpp"
  9.028  MEM2         = Limit: >= 848 mVpp @ 1 GHz, Result: [MEM2]
  9.029  EVAL   -e MEM >= 848 : [MEM2]

 10.001  RSLT         =
 10.002  HEAD         -2{ 500 mV/div}
 10.003  TARGET
 10.004  IEEE         HOR:SCA 40E-9
 10.005  IEEE         CH[V @Chan]:SCA 500E-3

# Set the output of the calibrator so the peak-to-peak measurement is
# between 2.99 V and 3.01V
 10.006  MATH         MEM = 3; MEM1 = MEM

 10.007  DO
 10.008  MATH         MEM = MEM1 + (3 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 10.009  IF           MEM > 5.56 || MEM < 0.00444
 10.010  MATH         MEM = 3
 10.011  ENDIF

 10.012  9500         Vpp                          10MH           LS    S  L

 10.013  DO
 10.014  IEEE         [D250]TRIG:A SETL
 10.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 10.016  UNTIL        @Trig

 10.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
 10.018  UNTIL        (MEM >= 2.99) && (MEM <= 3.01)

 10.019  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
 10.020  MATH         MEM = MEM1
 10.021  9500         Vpp                          1GH            LS    S  L
 10.022  IEEE         TRIG:A SETL
 10.023  WAIT         -t 2 Settling...
 10.024  IEEE         MEASU:MEAS2:VAL?[I]
 10.025  MATH         MEM2 = FMT(MEM, "%.2f") & " Vpp"
 10.026  MEM2         = Limit: >= 2.12 Vpp @ 1 GHz, Result: [MEM2]
 10.027  EVAL   -e MEM >= 2.12 : [MEM2]

 11.001  RSLT         =
 11.002  HEAD         -2{ 1 V/div}
 11.003  TARGET
 11.004  IEEE         HOR:SCA 40E-9
 11.005  IEEE         CH[V @Chan]:SCA 1

# Set the output of the calibrator so the peak-to-peak measurement is
# between 2.99 V and 3.01V
 11.006  MATH         MEM = 3; MEM1 = MEM

 11.007  DO
 11.008  MATH         MEM = MEM1 + (3 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 11.009  IF           MEM > 5.56 || MEM < 0.00444
 11.010  MATH         MEM = 3
 11.011  ENDIF

 11.012  9500         Vpp                          10MH           LS    S  L

 11.013  DO
 11.014  IEEE         [D250]TRIG:A SETL
 11.015  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 11.016  UNTIL        @Trig

 11.017  IEEE         [D250]MEASU:MEAS2:VAL?[I]
 11.018  UNTIL        (MEM >= 2.99) && (MEM <= 3.01)

 11.019  IEEE         HOR:SCA 1E-9
# Last calibrator amplitude setting is in MEM1.
 11.020  MATH         MEM = MEM1
 11.021  9500         Vpp                          1GH            LS    S  L
 11.022  IEEE         TRIG:A SETL
 11.023  WAIT         -t 2 Settling...
 11.024  IEEE         MEASU:MEAS2:VAL?[I]
 11.025  MATH         MEM2 = FMT(MEM, "%.2f") & " Vpp"
 11.026  MEM2         = Limit: >= 2.12 Vpp @ 1 GHz, Result: [MEM2]
 11.027  EVAL   -e MEM >= 2.12 : [MEM2]

 12.001  ENDIF

 12.002  HEAD
 12.003  HEAD         -2
 12.004  9500         *                                                 S
 12.005  END

 12.006  EVAL   Increment step number

# ******************************* Channels Isolation *************************

 13.001  LABEL        CHANNELS_ISOLATION

 13.002  IF           @Chan == 1
 13.003  RSLT         =
 13.004  RSLT         =CHECK CHANNELS ISOLATION(CROSSTALK)
 13.005  ENDIF

 13.006  HEAD         CHECK CHANNELS ISOLATION
 13.007  RSLT         =
 13.008  RSLT         = Input Channel [V @Chan]

 13.009  RSLT         =
 13.010  HEAD         -2{ 100 MHz, 8 Division}
 13.011  TARGET
 13.012  LABEL        START_100MHz_ISO
 13.013  CALL         Sub Tek TDS5000 Channel Select IEEE

# Note: Here we adjust the vertical scale to 10 mV/div rather than 100 mV/div
# of service manual is because we found it is easy to occur execution error
# or query error when querying the crosstalk result for the value is too small
# than vertical scale. According the specification the crosstalk of channels
# should be tested with same vertical scale setting between the test channels.
 13.014  IF           @NumChan == 2

# Specify channel being tested.
 13.015  IF           @Chan == 1
 13.016  MATH         L[12] = 2
 13.017  ELSE
 13.018  MATH         L[12] = 1
 13.019  ENDIF

 13.020  IEEE         SELECT:CH[L12] ON
 13.021  IEEE         CH[V @Chan]:TER 50;SCA 10E-3
 13.022  IEEE         CH[L12]:TER 50;SCA 10E-3

 13.023  ELSE

# Specify channel being tested.
 13.024  IF           @Chan == 1
 13.025  MATH         L[12] = 2; L[13] = 3; L[14] = 4
 13.026  ELSEIF       @Chan == 2
 13.027  MATH         L[12] = 1; L[13] = 3; L[14] = 4
 13.028  ELSEIF       @Chan == 3
 13.029  MATH         L[12] = 1; L[13] = 2; L[14] = 4
 13.030  ELSE
 13.031  MATH         L[12] = 1; L[13] = 2; L[14] = 3
 13.032  ENDIF

 13.033  IEEE         SELECT:CH[L12] ON;CH[L13] ON;CH[L14] ON
 13.034  IEEE         CH[V @Chan]:TER 50;SCA 10E-3
 13.035  IEEE         CH[L12]:TER 50;SCA 10E-3
 13.036  IEEE         CH[L13]:TER 50;SCA 10E-3
 13.037  IEEE         CH[L14]:TER 50;SCA 10E-3
 13.038  ENDIF

 13.039  IEEE         TRIG:A:MOD AUTO;TYPE EDGE
 13.040  IEEE         TRIG:A:EDGE:SOU CH[V @Chan]
 13.041  IEEE         MEASU:MEAS1:SOU CH[V @Chan];TYP AMPL;STATE ON
 13.042  IEEE         HOR:SCA 20E-9

# Set the output of the calibrator so the amplitude measurement at 100 MHz is
# between 79.5 and 80.5mV.
 13.043  MATH         MEM = 80.0; MEM1 = MEM

 13.044  DO
 13.045  MATH         MEM = MEM1 + (80.0 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 13.046  IF           MEM > 5560 || MEM < 4.44
 13.047  MATH         MEM = 80.0
 13.048  ENDIF

 13.049  DO
 13.050  9500         mVpp                         100MH          LS    S  L
 13.051  IEEE         [D500]TRIG:A SETL
 13.052  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 13.053  UNTIL        @Trig

 13.054  IEEE         [D500]MEASU:MEAS1:VAL?[I]
 13.055  MATH         MEM = MEM / 1E-3
 13.056  UNTIL        (MEM >= 79.5) && (MEM <= 80.5)

# Save the output amplitude of calibrator.
 13.057  MATH         Ampl = MEM1
 13.058  IEEE         MEASU:MEAS2:SOU CH[L12];TYP AMPL;STATE ON

 13.059  IF           @NumChan == 2
 13.060  IEEE         [D1000]MEASU:MEAS2:VAL?[I]
# Convert the amplitude reading into divisions based vertical scale setting.
 13.061  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 13.062  MATH         MEM = FRND(MEM, 4)
 13.063  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 13.064  MEM2         = CH [L12] Limit: <= 0.08 div @ 100 MHz, Result: [MEM2]
 13.065  EVAL   -e MEM <= 0.08 : [MEM2]

 14.001  IEEE         MEASU:MEAS2:STATE OFF

# 4 channels UUT.
 14.002  ELSE
 14.003  JMPL         FIRST_CH_100MHz

# This TARGET and JMPL are here so "Repeat" and "Cancel" will perform
# a new waveform acquisition.
 14.004  TARGET
 14.005  JMPL         START_100MHz_ISO

 14.006  LABEL        FIRST_CH_100MHz
 14.007  IEEE         [D1000]MEASU:MEAS2:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 14.008  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 14.009  MATH         MEM = FRND(MEM, 4)
 14.010  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 14.011  MEM2         = CH [L12] Limit: <= 0.08 div @ 100 MHz, Result: [MEM2]
 14.012  EVAL   -e MEM <= 0.08 : [MEM2]

 15.001  IEEE         MEASU:MEAS3:SOU CH[L13];TYP AMPL;STATE ON
 15.002  MATH         MEM = Ampl

 15.003  DO
 15.004  9500         mVpp                         100MH          LS    S  L
 15.005  IEEE         [D500]TRIG:A SETL
 15.006  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 15.007  UNTIL        @Trig

 15.008  IEEE         MEASU:MEAS3:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 15.009  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 15.010  MATH         MEM = FRND(MEM, 4)
 15.011  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 15.012  MEM2         = CH [L13] Limit: <= 0.08 div @ 100 MHz, Result: [MEM2]
 15.013  EVAL   -e MEM <= 0.08 : [MEM2]

 16.001  IEEE         MEASU:MEAS4:SOU CH[L14];TYP AMPL;STATE ON
 16.002  MATH         MEM = Ampl

 16.003  DO
 16.004  9500         mVpp                         100MH          LS    S  L
 16.005  IEEE         [D1000]TRIG:A SETL
 16.006  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 16.007  UNTIL        @Trig

 16.008  IEEE         MEASU:MEAS4:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 16.009  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 16.010  MATH         MEM = FRND(MEM, 4)
 16.011  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 16.012  MEM2         = CH [L14] Limit: <= 0.08 div @ 100 MHz, Result: [MEM2]
 16.013  EVAL   -e MEM <= 0.08 : [MEM2]

 17.001  IEEE         MEASU:MEAS2:STATE OFF
 17.001  IEEE         MEASU:MEAS3:STATE OFF
 17.001  IEEE         MEASU:MEAS4:STATE OFF
 17.002  ENDIF

 17.003  RSLT         =
 17.004  HEAD         -2{ Full Bandwidth, 8 Division}
 17.005  TARGET
 17.006  LABEL        START_FULL_BW_ISO
# Set the output of the calibrator so the amplitude measurement at full
# bandwidth is between 78.5 and 81.5 mV.
 17.007  MATH         MEM = 80.0; MEM1 = MEM

 17.008  DO
 17.009  MATH         MEM = MEM1 + (80.0 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 17.010  IF           MEM > 3360 || MEM < 4.44
 17.011  MATH         MEM = 80.0
 17.012  ENDIF

 17.013  DO
 17.014  9500         mVpp                         1GH            LS    S  L
 17.015  IEEE         [D500]TRIG:A SETL
 17.016  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 17.017  UNTIL        @Trig

 17.018  IEEE         MEASU:MEAS1:VAL?[I]
 17.019  MATH         MEM = MEM / 1E-3
 17.020  UNTIL        (MEM >= 78.5) && (MEM <= 81.5)

# Save the output amplitude of calibrator.
 17.021  MATH         Ampl = MEM1
 17.022  MATH         S[9] =  1000
 17.023  IEEE         MEASU:MEAS2:SOU CH[L12];TYP AMPL;STATE ON

 17.024  IF           @NumChan == 2
 17.025  IEEE         [D1000]MEASU:MEAS2:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 17.026  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 17.027  MATH         MEM = FRND(MEM, 4)
 17.028  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 17.029  MEM2         = CH [L12] Limit: <= 0.16 div @ [S9] MHz, Result: [MEM2]
 17.030  EVAL   -e MEM <= 0.16 : [MEM2]

 18.001  IEEE         MEASU:MEAS1:STATE OFF
 18.001  IEEE         MEASU:MEAS2:STATE OFF

# 4 channels UUT.
 18.002  ELSE
 18.003  JMPL         FIRST_CH_FULL_BW

# This TARGET and JMPL are here so "Repeat" and "Cancel" will perform
# a new waveform acquisition.
 18.004  TARGET
 18.005  JMPL         START_FULL_BW_ISO

 18.006  LABEL        FIRST_CH_FULL_BW
 18.007  IEEE         [D1000]MEASU:MEAS2:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 18.008  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 18.009  MATH         MEM = FRND(MEM, 4)
 18.010  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 18.011  MEM2         = CH [L12] Limit: <= 0.16 div @ [S9] MHz, Result: [MEM2]
 18.012  EVAL   -e MEM <= 0.16 : [MEM2]

 19.001  IEEE         MEASU:MEAS3:SOU CH[L13];TYP AMPL;STATE ON
 19.002  MATH         MEM = Ampl

 19.003  DO
 19.004  9500         mVpp                         1GH            LS    S  L
 19.005  IEEE         [D500]TRIG:A SETL
 19.006  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 19.007  UNTIL        @Trig

 19.008  IEEE         MEASU:MEAS3:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 19.009  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 19.010  MATH         MEM = FRND(MEM, 4)
 19.011  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 19.012  MEM2         = CH [L13] Limit: <= 0.16 div @ [S9] MHz, Result: [MEM2]
 19.013  EVAL   -e MEM <= 0.16 : [MEM2]

 20.001  IEEE         MEASU:MEAS4:SOU CH[L14];TYP AMPL;STATE ON
 20.002  MATH         MEM = Ampl

 20.003  DO
 20.004  9500         mVpp                         1GH            LS    S  L
 20.005  IEEE         [D500]TRIG:A SETL
 20.006  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 20.007  UNTIL        @Trig

 20.008  IEEE         MEASU:MEAS4:VAL?[I]
# Convert the amplitude reading into divisions based on vertical scale.
 20.009  MATH         MEM = MEM  * ( 1 / 10E-3)
# Set the significant digit of reading
 20.010  MATH         MEM = FRND(MEM, 4)
 20.011  MATH         MEM2 = FMT(MEM, "%.3f") & " div"
 20.012  MEM2         = CH [L14] Limit: <= 0.16 div @ [S9] MHz, Result: [MEM2]
 20.013  EVAL   -e MEM <= 0.16 : [MEM2]

 21.001  IEEE         MEASU:MEAS1:STATE OFF
 21.001  IEEE         MEASU:MEAS2:STATE OFF
 21.001  IEEE         MEASU:MEAS3:STATE OFF
 21.001  IEEE         MEASU:MEAS4:STATE OFF
 21.002  ENDIF

 21.003  HEAD
 21.004  HEAD         -2
 21.005  9500         *                                                 S
 21.006  END

 21.007  EVAL   Increment step number

# ********************************** Trigger  ********************************

 22.001  LABEL        TRIGGER

 22.002  IF           @Chan == 1
 22.003  RSLT         =
 22.004  RSLT         =EDGE-TRIGGER SENSITIVITY
 22.005  ENDIF

 22.006  RSLT         =
 22.007  RSLT         =Channel [V @Chan]

 22.008  HEAD         EDGE-TRIGGER SENSITIVITY (Channel [V @Chan])
 22.009  RSLT         =
 22.010  HEAD         -2{TRIGGER SENSITIVITY (50 MHz)}
 22.011  TARGET
 22.012  CALL         Sub Tek TDS5000 Channel Select IEEE
 22.013  IEEE         TRIG:A:MOD NORM;TYP EDGE
 22.014  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC
 22.015  IEEE         ACQ:MODE AVE;NUMAV 16
 22.016  IEEE         MEASU:METH MINM
 22.017  IEEE         MEASU:MEAS1:SOU CH[V @Chan];TYPE AMPL;STATE ON
 22.018  IEEE         TRIG:A SETL
 22.019  IEEE         CH[V @Chan]:SCA 100E-3
 22.020  IEEE         CH[V @Chan]:TER 50
 22.021  IEEE         HOR:SCA 20E-9

# Set the output of the calibrator so the peak-to-peak measurement is
# approximately 350 mV(100 mV/div, 3.5 div).
 22.022  MATH         MEM = 350; MEM1 = MEM

 22.023  DO
 22.024  MATH         MEM = MEM1 + (350 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 22.025  IF           MEM > 5560 || MEM < 4.44
 22.026  MATH         MEM = 350
 22.027  ENDIF

 22.028  9500         mVpp                         50MH           LS    S  L

 22.029  DO
 22.030  IEEE         [D250]TRIG:A SETL
 22.031  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 22.032  UNTIL        @Trig

 22.033  IEEE         [D250]MEASU:MEAS1:VAL?[I]
 22.034  MATH         MEM = MEM / 1E-3
 22.035  UNTIL        (MEM >= 348) && (MEM <= 352)

# Reduce the output of calibrator to one tenth (about 35 mV or 0.35 div)
# in place of using a 10x attenuator.
 22.036  MATH         MEM = MEM1 / 10
 22.037  9500         mVpp                         50MH           LS    S  L
 22.038  MATH         Ampl = MEM1
 22.039  IEEE         TRIG:MAI:EDGE:SLO RISE
 22.040  MATH         @PeakVal = 17.5E-3
 22.041  MATH         @StepVal = 0.5E-3
 22.042  MATH         @TrigObj = "A"
 22.043  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 22.044  MEM2         = Rising Slope, Limit: 0.35 div @ 50 MHz
 22.045  EVAL   -e @Trig : [MEM2]

 23.001  MATH         MEM = Ampl
 23.002  9500         mVpp                         50MH           LS    S  L
 23.003  IEEE         TRIG:MAI:EDGE:SLO FALL
 23.004  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 23.005  MEM2         = Falling Slope, Limit: 0.35 div @ 50 MHz
 23.006  EVAL   -e @Trig : [MEM2]

 24.001  RSLT         =
 24.002  HEAD         -2{ TRIG DELAY SENSITIVITY (50 MHz)}
 24.003  TARGET
 24.004  MATH         MEM = Ampl
 24.005  9500         mVpp                         50MH           LS    S  L
 24.006  IEEE         TRIG:MAI:EDGE:SLO RISE
 24.007  IEEE         TRIG:A:EDGE:SOU LINE
 24.008  IEEE         TRIG:B:STATE ON;BY TIME;EDGE:SOU CH[V @Chan]
 24.009  IEEE         TRIG:B SETL
 24.010  MATH         @TrigObj = "B"
 24.011  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 24.012  MEM2         = Rising Slope, Limit: 0.35 div @ 50 MHz
 24.013  EVAL   -e @Trig : [MEM2]

 25.001  IEEE         TRIG:B:STATE OFF
 25.002  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC

 25.003  IF           @Chan == 1
 25.004  RSLT         =
 25.005  HEAD         -2{ AUX IN TRIG SENSITIVITY (50 MHz)}
# This TARGET and JMPL are here so "Repeat" and "Cancel" will be
# able to setup waveform again with correct hook-up.
 25.006  JMPL         AUX_IN_TRIG_SENS_50M_START

 25.007  TARGET
 25.008  DISP         Reconnect the CH 1 Active Head to the UUT CH 1.

 25.009  LABEL        AUX_IN_TRIG_SENS_50M_START
 25.010  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC
# Set the output of the calibrator so the peak-to-peak measurement is
# approximately 400 mV(100 mV/div, 4 div).
 25.011  MATH         MEM = 400; MEM1 = MEM

 25.012  DO
 25.013  MATH         MEM = MEM1 + (400 - MEM) / 2

# Set the output limit trap in order to avoid calculated output beyond the
# calibrator maximum output at this frequency because of unstable reading.
 25.014  IF           MEM > 5560
 25.015  MATH         MEM = 400
 25.016  ENDIF

 25.017  9500         mVpp                         50MH           LS    S  L
 25.018  MATH         Ampl = MEM1

 25.019  DO
 25.020  IEEE         [D250]TRIG:A SETL
 25.021  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 25.022  UNTIL        @Trig

 25.023  IEEE         [D250]MEASU:MEAS1:VAL?[I]
 25.024  MATH         MEM = MEM / 1E-3
 25.025  UNTIL        (MEM >= 398) && (MEM <= 402)

 25.026  IEEE         [@9500]OUTP:STAT OFF
 25.027  DISP         Connect the CH 1 Active Head to the UUT AUX IN.
 25.027  DISP
 25.027  DISP         You may not see the waveform during the following test.
 25.027  DISP         The "triggered" status will be checked automatically.
 25.028  IEEE         [@9500]OUTP:STAT ON
 25.029  WAIT         -t 2 System Settling ...
 25.030  IEEE         TRIG:A:EDGE:SOU AUX
 25.031  MATH         @PeakVal = 200E-3
 25.032  MATH         @StepVal = 0.5E-3
 25.033  MATH         @TrigObj = "A"
 25.034  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 25.035  MEM2         = Rising Slope, Limit: 400 mV @ 50 MHz
 25.036  EVAL   -e @Trig : [MEM2]

 26.001  MATH         MEM = Ampl
 26.002  9500         mVpp                         50MH           LS    S  L
 26.003  IEEE         TRIG:MAI:EDGE:SLO FALL
 26.004  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 26.005  MEM2         = Falling Slope, Limit: 400 mV @ 50 MHz
 26.006  EVAL   -e @Trig : [MEM2]

 27.001  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC
 27.002  9500         *                                                 S
 27.003  DISP         Reconnect the CH 1 Active Head to the UUT CH 1.
 27.004  ENDIF

 27.005  RSLT         =
 27.006  HEAD         -2{ TRIG SENSITIVITY (Full Bandwidth)}
 27.007  TARGET
 27.008  IEEE         HOR:SCA 400E-12
# Set the output of the calibrator so the peak-to-peak measurement is
# approximately 500 mV(100 mV/div, 5 div).
 27.009  MATH         MEM = 500; MEM1 = MEM

 27.010  DO
 27.011  MATH         MEM = MEM1 + (500 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 27.012  IF           MEM > 5560 || MEM < 4.44
 27.013  MATH         MEM = 500
 27.014  ENDIF

 27.015  9500         mVpp                         1GH            LS    S  L
 27.016  MATH         Ampl = MEM1

 27.017  DO
 27.018  IEEE         [D250]TRIG:A SETL
 27.019  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 27.020  UNTIL        @Trig

 27.021  IEEE         [D250]MEASU:MEAS1:VAL?[I]
 27.022  MATH         MEM = MEM / 1E-3
 27.023  UNTIL        (MEM >= 495) && (MEM <= 505)

# Reduce the output of calibrator to one fifth (about 100 mV or 1 div)
# in place of using a 5x attenuator.
 27.024  MATH         MEM = MEM1 / 5
 27.025  MATH         S[9] =  1
 27.026  9500         mVpp                         1GH            LS    S  L
 27.027  IEEE         TRIG:MAI:EDGE:SLO RISE
 27.028  MATH         @PeakVal = 50E-3
 27.029  MATH         @StepVal = 0.5E-3
 27.030  MATH         @TrigObj = "A"
 27.031  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 27.032  MEM2         = Rising Slope, Limit: 1 div @ 1 GHz
 27.033  EVAL   -e @Trig : [MEM2]

 28.001  MATH         MEM = Ampl
 28.002  9500         mVpp                         1GH            LS    S  L
 28.003  IEEE         TRIG:MAI:EDGE:SLO FALL
 28.004  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 28.005  MEM2         = Falling Slope, Limit: 1 div @ 1 GHz
 28.006  EVAL   -e @Trig : [MEM2]

 29.001  RSLT         =
 29.002  HEAD         -2{ TRIG DELAY SENSITIVITY (Full Bandwidth)}
 29.003  TARGET
 29.004  MATH         MEM = Ampl
 29.005  9500         mVpp                         1GH            LS    S  L
 29.006  IEEE         TRIG:MAI:EDGE:SLO RISE
 29.007  IEEE         TRIG:A:EDGE:SOU LINE
 29.008  IEEE         TRIG:B:STATE ON;BY TIME;EDGE:SOU CH[V @Chan]
 29.009  IEEE         TRIG:B SETL
 29.010  MATH         @TrigObj = "B"
 29.011  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 29.012  MEM2         = Rising Slope Trig Sens Limit: 1 div @ 1 GHz
 29.013  EVAL   -e @Trig : [MEM2]

 30.001  IEEE         TRIG:B:STATE OFF
 30.002  9500         *                                                 S

 30.003  IF           @Chan == 1
 30.004  RSLT         =
 30.005  HEAD         -2{ AUX IN TRIG SENSITIVITY (Full Bandwidth)}
# This TARGET and JMPL are here so "Repeat" and "Cancel" will be
# able to setup waveform again with correct hook-up.
 30.006  JMPL         AUX_IN_TRIG_SENS_FB_START

 30.007  TARGET
 30.008  DISP         Reconnect the CH 1 Active Head to the UUT CH 1.

 30.009  LABEL        AUX_IN_TRIG_SENS_FB_START
 30.010  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC

# Set the output of the calibrator so the peak-to-peak measurement is
# approximately 750 mV(100 mV/div, 7.5 div).
 30.011  MATH         MEM = 750; MEM1 = MEM

 30.012  DO
 30.013  MATH         MEM = MEM1 + (750 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
 30.014  IF           MEM > 5560 || MEM < 4.44
 30.015  MATH         MEM = 750
 30.016  ENDIF

 30.017  9500         mVpp                         1GH            LS    S  L
 30.018  MATH         Ampl = MEM1

 30.019  DO
 30.020  IEEE         [D250]TRIG:A SETL
 30.021  CALL         Sub Tek TDS5000 Check Trig Status IEEE
 30.022  UNTIL        @Trig

 30.023  IEEE         [D250]MEASU:MEAS1:VAL?[I]
 30.024  MATH         MEM = MEM / 1E-3
 30.025  UNTIL        (MEM >= 740) && (MEM <= 760)

 30.026  IEEE         [@9500]OUTP:STAT OFF
 30.027  DISP         Connect the CH 1 Active Head to the UUT AUX IN.
 30.027  DISP
 30.027  DISP         You may not see the waveform during the following test.
 30.027  DISP         The "triggered" status will be checked automatically.
 30.028  IEEE         [@9500]OUTP:STAT ON
 30.029  WAIT         -t 2 System Settling ...
 30.030  IEEE         TRIG:A:EDGE:SOU AUX
 30.031  MATH         @PeakVal = 375E-3
 30.032  MATH         @StepVal = 15E-3
 30.033  MATH         @TrigObj = "A"
 30.034  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 30.035  MEM2         = Rising Slope, Limit: 750 mV @ 1 GHz
 30.036  EVAL   -e @Trig : [MEM2]

 31.001  MATH         MEM = Ampl
 31.002  9500         mVpp                         1GH            LS    S  L
 31.003  IEEE         TRIG:MAI:EDGE:SLO FALL
 31.004  CALL         Sub Tek TDS5000 Adjust Trig Level IEEE
 31.005  MEM2         = Falling Slope, Limit: 750 mV @ 1 GHz
 31.006  EVAL   -e @Trig : [MEM2]

 32.001  IEEE         TRIG:A:EDGE:SOU CH[V @Chan];COUP DC
 32.002  9500         *                                                 S
 32.003  WAIT         -t 30 Waiting for excess heat to dissipate...
 32.004  ENDIF

 32.005  HEAD
 32.006  HEAD         -2
 32.007  END
