﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Tektronix TDS 5104: (1 year) VER IEEE /9500+4Hd
DATE:                  2016-06-29 13:19:50
AUTHOR:                Fluke
REVISION:              $Revision: 2624 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       307
CONFIGURATION:         Datron 9500 (C5,G1)
CONFIGURATION:         Datron 9510 on channel 1
CONFIGURATION:         Datron 9510 on channel 2
CONFIGURATION:         Datron 9510 on channel 3
CONFIGURATION:         Datron 9510 on channel 4
=============================================================================
#
#  Procedure Author:
#        GCM, DFM, DAC, VY
#
#  Source(s):
#        TDS5000 Series Digital Phosphor Oscilloscopes
#        Service Manual, PN 071-1004-02
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Additional Equipment Required:
#        2 Way Power Splitter
#        BNC T(f-m-f) adapter
#        Cable, 50 Ohm, BNC(m)-(m), Pomona 2249-C-36
#        SMA T(f-m-f) adapter
#        Cable, 50 Ohm, SMA(m)-(m)
#        3 sets of SMA(f) to SMA(f), SMA(m) to BNC(f) adapter
#        2 sets SMA Short
#        Probe 1X or 10X, such as Tektronix P5050, P6243, or P6245
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# These statements are here to force the main procedure header to list the
# configuration required by the subprocedures.
  1.001  IF           0
  1.002  M9500                       CH1
  1.003  9500         1GH                          1Vpp           LS    S  L
  1.004  M9500                       CH2
  1.005  9500         1GH                          1Vpp           LS    S  L
  1.006  M9500                       CH3
  1.007  9500         1GH                          1Vpp           LS    S  L
  1.008  M9500                       CH4
  1.009  9500         1GH                          1Vpp           LS    S  L
  1.010  ENDIF

  1.011  ASK-   R   Q N              P                            A        V
# ASK+ K is required for measurement uncertainty.
  1.012  ASK+           K

  1.013  MATH         @ReqMetCalVersion = "7.20x"
  1.014  CALL         Sub MET/CAL Version Check

  1.015  IF           NOT(@MetCalVersionOK)
  1.016  DISP         This procedure requires MET/CAL 7.20 SP1 (7.20x) or
  1.016  DISP         later.
  1.017  END
  1.018  ENDIF

  1.019  CALL         Sub Display Copyright
  1.020  CALL         Sub High Voltage Safety Warning
  1.021  CALL         Sub Select Failed Test Mode
  1.022  CALL         Sub Select Verification Method

  1.023  DISP         Ensure a minimum UUT warm-up time of at least
  1.023  DISP         20 minutes has been allowed to elapse, prior
  1.023  DISP         to beginning verification.

  1.024  HEAD         PRELIMINARY INSTRUCTIONS
  1.025  TARGET
  1.026  CALL         Sub Tek TDS5000 Setup IEEE
  1.027  IEEE         *RST
  1.028  WAIT         -t 3 System initializing...

  1.029  HEAD         UUT IDENTIFICATION
  1.030  CALL         Sub Tek TDS5000 Identification Query (*IDN?) IEEE
  1.031  MATH         Model = "TDS5104"
  1.032  MATH         L[1] = ZCMPI("TEKTRONIX", @Manufacturer)
  1.033  MATH         L[2] = ZCMPI(Model, @ModelNum)

  1.034  IF           NOT(L[1] && L[2])
  1.035  DISP         UUT is an [V @Manufacturer] [V @ModelNum],
  1.035  DISP         not a Tektronix [V Model]!
  1.036  END
  1.037  ENDIF

  1.038  CALL         Sub Datron 9500 Configuration Query IEEE

# If 9500 Active Heads are all the same type, use Dual Channel Leveled-Sine
# for channel delay tests.
  1.039  MATH         L[1] = ZCMPI(@HeadTypeCh1, @HeadTypeCh2)
  1.040  MATH         L[1] = ZCMPI(@HeadTypeCh1, @HeadTypeCh3) && L[1]
  1.041  MATH         L[1] = ZCMPI(@HeadTypeCh1, @HeadTypeCh4) && L[1]
  1.042  MATH         UseDualChanLS = L[1]

  1.043  HEAD         EQUIPMENT REQUIREMENTS

  1.044  IF           UseDualChanLS
  1.045  DISP         The following additional equipment and/or
  1.045  DISP         accessories are required:
  1.045  DISP
  1.045  DISP         - BNC T(f-m-f) adapter
  1.045  DISP         - Cable, 50 Ohm, BNC(m)-(m), Pomona 2249-C-36
  1.045  DISP         - SMA T(f-m-f) adapter
  1.045  DISP         - Cable, 50 Ohm, SMA(m)-(m)
  1.045  DISP         - 3 sets of SMA(f) to SMA(f), SMA(m) to BNC(f) adapter
  1.045  DISP         - 2 sets SMA Short
  1.045  DISP         - Probe 1X or 10X, such as Tek P5050, P6243, or P6245
  1.046  ELSE
  1.047  DISP         The following additional equipment and/or
  1.047  DISP         accessories are required:
  1.047  DISP
  1.047  DISP         - Power Splitter, 1 kHz to 500 MHz, 6 dB insertion loss,
  1.047  DISP         [32] output tracking: <0.25 dB, equivalent output
  1.047  DISP         [32] SWR: <1.22, HP/Agilent 11667A or equivalent
  1.047  DISP         - BNC T(f-m-f) adapter
  1.047  DISP         - Cable, 50 Ohm, BNC(m)-(m), Pomona 2249-C-36
  1.047  DISP         - SMA T(f-m-f) adapter
  1.047  DISP         - Cable, 50 Ohm, SMA(m)-(m)
  1.047  DISP         - 3 sets of SMA(f) to SMA(f), SMA(m) to BNC(f) adapter
  1.047  DISP         - 2 sets SMA Short
  1.047  DISP         - Probe 1X or 10X, such as Tek P5050, P6243, or P6245
  1.048  ENDIF

# NOTE: Throughout this procedure, JMPL/LABEL statements are used to
# minimize connection changes during execution. Test results, however,
# are reported in test number sequence.
#
#  Order  Results                            Run Time (Execution)
#  -----  -------------------------------    --------------------------------
#    1.   SELF TEST                          SELF TEST
#    2.   SIGNAL PATH COMPENSATION           SIGNAL PATH COMPENSATION
#    3.   DCV MEASUREMENT ACC(CH1)           DCV MEASUREMENT ACC(CH1)
#    4.   DCV MEASUREMENT ACC(CH2)           DCV MEASUREMENT ACC(CH2)
#    5.   DCV MEASUREMENT ACC(CH3)           DCV MEASUREMENT ACC(CH3)
#    6.   DCV MEASUREMENT ACC(CH4)           DCV MEASUREMENT ACC(CH4)
#    7.   BANDWIDTH(CH1)                     BANDWIDTH(CH1)
#    8.   BANDWIDTH(CH2)                     BANDWIDTH(CH2)
#    9.   BANDWIDTH(CH3)                     BANDWIDTH(CH3)
#   10.   BANDWIDTH(CH4)                     BANDWIDTH(CH4)
#   11.   CHANNEL DELAY                      CHANNEL ISOLATION(CH1 IN)
#   12.   CHANNEL ISOLATION(CH1 IN)          CHANNEL ISOLATION(CH2 IN)
#   13.   CHANNEL ISOLATION(CH2 IN)          CHANNEL ISOLATION(CH3 IN)
#   14.   CHANNEL ISOLATION(CH3 IN)          CHANNEL ISOLATION(CH4 IN)
#   15.   CHANNEL ISOLATION(CH4 IN)          SAMPLE RATE AND DELAY TIME ACC
#   16.   SAMPLE RATE AND DELAY TIME ACC     TIME ACC OF PULSE WIDTH TRIG(CH1)
#   17.   DELTA TIME MEASUREMENT ACC(CH1)    EDGE-TRIGGER SENSITIVITY(CH1)
#   18.   DELTA TIME MEASUREMENT ACC(CH2)    DELTA TIME MEASUREMENT ACC(CH1)
#   19.   DELTA TIME MEASUREMENT ACC(CH3)    DELTA TIME MEASUREMENT ACC(CH2)
#   20.   DELTA TIME MEASUREMENT ACC(CH4)    DELTA TIME MEASUREMENT ACC(CH3)
#   21.   TIME ACC OF PULSE WIDTH TRIG(CH1)  DELTA TIME MEASUREMENT ACC(CH4)
#   22.   EDGE-TRIGGER SENSITIVITY(CH1)      CHANNEL DELAY
#   23.   SIGNAL OUT AND AUX TRIGGER OUT     SIGNAL OUT AND AUX TRIGGER OUT
#   24.   PROBE COMPENSATION OUTPUT          PROBE COMPENSATION OUTPUT

  1.049  CALL         Sub Tek TDS5000 Set Bandwidth & Num_Chan
  1.050  CALL         Sub Tek TDS5000 Self-Test IEEE
  1.051  JMPL         END                          @Abort

  1.052  MATH         @SPCTime = 720
  1.053  CALL         Sub Tek TDS5000 Sig Path Comp Cal IEEE
  1.054  JMPL         END                          @Abort

  1.055  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7]
  1.056  DISP         Connect the 9500 to the UUT as follows:
  1.056  DISP         [32] CH 1 Active Head to UUT CH 1
  1.056  DISP         [32] CH 2 Active Head to UUT CH 2
  1.056  DISP         [32] CH 3 Active Head to UUT CH 3
  1.056  DISP         [32] CH 4 Active Head to UUT CH 4

  1.057  MATH         @Chan = 1
  1.058  M9500                       CH1
  1.059  CALL         Sub Tek TDS5000 (1 yr) DCV Meas Acc IEEE /9500

  1.060  MATH         @Chan = 2
  1.061  M9500                       CH2
  1.062  CALL         Sub Tek TDS5000 (1 yr) DCV Meas Acc IEEE /9500

  1.063  MATH         @Chan = 3
  1.064  M9500                       CH3
  1.065  CALL         Sub Tek TDS5000 (1 yr) DCV Meas Acc IEEE /9500

  1.066  MATH         @Chan = 4
  1.067  M9500                       CH4
  1.068  CALL         Sub Tek TDS5000 (1 yr) DCV Meas Acc IEEE /9500

  1.069  MATH         @Chan = 1
  1.070  M9500                       CH1
  1.071  CALL         Sub Tek TDS5104 (1 yr) Bandwidth IEEE /9500

  1.072  MATH         @Chan = 2
  1.073  M9500                       CH2
  1.074  CALL         Sub Tek TDS5104 (1 yr) Bandwidth IEEE /9500

  1.075  MATH         @Chan = 3
  1.076  M9500                       CH3
  1.077  CALL         Sub Tek TDS5104 (1 yr) Bandwidth IEEE /9500

  1.078  MATH         @Chan = 4
  1.079  M9500                       CH4
  1.080  CALL         Sub Tek TDS5104 (1 yr) Bandwidth IEEE /9500
  1.081  JMPL         CHANNELS_ISOLATION_CH1

  1.082  LABEL        CHANNEL_DELAY
  1.083  MATH         @Chan = 1

  1.084  IF           UseDualChanLS
  1.085  CALL         Sub Tek TDS5000 (1 yr) Chan Delay IEEE /9500+4Hd
  1.086  ELSE
  1.087  M9500                       CH1
  1.088  CALL         Sub Tek TDS5000 (1 yr) Channel Delay IEEE /9500
  1.089  ENDIF

  1.090  JMPL         TRIG_SENS_CH1

  1.091  LABEL        CHANNELS_ISOLATION_CH1
  1.092  MATH         @Chan = 1
  1.093  M9500                       CH1
  1.094  CALL         Sub Tek TDS5104 (1 yr) Channels Iso IEEE /9500

  1.095  MATH         @Chan = 2
  1.096  M9500                       CH2
  1.097  CALL         Sub Tek TDS5104 (1 yr) Channels Iso IEEE /9500

  1.098  MATH         @Chan = 3
  1.099  M9500                       CH3
  1.100  CALL         Sub Tek TDS5104 (1 yr) Channels Iso IEEE /9500

  1.101  MATH         @Chan = 4
  1.102  M9500                       CH4
  1.103  CALL         Sub Tek TDS5104 (1 yr) Channels Iso IEEE /9500

  1.104  MATH         @Chan = 1
  1.105  M9500                       CH1
  1.106  CALL         Sub Tek TDS5000 (1 yr) Sample Rate IEEE /9500
  1.107  JMPL         TRIG_CH1

  1.108  LABEL        DELTA_TIME_CH1
  1.109  MATH         @Chan = 1
  1.110  M9500                       CH1
  1.111  CALL         Sub Tek TDS5000 (1 yr) Delta Time IEEE /9500

  1.112  MATH         @Chan = 2
  1.113  M9500                       CH1
  1.114  CALL         Sub Tek TDS5000 (1 yr) Delta Time IEEE /9500

  1.115  MATH         @Chan = 3
  1.116  M9500                       CH1
  1.117  CALL         Sub Tek TDS5000 (1 yr) Delta Time IEEE /9500

  1.118  MATH         @Chan = 4
  1.119  M9500                       CH1
  1.120  CALL         Sub Tek TDS5000 (1 yr) Delta Time IEEE /9500
  1.121  JMPL         SIGNAL_OUT

  1.122  LABEL        TRIG_CH1
  1.123  MATH         @Chan = 1
  1.124  M9500                       CH1
  1.125  CALL         Sub Tek TDS5000 (1 yr) Trig Time Acc IEEE /9500
  1.126  JMPL         CHANNEL_DELAY

  1.127  LABEL        TRIG_SENS_CH1
  1.128  MATH         @Chan = 1
  1.129  M9500                       CH1
  1.130  CALL         Sub Tek TDS5104 (1 yr) Trig Sens IEEE /9500
  1.131  JMPL         DELTA_TIME_CH1

  1.132  LABEL        SIGNAL_OUT
# The following signal out test is attached only with channel 3 input
  1.133  MATH         @Chan = 3
  1.134  M9500                       CH1
  1.135  CALL         Sub Tek TDS5000 (1 yr) Signal Out IEEE /9500

  1.136  MATH         @Chan = 1
  1.137  M9500                       CH1
  1.138  CALL         Sub Tek TDS5000 (1 yr) Probe Comp IEEE /9500

  1.139  LABEL        END
  1.140  IEEE         *RST
  1.141  HEAD
  1.142  RSLT         =

  1.143  IF           @Abort
  1.144  DISP         {V E R I F I C A T I O N   A B O R T E D !}
  1.145  ELSE
  1.146  DISP         {V E R I F I C A T I O N   C O M P L E T E !}
  1.147  ENDIF

  1.148  END
