﻿© Fluke. All Rights Reserved.                               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 884xA Check AC Option Status
INSTRUMENT:            Sub Fluke 884xA Check Input Switch
INSTRUMENT:            Sub Fluke 884xA Check Cal Status
INSTRUMENT:            Sub Fluke 884xA Self Test
INSTRUMENT:            Sub Fluke 884xA Wait for Cal Step Completion
DATE:                  2009-02-12
AUTHOR:                Fluke
REVISION:              $Revision: 16473 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       291
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Models covered:
#        884xA series
#
#  Source(s):
#        Fluke 8842A Digital Multimeter Instruction Manual, P/N 765313,
#         October 1985, Rev. 2, 6/86
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#
# Subprocedures:
#        None
#
# Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         AC_OPTION_STATUS             PSUBI("AC Option Status")
  1.002  JMPL         CHECK_FRONT_REAR_SWITCH      PSUBI("Input Switch")
  1.003  JMPL         CHECK_CAL_SWITCH             PSUBI("Cal Status")
  1.004  JMPL         SELF_TEST                    PSUBI("Self Test")
  1.005  JMPL         CAL_STEP_COMPLETION          PSUBI("Step Completion")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   dummy
#
# ====== Sub Fluke 884xA Check AC Option Status ============================
#
# Send F2 (ACV) and get error status (G5).
#
# G7 response is "10xx" where
#
#   xx = 00  No error if option is installed.
#
#   xx = 30  AC functions available only with 8842A-09 True RMS AC option
#

  2.001  LABEL        AC_OPTION_STATUS

  2.002  IEEE         F2
  2.003  IEEE         G7[D100][I$]

  2.004  IF           ZCMP(MEM2, "1000")
  2.005  MATH         @AC_Option = 1
  2.006  RSLT         = Option -09 (True RMS AC)
  2.007  ELSE
  2.008  MATH         @AC_Option = 0
  2.009  ENDIF

  2.010  IEEE         X0
  2.011  END

  2.012  EVAL   Increment Test Number
#
# ====== Sub Fluke 884xA Check Input Switch ================================
#
# The main procedure must set @Input = "FRONT" or "REAR".
#
# G5 response is "1iab" where
#
#    i = 0 FRONT inputs selected
#        1 REAR inputs selected
#
#    a = 0 Autorange on
#        1 Autorange off (Manual range)
#
#    b = 0 OFFSET off
#        1 OFFSET on
#

  3.001  LABEL        CHECK_FRONT_REAR_SWITCH

  3.002  IEEE         G5[D100][I$]
# Extract second character (currently selected input) in "G5" response string.
  3.003  MATH         Input = SUB(MEM2, 2, 1)

  3.004  IF           ZCMPI(@Input, "FRONT")

  3.005  IF           NOT(ZCMP(Input, "0"))
  3.006  DISP         Place the UUT INPUTS FRONT/REAR switch in the FRONT
  3.006  DISP         (out) position.
  3.007  ELSE
  3.008  END
  3.009  ENDIF

  3.010  ELSE

  3.011  IF           NOT(ZCMP(Input, "1"))
  3.012  DISP         Place the UUT INPUTS FRONT/REAR switch in the REAR
  3.012  DISP         (in) position.
  3.013  ELSE
  3.014  END
  3.015  ENDIF

  3.016  ENDIF

  3.017  JMPL         CHECK_FRONT_REAR_SWITCH

  3.018  EVAL   Increment Test Number
#
# ====== Sub Fluke 884xA Check Cal Status ==================================
#
# The main procedure must set @Status = "CAL" or "NORMAL".
#
# G4 response is "10vm" where
#
#    v = 0 Not in cal verification
#        1 Cal verification
#
#    m = 0 Not in calibration mode
#        1 A/D calibration
#        2 Offset and gain calibration
#        4 HF AC calibration
#
  4.001  LABEL        CHECK_CAL_SWITCH
  4.002  IEEE         G4[D100][I]

  4.003  IF           ZCMPI(@Status, "CAL") && NOT(MEM > 1000)
  4.004  DISP         Enable the UUT CAL MODE by pressing the CAL ENABLE
  4.004  DISP         switch (located on the right side of the display,
  4.004  DISP         normally covered with a calibration seal) using a
  4.004  DISP         small screwdriver or other suitable object.

  4.005  ELSEIF       ZCMPI(@Status, "NORMAL") && MEM > 1000
  4.006  DISP         Exit the UUT CAL MODE by releasing the CAL ENABLE
  4.006  DISP         switch.

  4.007  ELSE
  4.008  END
  4.009  ENDIF

  4.010  JMPL         CHECK_CAL_SWITCH

  4.011  EVAL   Increment Test Number
#
# ====== Sub Fluke 884xA Self Test =========================================
#
# The main procedure should perform an evaluation such as the following after
# calling this subprocedure.
#
#   1.041  EVAL   -e @Error == 0 : [32]
#
# There was an error if returned value is 1.00XXe+21 (XX is the error code)
# Isolate error code next.
#

  5.001  LABEL        SELF_TEST
  5.002  MATH         @Error = 0
  5.003  IEEE         *[D2000]Z0

  5.004  LABEL        PERFORMING_SELF_TEST
  5.005  HEAD         SELF-TEST
  5.006  MATH         SubHeadText = "Performing Self-Test, Please Wait"

  5.007  DO
  5.008  HEAD         -2 [V SubHeadText]..[D500]
  5.009  HEAD         -2 [V SubHeadText] ..[D500]
  5.010  HEAD         -2 [V SubHeadText]  ..[D500]
  5.011  HEAD         -2 [V SubHeadText]   ..[D500]
  5.012  IEEE         [SPL 16]
  5.013  UNTIL        MEM

  5.014  IEEE         [T30000][I]
  5.015  MATH         Error = MEM / 1E+017 - 10000

  5.016  IF           Error > 0
  5.017  MATH         @Error = @Error + 1

  5.018  IF           Error == 1
  5.019  MATH         ErrorText = "200 VAC, Zero"
  5.020  ELSEIF       Error == 2
  5.021  MATH         ErrorText = "700 VAC, Zero"
  5.022  ELSEIF       Error == 3
  5.023  MATH         ErrorText = "mA AC, Zero"
  5.024  ELSEIF       Error == 4
  5.025  MATH         ErrorText = "mA DC, Zero"
  5.026  ELSEIF       Error == 5
  5.027  MATH         ErrorText = "200 VDC, Zero"
  5.028  ELSEIF       Error == 6
  5.029  MATH         ErrorText = "1000 VDC, Zero"
  5.030  ELSEIF       Error == 7
  5.031  MATH         ErrorText = "1000 VDC + 20 MOhms"
  5.032  ELSEIF       Error == 8
  5.033  MATH         ErrorText = "20 VDC + 20 MOhms"
  5.034  ELSEIF       Error == 9
  5.035  MATH         ErrorText = "20 VDC + 2000 kOhms"
  5.036  ELSEIF       Error == 10
  5.037  MATH         ErrorText = "2 VDC + 2000 kOhms"
  5.038  ELSEIF       Error == 11
  5.039  MATH         ErrorText = "200 Ohms, Zero"
  5.040  ELSEIF       Error == 12
  5.041  MATH         ErrorText = "2 kOhms, Zero"
  5.042  ELSEIF       Error == 13
  5.043  MATH         ErrorText = "20 kOhms, Zero"
  5.044  ELSEIF       Error == 14
  5.045  MATH         ErrorText = "200 kOhms, Zero"
  5.046  ELSEIF       Error == 15
  5.047  MATH         ErrorText = "1000 VDC + X10 T/H + 20 MOhms"
  5.048  ELSEIF       Error == 16
  5.049  MATH         ErrorText = "200 VDC + 200 kOhms"
  5.050  ELSEIF       Error == 17
  5.051  MATH         ErrorText = "200 VDC + 20 kOhms"
  5.052  ELSEIF       Error == 18
  5.053  MATH         ErrorText = "200 VDC + 2 kOhms"
  5.054  ELSEIF       Error == 19
  5.055  MATH         ErrorText = "200 VDC, Filter On"
  5.056  ELSEIF       Error == 20
  5.057  MATH         ErrorText = "200 VDC + 2 kOhms, Filter Off"
  5.058  ELSEIF       Error == 21
  5.059  MATH         ErrorText = "200 VDC, Filter Off"
  5.060  ELSEIF       Error == 22
  5.061  MATH         ErrorText = "X100 T/H"
# Digital self-test errors.
  5.062  ELSEIF       Error == 25
  5.063  MATH         ErrorText = "In-Guard uC Internal RAM"
  5.064  ELSEIF       Error == 26
  5.065  MATH         ErrorText = "Display RAM"
  5.066  ELSEIF       Error == 27
  5.067  MATH         ErrorText = "In-Guard uC Internal Program Memory"
  5.068  ELSEIF       Error == 28
  5.069  MATH         ErrorText = "External Program Memory"
  5.070  ELSEIF       Error == 29
  5.071  MATH         ErrorText = "Calibration Memory"
  5.072  ENDIF

  5.073  RSLT         = Error [V Error]: [V ErrorText]
  5.074  ELSE
  5.075  HEAD         -2
  5.076  END
  5.077  ENDIF

  5.078  JMPL         PERFORMING_SELF_TEST

  5.079  EVAL   Increment Test Number
#
# ====== Sub Fluke 884xA Wait for Cal Step Completion ======================
#
# Prior to calling this procedure, @Timeout must be set (in seconds).
#
# Serial Poll 884xA with a mask of 8 (Cal Step Complete).
  6.001  LABEL        CAL_STEP_COMPLETION

  6.002  DO
  6.003  IEEE         [D1000][SPL 8]

# Check response for a 1 (bit set).
  6.004  IF           MEM
  6.005  END
  6.006  ELSE
# Check to see if timed out waiting for Cal Step Complete.
  6.007  MATH         @Timeout = @Timeout - 1
  6.008  ENDIF

  6.009  UNTIL        NOT(@Timeout)

  6.010  HEAD         -2
  6.011  OPBR         -z Timed out waiting for cal step to complete.
  6.011  OPBR
  6.011  OPBR         Would you like to repeat the step?

  6.012  END
