﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 8842A (1 yr) VER IEEE /5700
DATE:                  2016-07-12 10:37:56
AUTHOR:                Fluke
REVISION:              $Revision: 16471 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       122
NUMBER OF LINES:       1206
CONFIGURATION:         Fluke 5700A
=============================================================================
#
#  Procedure Author:
#        HMK, DFM
#
#  Source(s):
#        Fluke 8842A Digital Multimeter Instruction Manual, P/N 879309,
#         December 1991, Rev. 3, 7/96
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-   R   Q N              P J                                   V

  1.002  MMFC                                                              C2

  1.003  CALL         Sub Display Copyright
  1.004  CALL         Sub High Voltage Safety Warning

  1.005  HEAD         PRELIMINARY INSTRUCTIONS
  1.006  DISP         Ensure a minimum UUT warm-up time of at least
  1.006  DISP         1 hour, in an environment of 18°C to 28°C and
  1.006  DISP         relative humidity of less than 75%, has been
  1.006  DISP         allowed to elapse, prior to proceeding.
  1.006  DISP
  1.006  DISP         Ensure specified warm-up time(s) for required
  1.006  DISP         reference devices has been satisfied.

  1.007  CALL         Sub UUT Connection GPIB

  1.008  HEAD         SETUP PROCEDURE EXECUTION PARAMETERS
  1.009  CALL         Sub Select Failed Test Mode
  1.010  CALL         Sub Select Guardbanding & Ver Method

  1.011  RSLT         =
  1.012  HEAD         {INSTALLED OPTIONS}
  1.013  RSLT         = Option -05 (IEEE-488 Interface)

  1.014  CALL         Sub Fluke 884xA Check AC Option Status

  1.015  HEAD         CHECK INSTRUMENT STATUS
  1.016  MATH         @Status = "NORMAL"
  1.017  CALL         Sub Fluke 884xA Check Cal Status
  1.018  MATH         @Input = "FRONT"
  1.019  CALL         Sub Fluke 884xA Check Input Switch

  1.020  RSLT         =
  1.021  HEAD         {SELF TEST}
  1.022  TARGET
  1.023  DISP         Ensure NOTHING is connected to the UUT [V @Input]
  1.023  DISP         inputs at this time.
  1.024  CALL         Sub Fluke 884xA Self Test
  1.025  EVAL   -e @Error == 0 : [32]

  2.001  IEEE         *
  2.002  JMPL         RESISTANCE_4W

  2.003  LABEL        DC_VOLTS
  2.004  RSLT         =
  2.005  HEAD         {DC VOLTAGE TEST}
  2.006  RSLT         =
  2.007  RSLT         =20 mV Range
  2.008  RSLT         =
  2.009  HEAD         -2 20 mV Range:{ Slow} Reading Rate
  2.010  TARGET       -p
  2.011  IEEE         F1R8S0T2
  2.012  5700         0.0000mV                                          S  2W
# Allow UUT input relays 15 seconds to allow thermal EMFs to dissipate.
  2.013  WAIT         -t 15 Input relay thermal emfs dissipating...
# Store offset.
  2.014  IEEE         ?[I]B1[D10]
  2.015  TOL          0.01% 0.0030U
  2.016  TARGET       -m
  2.017  IEEE         ?[I]
  2.018  MATH         MEM = MEM / 1E-3
  2.019  MEMCX  20    mV             TOL

  3.001  5700         10.0000mV                                         S  2W
  3.002  IEEE         ?[I]
  3.003  MATH         MEM = MEM / 1E-3
  3.004  MEMCX  20    mV             TOL

  4.001  RSLT         =
  4.002  HEAD         -2 20 mV Range:{ Medium} Reading Rate
  4.003  TARGET       -p
  4.004  IEEE         S1
  4.005  5700         0.0000mV                                          S  2W
  4.006  TOL          0.01% 0.0030U 0.0020U
  4.007  TARGET       -m
  4.008  IEEE         ?[I]
  4.009  MATH         MEM = MEM / 1E-3
  4.010  MEMCX  20    mV             TOL

  5.001  5700         10.0000mV                                         S  2W
  5.002  TARGET       -m
  5.003  IEEE         ?[I]
  5.004  MATH         MEM = MEM / 1E-3
  5.005  MEMCX  20    mV             TOL

  6.001  RSLT         =
  6.002  HEAD         -2 20 mV Range:{ Fast} Reading Rate
  6.003  TARGET       -p
  6.004  IEEE         S2
  6.005  5700         0.000mV                                           S  2W
  6.006  TOL          0.01% 0.030U
  6.007  TARGET       -m
  6.008  IEEE         ?[I]
  6.009  MATH         MEM = MEM / 1E-3
  6.010  MEMCX  20    mV             TOL

  7.001  5700         10.000mV                                          S  2W
  7.002  TARGET       -m
  7.003  IEEE         ?[I]
  7.004  MATH         MEM = MEM / 1E-3
  7.005  MEMCX  20    mV             TOL

  8.001  RSLT         =
  8.002  RSLT         =200 mV Range
  8.003  RSLT         =
  8.004  HEAD         -2 200 mV Range:{ Slow} Reading Rate
  8.005  TARGET       -p
  8.006  IEEE         B0R1S0
  8.007  5700         0.000mV                                           S  2W
  8.008  TOL          0.007% 0.003U
  8.009  IEEE         ?[I]B1[D10]
  8.010  TARGET       -m
  8.011  IEEE         ?[I]
  8.012  MATH         MEM = MEM / 1E-3
  8.013  MEMCX  200   mV             TOL

  9.001  5700         100.000mV                                         S  2W
  9.002  IEEE         ?[I]
  9.003  MATH         MEM = MEM / 1E-3
  9.004  MEMCX  200   mV             TOL

 10.001  RSLT         =
 10.002  HEAD         -2 200 mV Range:{ Medium} Reading Rate
 10.003  TARGET       -p
 10.004  IEEE         S1
 10.005  5700         0.000mV                                           S  2W
 10.006  TOL          0.007% 0.003U 0.003U
 10.007  TARGET       -m
 10.008  IEEE         ?[I]
 10.009  MATH         MEM = MEM / 1E-3
 10.010  MEMCX  200   mV             TOL

 11.001  5700         100.000mV                                         S  2W
 11.002  TARGET       -m
 11.003  IEEE         ?[I]
 11.004  MATH         MEM = MEM / 1E-3
 11.005  MEMCX  200   mV             TOL

 12.001  RSLT         =
 12.002  HEAD         -2 200 mV Range:{ Fast} Reading Rate
 12.003  TARGET       -p
 12.004  IEEE         S2
 12.005  5700         0.00mV                                            S  2W
 12.006  TOL          0.007% 0.02U
 12.007  TARGET       -m
 12.008  IEEE         ?[I]
 12.009  MATH         MEM = MEM / 1E-3
 12.010  MEMCX  200   mV             TOL

 13.001  5700         100.00mV                                          S  2W
 13.002  TARGET       -m
 13.003  IEEE         ?[I]
 13.004  MATH         MEM = MEM / 1E-3
 13.005  MEMCX  200   mV             TOL

 14.001  RSLT         =
 14.002  RSLT         =2 V Range
 14.003  RSLT         =
 14.004  HEAD         -2 2 V Range:{ Slow} Reading Rate
 14.005  TARGET       -p
 14.006  IEEE         B0R2S0
 14.007  5700         0.00000V                                          S  2W
 14.008  TOL          0.003% 0.00002U
 14.009  TARGET       -m
 14.010  IEEE         ?[I]
 14.011  MEMCX  2     V              TOL

 15.001  5700         1.00000V                                          S  2W
 15.002  TARGET       -m
 15.003  IEEE         ?[I]
 15.004  MEMCX  2     V              TOL

 16.001  RSLT         =
 16.002  HEAD         -2 2 V Range:{ Medium} Reading Rate
 16.003  TARGET       -p
 16.004  IEEE         S1
 16.005  5700         0.00000V                                          S  2W
 16.006  TOL          0.003% 0.00002U 0.00003U
 16.007  TARGET       -m
 16.008  IEEE         ?[I]
 16.009  MEMCX  2     V              TOL

 17.001  5700         1.00000V                                          S  2W
 17.002  IEEE         ?[I]
 17.003  MEMCX  2     V              0.00006U

 18.001  RSLT         =
 18.002  HEAD         -2 2 V Range:{ Fast} Reading Rate
 18.003  TARGET       -p
 18.004  IEEE         S2
 18.005  5700         0.0000V                                           S  2W
 18.006  TOL          0.003% 0.0002U
 18.007  TARGET       -m
 18.008  IEEE         ?[I]
 18.009  MEMCX  2     V              TOL

 19.001  5700         1.0000V                                           S  2W
 19.002  TARGET       -m
 19.003  IEEE         ?[I]
 19.004  MEMCX  2     V              TOL

 20.001  RSLT         =
 20.002  RSLT         =20 V Range
 20.003  RSLT         =
 20.004  HEAD         -2 20 V Range:{ Slow} Reading Rate
 20.005  TARGET       -p
 20.006  IEEE         R3S0
 20.007  5700         0.0000V                                           S  2W
 20.008  TOL          0.0035% 0.00002U
 20.009  TARGET       -m
 20.010  IEEE         ?[I]
 20.011  MEMCX  20    V              TOL

 21.001  5700         10.0000V                                          S  2W
 21.002  TARGET       -m
 21.003  IEEE         ?[I]
 21.004  MEMCX  20    V              TOL

 22.001  RSLT         =
 22.002  HEAD         -2 20 V Range:{ Medium} Reading Rate
 22.003  TARGET       -p
 22.004  IEEE         S1
 22.005  5700         0.0000V                                           S  2W
 22.006  TOL          0.0035% 0.0002U 0.0003U
 22.007  TARGET       -m
 22.008  IEEE         ?[I]
 22.009  MEMCX  20    V              TOL

 23.001  5700         10.0000V                                          S  2W
 23.002  TARGET       -m
 23.003  IEEE         ?[I]
 23.004  MEMCX  20    V              TOL

 24.001  RSLT         =
 24.002  HEAD         -2 20 V Range:{ Fast} Reading Rate
 24.003  TARGET       -p
 24.004  IEEE         S2
 24.005  5700         0.000V                                            S  2W
 24.006  TOL          0.0035% 0.002U
 24.007  TARGET       -m
 24.008  IEEE         ?[I]
 24.009  MEMCX  20    V              TOL

 25.001  5700         10.000V                                           S  2W
 25.002  TARGET       -m
 25.003  IEEE         ?[I]
 25.004  MEMCX  20    V              TOL

 26.001  RSLT         =
 26.002  RSLT         =200 V Range
 26.003  RSLT         =
 26.004  HEAD         -2 200 V Range:{ Slow} Reading Rate
 26.005  TARGET       -p
 26.006  IEEE         R4S0
 26.007  5700         0.000V                                            S  2W
 26.008  TOL          0.0035% 0.002U
 26.009  TARGET       -m
 26.010  IEEE         ?[I]
 26.011  MEMCX  200   V              TOL

 27.001  5700         100.000V                                          S  2W
 27.002  TARGET       -m
 27.003  IEEE         ?[I]
 27.004  MEMCX  200   V              TOL

 28.001  RSLT         =
 28.002  HEAD         -2 200 V Range:{ Medium} Reading Rate
 28.003  TARGET       -p
 28.004  IEEE         S1
 28.005  5700         0.000V                                            S  2W
 28.006  TOL          0.0035% 0.002U 0.003U
 28.007  TARGET       -m
 28.008  IEEE         ?[I]
 28.009  MEMCX  200   V              TOL

 29.001  5700         100.000V                                          S  2W
 29.002  TARGET       -m
 29.003  IEEE         ?[I]
 29.004  MEMCX  200   V              TOL

 30.001  RSLT         =
 30.002  HEAD         -2 200 V Range:{ Fast} Reading Rate
 30.003  TARGET       -p
 30.004  IEEE         S2
 30.005  5700         0.00V                                             S  2W
 30.006  TOL          0.0035% 0.02U
 30.007  TARGET       -m
 30.008  IEEE         ?[I]
 30.009  MEMCX  200   V              TOL

 31.001  5700         100.00V                                           S  2W
 31.002  TARGET       -m
 31.003  IEEE         ?[I]
 31.004  MEMCX  200   V              TOL

 32.001  RSLT         =
 32.002  RSLT         =1000 V Range
 32.003  RSLT         =
 32.004  HEAD         -2 1000 V Range:{ Slow} Reading Rate
 32.005  TARGET       -p
 32.006  IEEE         R5S0
 32.007  5700         0.00V                                             S  2W
 32.008  TOL          0.0045% 0.02U
 32.009  TARGET       -m
 32.010  IEEE         ?[I]
 32.011  MEMCX  1000  V              TOL

 33.001  5700         1000.00V                                          S  2W
 33.002  TARGET       -m
 33.003  IEEE         ?[I]
 33.004  MEMCX  1000  V              TOL

 34.001  RSLT         =
 34.002  HEAD         -2 1000 V Range:{ Medium} Reading Rate
 34.003  TARGET       -p
 34.004  IEEE         S1
 34.005  5700         0.00V                                             S  2W
 34.006  TOL          0.0045% 0.02U 0.03U
 34.007  TARGET       -m
 34.008  IEEE         ?[I]
 34.009  MEMCX  1000  V              TOL

 35.001  5700         1000.00V                                          S  2W
 35.002  TARGET       -m
 35.003  IEEE         ?[I]
 35.004  MEMCX  1000  V              TOL

 36.001  RSLT         =
 36.002  HEAD         -2 1000 V Range:{ Fast} Reading Rate
 36.003  TARGET
 36.004  IEEE         S2
 36.005  5700         0.0V                                              S  2W
 36.006  TOL          0.0045% 0.2U
 36.007  TARGET       -m
 36.008  IEEE         ?[I]
 36.009  MEMCX  1000  V              TOL

 37.001  5700         1000.0V                                           S  2W
 37.002  TARGET       -m
 37.003  IEEE         ?[I]
 37.004  MEMCX  1000  V              TOL

 38.001  HEAD         -2
 38.002  5700         *                                                 S
 38.003  IEEE         *[D3000]

 38.004  IF           @AC_Option
# Allow UUT input 10 seconds to dissipate internal heating following 1000 VDC
# application.
 38.005  WAIT         -t 10 Input heating dissipating...
 38.006  CALL         Sub Fluke 8842A (1 year) ACV VER IEEE /5700
 38.007  ENDIF

 38.008  JMPL         CURRENT

 38.009  LABEL        RESISTANCE_4W
 38.010  RSLT         =
 38.011  HEAD         {RESISTANCE TEST (4-Wire)}
 38.012  RSLT         =
 38.013  RSLT         =20 Ω Range
 38.014  RSLT         =
 38.015  HEAD         -2 20 Ω Range:{ Slow} Reading Rate
 38.016  TARGET       -p
 38.017  DISP         Make the following connections:
 38.017  DISP
 38.017  DISP         [32] Calibrator       to        UUT
 38.017  DISP         [32] OUTPUT HI ---------------> INPUT HI
 38.017  DISP         [32] OUTPUT LO ---------------> INPUT LO
 38.017  DISP         [32] SENSE HI ----------------> SENSE HI
 38.017  DISP         [32] SENSE LO ----------------> SENSE LO
 38.017  DISP         [32] AUX CURRENT OUTPUT ------> INPUT 2A
 38.017  DISP         [32] V-GUARD (via shields) ---> INPUT LO
 38.018  IEEE         B0F4R8S0T2
 38.019  5700         0.0000Z                                           S  4W
 38.020  TOL          0.012% 0.0040U
# Allow UUT 15 seconds to allow thermal EMFs to dissipate after handling leads
# during hook-up.
 38.021  WAIT         -t 15 Thermal emfs dissipating...
 38.022  IEEE         ?[I]B1[D10]
 38.023  TARGET       -m
 38.024  IEEE         ?[I]
 38.025  MEMCX  20    Z              TOL

 39.001  5700         10.0000Z                                          S  4W
 39.002  TARGET       -m
 39.003  IEEE         ?[I]
 39.004  MEMCX  20    Z              TOL

 40.001  RSLT         =
 40.002  HEAD         -2 20 Ω Range:{ Medium} Reading Rate
 40.003  TARGET       -p
 40.004  IEEE         S1
 40.005  5700         0.0000Z                                           S  4W
 40.006  TOL          0.012% 0.0040U 0.0020U
 40.007  TARGET       -m
 40.008  IEEE         ?[I]
 40.009  MEMCX  20    Z              TOL

 41.001  5700         10.0000Z                                          S  4W
 41.002  TARGET       -m
 41.003  IEEE         ?[I]
 41.004  MEMCX  20    Z              TOL

 42.001  RSLT         =
 42.002  HEAD         -2 20 Ω Range:{ Fast} Reading Rate
 42.003  TARGET       -p
 42.004  IEEE         S2
 42.005  5700         0.000Z                                            S  4W
 42.006  TOL          0.012% 0.020U
 42.007  TARGET       -m
 42.008  IEEE         ?[I]
 42.009  MEMCX  20    Z              TOL

 43.001  5700         10.0000Z                                          S  4W
 43.002  TARGET       -m
 43.003  IEEE         ?[I]
 43.004  MEMCX  20    Z              TOL

 44.001  RSLT         =
 44.002  RSLT         =200 Ω Range
 44.003  RSLT         =
 44.004  HEAD         -2 200 Ω Range:{ Slow} Reading Rate
 44.005  TARGET       -p
 44.006  IEEE         B0R1S0
 44.007  5700         0.000Z                                            S  4W
 44.008  TOL          0.010% 0.004U
 44.009  IEEE         ?[I]B1[D10]
 44.010  TARGET       -m
 44.011  IEEE         ?[I]
 44.012  MEMCX  200   Z              TOL

 45.001  5700         100.000Z                                          S  4W
 45.002  TARGET       -m
 45.003  IEEE         ?[I]
 45.004  MEMCX  200   Z              TOL

 46.001  RSLT         =
 46.002  HEAD         -2 200 Ω Range:{ Medium} Reading Rate
 46.003  TARGET       -p
 46.004  IEEE         S1
 46.005  5700         0.000Z                                            S  4W
 46.006  TOL          0.010% 0.004U 0.002U
 46.007  TARGET       -m
 46.008  IEEE         ?[I]
 46.009  MEMCX  200   Z              TOL

 47.001  5700         100.000Z                                          S  4W
 47.002  TARGET       -m
 47.003  IEEE         ?[I]
 47.004  MEMCX  200   Z              TOL

 48.001  RSLT         =
 48.002  HEAD         -2 200 Ω Range:{ Fast} Reading Rate
 48.003  TARGET       -p
 48.004  IEEE         S2
 48.005  5700         0.00Z                                             S  4W
 48.006  TOL          0.010% 0.03U
 48.007  TARGET       -m
 48.008  IEEE         ?[I]
 48.009  MEMCX  200   Z              TOL

 49.001  5700         100.00Z                                           S  4W
 49.002  TARGET       -m
 49.003  IEEE         ?[I]
 49.004  MEMCX  200   Z              TOL

 50.001  RSLT         =
 50.002  RSLT         =2 kΩ Range
 50.003  RSLT         =
 50.004  HEAD         -2 2 kΩ Range:{ Slow} Reading Rate
 50.005  TARGET       -p
 50.006  IEEE         B0R2S0
 50.007  5700         0.00000kZ                                         S  4W
 50.008  TOL          0.008% 0.00003U
 50.009  IEEE         ?[I]B1[D10]
 50.010  TARGET       -m
 50.011  IEEE         ?[I]
 50.012  MATH         MEM = MEM / 1E+3
 50.013  MEMCX  2     kZ             TOL

 51.001  5700         1.00000kZ                                         S  4W
 51.002  TARGET       -m
 51.003  IEEE         ?[I]
 51.004  MATH         MEM = MEM / 1E+3
 51.005  MEMCX  2     kZ             TOL

 52.001  RSLT         =
 52.002  HEAD         -2 2 kΩ Range:{ Medium} Reading Rate
 52.003  TARGET       -p
 52.004  IEEE         S1
 52.005  5700         0.00000kZ                                         S  4W
 52.006  TOL          0.008% 0.00003U 0.00002U
 52.007  TARGET       -m
 52.008  IEEE         ?[I]
 52.009  MATH         MEM = MEM / 1E+3
 52.010  MEMCX  2     kZ             TOL

 53.001  5700         1.00000kZ                                         S  4W
 53.002  TARGET       -m
 53.003  IEEE         ?[I]
 53.004  MATH         MEM = MEM / 1E+3
 53.005  MEMCX  2     kZ             TOL

 54.001  RSLT         =
 54.002  HEAD         -2 2 kΩ Range:{ Fast} Reading Rate
 54.003  TARGET       -p
 54.004  IEEE         S2
 54.005  5700         0.0000kZ                                          S  4W
 54.006  TOL          0.008% 0.0002U
 54.007  TARGET       -m
 54.008  IEEE         ?[I]
 54.009  MATH         MEM = MEM / 1E+3
 54.010  MEMCX  2     kZ             TOL

 55.001  5700         1.0000kZ                                          S  4W
 55.002  TARGET       -m
 55.003  IEEE         ?[I]
 55.004  MATH         MEM = MEM / 1E+3
 55.005  MEMCX  2     kZ             TOL

 56.001  RSLT         =
 56.002  RSLT         =20 kΩ Range
 56.003  RSLT         =
 56.004  HEAD         -2 20 kΩ Range:{ Slow} Reading Rate
 56.005  TARGET       -p
 56.006  IEEE         B0R3S0
 56.007  5700         0.0000kZ                                          S  4W
 56.008  TOL          0.008% 0.0003U
 56.009  IEEE         ?[I]B1[D10]
 56.010  TARGET       -m
 56.011  IEEE         ?[I]
 56.012  MATH         MEM = MEM / 1E+3
 56.013  MEMCX  20    kZ             TOL

 57.001  5700         10.0000kZ                                         S  4W
 57.002  TARGET       -m
 57.003  IEEE         ?[I]
 57.004  MATH         MEM = MEM / 1E+3
 57.005  MEMCX  20    kZ             TOL

 58.001  RSLT         =
 58.002  HEAD         -2 20 kΩ Range:{ Medium} Reading Rate
 58.003  TARGET       -p
 58.004  IEEE         S1
 58.005  5700         0.0000kZ                                          S  4W
 58.006  TOL          0.008% 0.0003U 0.0002U
 58.007  TARGET       -m
 58.008  IEEE         ?[I]
 58.009  MATH         MEM = MEM / 1E+3
 58.010  MEMCX  20    kZ             TOL

 59.001  5700         10.0000kZ                                         S  4W
 59.002  TARGET       -m
 59.003  IEEE         ?[I]
 59.004  MATH         MEM = MEM / 1E+3
 59.005  MEMCX  20    kZ             TOL

 60.001  RSLT         =
 60.002  HEAD         -2 20 kΩ Range:{ Fast} Reading Rate
 60.003  TARGET       -p
 60.004  IEEE         S2
 60.005  5700         0.000kZ                                           S  4W
 60.006  TOL          0.008% 0.002U
 60.007  TARGET       -m
 60.008  IEEE         ?[I]
 60.009  MATH         MEM = MEM / 1E+3
 60.010  MEMCX  20    kZ             TOL

 61.001  5700         10.000kZ                                          S  4W
 61.002  TARGET       -m
 61.003  IEEE         ?[I]
 61.004  MATH         MEM = MEM / 1E+3
 61.005  MEMCX  20    kZ             TOL

 62.001  RSLT         =
 62.002  RSLT         =200 kΩ Range
 62.003  RSLT         =
 62.004  HEAD         -2 200 kΩ Range:{ Slow} Reading Rate
 62.005  TARGET       -p
 62.006  IEEE         B0R4S0
 62.007  5700         0.000kZ                                           S  4W
 62.008  TOL          0.010% 0.003U
 62.009  IEEE         ?[I]B1[D10]
 62.010  TARGET       -m
 62.011  IEEE         ?[I]
 62.012  MATH         MEM = MEM / 1E+3
 62.013  MEMCX  200   kZ             TOL

 63.001  5700         100.000kZ                                         S  4W
 63.002  TARGET       -m
 63.003  IEEE         ?[I]
 63.004  MATH         MEM = MEM / 1E+3
 63.005  MEMCX  200   kZ             TOL

 64.001  RSLT         =
 64.002  HEAD         -2 200 kΩ Range:{ Medium} Reading Rate
 64.003  TARGET       -p
 64.004  IEEE         S1
 64.005  5700         0.000kZ                                           S  4W
 64.006  TOL          0.010% 0.003U 0.002U
 64.007  TARGET       -m
 64.008  IEEE         ?[I]
 64.009  MATH         MEM = MEM / 1E+3
 64.010  MEMCX  200   kZ             TOL

 65.001  5700         100.000kZ                                         S  4W
 65.002  TARGET       -m
 65.003  IEEE         ?[I]
 65.004  MATH         MEM = MEM / 1E+3
 65.005  MEMCX  200   kZ             TOL

 66.001  RSLT         =
 66.002  HEAD         -2 200 kΩ Range:{ Fast} Reading Rate
 66.003  TARGET
 66.004  IEEE         S2
 66.005  5700         0.00kZ                                            S  4W
 66.006  TOL          0.010% 0.02U
 66.007  TARGET       -m
 66.008  IEEE         ?[I]
 66.009  MATH         MEM = MEM / 1E+3
 66.010  MEMCX  200   kZ             TOL

 67.001  5700         100.00kZ                                          S  4W
 67.002  TARGET       -m
 67.003  IEEE         ?[I]
 67.004  MATH         MEM = MEM / 1E+3
 67.005  MEMCX  200   kZ             TOL

 68.001  RSLT         =
 68.002  RSLT         =2000 kΩ Range
 68.003  RSLT         =
 68.004  HEAD         -2 2000 kΩ Range:{ Slow} Reading Rate
 68.005  TARGET       -p
 68.006  IEEE         B0R5S0
 68.007  5700         0.00kZ                                            S  4W
 68.008  TOL          0.027% 0.03U
 68.009  IEEE         ?[I]B1[D10]
 68.010  TARGET       -m
 68.011  IEEE         ?[I]
 68.012  MATH         MEM = MEM / 1E+3
 68.013  MEMCX  2000  kZ             TOL

 69.001  5700         1000.00kZ                                         S  4W
 69.002  TARGET       -m
 69.003  IEEE         ?[I]
 69.004  MATH         MEM = MEM / 1E+3
 69.005  MEMCX  2000  kZ             TOL

 70.001  RSLT         =
 70.002  HEAD         -2 2000 kΩ Range:{ Medium} Reading Rate
 70.003  TARGET       -p
 70.004  IEEE         S1
 70.005  5700         0.00kZ                                            S  4W
 70.006  TOL          0.027% 0.03U 0.03U
 70.007  TARGET       -m
 70.008  IEEE         ?[I]
 70.009  MATH         MEM = MEM / 1E+3
 70.010  MEMCX  2000  kZ             TOL

 71.001  5700         1000.00kZ                                         S  4W
 71.002  TARGET       -m
 71.003  IEEE         ?[I]
 71.004  MATH         MEM = MEM / 1E+3
 71.005  MEMCX  2000  kZ             TOL

 72.001  RSLT         =
 72.002  HEAD         -2 2000 kΩ Range:{ Fast} Reading Rate
 72.003  TARGET       -p
 72.004  IEEE         S2
 72.005  5700         0.0kZ                                             S  4W
 72.006  TOL          0.027% 0.2U
 72.007  TARGET       -m
 72.008  IEEE         ?[I]
 72.009  MATH         MEM = MEM / 1E+3
 72.010  MEMCX  2000  kZ             TOL

 73.001  5700         1000.0kZ                                          S  4W
 73.002  TARGET       -m
 73.003  IEEE         ?[I]
 73.004  MATH         MEM = MEM / 1E+3
 73.005  MEMCX  2000  kZ             TOL

 74.001  RSLT         =
 74.002  RSLT         =20 MΩ Range
 74.003  RSLT         =
 74.004  HEAD         -2 20 MΩ Range:{ Slow} Reading Rate
 74.005  TARGET       -p
 74.006  IEEE         B0R6S0
 74.007  5700         0.0000MZ                                          S  4W
 74.008  TOL          0.042% 0.0004U
 74.009  IEEE         ?[I]B1[D10]
 74.010  TARGET       -m
 74.011  IEEE         ?[I]
 74.012  MATH         MEM = MEM / 1E+6
 74.013  MEMCX  20    MZ             TOL

 75.001  5700         10.0000MZ                                         S  4W
 75.002  TARGET       -m
 75.003  IEEE         ?[I]
 75.004  MATH         MEM = MEM / 1E+6
 75.005  MEMCX  20    MZ             TOL

 76.001  RSLT         =
 76.002  HEAD         -2 20 MΩ Range:{ Medium} Reading Rate
 76.003  TARGET       -p
 76.004  IEEE         S1
 76.005  5700         0.0000MZ                                          S  4W
 76.006  TOL          0.042% 0.0004U 0.0003U
 76.007  TARGET       -m
 76.008  IEEE         ?[I]
 76.009  MATH         MEM = MEM / 1E+6
 76.010  MEMCX  20    MZ             TOL

 77.001  5700         10.0000MZ                                         S  4W
 77.002  TARGET       -m
 77.003  IEEE         ?[I]
 77.004  MATH         MEM = MEM / 1E+6
 77.005  MEMCX  20    MZ             TOL

 78.001  RSLT         =
 78.002  HEAD         -2 20 MΩ Range:{ Fast} Reading Rate
 78.003  TARGET       -p
 78.004  IEEE         S2
 78.005  5700         0.000MZ                                           S  4W
 78.006  TOL          0.042% 0.002U
 78.007  TARGET       -m
 78.008  IEEE         ?[I]
 78.009  MATH         MEM = MEM / 1E+6
 78.010  MEMCX  20    MZ             TOL

 79.001  5700         10.000MZ                                          S  4W
 79.002  TARGET       -m
 79.003  IEEE         ?[I]
 79.004  MATH         MEM = MEM / 1E+6
 79.005  MEMCX  20    MZ             TOL

 80.001  HEAD         -2
 80.002  5700         *                                                 S
 80.003  IEEE         *[D3000]

 80.004  JMPL         DC_VOLTS

 80.005  LABEL        RESISTANCE_2W
 80.006  RSLT         =
 80.007  HEAD         {RESISTANCE TEST (2-Wire)}

 80.008  DISP         Make the following connections:
 80.008  DISP
 80.008  DISP         [32]       5700A       to       UUT
 80.008  DISP         [32] OUTPUT HI -----> INPUT HI
 80.008  DISP         [32]    SENSE V/Ohm HI -------> INPUT HI
 80.008  DISP         [32]    SENSE V/Ohm LO -------> INPUT LO
 80.008  DISP         [32] OUTPUT V/Ω/A LO -----> INPUT LO
 80.008  DISP
 80.008  DISP         NOTE: Connect sense leads to UUT first!

 80.009  RSLT         =
 80.010  RSLT         =2 kΩ Range
 80.011  RSLT         =
 80.012  HEAD         -2 2 kΩ Range:{ Slow} Reading Rate
 80.013  TARGET       -p
 80.014  IEEE         B0F3R2S0T2
 80.015  5700         0.00000kZ                                         S  CW
 80.016  TOL          0.008% 0.00003U
 80.017  TARGET       -m
 80.018  IEEE         ?[I]
 80.019  MATH         MEM = MEM / 1E+3
 80.020  MEMCX  2     kZ             TOL

 81.001  5700         1.00000kZ                                         S  CW
 81.002  TARGET       -m
 81.003  IEEE         ?[I]
 81.004  MATH         MEM = MEM / 1E+3
 81.005  MEMCX  2     kZ             TOL

 82.001  RSLT         =
 82.002  HEAD         -2 2 kΩ Range:{ Medium} Reading Rate
 82.003  TARGET       -p
 82.004  IEEE         S1
 82.005  5700         0.00000kZ                                         S  CW
 82.006  TOL          0.008% 0.00003U 0.00002U
 82.007  TARGET       -m
 82.008  IEEE         ?[I]
 82.009  MATH         MEM = MEM / 1E+3
 82.010  MEMCX  2     kZ             TOL

 83.001  5700         1.00000kZ                                         S  CW
 83.002  TARGET       -m
 83.003  IEEE         ?[I]
 83.004  MATH         MEM = MEM / 1E+3
 83.005  MEMCX  2     kZ             TOL

 84.001  RSLT         =
 84.002  HEAD         -2 2 kΩ Range:{ Fast} Reading Rate
 84.003  TARGET       -p
 84.004  IEEE         S2
 84.005  5700         0.0000kZ                                          S  CW
 84.006  TOL          0.008% 0.0002U
 84.007  TARGET       -m
 84.008  IEEE         ?[I]
 84.009  MATH         MEM = MEM / 1E+3
 84.010  MEMCX  2     kZ             TOL

 85.001  5700         1.0000kZ                                          S  CW
 85.002  TARGET       -m
 85.003  IEEE         ?[I]
 85.004  MATH         MEM = MEM / 1E+3
 85.005  MEMCX  2     kZ             TOL

 86.001  RSLT         =
 86.002  RSLT         =20 kΩ Range
 86.003  RSLT         =
 86.004  HEAD         -2 20 kΩ Range:{ Slow} Reading Rate
 86.005  TARGET       -p
 86.006  IEEE         B0R3S0
# The 8842A is zeroed. Offset errors by the 5700A are cancelled out.
 86.007  5700         0.0000kZ                                          S  CW
 86.008  TOL          0.008% 0.0003U
 86.009  IEEE         ?[I]B1[D10]
 86.010  TARGET       -m
 86.011  IEEE         ?[I]
 86.012  MATH         MEM = MEM / 1E+3
 86.013  MEMCX  20    kZ             TOL

 87.001  5700         10.0000kZ                                         S  CW
 87.002  TARGET       -m
 87.003  IEEE         ?[I]
 87.004  MATH         MEM = MEM / 1E+3
 87.005  MEMCX  20    kZ             TOL

 88.001  RSLT         =
 88.002  HEAD         -2 20 kΩ Range:{ Medium} Reading Rate
 88.003  TARGET       -p
 88.004  IEEE         S1
 88.005  5700         0.0000kZ                                          S  CW
 88.006  TOL          0.008% 0.0003U 0.0002U
 88.007  TARGET       -m
 88.008  IEEE         ?[I]
 88.009  MATH         MEM = MEM / 1E+3
 88.010  MEMCX  20    kZ             TOL

 89.001  5700         10.0000kZ                                         S  CW
 89.002  TARGET       -m
 89.003  IEEE         ?[I]
 89.004  MATH         MEM = MEM / 1E+3
 89.005  MEMCX  20    kZ             TOL

 90.001  RSLT         =
 90.002  HEAD         -2 20 kΩ Range:{ Fast} Reading Rate
 90.003  TARGET       -p
 90.004  IEEE         S2
 90.005  5700         0.000kZ                                           S  CW
 90.006  TOL          0.008% 0.002U
 90.007  TARGET       -m
 90.008  IEEE         ?[I]
 90.009  MATH         MEM = MEM / 1E+3
 90.010  MEMCX  20    kZ             TOL

 91.001  5700         10.000kZ                                          S  CW
 91.002  TARGET       -m
 91.003  IEEE         ?[I]
 91.004  MATH         MEM = MEM / 1E+3
 91.005  MEMCX  20    kZ             TOL

 92.001  RSLT         =
 92.002  RSLT         =200 kΩ Range
 92.003  RSLT         =
 92.004  HEAD         -2 200 kΩ Range:{ Slow} Reading Rate
 92.005  TARGET       -p
 92.006  IEEE         B0R4S0
# The 8842A is zeroed. Offset errors by the 5700A are cancelled out.
 92.007  5700         0.000kZ                                           S  CW
 92.008  TOL          0.010% 0.003U
 92.009  IEEE         ?[I]B1[D10]
 92.010  TARGET       -m
 92.011  IEEE         ?[I]
 92.012  MATH         MEM = MEM / 1E+3
 92.013  MEMCX  200   kZ             TOL

 93.001  5700         100.000kZ                                         S  2W
 93.002  TARGET       -m
 93.003  IEEE         ?[I]
 93.004  MATH         MEM = MEM / 1E+3
 93.005  MEMCX  200   kZ             TOL

 94.001  RSLT         =
 94.002  HEAD         -2 200 kΩ Range:{ Medium} Reading Rate
 94.003  TARGET       -p
 94.004  IEEE         S1
 94.005  5700         0.000kZ                                           S  CW
 94.006  TOL          0.010% 0.003U 0.002U
 94.007  TARGET       -m
 94.008  IEEE         ?[I]
 94.009  MATH         MEM = MEM / 1E+3
 94.010  MEMCX  200   kZ             TOL

 95.001  5700         100.000kZ                                         S  2W
 95.002  TARGET       -m
 95.003  IEEE         ?[I]
 95.004  MATH         MEM = MEM / 1E+3
 95.005  MEMCX  200   kZ             TOL

 96.001  RSLT         =
 96.002  HEAD         -2 200 kΩ Range:{ Fast} Reading Rate
 96.003  TARGET
 96.004  IEEE         S2
 96.005  5700         0.00kZ                                            S  CW
 96.006  TOL          0.010% 0.02U
 96.007  TARGET       -m
 96.008  IEEE         ?[I]
 96.009  MATH         MEM = MEM / 1E+3
 96.010  MEMCX  200   kZ             TOL

 97.001  5700         100.00kZ                                          S  2W
 97.002  TARGET       -m
 97.003  IEEE         ?[I]
 97.004  MATH         MEM = MEM / 1E+3
 97.005  MEMCX  200   kZ             TOL

 98.001  RSLT         =
 98.002  RSLT         =2000 kΩ Range
 98.003  RSLT         =
 98.004  HEAD         -2 2000 kΩ Range:{ Slow} Reading Rate
 98.005  TARGET       -p
 98.006  IEEE         B0R5S0
 98.007  5700         0.00kZ                                            S  CW
 98.008  TOL          0.027% 0.03U
 98.009  IEEE         ?[I]B1[D10]
 98.010  TARGET       -m
 98.011  IEEE         ?[I]
 98.012  MATH         MEM = MEM / 1E+3
 98.013  MEMCX  2000  kZ             TOL

 99.001  5700         1000.00kZ                                         S  2W
 99.002  TARGET       -m
 99.003  IEEE         ?[I]
 99.004  MATH         MEM = MEM / 1E+3
 99.005  MEMCX  2000  kZ             TOL

100.001  RSLT         =
100.002  HEAD         -2 2000 kΩ Range:{ Medium} Reading Rate
100.003  TARGET       -p
100.004  IEEE         S1
100.005  5700         0.00kZ                                            S  CW
100.006  TOL          0.027% 0.03U 0.03U
100.007  TARGET       -m
100.008  IEEE         ?[I]
100.009  MATH         MEM = MEM / 1E+3
100.010  MEMCX  2000  kZ             TOL

101.001  5700         1000.00kZ                                         S  2W
101.002  TARGET       -m
101.003  IEEE         ?[I]
101.004  MATH         MEM = MEM / 1E+3
101.005  MEMCX  2000  kZ             TOL

102.001  RSLT         =
102.002  HEAD         -2 2000 kΩ Range:{ Fast} Reading Rate
102.003  TARGET       -p
102.004  IEEE         S2
102.005  5700         0.0kZ                                             S  CW
102.006  TOL          0.027% 0.2U
102.007  TARGET       -m
102.008  IEEE         ?[I]
102.009  MATH         MEM = MEM / 1E+3
102.010  MEMCX  2000  kZ             TOL

103.001  5700         1000.0kZ                                          S  2W
103.002  TARGET       -m
103.003  IEEE         ?[I]
103.004  MATH         MEM = MEM / 1E+3
103.005  MEMCX  2000  kZ             TOL

104.001  RSLT         =
104.002  RSLT         =20 MΩ Range
104.003  RSLT         =
104.004  HEAD         -2 20 MΩ Range:{ Slow} Reading Rate
104.005  TARGET       -p
104.006  IEEE         B0R6S0
104.007  5700         0.0000MZ                                          S  CW
104.008  TOL          0.042% 0.0004U
104.009  IEEE         ?[I]B1[D10]
104.010  TARGET       -m
104.011  IEEE         ?[I]
104.012  MATH         MEM = MEM / 1E+6
104.013  MEMCX  20    MZ             TOL

105.001  5700         10.0000MZ                                         S  2W
105.002  TARGET       -m
105.003  IEEE         ?[I]
105.004  MATH         MEM = MEM / 1E+6
105.005  MEMCX  20    MZ             TOL

106.001  RSLT         =
106.002  HEAD         -2 20 MΩ Range:{ Medium} Reading Rate
106.003  TARGET       -p
106.004  IEEE         S1
106.005  5700         0.0000MZ                                          S  CW
106.006  TOL          0.042% 0.0004U 0.0003U
106.007  TARGET       -m
106.008  IEEE         ?[I]
106.009  MATH         MEM = MEM / 1E+6
106.010  MEMCX  20    MZ             TOL

107.001  5700         10.0000MZ                                         S  2W
107.002  TARGET       -m
107.003  IEEE         ?[I]
107.004  MATH         MEM = MEM / 1E+6
107.005  MEMCX  20    MZ             TOL

108.001  RSLT         =
108.002  HEAD         -2 20 MΩ Range:{ Fast} Reading Rate
108.003  TARGET       -p
108.004  IEEE         S2
108.005  5700         0.000MZ                                           S  CW
108.006  TOL          0.042% 0.002U
108.007  TARGET       -m
108.008  IEEE         ?[I]
108.009  MATH         MEM = MEM / 1E+6
108.010  MEMCX  20    MZ             TOL

109.001  5700         10.000MZ                                          S  2W
109.002  TARGET       -m
109.003  IEEE         ?[I]
109.004  MATH         MEM = MEM / 1E+6
109.005  MEMCX  20    MZ             TOL
110.001  JMPL         END

110.002  LABEL        CURRENT
110.003  RSLT         =
110.004  HEAD         {DC CURRENT TEST}
110.005  RSLT         =
110.006  RSLT         =200 mA Range
110.007  RSLT         =
110.008  HEAD         -2 200 mA Range:{ Slow} Reading Rate
110.009  TARGET       -p
110.010  IEEE         F5R4S0
# Allow UUT 10 seconds to allow thermal EMFs to dissipate following high
# voltage AC tests.
110.011  WAIT         -t 10 Thermal emfs dissipating...
110.012  ACC          0.000mA        0.000001U
110.013  TOL          0.05% 0.040U
110.014  TARGET       -m
110.015  IEEE         ?[I]
110.016  MATH         MEM = MEM / 1E-3
110.017  MEMCX  200   mA             TOL

111.001  5700         100.000mA                                         S  2W
111.002  TARGET       -m
111.003  IEEE         ?[I]
111.004  MATH         MEM = MEM / 1E-3
111.005  MEMCX  200   mA             TOL

112.001  5700         *                                                 S

112.002  RSLT         =
112.003  HEAD         -2 200 mA Range:{ Medium} Reading Rate
112.004  TARGET       -p
112.005  IEEE         S1
112.006  ACC          0.000mA        0.000001U
112.007  TOL          0.05% 0.040U 0.002U
112.008  TARGET       -m
112.009  IEEE         ?[I]
112.010  MATH         MEM = MEM / 1E-3
112.011  MEMCX  200   mA             TOL

113.001  5700         100.000mA                                         S  2W
113.002  TARGET       -m
113.003  IEEE         ?[I]
113.004  MATH         MEM = MEM / 1E-3
113.005  MEMCX  200   mA             TOL

114.001  5700         *                                                 S

114.002  RSLT         =
114.003  HEAD         -2 200 mA Range:{ Fast} Reading Rate
114.004  TARGET       -p
114.005  IEEE         S2
114.006  TOL          0.05% 0.20U
114.007  ACC          0.0mA          0.000001U
114.008  TARGET       -m
114.009  IEEE         ?[I]
114.010  MATH         MEM = MEM / 1E-3
114.011  MEMCX  200   mA             TOL

115.001  5700         100.00mA                                          S  2W
115.002  TARGET       -m
115.003  IEEE         ?[I]
115.004  MATH         MEM = MEM / 1E-3
115.005  MEMCX  200   mA             TOL

116.001  5700         *                                                 S

116.002  RSLT         =
116.003  RSLT         =2000 mA Range
116.004  RSLT         =
116.005  HEAD         -2 2000 mA Range:{ Slow} Reading Rate
116.006  TARGET       -p
116.007  IEEE         R5S0
116.008  ACC          0.00mA         0.000001U
116.009  TOL          0.05% 0.04U
116.010  TARGET       -m
116.011  IEEE         ?[I]
116.012  MATH         MEM = MEM / 1E-3
116.013  MEMCX  2000  mA             TOL

117.001  5700         1000.00mA                                         S  2W
117.002  TARGET       -m
117.003  IEEE         ?[I]
117.004  MATH         MEM = MEM / 1E-3
117.005  MEMCX  2000  mA             TOL

118.001  5700         *                                                 S

118.002  RSLT         =
118.003  HEAD         -2 2000 mA Range:{ Medium} Reading Rate
118.004  TARGET       -p
118.005  IEEE         S1
118.006  ACC          0.00mA         0.000001U
118.007  TOL          0.05% 0.04U 0.02U
118.008  TARGET       -m
118.009  IEEE         ?[I]
118.010  MATH         MEM = MEM / 1E-3
118.011  MEMCX  2000  mA             TOL

119.001  5700         1000.00mA                                         S  2W
119.002  TARGET       -m
119.003  IEEE         ?[I]
119.004  MATH         MEM = MEM / 1E-3
119.005  MEMCX  2000  mA             TOL

120.001  5700         *                                                 S

120.002  RSLT         =
120.003  HEAD         -2 2000 mA Range:{ Fast} Reading Rate
120.004  TARGET       -p
120.005  IEEE         S2
120.006  ACC          0.0mA          1e-6U
120.007  TOL          0.05% 0.2U
120.008  TARGET       -m
120.009  IEEE         ?[I]
120.010  MATH         MEM = MEM / 1E-3
120.011  MEMCX  2000  mA             TOL

121.001  5700         1000.0mA                                          S  2W
121.002  TARGET       -m
121.003  IEEE         ?[I]
121.004  MATH         MEM = MEM / 1E-3
121.005  MEMCX  2000  mA             TOL

122.001  5700         *                                                 S
122.002  IEEE         *[D3000]

122.003  IF           @AC_Option
122.004  CALL         Sub Fluke 884xA (1 yr) ACI VER IEEE /5700
122.005  ENDIF

122.006  JMPL         RESISTANCE_2W

122.007  LABEL        END

122.008  HEAD         -2
122.009  HEAD
122.010  END
