﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tegam/ESI DB62-11M (2 yr) VER /8508
DATE:                  2016-06-28 13:27:00
AUTHOR:                Fluke
REVISION:              $Revision: 16411 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       87
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 8508A 1 year specifications.
#
#        100 Ω STEPS: 200 Ω;  TUR 3.8333
#        1 MEG STEPS:   2 MΩ;   TUR 3.0770
#
#  Source:
#        ESI DATASHEET
#        Model DB62
#        Dekabox In-line Decade Resistors
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  8508         *                                                 S
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                                     V

  1.005  IF           NOT(VERSIONCHECK("8.0"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub Select Failed Test Mode
  1.010  CALL         Sub Select Verification Method (No NTHROW)

  1.011  HEAD         TEST SETUP
  1.012  DISP         Make the following connections:
  1.012  DISP         [32]  8508A     to       UUT
  1.012  DISP         [32] SENSE HI ------> 1 terminal
  1.012  DISP         [32] SENSE LO ------> 2 terminal
  1.012  DISP         [32] INPUT HI ------> 1 terminal
  1.012  DISP         [32] INPUT LO ------> 2 terminal
  1.012  DISP
  1.012  DISP         Connect the sense leads to the UUT first!

  1.013  DISP         In order to minimize contact resistance effects due
  1.013  DISP         to oxidation of the UUT switch contacts, exercise the
  1.013  DISP         UUT dials by rotating them several times, prior to
  1.013  DISP         proceeding.

# Set resolution to floor specification.
  1.014  VSET         UUT_RES = 6E-3

  1.015  MATH         @ModelNum = "DB62-11M"

  1.016  CALL         Sub Tegam/ESI DB62 Zero /8508
  1.017  CALL         Sub Tegam/ESI DB62 (2 yr) 10 Ω Steps VER /8508
  1.018  CALL         Sub Tegam/ESI DB62 (2 yr) 100 Ω Steps VER /8508
  1.019  CALL         Sub Tegam/ESI DB62 (2 yr) 1 K Steps VER /8508
  1.020  CALL         Sub Tegam/ESI DB62 (2 yr) 10 K Steps VER /8508
  1.021  CALL         Sub Tegam/ESI DB62 (2 yr) 100 K Steps VER /8508
  1.022  CALL         Sub Tegam/ESI DB62 (2 yr) 1 MEG Steps VER /8508

  1.023  END
