﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 80 Series V Verify Adj Password
DATE:                  2015-04-10 09:55:31
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10780 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       99
=============================================================================
#
#  Procedure Author(s):
#        DFM, DAC, VY, PS, ND
#
#  Model(s) Covered:
#        83 V, 87 V, 87 V/AN, 87 V EX, 88 V
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        Probe, test, safety plug (normally supplied with UUT)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  HEAD         {ENTER CALIBRATION ADJUSTMENT MODE}
  1.002  TARGET
  1.003  DISP         Starting with the UUT rotary function switch set to
  1.003  DISP         OFF, press and hold the UUT MIN MAX pushbutton while
  1.003  DISP         turning the rotary function switch to V AC. The UUT
  1.003  DISP         display will show "CAL".
  1.003  DISP
  1.003  DISP         Release the MIN MAX pushbutton.
  1.003  DISP
  1.003  DISP         Press the AutoHOLD button once. The UUT display will
  1.003  DISP         indicate the number of calibrations that have been
  1.003  DISP         completed.
  1.003  DISP
  1.003  DISP         Pressing the AutoHOLD button once more will prepare
  1.003  DISP         the UUT to receive adjustment password entry. The
  1.003  DISP         UUT display will show "????".

  1.004  DO
  1.005  DISP         Using the following list, enter the adjustment password.
  1.005  DISP
  1.005  DISP         yellow = 1     MINMAX = 2      RANGE = 3  AutoHOLD = 4
  1.005  DISP         Backlight = 5  Continuity = 6  REL = 7    Hz % = 8
  1.005  DISP
  1.005  DISP         The default password at time of manufacture is 1234.
  1.005  DISP
  1.005  DISP         Enter the correct four key password, then press AutoHOLD
  1.005  DISP         pushbutton to verify it.

  1.006  OPBR         -z Is "C-01" displayed on the UUT?
  1.007  MATH         @AdjStart = MEM1

  1.008  IF           NOT(@AdjStart)
  1.009  OPBR         -z Password you entered is not correct.
  1.009  OPBR
  1.009  OPBR         Do you want to try again?

  1.010  IF           NOT(MEM1)
  1.011  DISP         Procedure will be aborted!
  1.011  DISP
  1.011  DISP         Reference the UUT Calibration / Service Manual
  1.011  DISP         to change or reset the default password, then
  1.011  DISP         start the calibration again.
  1.012  END
  1.013  ENDIF

  1.014  ENDIF

  1.015  UNTIL        @AdjStart

  1.016  HEAD
  1.017  END
