﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 87 V,87 V/AN,87 V/EX CalSteps ADJ /5502
DATE:                  2015-04-10 14:09:01
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10822 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       198
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#
#  Procedure Author(s):
#        DFM, VY, GMO, PS, ND
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  HEAD         CALIBRATION START
  1.002  MATH         StepNo = 1

  1.003  DO

  1.004  MATH         Step = "C-" & FMT(StepNo, "%02.0f")

  1.005  IF           StepNo < 31
  1.006  MATH         Next = "C-" & FMT((StepNo + 1), "%02.0f")
  1.007  ELSE
  1.008  MATH         Next = "End"
  1.009  ENDIF

  1.010  HEAD         -2 Adjustment Step [V Step]
  1.011  TARGET

  1.012  IF           StepNo == 1

  1.013  HEAD         AC VOLTS CALIBRATION
  1.014  DISP         Rotate UUT function switch to V AC.
  1.015  PIC          55xx_8x_2w
  1.016  5502E        +Voltage = 600 mV; Frequency = 60 Hz
  1.017  ELSEIF       StepNo == 2
  1.018  5502E        +Voltage = 600 mV; Frequency = 20 kHz
  1.019  ELSEIF       StepNo == 3
  1.020  5502E        +Voltage = 6 V; Frequency = 60 Hz
  1.021  ELSEIF       StepNo == 4
  1.022  5502E        +Voltage = 6 V; Frequency = 20 kHz
  1.023  ELSEIF       StepNo == 5
  1.024  5502E        +Voltage = 60 V; Frequency = 60 Hz
  1.025  ELSEIF       StepNo == 6
  1.026  5502E        +Voltage = 60 V; Frequency = 20 kHz
  1.027  ELSEIF       StepNo == 7
  1.028  5502E        +Voltage = 600 V; Frequency = 60 Hz
  1.029  ELSEIF       StepNo == 8
  1.030  5502E        +Voltage = 600 V; Frequency = 10 kHz
  1.031  ELSEIF       StepNo == 9

  1.032  5502E        Standby

  1.033  HEAD         DC VOLTS CALIBRATION
  1.034  DISP         Rotate UUT function switch to V DC.
  1.035  5502E        +Voltage = 6 V
  1.036  ELSEIF       StepNo == 10
  1.037  5502E        +Voltage = 60 V
  1.038  ELSEIF       StepNo == 11
  1.039  5502E        +Voltage = 600 V
  1.040  ELSEIF       StepNo == 12
  1.041  5502E        Standby

  1.042  HEAD         DC MILLIVOLTS CALIBRATION
  1.043  DISP         Rotate UUT function switch to mV DC.
  1.044  5502E        +Voltage = 600 mV
  1.045  ELSEIF       StepNo == 13
  1.046  5502E        +Voltage = 60 mV

  1.047  ELSEIF       StepNo == 14
  1.048  5502E        Standby

  1.049  HEAD         RESISTANCE CALIBRATION
  1.050  DISP         Rotate UUT function switch to Ω.
  1.051  PIC          55xx_8x_cw
  1.052  5502E        +Resistance = 600 Ohms; LeadCompensation = 2Wire
  1.053  ELSEIF       StepNo == 15
  1.054  5502E        +Resistance = 6 kOhms; LeadCompensation = 2Wire
  1.055  ELSEIF       StepNo == 16
  1.056  5502E        +Resistance = 60 kOhms; LeadCompensation = 2Wire
  1.057  ELSEIF       StepNo == 17
  1.058  5502E        +Resistance = 600 kOhms
  1.059  ELSEIF       StepNo == 18
  1.060  5502E        +Resistance = 6 MOhms
  1.061  ELSEIF       StepNo == 19
  1.062  5502E        +Resistance = 0 Ohms; LeadCompensation = 2Wire
  1.063  ELSEIF       StepNo == 20
  1.064  DISP         [32]        Note
  1.064  DISP
  1.064  DISP         Minimize movement around the test setup
  1.064  DISP         during this step.
  1.065  5502E        +Resistance = 50 MOhms
  1.066  ELSEIF       StepNo == 21
  1.067  5502E        Standby

  1.068  HEAD         DIODE CALIBRATION
  1.069  DISP         Rotate UUT function switch to Diode.
  1.070  PIC          55xx_8x_2w
  1.071  5502E        +Voltage = 3 V
  1.072  ELSEIF       StepNo == 22
  1.073  5502E        Standby

  1.074  HEAD         AC AMPS CALIBRATION

  1.075  DISP         Rotate UUT function switch to mA AC.
  1.076  PIC          55xx_8x_high_amps
  1.077  5502E        CurrentTerminal = 20A
  1.077  5502E        +Current = 6 A; Frequency = 60 Hz
  1.078  ELSEIF       StepNo == 23
  1.079  5502E        +Current = 6 A; CurrentTerminal = 20A
  1.080  ELSEIF       StepNo == 24
  1.081  5502E        Standby

  1.082  HEAD         AC MILLIAMPS CALIBRATION
  1.083  PIC          55xx_8x_low_amps
  1.084  5502E        CurrentTerminal = Aux
  1.084  5502E        +Current = 60 mA; Frequency = 60 Hz
  1.085  ELSEIF       StepNo == 25
  1.086  5502E        CurrentTerminal = Aux
  1.086  5502E        +Current = 400 mA; Frequency = 60 Hz
  1.087  ELSEIF       StepNo == 26
  1.088  5502E        +Current = 60 mA; CurrentTerminal = Aux
  1.089  ELSEIF       StepNo == 27
  1.090  5502E        +Current = 400 mA; CurrentTerminal = Aux
  1.091  ELSEIF       StepNo == 28
  1.092  5502E        Standby
  1.093  HEAD         AC MICROAMPS CALIBRATION
  1.094  DISP         Rotate UUT function switch to µA AC.
  1.095  5502E        CurrentTerminal = Aux
  1.095  5502E        +Current = 600 uA; Frequency = 60 Hz
  1.096  ELSEIF       StepNo == 29
  1.097  5502E        CurrentTerminal = Aux
  1.097  5502E        +Current = 6000 uA; Frequency = 60 Hz
  1.098  ELSEIF       StepNo == 30
  1.099  5502E        +Current = 600 uA; CurrentTerminal = Aux
  1.100  ELSEIF       StepNo == 31
  1.101  5502E        +Current = 6000 uA; CurrentTerminal = Aux
  1.102  ENDIF

  1.103  DISP         Press AutoHOLD button to initiate Cal Step [V Step].

  1.104  IF           StepNo == 2 || StepNo == 4 || StepNo == 6 || StepNo == 8
  1.105  WAIT         -t 11 Performing AC frequency response adjustment...
  1.106  ELSE
  1.107  WAIT         [D1000]
  1.108  ENDIF

  1.109  OPBR         -z When Cal Step completes, UUT will display "[V Next]".
  1.109  OPBR
  1.109  OPBR         Does the UUT display indicate "[V Next]"?
  1.109  OPBR
  1.109  OPBR         Select "Yes" to continue, "No" to repeat the step, or
  1.109  OPBR         "Terminate" to abort the procedure.

  1.110  IF           MEM1
  1.111  MATH         StepNo = StepNo + 1
  1.112  ENDIF

  1.113  UNTIL        StepNo > 31

  1.114  5502E        Standby
  1.115  HEAD

  1.116  END
