﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 30,32 (1 year) VER /5502,5500A/COIL
DATE:                  2015-05-12 12:22:27
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 11738 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       85
CONFIGURATION:         Fluke 5502E
CONFIGURATION:         Fluke 5500A/COIL
=============================================================================
#
#  Procedure Author(s):
#        DAC, PS, ND
#
#  Source(s):
#        Fluke 30 Performance Check  *
#        Fluke 32 RMS Clamp Meter Service Information
#        PN 103994 May 1995, Rev. 1, 2/98   *
#        Fluke 5500A/COIL Instruction Sheet (PN 600616 Aug. 1995)
#        Model 5500A/COIL, 50 Turn Current Coil, Technical Data
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# The following statements are include to "force" the main procedure header
# to list all references required by all subprocedures called.
  1.001  IF           0
  1.002  5502E        Coil = 5500A/COIL; CurrentTerminal = Aux
  1.002  5502E        +Current = 0 A
  1.003  ENDIF

  1.004  ASK-                        P                            F        V

  1.005  IF           NOT(VERSIONCHECK("8.1.4"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub High Voltage Safety Warning

  1.010  HEAD         SETUP PROCEDURE EXECUTION PARAMETERS
  1.011  CALL         Sub Select Failed Test Mode
  1.012  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.013  CALL         Sub Fluke 30,32 (1 yr) 200A Range VER /5502,5500A/COIL

  1.014  IF           @UUT_Model == "30"
  1.015  CALL         Sub Fluke 30 (1 yr) 400 A Range VER /5502,5500A/COIL
  1.016  ELSEIF       @UUT_Model == "32"
  1.017  CALL         Sub Fluke 32 (1 yr) 600 A Range VER /5502,5500A/COIL
  1.018  ENDIF

  1.019  CALL         Sub Fluke 30,32 (1 yr) Voltage VER /5502
  1.020  CALL         Sub Fluke 30,32 (1 yr) Resistance VER /5502

  1.021  IF           @UUT_Model == "30"
  1.022  CALL         Sub Fluke 30 (1 yr) Continuity VER /5502
  1.023  ELSEIF       @UUT_Model == "32"
  1.024  CALL         Sub Fluke 32 (1 yr) Continuity VER /5502
  1.025  ENDIF

  1.026  END
