﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287 (1 yr) VER RS-232 /5502
DATE:                  2014-10-03 12:12:06
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 11341 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       165
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#
#  Procedure Author(s):
#        VY, DAC, DFM, BHT
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Additional Equipment and/or Accessories Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-   R   Q N              P               C            A        V

  1.002  IF           NOT(VERSIONCHECK("8.1.4"))
  1.003  END
  1.004  ENDIF

  1.005  CALL         Sub Display Copyright
  1.006  CALL         Sub High Voltage Safety Warning

  1.007  HEAD         PRELIMINARY INSTRUCTIONS
  1.008  DISP         This verification must take place in an environment
  1.008  DISP         of 18°C - 28°C, ±1°C, and relative humidity of less
  1.008  DISP         than 90%. Ensure the UUT has been allowed to become
  1.008  DISP         acclimated to the test conditions for a mimimum of
  1.008  DISP         2 hours, prior to proceeding.
  1.008  DISP
  1.008  DISP         Ensure specified warm-up time(s) for required
  1.008  DISP         reference devices has been satisfied.

  1.009  HEAD         SETUP PROCEDURE EXECUTION PARAMETERS
  1.010  CALL         Sub Select Failed Test Mode
  1.011  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.012  HEAD         EQUIPMENT REQUIREMENTS
  1.013  OPBR         -z Do you want to REVIEW the list of additional
  1.013  OPBR         equipment and/or accessories required?

  1.014  IF           MEM1
  1.015  CALL         Sub Fluke 287/289 VER Required Equipment
  1.016  ENDIF

  1.017  MATH         @CableModel = "Fluke IR189USB"
  1.018  CALL         Sub Fluke 287/289 Connection RS-232 /IR189USB
  1.019  JMPL         ABORT                          @Error

  1.020  HEAD         COMMUNICATION SETUP
  1.021  TARGET
  1.022  CALL         Sub Fluke 287/289 Setup RS-232

  1.023  MATH         @UUT_Model = "287"
  1.024  CALL         Sub Fluke 287/289 Check ID RS-232
  1.025  JMPL         ABORT                          @Error

  1.026  CALL         Sub Fluke 287/289 Check Battery Level RS-232
  1.027  JMPL         ABORT                          @Error

# NOTE: The execution order of this verification procedure has been optimized
# to minimize operator intervention, while retaining the correct sequence for
# reported test results.  For more information about the method used, refer
# to this application note, available at www.flukecal.com:
# Application Note 6001075: Preserving Results Order While Optimizing
# Execution Sequence in MET/CAL Procedures.

  1.028  CALL         Sub Fluke 287/289 Preliminary Tests

  1.029  CALL         Sub Fluke 287/289 Reset to Default RS-232
  1.030  JMPL         ABORT                         @Error

  1.031  CALL         Sub Fluke 287/289 (1 yr) Temperature VER RS-232 /5502
  1.032  JMPL         ABORT                          @Error
  1.033  JMPL         OHMS

  1.034  LABEL        DC_mV
  1.035  CALL         Sub Fluke 287/289 (1 yr) DC Millivolts VER RS-232 /5502
  1.036  JMPL         ABORT                          @Error
  1.037  JMPL         DC_V

  1.038  LABEL        OHMS
  1.039  CALL         Sub Fluke 287/289 (1 yr) Resistance VER RS-232 /5502
  1.040  JMPL         ABORT                         @Error
  1.041  JMPL         CAPACITANCE

  1.042  LABEL        AC_mV
  1.043  CALL         Sub Fluke 287/289 (1 yr) AC MilliVolt VER RS-232 /5502
  1.044  JMPL         ABORT                          @Error

  1.045  CALL         Sub Fluke 287/289 (1 yr) 5 VAC Range VER RS-232 /5502
  1.046  JMPL         ABORT                         @Error
  1.047  JMPL         ACV_PEAK

  1.048  LABEL        DUTY_CYCLE
  1.049  CALL         Sub Fluke 287/289 (1 yr) Duty Cycle VER RS-232 /5502
  1.050  JMPL         ABORT                          @Error

  1.051  CALL         Sub Fluke 287/289 (1 yr) AC Volts VER RS-232 /5502
  1.052  JMPL         ABORT                         @Error
  1.053  JMPL         CURRENT

  1.054  LABEL        DC_V
  1.055  CALL         Sub Fluke 287/289 (1 yr) DC Volts VER RS-232 /5502
  1.056  JMPL         AC_mV

  1.057  LABEL        ACV_PEAK
  1.058  CALL         Sub Fluke 287/289 (1 yr) Peak ACV VER RS-232 /5502
  1.059  JMPL         ABORT                         @Error
  1.060  JMPL         DUTY_CYCLE

  1.061  LABEL        CAPACITANCE
  1.062  CALL         Sub Fluke 287/289 (1 yr) Capacitance VER RS-232 /5502
  1.063  JMPL         ABORT                          @Error

  1.064  CALL         Sub Fluke 287/289 (1 yr) Diode Test VER RS-232 /5502
  1.065  JMPL         ABORT                          @Error
  1.066  JMPL         DC_mV

  1.067  LABEL        CURRENT
  1.068  CALL         Sub Fluke 287/289 (1 yr) Current VER RS-232 /5502

  1.069  JMPL         END

  1.070  LABEL        ABORT
  1.071  HEAD         {V E R I F I C A T I O N   A B O R T E D}

  1.072  LABEL        END
  1.073  HEAD         -2
  1.074  5502E        Standby
  1.075  HEAD
  1.076  END
