﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 (1 yr) AC MilliVolt VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) 5 VAC Range VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Duty Cycle VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Peak ACV VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) AC Volts VER RS-232 /5502
DATE:                  2015-02-20 10:05:08
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       23
NUMBER OF LINES:       368
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#
#  Procedure Author(s):
#        VY, DAC, DFM, BHT
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#         None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON


  1.001  JMPL         AC_MILLIVOLTS                PSUBI("AC MilliVolt")
  1.002  JMPL         5_VAC_RANGE                  PSUBI("5 VAC Range")
  1.003  JMPL         DUTY_CYCLE                   PSUBI("Duty Cycle")
  1.004  JMPL         PEAK_ACV                   PSUBI("Peak ACV")
  1.005  JMPL         AC_VOLTS                     PSUBI("AC Volts")
  1.006  DISP         Subprocedure Not Found!
  1.007  END

  1.008  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) AC MilliVolt VER RS-232 /5502  ============

  2.001  LABEL        AC_MILLIVOLTS
  2.002  RSLT         =
  2.003  HEAD         {AC MILLIVOLTS}
  2.004  RSLT         =
  2.005  HEAD         -2{50 mV Range}
  2.006  MATH         @SetFunction = "mV_AC"; @SetKnobPosition = 3
  2.007  MATH         @FunctionMsg = "mV AC"
  2.008  TARGET       -p
  2.009  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
  2.010  JMPL         END                          @Error
# Energize calibrator with valid output to avoid overrange condition on UUT.
  2.011  5502E        +Voltage = 2.500 mV; Frequency = 1 kHz
  2.012  MATH         @Command = "MR 50,-3"
  2.013  CALL         Sub Fluke 287/289 Send Command RS-232
  2.014  JMPL         END                          @Error
  2.015  5502E        +Voltage = 5.000 mV; Frequency = 20 Hz
  2.016  WAIT         -t 3 System settling...
  2.017  TARGET       -m
  2.018  CALL         Sub Fluke 287/289 Query Measurement RS-232
  2.019  JMPL         END                          @Error
  2.020  MATH         MEM = MEM / 1E-3
  2.021  MEMCX  50    5.000mV        1.5% 0.060U   20Hz

  3.001  5502E        +Voltage = 50.000 mV; Frequency = 65 kHz
  3.002  WAIT         -t 3 System settling...
  3.003  TARGET       -m
  3.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  3.005  JMPL         END                          @Error
  3.006  MATH         MEM = MEM / 1E-3
  3.007  MEMCX  50    50.000mV       3.5% 0.040U   65kHz

  4.001  RSLT         =
  4.002  HEAD         -2{500 mV Range}
  4.003  TARGET       -p
  4.004  MATH         @Command = "MR 500,-3"
  4.005  CALL         Sub Fluke 287/289 Send Command RS-232
  4.006  JMPL         END                          @Error
  4.007  5502E        +Voltage = 50.00 mV; Frequency = 100 kHz
  4.008  WAIT         -t 3 System settling...
  4.009  TARGET       -m
  4.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
  4.011  JMPL         END                          @Error
  4.012  MATH         MEM = MEM / 1E-3
  4.013  MEMCX  500   50.00mV        3.5% 0.40U    100kHz

  5.001  5502E        +Voltage = 250.00 mV; Frequency = 65 kHz
  5.002  WAIT         -t 3 System settling...
  5.003  TARGET       -m
  5.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  5.005  JMPL         END                          @Error
  5.006  MATH         MEM = MEM / 1E-3
  5.007  MEMCX  500   250.00mV       3.5% 0.40U    65kHz

  6.001  5502E        +Voltage = 500.00 mV; Frequency = 45 Hz
  6.002  WAIT         -t 3 System settling...
  6.003  TARGET       -m
  6.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  6.005  JMPL         END                          @Error
  6.006  MATH         MEM = MEM / 1E-3
  6.007  MEMCX  500   500.00mV       0.3% 0.25U    45Hz

  7.001  RSLT         =
  7.002  HEAD         -2{500 mV Range,Frequency}
  7.003  TARGET       -p
  7.004  MATH         @Command = "MF mV_AC,HERTZ"
  7.005  CALL         Sub Fluke 287/289 Send Command RS-232
  7.006  JMPL         END                          @Error
  7.007  MATH         @Command = "MR 500,-3"
  7.008  CALL         Sub Fluke 287/289 Send Command RS-232
  7.009  JMPL         END                          @Error
  7.010  5502E        +Frequency = 45.000 Hz; Voltage = 500 mV
  7.011  WAIT         -t 3 System settling...
  7.012  TARGET       -m
  7.013  CALL         Sub Fluke 287/289 Query Measurement RS-232
  7.014  JMPL         END                          @Error
  7.015  MEMCX        45.000Hz       0.02% 0.005U  500mV

  8.001  5502E        +Frequency = 950.000 kHz; Voltage = 600 mV
  8.002  WAIT         -t 3 System settling...
  8.003  TARGET       -m
  8.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  8.005  JMPL         END                          @Error
  8.006  MATH         MEM = MEM / 1E+3
  8.007  MEMCX        950.00kHz      0.005% 0.05U  600mV

  9.001  HEAD         -2
  9.002  HEAD
  9.003  5502E        Standby
  9.004  MATH         @Command = "MFD"
  9.005  CALL         Sub Fluke 287/289 Send Command RS-232
  9.006  END

  9.007  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) 5 VAC Range VER RS-232 /5502  =============

 10.001  LABEL        5_VAC_RANGE
 10.002  RSLT         =
 10.003  HEAD         {AC VOLTS}
 10.004  RSLT         =
 10.005  HEAD         -2{5 V Range}
 10.006  MATH         @SetFunction = "V_AC"; @SetKnobPosition = 2
 10.007  MATH         @FunctionMsg = "V AC"
 10.008  TARGET       -p
 10.009  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
 10.010  JMPL         END                          @Error
 10.011  MATH         @Command = "MR 5,0"
 10.012  CALL         Sub Fluke 287/289 Send Command RS-232
 10.013  JMPL         END                          @Error
 10.014  5502E        +Voltage = 0.1000 V; Frequency = 60 Hz
 10.015  WAIT         -t 3 System settling...
 10.016  TARGET       -m
 10.017  CALL         Sub Fluke 287/289 Query Measurement RS-232
 10.018  JMPL         END                          @Error
# Below 5 % of range, add 20 counts.
 10.019  TOL          0.3% 0.0025U 0.0020U
 10.020  MEMCX  5     0.1000V        TOL           60Hz

 11.001  5502E        +Voltage = 0.5000 V; Frequency = 10 kHz
 11.002  WAIT         -t 3 System settling...
 11.003  TARGET       -m
 11.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 11.005  JMPL         END                          @Error
 11.006  MEMCX  5     0.5000V        0.6% 0.0025U  10kHz

 12.001  5502E        +Voltage = 3.0000 V; Frequency = 100 kHz
 12.002  WAIT         -t 3 System settling...
 12.003  TARGET       -m
 12.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 12.005  JMPL         END                          @Error
# Add 2.5 % above 65 kHz.
 12.006  TOL          3.5% 0.0040U 2.5%
 12.007  MEMCX  5     3.0000V        TOL           100kHz

 13.001  HEAD         -2
 13.002  HEAD
 13.003  5502E        Standby
 13.004  END

 13.005  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Duty Cycle VER RS-232 /5502  ==============

 14.001  LABEL        DUTY_CYCLE
 14.002  HEAD         AC VOLTS
 14.003  RSLT         =
 14.004  HEAD         -2{5 V Range, Duty Cycle (5 Vpp Squarewave)}
 14.005  MATH         @Command = "MF V_AC,DUTY_CYCLE"
 14.006  CALL         Sub Fluke 287/289 Send Command RS-232
 14.007  TARGET       -p
 14.008  JMPL         END                          @Error
 14.009  MATH         @Command = "MR 5,0"
 14.010  CALL         Sub Fluke 287/289 Send Command RS-232
 14.011  JMPL         END                          @Error
 14.012  5502E        Waveform = Square; Volt = 5 Vpp
 14.012  5502E        +DutyCycle = 15.00 %; Frequency = 50 kHz
 14.013  WAIT         -t 3 System settling...
 14.014  TARGET       -m
 14.015  CALL         Sub Fluke 287/289 Query Measurement RS-232
 14.016  JMPL         END                          @Error
# The accuracy of 1.00 % to 99.00 % duty cycle is: ± (0.2% / kHz + 0.1 %).
# According manual supplement Note [3]:
#    For 10 µs < pulse width < 25 µs add 1 %.
#    For 2 µs < pulse width   10 µs add 3.5 %.
# In this test the pulse width of signal is 0.15 * (1 / 50000) = 3 µs,
# therefore, the test tolerance is ± (50 * 0.002 + 0.1 + 3.5) % = ± 13.6%.
 14.017  MEMCX        15.00pct       13.60U        50kHz

 15.001  HEAD         -2
 15.002  HEAD
 15.003  5502E        Standby
 15.004  MATH         @Command = "MFD"
 15.005  CALL         Sub Fluke 287/289 Send Command RS-232
 15.006  END

 15.007  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Peak ACV VER RS-232 /5502  ================

 16.001  LABEL        PEAK_ACV
 16.002  HEAD         AC VOLTS
 16.003  RSLT         =
 16.004  HEAD         -2{5 V Range, ACV Peak (4 Vpp Squarewave, +1 V offset)}
 16.005  TARGET       -p
# Select ACV PEAK measurment mode.
 16.006  MATH         @Command = "MF V_AC,PEAK_MIN_MAX"
 16.007  CALL         Sub Fluke 287/289 Send Command RS-232
 16.008  JMPL         END                          @Error
 16.009  MATH         @Command = "MR 5,0"
 16.010  CALL         Sub Fluke 287/289 Send Command RS-232
 16.011  JMPL         END                          @Error

 16.012  5502E        Offset = 1 V; Waveform = Square
 16.012  5502E        +Voltage = 4 Vpp; Frequency = 2 kHz
# Retrieve 5502E square peak to peak accuracy.
 16.013  MATH         L[1] = REFACC()
# Convert accuracy to percent.
 16.014  MATH         L[2] = L[1] / MEM1 * 100
# Setup system accuracy based peak value of square.
 16.015  ACC          2.000V         L2%
 16.016  WAIT         -t 3 System settling...
 16.017  TARGET       -m
 16.018  CALL         Sub Fluke 287/289 Query Measurement RS-232
 16.019  JMPL         END                          @Error
 16.020  MEMCX        2.000V         0.137U

 17.001  HEAD         -2
 17.002  HEAD
 17.003  5502E        Standby
 17.004  MATH         @Command = "PRESS F4"
 17.005  CALL         Sub Fluke 287/289 Send Command RS-232
 17.006  JMPL         END                          @Error
 17.007  MATH         @Command = "MM NONE"
 17.008  CALL         Sub Fluke 287/289 Send Command RS-232
 17.009  END

 17.010  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) AC Volts VER RS-232 /5502  ================

 18.001  LABEL        AC_VOLTS
 18.002  HEAD         AC VOLTS
 18.003  RSLT         =
 18.004  HEAD         -2{50 V Range}
 18.005  TARGET       -p
 18.006  MATH         @Command = "MR 50,0"
 18.007  CALL         Sub Fluke 287/289 Send Command RS-232
 18.008  JMPL         END                          @Error
 18.009  5502E        +Voltage = 15.000 V; Frequency = 100 kHz
 18.010  WAIT         -t 3 System settling...
 18.011  TARGET       -m
 18.012  CALL         Sub Fluke 287/289 Query Measurement RS-232
 18.013  JMPL         END                          @Error
 18.014  MEMCX  50    15.000V        3.5% 0.040U   100kHz

 19.001  RSLT         =
 19.002  HEAD         -2{500 V Range}

 19.003  IF           ZCMP(@ModelNum, "289")
 19.004  RSLT         = Low Pass Filter On
 19.005  MATH         @Command = "MM LOW_PASS_FILTER"
 19.006  CALL         Sub Fluke 287/289 Send Command RS-232
 19.007  JMPL         END                          @Error
 19.008  TARGET       -p
 19.009  MATH         @Command = "MR 500,0"
 19.010  CALL         Sub Fluke 287/289 Send Command RS-232
 19.011  JMPL         END                          @Error
 19.012  5502E        +Voltage = 50.00 V; Frequency = 60 Hz
 19.013  WAIT         -t 3 System settling...
 19.014  TARGET       -m
 19.015  CALL         Sub Fluke 287/289 Query Measurement RS-232
 19.016  JMPL         END                          @Error
 19.017  MEMCX  500   50.00V         2% 0.40U      60Hz

 20.001  MATH         L[1] = ACCV2(@CalDev, "Volts SI", 50.0, 1600)
# Convert to percentage.
 20.002  MATH         L[1] = L[1] / 50.0 * 100
 20.003  TARGET       -p
 20.004  5502E        +Voltage = 50.00 V; Frequency = 1600 Hz
 20.005  WAIT         -t 3 System settling...
 20.006  TARGET       -m
 20.007  CALL         Sub Fluke 287/289 Query Measurement RS-232
 20.008  JMPL         END                          @Error
 20.009  ACC    0     V              L1%
 20.010  MEMCX  500   0.00V          +8.00U        1600Hz

 21.001  MATH         @Command = "MM NONE"
 21.002  CALL         Sub Fluke 287/289 Send Command RS-232
 21.003  JMPL         END                          @Error
 21.004  RSLT         =
 21.005  ENDIF

 21.006  TARGET       -p
 21.007  MATH         @Command = "MR 500,0"
 21.008  CALL         Sub Fluke 287/289 Send Command RS-232
 21.009  JMPL         END                          @Error
 21.010  5502E        +Voltage = 500.00 V; Frequency = 10 kHz
 21.011  WAIT         -t 3 System settling...
 21.012  TARGET       -m
 21.013  CALL         Sub Fluke 287/289 Query Measurement RS-232
 21.014  JMPL         END                          @Error
 21.015  MEMCX  500   500.00V        0.4% 0.25U    10kHz

 22.001  RSLT         =
 22.002  HEAD         -2{1000 V Range}
 22.003  TARGET       -p
 22.004  MATH         @Command = "MR 1000,0"
 22.005  CALL         Sub Fluke 287/289 Send Command RS-232
 22.006  JMPL         END                          @Error
 22.007  5502E        +Voltage = 1000.0 V; Frequency = 10 kHz
 22.008  WAIT         -t 3 System settling...
 22.009  TARGET       -m
 22.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 22.011  JMPL         END                          @Error
 22.012  MEMCX  1000  1000.0V        0.4% 2.5U     10kHz

 23.001  LABEL        END
 23.002  HEAD         -2
 23.003  HEAD
 23.004  5502E        Standby
 23.005  END
