﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Temperature VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Resistance VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) DC Millivolts VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) DC Volts VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Capacitance VER RS-232 /5502
INSTRUMENT:            Sub Fluke 287/289 (1 yr) Diode Test VER RS-232 /5502
DATE:                  2015-02-20 10:06:30
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       36
NUMBER OF LINES:       585
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#
#  Procedure Author(s):
#        VY, DAC, DFM, BHT
#
#  This procedure contains tests whose Test Specification Ratios are less
#  than 4:1, based on 5502E (1 year) specifications.
#
#        RESISTANCE TEST
#              - 5.0000 MΩ; TUR 2.5902
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#         None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         TEMPERATURE                  PSUBI("Temperature")
  1.002  JMPL         RESISTANCE                   PSUBI("Resistance")
  1.003  JMPL         DC_MILLIVOLTS                PSUBI("DC MilliVolt")
  1.004  JMPL         DC_VOLTS                     PSUBI("DC Volts")
  1.005  JMPL         CAPACITANCE                  PSUBI("Capacitance")
  1.006  JMPL         DIODE                        PSUBI("Diode")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Temperature VER RS-232 /5502  =============

  2.001  LABEL        TEMPERATURE
  2.002  RSLT         =
  2.003  HEAD         {TEMPERATURE}
  2.004  RSLT         =
  2.005  HEAD         -2{-200 °C to +1350 °C Range}
# Define variables related test function to use in sub procedure.
  2.006  MATH         @SetFunction = "Temperature"; @SetKnobPosition = 5
  2.007  MATH         @FunctionMsg = "mV DC/Temperature"
  2.008  TARGET       -p
  2.009  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
  2.010  JMPL         END                          @Error
  2.011  PIC          55xx_28x_TC.jpg
  2.012  5502E        +Temperature = 0.0 degC; TC_Type = K
  2.013  WAIT         -t 2:00 System settling...
# Query the UUT reading and set the temperature offset.
  2.014  CALL         Sub Fluke 287/289 Query Measurement RS-232
  2.015  JMPL         END                          @Error
  2.016  MATH         @Command = "MP TempOS," & -1 * MEM
  2.017  CALL         Sub Fluke 287/289 Send Command RS-232
  2.018  JMPL         END                          @Error
  2.019  5502E        +Temperature = 0.0 degC; TC_Type = K
  2.020  WAIT         -t 3 System settling...
  2.021  TARGET       -m
  2.022  CALL         Sub Fluke 287/289 Query Measurement RS-232
  2.023  JMPL         END                          @Error
  2.024  MEMCX  1350  0.0degC        1% 1.0U

  3.001  5502E        +Temperature = 100.0 degC; TC_Type = K
  3.002  WAIT         -t 3 System settling...
  3.003  TARGET       -m
  3.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  3.005  JMPL         END                          @Error
  3.006  MEMCX  1350  100.0degC      1% 1.0U

  4.001  5502E        +Temperature = 1000.0 degC; TC_Type = K
  4.002  WAIT         -t 3 System settling...
  4.003  TARGET       -m
  4.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  4.005  JMPL         END                          @Error
  4.006  MEMCX  1350  1000.0degC     1% 1.0U

  5.001  HEAD         -2
  5.002  HEAD
  5.003  5502E        Standby
  5.004  END

  5.005  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Resistance VER RS-232 /5502  ==============

  6.001  LABEL        RESISTANCE
  6.002  RSLT         =
  6.003  HEAD         {OHMS}
  6.004  RSLT         =
  6.005  HEAD         -2{500 Ω Range}
  6.006  MATH         @SetFunction = "Ohms"; @SetKnobPosition = 6
  6.007  MATH         @FunctionMsg = "Ω/Cont/nS"
  6.008  TARGET       -p
  6.009  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
  6.010  JMPL         END                          @Error

  6.011  IF           ZCMP(@ModelNum, "287")
  6.012  PIC          55xx_28x_CWOhmTest.jpg
  6.013  ENDIF

  6.014  MATH         @Command = "MR 500,0"
  6.015  CALL         Sub Fluke 287/289 Send Command RS-232
  6.016  JMPL         END                          @Error
  6.017  5502E        +Resistance = 0.00 Ohms; LeadCompensation = 2Wire
  6.018  WAIT         -t 3 System settling...
  6.019  TARGET       -m
  6.020  CALL         Sub Fluke 287/289 Query Measurement RS-232
  6.021  JMPL         END                          @Error
  6.022  MEMCX  500   0.00Z          0.10U

  7.001  JMPL         RESISTANCE_RELATIVE_TEST

# This TARGET and JMPL are here so "Repeat" will perform a new relative test.
  7.002  TARGET       -p
  7.003  MATH         @Command = "MM NONE"
  7.004  CALL         Sub Fluke 287/289 Send Command RS-232
  7.005  JMPL         END                          @Error

  7.006  LABEL        RESISTANCE_RELATIVE_TEST
  7.007  5502E        +Resistance = 0.00 Ohms; LeadCompensation = 2Wire
  7.008  WAIT         -t 5 System settling...
  7.009  MATH         @Command = "MM REL"
  7.010  CALL         Sub Fluke 287/289 Send Command RS-232
  7.011  JMPL         END                          @Error
  7.012  5502E        LeadCompensation = 2Wire;
  7.012  5502E        +Resistance = 0.20 Ohms
  7.013  WAIT         -t 5 System settling...
  7.014  TARGET       -m
  7.015  CALL         Sub Fluke 287/289 Query Measurement RS-232
  7.016  JMPL         END                          @Error
  7.017  MEMCX  500   0.20Z          0.05% 0.10U

  8.001  5502E        +Resistance = 500.00 Ohms; LeadCompensation = 2Wire
  8.002  WAIT         -t 3 System settling...
  8.003  TARGET       -m
  8.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
  8.005  JMPL         END                          @Error
  8.006  MEMCX  500   500.00Z        0.05% 0.10U

  9.001  MATH         @Command = "MM NONE"
  9.002  CALL         Sub Fluke 287/289 Send Command RS-232
  9.003  JMPL         END                          @Error

  9.004  RSLT         =
  9.005  HEAD         -2{5 kΩ Range}
  9.006  TARGET       -p
  9.007  MATH         @Command = "MR 5,3"
  9.008  CALL         Sub Fluke 287/289 Send Command RS-232
  9.009  JMPL         END                          @Error
  9.010  5502E        +Resistance = 5.0000 kOhms; LeadCompensation = 2Wire
  9.011  WAIT         -t 3 System settling...
  9.012  TARGET       -m
  9.013  CALL         Sub Fluke 287/289 Query Measurement RS-232
  9.014  JMPL         END                          @Error
  9.015  MATH         MEM = MEM / 1E+3
  9.016  MEMCX  5     5.0000kZ       0.05% 0.0002U

 10.001  RSLT         =
 10.002  HEAD         -2{50 kΩ Range}
 10.003  TARGET       -p
 10.004  MATH         @Command = "MR 50,3"
 10.005  CALL         Sub Fluke 287/289 Send Command RS-232
 10.006  JMPL         END                          @Error
 10.007  5502E        +Resistance = 50.000 kOhms; LeadCompensation = 2Wire
 10.008  WAIT         -t 3 System settling...
 10.009  TARGET       -m
 10.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 10.011  JMPL         END                          @Error
 10.012  MATH         MEM = MEM / 1E+3
 10.013  MEMCX  50    50.000kZ       0.05% 0.002U

 11.001  RSLT         =
 11.002  HEAD         -2{500 kΩ Range}
 11.003  TARGET       -p
 11.004  MATH         @Command = "MR 500,3"
 11.005  CALL         Sub Fluke 287/289 Send Command RS-232
 11.006  JMPL         END                          @Error
 11.007  5502E        +Resistance = 500.00 kOhms
 11.008  WAIT         -t 3 System settling...
 11.009  TARGET       -m
 11.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 11.011  JMPL         END                          @Error
 11.012  MATH         MEM = MEM / 1E+3
 11.013  MEMCX  500   500.00kZ       0.05% 0.15U

 12.001  RSLT         =
 12.002  HEAD         -2{5 MΩ Range}
 12.003  TARGET       -p
 12.004  MATH         @Command = "MR 5,6"
 12.005  CALL         Sub Fluke 287/289 Send Command RS-232
 12.006  JMPL         END                          @Error
 12.007  5502E        +Resistance = 5.0000 MOhms
 12.008  WAIT         -t 5 System settling...
 12.009  TARGET       -m
 12.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 12.011  JMPL         END                          @Error
 12.012  MATH         MEM = MEM / 1E+6
 12.013  MEMCX  5     5.0000MZ       0.15% 0.0004U
#! WARNING: Test Tol 7900, Sys Tol 3050 MZ, TUR 3.1633 (< 4.00).

 13.001  RSLT         =
 13.002  HEAD         -2{30 MΩ Range}
 13.003  TARGET       -p
 13.004  MATH         @Command = "MR 30,6"
 13.005  CALL         Sub Fluke 287/289 Send Command RS-232
 13.006  JMPL         END                          @Error
 13.007  5502E        +Resistance = 30.000 MOhms
 13.008  WAIT         -t 5 System settling...
 13.009  TARGET       -m
 13.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 13.011  JMPL         END                          @Error
 13.012  MATH         MEM = MEM / 1E+6
 13.013  MEMCX  30    30.000MZ       1.5% 0.004U

 14.001  RSLT         =
 14.002  HEAD         -2{500 MΩ Range}
 14.003  TARGET       -p
 14.004  5502E        +Resistance = 30 MOhms
 14.005  MATH         @Command = "MR 500,6"
 14.006  CALL         Sub Fluke 287/289 Send Command RS-232
 14.007  JMPL         END                          @Error
 14.008  5502E        +Resistance = 300.0 MOhms
 14.009  WAIT         -t 7 System settling...
 14.010  TARGET       -m
 14.011  CALL         Sub Fluke 287/289 Query Measurement RS-232
 14.012  JMPL         END                          @Error
 14.013  MATH         MEM = MEM / 1E+6
 14.014  MEMCX  500   300.0MZ        8% 0.2U

 15.001  HEAD         -2
 15.002  HEAD
 15.003  5502E        Standby
 15.004  END

 15.005  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) DC MilliVolts VER RS-232 /5502E  ===========

 16.001  LABEL        DC_MILLIVOLTS
 16.002  RSLT         =
 16.003  HEAD         {DC MILLIVOLTS}
 16.004  RSLT         =
 16.005  HEAD         -2{50 mV Range}
 16.006  MATH         @SetFunction = "mV_DC"; @SetKnobPosition = 5
 16.007  MATH         @FunctionMsg = "mV DC/Temperature"
 16.008  TARGET       -p
# Set measurement to none so Repeat and Cancel perform a new relative test.
 16.009  MATH         @Command = "MM NONE"
 16.010  CALL         Sub Fluke 287/289 Send Command RS-232
 16.011  JMPL         END                          @Error
 16.012  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
 16.013  JMPL         END                          @Error
 16.014  MATH         @Command = "MR 50,-3"
 16.015  CALL         Sub Fluke 287/289 Send Command RS-232
 16.016  JMPL         END                          @Error
 16.017  5502E        +Voltage = 0.000 mV
 16.018  WAIT         -t 5 System settling...
 16.019  MATH         @Command = "MM REL"
 16.020  CALL         Sub Fluke 287/289 Send Command RS-232
 16.021  JMPL         END                          @Error
 16.022  WAIT         -t 3 System settling...
 16.023  TARGET       -m
 16.024  CALL         Sub Fluke 287/289 Query Measurement RS-232
 16.025  JMPL         END                          @Error
 16.026  MATH         MEM = MEM / 1E-3
 16.027  MEMCX  50    0.000mV        0.05% 0.020U

 17.001  5502E        +Voltage = 0.025 mV
 17.002  WAIT         -t 3 System settling...
 17.003  TARGET       -m
 17.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 17.005  JMPL         END                          @Error
 17.006  MATH         MEM = MEM / 1E-3
 17.007  MEMCX  50    0.025mV        0.05% 0.020U

 18.001  5502E        +Voltage = -0.025 mV
 18.002  WAIT         -t 3 System settling...
 18.003  TARGET       -m
 18.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 18.005  JMPL         END                          @Error
 18.006  MATH         MEM = MEM / 1E-3
 18.007  MEMCX  50    -0.025mV       0.05% 0.020U

 19.001  5502E        +Voltage = 50.000 mV
 19.002  WAIT         -t 3 System settling...
 19.003  TARGET       -m
 19.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 19.005  JMPL         END                          @Error
 19.006  MATH         MEM = MEM / 1E-3
 19.007  MEMCX  50    50.000mV       0.05% 0.020U

 20.001  MATH         @Command = "MM NONE"
 20.002  CALL         Sub Fluke 287/289 Send Command RS-232
 20.003  JMPL         END                          @Error

 20.004  RSLT         =
 20.005  HEAD         -2{500 mV Range}
 20.006  TARGET       -p
 20.007  MATH         @Command = "MR 500,-3"
 20.008  CALL         Sub Fluke 287/289 Send Command RS-232
 20.009  JMPL         END                          @Error
 20.010  5502E        +Voltage = 500.00 mV
 20.011  WAIT         -t 3 System settling...
 20.012  TARGET       -m
 20.013  CALL         Sub Fluke 287/289 Query Measurement RS-232
 20.014  JMPL         END                          @Error
 20.015  MATH         MEM = MEM / 1E-3
 20.016  MEMCX  500   500.00mV       0.025% 0.02U

 21.001  5502E        +Voltage = -250.00 mV
 21.002  WAIT         -t 3 System settling...
 21.003  TARGET       -m
 21.004  CALL         Sub Fluke 287/289 Query Measurement RS-232
 21.005  JMPL         END                          @Error
 21.006  MATH         MEM = MEM / 1E-3
 21.007  MEMCX  500   -250.00mV      0.025% 0.02U

 22.001  5502E        Standby

 22.002  HEAD         {DC/AC}
 22.003  TARGET       -p
 22.004  MATH         @Command = "MF mV_DC_OVER_AC"
 22.005  CALL         Sub Fluke 287/289 Send Command RS-232
 22.006  JMPL         END                          @Error
 22.007  MATH         @Command = "MR 500,-3"
 22.008  CALL         Sub Fluke 287/289 Send Command RS-232
 22.009  JMPL         END                          @Error
 22.010  5502E        +Voltage = 50.00 mV
 22.011  WAIT         -t 3 System settling...
 22.012  TARGET       -m
 22.013  CALL         Sub Fluke 287/289 Query Measurement RS-232
 22.014  JMPL         END                          @Error
 22.015  MATH         MEM = MEM / 1E-3
 22.016  MEMCX  500   50.00mV        0.025% 0.02U

 23.001  MATH         @Command = "MFD"
 23.002  CALL         Sub Fluke 287/289 Send Command RS-232
 23.003  JMPL         END                          @Error

 23.004  HEAD         {AC/DC}
 23.005  TARGET       -p
 23.006  MATH         @Command = "MF mV_AC_OVER_DC"
 23.007  CALL         Sub Fluke 287/289 Send Command RS-232
 23.008  JMPL         END                          @Error
 23.009  MATH         @Command = "MR 500,-3"
 23.010  CALL         Sub Fluke 287/289 Send Command RS-232
 23.011  JMPL         END                          @Error
 23.012  5502E        +Voltage = 250.0 mV; Frequency = 35 kHz
 23.013  WAIT         -t 3 System settling...
 23.014  TARGET       -m
 23.015  CALL         Sub Fluke 287/289 Query Measurement RS-232
 23.016  JMPL         END                          @Error
 23.017  MATH         MEM = MEM / 1E-3
 23.018  MEMCX  500   250.00mV       5.0% 0.40U    35kH

 24.001  HEAD         -2
 24.002  HEAD
 24.003  5502E        Standby
 24.004  MATH         @Command = "MFD"
 24.005  CALL         Sub Fluke 287/289 Send Command RS-232
 24.006  END

 24.007  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) DC Volts VER RS-232 /5502  ================

 25.001  LABEL        DC_VOLTS
 25.002  RSLT         =
 25.003  HEAD         {DC VOLTS}
 25.004  RSLT         =
 25.005  HEAD         -2{5 V Range}
 25.006  MATH         @SetFunction = "V_DC"; @SetKnobPosition = 4
 25.007  MATH         @FunctionMsg = "V DC"
 25.008  TARGET       -p
 25.009  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
 25.010  JMPL         END                          @Error
 25.011  MATH         @Command = "MR 5,0"
 25.012  CALL         Sub Fluke 287/289 Send Command RS-232
 25.013  JMPL         END                          @Error
 25.014  5502E        +Voltage = 4.0000 V
 25.015  WAIT         -t 3 System settling...
 25.016  TARGET       -m
 25.017  CALL         Sub Fluke 287/289 Query Measurement RS-232
 25.018  JMPL         END                          @Error
 25.019  MEMCX  5     4.0000V        .025% .0002U

 26.001  RSLT         =
 26.002  HEAD         -2{50 V Range}
 26.003  TARGET       -p
 26.004  MATH         @Command = "MR 50,0"
 26.005  CALL         Sub Fluke 287/289 Send Command RS-232
 26.006  JMPL         END                          @Error
 26.007  5502E        +Voltage = -40.000 V
 26.008  WAIT         -t 3 System settling...
 26.009  TARGET       -m
 26.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 26.011  JMPL         END                          @Error
 26.012  MEMCX  50    -40.000V       0.025% 0.002U

 27.001  RSLT         =
 27.002  HEAD         -2{500 V Range}
 27.003  TARGET       -p
 27.004  MATH         @Command = "MR 500,0"
 27.005  CALL         Sub Fluke 287/289 Send Command RS-232
 27.006  JMPL         END                          @Error
 27.007  5502E        +Voltage = 400.00 V
 27.008  WAIT         -t 3 System settling...
 27.009  TARGET       -m
 27.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 27.011  JMPL         END                          @Error
 27.012  MEMCX  500   400.00V        0.03% 0.02U

 28.001  RSLT         =
 28.002  HEAD         -2{1000 V Range}
 28.003  TARGET       -p
 28.004  MATH         @Command = "MR 1000,0"
 28.005  CALL         Sub Fluke 287/289 Send Command RS-232
 28.006  JMPL         END                          @Error
 28.007  5502E        +Voltage = 600.0 V
 28.008  WAIT         -t 3 System settling...
 28.009  TARGET       -m
 28.010  CALL         Sub Fluke 287/289 Query Measurement RS-232
 28.011  JMPL         END                          @Error
 28.012  MEMCX  1000  600.0V         0.03% 0.2U

 29.001  5502E        Standby

 29.002  MATH         @Command = "MFD"
 29.003  CALL         Sub Fluke 287/289 Send Command RS-232
 29.004  JMPL         END                          @Error

 29.005  RSLT         =
 29.006  HEAD         -2{DC/AC (5 V Range)}
 29.007  TARGET       -p
 29.008  MATH         @Command = "MF V_DC_OVER_AC"
 29.009  CALL         Sub Fluke 287/289 Send Command RS-232
 29.010  JMPL         END                          @Error
 29.011  MATH         @Command = "MR 5,0"
 29.012  CALL         Sub Fluke 287/289 Send Command RS-232
 29.013  JMPL         END                          @Error
 29.014  5502E        +Voltage = 0.2000 V
 29.015  WAIT         -t 3 System settling...
 29.016  TARGET       -m
 29.017  CALL         Sub Fluke 287/289 Query Measurement RS-232
 29.018  JMPL         END                          @Error
 29.019  MEMCX  5     0.2000V        .025% .0023U

 30.001  RSLT         =
 30.002  HEAD         -2{AC/DC (5 V Range)}
 30.003  TARGET       -p
 30.004  MATH         @Command = "MF V_AC_OVER_DC"
 30.005  CALL         Sub Fluke 287/289 Send Command RS-232
 30.006  JMPL         END                          @Error
 30.007  5502E        +Voltage = 2.0000 V; Frequency = 5 kHz
 30.008  WAIT         -t 3 System settling...
 30.009  TOL          1.5% 0.0040U 0.0020U
 30.010  TARGET       -m
 30.011  CALL         Sub Fluke 287/289 Query Measurement RS-232
 30.012  JMPL         END                          @Error
 30.013  MEMCX  5     2.0000V        TOL           5kH

 31.001  HEAD         -2
 31.002  HEAD
 31.003  5502E        Standby
 31.004  MATH         @Command = "MFD"
 31.005  CALL         Sub Fluke 287/289 Send Command RS-232
 31.006  END

 31.007  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Capacitance VER RS-232 /5502  =============

 32.001  LABEL        CAPACITANCE
 32.002  RSLT         =
 32.003  HEAD         {CAPACITANCE}
 32.004  RSLT         =
 32.005  HEAD         -2{10 nF Range}
 32.006  MATH         @SetFunction = "CAPACITANCE"; @SetKnobPosition = 7
 32.007  MATH         @FunctionMsg = "Diode/Capacitance"
 32.008  TARGET       -p
# Set measurement to none so Repeat and Cancel perform a new relative test.
 32.009  MATH         @Command = "MM NONE"
 32.010  CALL         Sub Fluke 287/289 Send Command RS-232
 32.011  JMPL         END                          @Error
 32.012  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
 32.013  JMPL         END                          @Error

 32.014  LABEL        CAPACITANCE_RELATIVE_TEST
 32.015  MATH         @Command = "MR 10,-9"
 32.016  CALL         Sub Fluke 287/289 Send Command RS-232
 32.017  JMPL         END                          @Error
 32.018  PIC          55xx_28x_CapZero.jpg
 32.019  WAIT         -t 5 System settling...
 32.020  MATH         @Command = "MM REL"
 32.021  CALL         Sub Fluke 287/289 Send Command RS-232
 32.022  JMPL         END                          @Error

 32.023  PIC          55xx_28x_VoltTest.jpg
 32.024  5502E        +Capacitance = 5.00 nF
 32.025  WAIT         -t 5 System settling...
 32.026  TARGET       -m
 32.027  CALL         Sub Fluke 287/289 Query Measurement RS-232
 32.028  JMPL         END                          @Error
 32.029  MATH         MEM = MEM / 1E-9
 32.030  MEMCX  10    5.00nF         1% 0.05U

 33.001  HEAD         -2
 33.002  HEAD
 33.003  5502E        Standby
 33.004  MATH         @Command = "MM NONE"
 33.005  CALL         Sub Fluke 287/289 Send Command RS-232
 33.006  END

 33.007  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 (1 yr) Diode Test VER RS-232 /5502  ==============

 34.001  LABEL        DIODE
 34.002  RSLT         =
 34.003  HEAD         {DIODE TEST}
 34.004  HEAD         -2 3.1 V Range
 34.005  MATH         @SetFunction = "CAPACITANCE"; @SetKnobPosition = 7
 34.006  MATH         @FunctionMsg = "Diode/Capacitance"
 34.007  TARGET
 34.008  CALL         Sub Fluke 287/289 Check Knob & Function RS-232 /5502
 34.009  JMPL         END                          @Error
 34.010  MATH         @Command = "MF DIODE_TEST"
 34.011  CALL         Sub Fluke 287/289 Send Command RS-232
 34.012  JMPL         END                          @Error
 34.013  5502E        +Resistance = 3.5 kOhms
 34.014  CALL         Sub Fluke 287/289 Query Measurement RS-232
 34.015  JMPL         END                          @Error
 34.016  CALL         Sub Fluke 287/289 Query Measurement RS-232
 34.017  JMPL         END                          @Error
 34.018  EVAL   -e (MEM >=2) && (MEM <=3.1) : 3.5 kΩ

 35.001  HEAD         -2 3.1 V Range: 0 Ω
 35.002  TARGET
 35.003  5502E        +Resistance = 0 Ohms
 35.004  EVAL   -s "0.0 Ω" : Is the beeper on?

 36.001  LABEL        END
 36.002  HEAD         -2
 36.003  HEAD
 36.004  5502E        Standby
 36.005  END
