﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 Check Knob & Function RS-232 /5502
DATE:                  2015-02-20 10:08:08
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       128
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#
#  Procedure Author(s):
#        DAC
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  DO
  1.002  MATH         @Command = "QMF"
  1.003  CALL         Sub Fluke 287/289 Send Command RS-232

  1.004  IF           @Error
  1.005  END
  1.006  ENDIF

  1.007  PORT         [D50][I$]
  1.008  MATH         ActualFunction = FLD(MEM2, 1, ",")

  1.009  IF           ZCMPI(ActualFunction, "V_AC_LOZ")
  1.010  MATH         ActualKnobPosition = 1
  1.011  ELSEIF       ZCMPI(ActualFunction, "V_AC")
  1.012  MATH         ActualKnobPosition = 2
  1.013  ELSEIF       ZCMPI(ActualFunction, "mV_AC")
  1.014  MATH         ActualKnobPosition = 3
  1.015  ELSEIF       ZCMPI(ActualFunction, "V_DC")
  1.016  MATH         ActualKnobPosition = 4
  1.017  ELSEIF       ZCMPI(ActualFunction, "mV_DC")
  1.018  MATH         ActualKnobPosition = 5
  1.019  ELSEIF       ZCMPI(ActualFunction, "Temperature")
  1.020  MATH         ActualKnobPosition = 5
  1.021  ELSEIF       ZCMPI(ActualFunction, "Ohms")
  1.022  MATH         ActualKnobPosition = 6
  1.023  ELSEIF       ZCMPI(ActualFunction, "Conductance")
  1.024  MATH         ActualKnobPosition = 6
  1.025  ELSEIF       ZCMPI(ActualFunction, "Continuity")
  1.026  MATH         ActualKnobPosition = 6
  1.027  ELSEIF       ZCMPI(ActualFunction, "Diode_Test")
  1.028  MATH         ActualKnobPosition = 7
  1.029  ELSEIF       ZCMPI(ActualFunction, "Capacitance")
  1.030  MATH         ActualKnobPosition = 7
  1.031  ELSEIF       ZCMPI(ActualFunction, "A_DC")
  1.032  MATH         ActualKnobPosition = 8
  1.033  ELSEIF       ZCMPI(ActualFunction, "mA_DC")
  1.034  MATH         ActualKnobPosition = 8
  1.035  ELSEIF       ZCMPI(ActualFunction, "A_AC")
  1.036  MATH         ActualKnobPosition = 8
  1.037  ELSEIF       ZCMPI(ActualFunction, "mA_AC")
  1.038  MATH         ActualKnobPosition = 8
  1.039  ELSEIF       ZCMPI(ActualFunction, "uA_DC")
  1.040  MATH         ActualKnobPosition = 9
  1.041  ELSEIF       ZCMPI(ActualFunction, "uA_AC")
  1.042  MATH         ActualKnobPosition = 9
  1.043  ELSEIF       ZCMPI(ActualFunction, "Ohms_Low")
  1.044  MATH         ActualKnobPosition = 10
  1.045  ELSE
  1.046  MATH         ActualKnobPosition = 0
  1.047  ENDIF

  1.048  MATH         KnobOK = (ActualKnobPosition == @SetKnobPosition)

  1.049  IF           KnobOK
  1.050  MATH         FuncOK = ZCMPI(ActualFunction, @SetFunction)

  1.051  IF           NOT(FuncOK)
  1.052  5502E        Standby
  1.053  MATH         @Command = "MF " & @SetFunction
  1.054  CALL         Sub Fluke 287/289 Send Command RS-232

  1.055  IF           @Error
  1.056  END
  1.057  ENDIF

  1.058  ENDIF        ; NOT(FuncOK)

# Knob position is incorrect => Function is incorrect
  1.059  ELSE
  1.060  5502E        Standby
  1.061  MATH         FuncOK = 0
  1.062  DISP         Turn the UUT rotary switch knob to [V @FunctionMsg].
  1.063  WAIT         [D1000]
  1.064  ENDIF        ; KnobOK

  1.065  UNTIL        KnobOK && FuncOK

  1.066  END
