﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 Preliminary Tests
DATE:                  2015-02-20 10:08:31
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       160
=============================================================================
#
#
#  Procedure Author(s):
#        VY, ZY, DAC, DFM, BHT
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         FACTORY DEFAULT
  1.003  TARGET
  1.004  MESS         Prior to proceeding, reset the UUT as follows:
  1.004  MESS
  1.004  MESS         - Press F4 (Setup) and select Reset using arrow keys.
  1.004  MESS         - Press F3 (Meter).
  1.004  MESS         - Press F1 (OK). Power up routine should be initiated.
  1.004  MESS         [32] (Wait until routine completes prior to proceeding.)
  1.004  MESS
  1.005  MEM2         =Did the UUT go through power up routine?
  1.006  EVAL   -s "FACTORY DEFAULT" : [MEM2]

  2.001  MESS
  2.002  RSLT         =
  2.003  HEAD         POWER LED TEST
  2.004  TARGET
  2.005  MESS         The UUT's power button has an LED backlight. To test
  2.005  MESS         the LED, power the UUT off, then on again, verifying
  2.005  MESS         that the power button illuminates for approximately
  2.005  MESS         4 seconds, then extinguishes.
  2.005  MESS
  2.006  EVAL   -s "POWER LED TEST" : Did power LED come on as described?

  3.001  MESS
  3.002  RSLT         =
  3.003  HEAD         BACKLIGHT TEST
  3.004  TARGET
  3.005  OPBR         -z Press the backlight button TWICE.
  3.005  OPBR
  3.005  OPBR         Did the backlight illuminate at two different levels?
  3.006  MATH         L[1] = MEM1
  3.007  OPBR         -z Press the backlight button ONCE again.
  3.007  OPBR
  3.007  OPBR         Is the backlight off?
  3.008  MATH         L[2] = MEM1
  3.009  EVAL   -e L[1] && L[2] : BACKLIGHT TEST

  4.001  RSLT         =
  4.002  HEAD         CURRENT TERMINAL SENSING TEST
  4.003  TARGET
  4.004  OPBR         -z Install a test lead in the mA/µA input terminal.
  4.004  OPBR
  4.004  OPBR         Turn the UUT rotary switch knob to all functions EXCEPT
  4.004  OPBR         the current functions, pausing a moment at each one.
  4.004  OPBR         (It make take a second or so for the beeper to begin
  4.004  OPBR         chirping, in some cases.)
  4.004  OPBR
  4.004  OPBR         Did the beeper chirp continuously?
  4.005  MATH         L[1] = MEM1

  4.006  OPBR         -z Turn the UUT rotary switch knob to A/mA (AC & DC).
  4.006  OPBR
  4.006  OPBR         Did the beeper stop chirping?
  4.007  MATH         L[2] = MEM1

  4.008  OPBR         -z Move the test lead into the UUT A input terminal.
  4.008  OPBR
  4.008  OPBR         Turn the UUT rotary switch knob to all functions EXCEPT
  4.008  OPBR         the current functions, pausing a moment at each one.
  4.008  OPBR
  4.008  OPBR         Did the beeper chirp continuously?
  4.009  MATH         L[3] = MEM1

  4.010  OPBR         -z Turn the UUT rotary switch knob to A/mA (AC & DC).
  4.010  OPBR
  4.010  OPBR         Did the beeper stop chirping?
  4.011  MATH         L[4] = MEM1
  4.012  EVAL   -e L[1] && L[2] && L[3] && L[4]: CURRENT TERMINAL SENSING TEST

  5.001  DISP         Remove the test lead from the UUT A jack.
  5.001  DISP
  5.001  DISP         Turn the UUT rotary switch knob to V AC.

  5.002  RSLT         =
  5.003  HEAD         KEYPAD TEST
  5.004  TARGET
  5.005  MESS         Press each keypad pushbutton, verifying that the UUT
  5.005  MESS         responds with a 'beep' for each button pressed.
  5.005  MESS
  5.006  EVAL   -s "KEYPAD TEST" : Did each button beep when pressed?

  6.001  MESS
  6.002  RSLT         =
  6.003  HEAD         LCD TEST
  6.004  TARGET
  6.005  DISP         To test the UUT LCD pixels, proceed as follows:
  6.005  DISP
  6.005  DISP         - Turn the rotary switch knob to mV DC/Temperature.
  6.005  DISP         - Press F4 for Setup and select Contrast.
  6.005  DISP         - Push Backlight button twice for max brightness and
  6.005  DISP         [32] use the F1 and F2 softkeys to adjust Contrast for
  6.005  DISP         [32] the brightest display.
  6.006  MESS         Push the "i Info" button and scroll the text with F1
  6.006  MESS         and F2 buttons, inspecting the display for missing
  6.006  MESS         pixels or display areas  that may be unreadable, due
  6.006  MESS         to pixel defects.
  6.006  MESS
  6.007  EVAL   -s "LCD TEST" : Are there any missing or unreadable pixels?[N]

  7.001  MESS
  7.002  DISP         To restore the UUT to normal viewing conditions,
  7.002  DISP         proceed as follows:
  7.002  DISP
  7.002  DISP         - Push F4 (Close) button to close the text window.
  7.002  DISP         - Push Backlight button twice for normal brightness.
  7.002  DISP         - Use F1 and F2 softkeys to adjust for normal display
  7.002  DISP         [32] illumination.

  7.003  HEAD
  7.004  END
