﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 Send Command RS-232
DATE:                  2015-02-20 10:09:06
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       95
=============================================================================
#
#
#  Procedure Author(s):
#        VY, DAC, DFM, BHT
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         @Error = 0; LoopCounter = 1

  1.002  DO
  1.003  PORT         [CLR][T10000][V @Command][I]
  1.004  MATH         @Error = (MEM > 0)

# Check for error (acknowledge response is not "0").
  1.005  IF           @Error

# If this is the first time the command was sent, send again in case error
# was transient.
  1.006  IF           LoopCounter < 2
  1.007  WAIT         [D1000]
  1.008  ELSE

  1.009  IF           MEM == 1
  1.010  MATH         @ErrorMsg = "Syntax Error"
  1.011  ELSEIF       MEM == 2
  1.012  MATH         @ErrorMsg = "Execution Error"
  1.013  ELSEIF       MEM == 5
  1.014  MATH         @ErrorMsg = "No Data Available"
  1.015  ELSEIF       MEM == 7
  1.016  MATH         @ErrorMsg = "Assert Error"
  1.017  ELSEIF       MEM == 8
  1.018  MATH         @ErrorMsg = "Meter Storage Busy"
  1.019  ELSE
  1.020  MATH         MEM2 = "Unknown Error! Acknowledge Response is " & MEM
  1.021  MATH         @ErrorMsg = MEM2
  1.022  ENDIF

  1.023  OPBR         -z [V @ErrorMsg]
  1.023  OPBR
  1.023  OPBR         Do you wish to send the command again?

  1.024  IF           MEM1
  1.025  MATH         LoopCounter = LoopCounter - 1
  1.026  ENDIF

  1.027  ENDIF        ; LoopCounter < 2

  1.028  ENDIF        ; @Error

  1.029  MATH         LoopCounter = LoopCounter + 1
  1.030  UNTIL        NOT(MEM) || (LoopCounter > 2)

  1.031  END
