﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 287/289 Setup RS-232
INSTRUMENT:            Sub Fluke 287/289 Check ID RS-232
INSTRUMENT:            Sub Fluke 287/289 Check Battery Level RS-232
INSTRUMENT:            Sub Fluke 287/289 Reset to Default RS-232
INSTRUMENT:            Sub Fluke 287/289 Query Measurement RS-232
DATE:                  2015-02-20 10:09:13
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10479 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       212
=============================================================================
#
#
#  Procedure Author(s):
#        VY, DAC, DFM, BHT
#
#  Source(s):
#        Fluke 287/289 True-rms Multimeters Calibration Manual
#        February 2008, Rev. 1, 3/09 *
#
#        Fluke 287/289 True-rms Multimeters Calibration Manual Supplement
#        Revision/Date 1, 3/09, Issue Date: 6/10, Supplement issue: 3
#
#        Fluke USB-IR Cable or USB-RS232 Cable Installation Guide
#        PN 2395928, February 2005, Rev. 1, 8/06
#
#        * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Initialize error flag to no error.
  1.001  MATH         @Error = 0

  1.002  JMPL         SETUP                        PSUBI("Setup")
  1.003  JMPL         CHECK_IDENTIFICATION         PSUBI("Check ID")
  1.004  JMPL         CHECK_BATTERY_LEVEL          PSUBI("Battery")
  1.005  JMPL         RESET_TO_DEFAULT             PSUBI("Reset to Default")
  1.006  JMPL         QUERY_MEASUREMENT            PSUBI("Query Measurement")
  1.007  DISP         Subprocedure Not Found!
  1.008  END

  1.009  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 Setup RS-232  =====================================

  2.001  LABEL        SETUP
  2.002  HEAD         ESTABLISHING SERIAL COMMUNICATION WITH UUT
  2.003  DISP         Push the green (Power) button to turn on the UUT,
  2.003  DISP         then select any function except current.
  2.004  WAIT         -t 8 UUT Initializing...
# Setup serial parameters for communication with IR link.
  2.005  PORT         [P115200,N,8,1,N][OTERM CR]

  2.006  HEAD
  2.007  END

  2.008  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 Check ID RS-232  ==================================

  3.001  LABEL        CHECK_IDENTIFICATION
  3.002  RSLT         =
  3.003  HEAD         {IDENTIFICATION}
  3.004  TARGET
  3.005  MATH         @Command = "ID"
  3.006  CALL         Sub Fluke 287/289 Send Command RS-232
  3.007  JMPL         END                          @Error
  3.008  PORT         [I$]
# Response format is "Fluke <model>,<firmware rev>,<serial number>".
  3.009  MATH         Name          = FLD(MEM2, 1, ",")
  3.010  MATH         @Manufacturer = FLD(Name, 1, " ")
  3.011  MATH         @ModelNum     = FLD(Name, 2, " ")
  3.012  MATH         SerialNum     = FLD(MEM2, 3, ",")
  3.013  MATH         @FirmwareRev  = FLD(MEM2, 2, ",")

# Get UUT Calibration Counter Value.
  3.014  MATH         @Command = "QCCV"
  3.015  CALL         Sub Fluke 287/289 Send Command RS-232
  3.016  JMPL         END                          @Error
  3.017  PORT         [I]
  3.018  MATH         CalNumber = MEM

# Strip leading space from firmware revision.
  3.019  IF           ZCMP(SUB(@FirmwareRev, 1, 1), " ")
  3.020  MATH         @FirmwareRev = SUB(@FirmwareRev, 2, LEN(@FirmwareRev))
  3.021  ENDIF

  3.022  DISP         Manufacturer:       [V @Manufacturer]
  3.022  DISP         Model:              [V @UUT_Model]
  3.022  DISP         Serial Number:      [V SerialNum]
  3.022  DISP         Firmware Level:     [V @FirmwareRev]
  3.022  DISP         Calibration Number: [V CalNumber]
  3.023  RSLT         =
  3.024  RSLT         = Serial Number      : [V SerialNum]
  3.025  RSLT         = Firmware Level     : [V @FirmwareRev]
  3.026  RSLT         = Calibration Number : [V CalNumber]

  3.027  MATH         Model = @UUT_Model

# If UUT and selected procedure didn't match in sub, terminate procedure.
  3.028  IF           NOT(ZCMPI(Model, @UUT_Model))
  3.029  DISP         The UUT is a Fluke [V @UUT_Model],not a Fluke [V Model]!
  3.029  DISP
  3.029  DISP         Select "Advance" to abort the procedure
  3.030  END
  3.031  ENDIF

  3.032  HEAD
  3.033  END

  3.034  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 Check Battery Level RS-232  =======================

  4.001  LABEL        CHECK_BATTERY_LEVEL

  4.002  MATH         @Command = "QBL"
  4.003  CALL         Sub Fluke 287/289 Send Command RS-232
  4.004  JMPL         END                          @Error
  4.005  PORT         [I$]

  4.006  MATH         Full         = ZCMPI(MEM2, "FULL")
  4.007  MATH         PartlyEmpty3 = ZCMPI(MEM2, "PARTLY_EMPTY_3")
  4.008  MATH         PartlyEmpty2 = ZCMPI(MEM2, "PARTLY_EMPTY_2")
  4.009  MATH         PartlyEmpty1 = ZCMPI(MEM2, "PARTLY_EMPTY_1")
  4.010  MATH         AlmostEmpty  = ZCMPI(MEM2, "ALMOST_EMPTY")

# Battery level good enough to perform calibration or verification (~80-100%).
  4.011  IF           Full || PartlyEmpty3
# Battery level (~60%).
  4.012  ELSEIF       PartlyEmpty2
  4.013  DISP         It is recommended that the UUT batteries be replaced
  4.013  DISP         prior to proceeding.
# Battery level (~20-40%).
  4.014  ELSEIF       PartlyEmpty1 || AlmostEmpty
  4.015  DISP         The UUT batteries MUST be replaced prior to proceeding.
  4.016  MATH         @Error = 1
# Battery level ("It's dead, Jim").
  4.017  ELSE
  4.018  DISP         The UUT batteries will be dead in 15 seconds or less!
  4.019  MATH         @Error = 1
  4.020  ENDIF

  4.021  END

  4.022  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 Reset to Default RS-232  ==========================

  5.001  LABEL        RESET_TO_DEFAULT
  5.002  HEAD         RESET UUT TO FACTORY DEFAULTS
  5.003  MATH         @Command = "RI"
  5.004  CALL         Sub Fluke 287/289 Send Command RS-232
  5.005  JMPL         END                          @Error
  5.006  WAIT         -t 8 UUT Initializing...

  5.007  HEAD
  5.008  END

  5.009  EVAL   Increment Test Number

# =====  Sub Fluke 287/289 Query Measurement RS-232  =========================

  6.001  LABEL        QUERY_MEASUREMENT

  6.002  DO
  6.003  MATH         @Command = "QM"
  6.004  CALL         Sub Fluke 287/289 Send Command RS-232
  6.005  JMPL         END                          @Error
# Get the reading and state.
  6.006  PORT         [I$]
# "QM" Command:  Return format is "<reading>,<unit>,<state>,<attribute>".
  6.007  MATH         MEM   = FLD(MEM2, 1, ",")
  6.008  MATH         State = FLD(MEM2, 3, ",")

  6.009  IF           ZCMPI(State, "OL")
  6.010  OPBR         -z The UUT reading is out of range.
  6.010  OPBR
  6.010  OPBR         Do you want to take another reading?
  6.011  MATH         Done = NOT(MEM1)

  6.012  ELSE
  6.013  MATH         Done = 1
  6.014  ENDIF

  6.015  UNTIL        Done

  6.016  LABEL        END
  6.017  END
