﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub 8648A/B/C/D (2 yr) CW Freq (Std TB) Tests /HFCTR
INSTRUMENT:            Sub 8648A/B/C/D (2 yr) CW Freq (1E5) Tests /HFCTR
DATE:                  2013-12-02 12:48:45
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       15
NUMBER OF LINES:       162
CONFIGURATION:         High Frequency Counter
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Additional Equipment Required:
#        None
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@HFCTR]
  1.003  ENDIF

  1.004  CALL         Sub Reset /HFCTR
  1.005  MATH         @HFCTR_Func = "FreqChHF"
  1.006  MATH         L[1] = @FreqRefAcc

  1.007  JMPL         CW_FREQ_STD_TB_TESTS_HFCTR   PSUBI(" TB) Tests //HFCTR")
  1.008  JMPL         CW_FREQ_1E5_TESTS_HFCTR      PSUBI("(1E5) Tests /HFCTR")
  1.009  DISP         Subprocedure not found!
  1.010  END

  1.011  EVAL   Increment step number

# =====  Sub 8648A/B/C/D (2 yr) CW Freq (Std TB) VER /HFCTR  ================

  2.001  LABEL        CW_FREQ_STD_TB_TESTS_HFCTR
  2.002  TARGET       -p
  2.003  SCPI         FREQ:CW 500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  2.004  TARGET       -m
  2.005  CALL         Sub Measure /HFCTR
  2.006  MATH         MEM = MEM / 1E+6
  2.007  ACC    500   MH             L1P%
  2.008  MEMC   1000  500.0000000MH  0.0015000U

  3.001  SCPI         FREQ:CW 1000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  3.002  TARGET       -m
  3.003  CALL         Sub Measure /HFCTR
  3.004  MATH         MEM = MEM / 1E+6
  3.005  ACC    1000  MH             L1P%
  3.006  MEMC   1000  1000.0000000MH 0.0030000U

  4.001  IF           NOT(ZCMPI(@ModelNum, "8648A"))
  4.002  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  4.003  TARGET       -m
  4.004  CALL         Sub Measure /HFCTR
  4.005  MATH         MEM = MEM / 1E+6
  4.006  ACC    2000  MH             L1P%
  4.007  MEMC   1000  2000.0000000MH 0.0060000U
  5.001  ENDIF

  5.002  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
  5.003  SCPI         FREQ:CW 3000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  5.004  TARGET       -m
  5.005  CALL         Sub Measure /HFCTR
  5.006  MATH         MEM = MEM / 1E+6
  5.007  ACC    3000  MH             L1P%
  5.008  MEMC   1000  3000.0000000MH 0.0090000U

  6.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  6.002  TARGET       -m
  6.003  CALL         Sub Measure /HFCTR
  6.004  MATH         MEM = MEM / 1E+6
  6.005  ACC    3200  MH             L1P%
  6.006  MEMC   1000  3200.0000000MH 0.0096000U
  7.001  ENDIF

  7.002  IF           ZCMPI(@ModelNum, "8648D")
  7.003  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  7.004  TARGET       -m
  7.005  CALL         Sub Measure /HFCTR
  7.006  MATH         MEM = MEM / 1E+6
  7.007  ACC    4000  MH             L1P%
  7.008  MEMC   1000  4000.0000000MH 0.0120000U
  8.001  ENDIF

  8.002  SCPI         *RST
  8.003  CALL         Sub Reset /HFCTR
  8.004  END

  8.005  EVAL   Increment step number

# =====  Sub 8648A/B/C/D (2 yr) CW Freq (Opt 1E5) VER /HFCTR  ===============

  9.001  LABEL        CW_FREQ_1E5_TESTS_HFCTR
  9.002  TARGET       -p
  9.003  SCPI         FREQ:CW 500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  9.004  TARGET       -m
  9.005  CALL         Sub Measure /HFCTR
  9.006  MATH         MEM = MEM / 1E+6
  9.007  ACC    500   MH             L1P%
  9.008  MEMC   1000  500.0000000MH  0.0000750U

 10.001  SCPI         FREQ:CW 1000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 10.002  TARGET       -m
 10.003  CALL         Sub Measure /HFCTR
 10.004  MATH         MEM = MEM / 1E+6
 10.005  ACC    1000  MH             L1P%
 10.006  MEMC   1000  1000.0000000MH 0.0001500U

 11.001  IF           NOT(ZCMPI(@ModelNum, "8648A"))
 11.002  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 11.003  TARGET       -m
 11.004  CALL         Sub Measure /HFCTR
 11.005  MATH         MEM = MEM / 1E+6
 11.006  ACC    2000  MH             L1P%
 11.007  MEMC   1000  2000.0000000MH 0.0003000U
 12.001  ENDIF

 12.002  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
 12.003  SCPI         FREQ:CW 3000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 12.004  TARGET       -m
 12.005  CALL         Sub Measure /HFCTR
 12.006  MATH         MEM = MEM / 1E+6
 12.007  ACC    3000  MH             L1P%
 12.008  MEMC   1000  3000.0000000MH 0.0004500U

 13.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 13.002  TARGET       -m
 13.003  CALL         Sub Measure /HFCTR
 13.004  MATH         MEM = MEM / 1E+6
 13.005  ACC    3200  MH             L1P%
 13.006  MEMC   1000  3200.0000000MH 0.0004800U
 14.001  ENDIF

 14.002  IF           ZCMPI(@ModelNum, "8648D")
 14.003  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 14.004  TARGET       -m
 14.005  CALL         Sub Measure /HFCTR
 14.006  MATH         MEM = MEM / 1E+6
 14.007  ACC    4000  MH             L1P%
 14.008  MEMC   1000  4000.0000000MH 0.0006000U
 15.001  ENDIF        ; 8648D

 15.002  SCPI         *RST
 15.003  CALL         Sub Reset /HFCTR
 15.004  END
