﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648A/B/C/D (2 yr) CW Freq (Std TB) Tests /LFCTR
INSTRUMENT:            Sub 8648A/B/C/D (2 yr) CW Freq (1E5) Tests /LFCTR
DATE:                  2016-06-28 07:43:58
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       13
NUMBER OF LINES:       141
CONFIGURATION:         Low Frequency Counter
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LFCTR]
  1.003  ENDIF

  1.004  CALL         Sub Reset /LFCTR
  1.005  MATH         @LFCTR_Func = "FreqCh1"
  1.006  MATH         @LFCTR_Ch1Imp   = "LoZ"
  1.007  MATH         @LFCTR_MeasTime = "2s"
  1.008  MATH         L[1] = @FreqRefAcc

  1.009  JMPL         CW_FREQ_STD_TB_TESTS_LFCTR   PSUBI(" TB) Tests /LFCTR")
  1.010  JMPL         CW_FREQ_1E5_TESTS_LFCTR      PSUBI("1E5) Tests /LFCTR")
  1.011  DISP         Subprocedure not found!
  1.012  END

  1.013  EVAL   Increment step number

# =====  Sub 8648A/B/C/D (2 yr) CW Freq (Std TB) Tests /LFCTR  ==============

  2.001  LABEL        CW_FREQ_STD_TB_TESTS_LFCTR
  2.002  TARGET       -p
  2.003  SCPI         FREQ:CW 0.5 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  2.004  TARGET       -m
  2.005  CALL         Sub Measure /LFCTR
  2.006  MATH         MEM = MEM / 1E+6
  2.007  ACC    0.5   MH             L1P%
  2.008  MEMC   1000  0.5000000MH    0.0000015U

  3.001  SCPI         FREQ:CW 1 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  3.002  TARGET       -m
  3.003  CALL         Sub Measure /LFCTR
  3.004  MATH         MEM = MEM / 1E+6
  3.005  ACC    1     MH             L1P%
  3.006  MEMC   1000  1.0000000MH    0.0000030U

  4.001  SCPI         FREQ:CW 10 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  4.002  TARGET       -m
  4.003  CALL         Sub Measure /LFCTR
  4.004  MATH         MEM = MEM / 1E+6
  4.005  ACC    10    MH             L1P%
  4.006  MEMC   1000  10.0000000MH   0.0000300U

  5.001  SCPI         FREQ:CW 50 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  5.002  TARGET       -m
  5.003  CALL         Sub Measure /LFCTR
  5.004  MATH         MEM = MEM / 1E+6
  5.005  ACC    50    MH             L1P%
  5.006  MEMC   1000  50.0000000MH   0.0001500U

  6.001  SCPI         FREQ:CW 100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  6.002  TARGET       -m
  6.003  CALL         Sub Measure /LFCTR
  6.004  MATH         MEM = MEM / 1E+6
  6.005  ACC    100   MH             L1P%
  6.006  MEMC   1000  100.0000000MH  0.0003000U

  7.001  SCPI         *RST
  7.002  CALL         Sub Reset /LFCTR
  7.003  END

  7.004  EVAL   Increment step number

# =====  Sub 8648A/B/C/D (2 yr) CW Freq (1E5) Tests /LFCTR  ===============

  8.001  LABEL        CW_FREQ_1E5_TESTS_LFCTR
  8.002  TARGET       -p
  8.003  SCPI         FREQ:CW 0.5 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  8.004  TARGET       -m
  8.005  CALL         Sub Measure /LFCTR
  8.006  MATH         MEM = MEM / 1E+6
  8.007  ACC    0.5   MH             L1P%
  8.008  MEMC   1000  0.5000000MH    0.0000010U

  9.001  SCPI         FREQ:CW 1 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  9.002  TARGET       -m
  9.003  CALL         Sub Measure /LFCTR
  9.004  MATH         MEM = MEM / 1E+6
  9.005  ACC    1     MH             L1P%
  9.006  MEMC   1000  1.0000000MH    0.0000010U

 10.001  SCPI         FREQ:CW 10 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 10.002  TARGET       -m
 10.003  CALL         Sub Measure /LFCTR
 10.004  MATH         MEM = MEM / 1E+6
 10.005  ACC    10    MH             L1P%
 10.006  MEMC   1000  10.0000000MH   0.0000020U

 11.001  SCPI         FREQ:CW 50 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 11.002  TARGET       -m
 11.003  CALL         Sub Measure /LFCTR
 11.004  MATH         MEM = MEM / 1E+6
 11.005  ACC    50    MH             L1P%
 11.006  MEMC   1000  50.0000000MH   0.0000080U

 12.001  SCPI         FREQ:CW 100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 12.002  TARGET       -m
 12.003  CALL         Sub Measure /LFCTR
 12.004  MATH         MEM = MEM / 1E+6
 12.005  ACC    100   MH             L1P%
 12.006  MEMC   1000  100.0000000MH  0.0000150U

 13.001  SCPI         *RST
 13.002  CALL         Sub Reset /LFCTR
 13.003  END
