﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) DC FM Freq Error VER /HFCTR
DATE:                  2016-06-28 07:43:19
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       25
NUMBER OF LINES:       383
CONFIGURATION:         High Frequency Counter
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Dummy statements so procedure header contains CONFIGURATION: lines for
# instrument used in subprocedures called.
  1.001  IF           0
  1.002  IEEE         [@HFCTR]
  1.003  ENDIF

  1.004  CALL         Sub Reset /HFCTR
  1.005  MATH         @HFCTR_Func = "FreqChHF"
  1.006  MATH         L[1] = @FreqRefAcc

  1.007  HEAD         DC FM FREQUENCY ERROR PERFORMANCE
  1.008  RSLT         =
  1.009  HEAD         -2{Carrier Frequency: 500 MHz}
  1.010  TARGET       -p
  1.011  TSET         TDESC = 1 kHz deviation
  1.012  CALL         Sub Reset /HFCTR
  1.013  SCPI         FREQ:CW 500 MHZ;:FM:DEV 1 KHZ;:FM:SOUR EXT
  1.014  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  1.015  TARGET       -m
  1.016  SCPI         FM:STAT OFF
  1.017  CALL         Sub Measure /HFCTR
  1.018  MATH         FMoff = MEM
  1.019  SCPI         FM:STAT ON
  1.020  CALL         Sub Measure /HFCTR
  1.021  MATH         MEM = FMoff - MEM
  1.022  ACC    0     H              L1P%
  1.023  MEMC         0H             100U

  2.001  TSET         TDESC = 5 kHz deviation
  2.002  SCPI         FREQ:CW 500 MHZ;:FM:DEV 5 KHZ;:FM:SOUR EXT
  2.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  2.004  TARGET       -m
  2.005  SCPI         FM:STAT OFF
  2.006  CALL         Sub Measure /HFCTR
  2.007  MATH         FMoff = MEM
  2.008  SCPI         FM:STAT ON
  2.009  CALL         Sub Measure /HFCTR
  2.010  MATH         MEM = FMoff - MEM
  2.011  ACC    0     H              L1P%
  2.012  MEMC         0H             100U

  3.001  TSET         TDESC = 9.9 kHz deviation
  3.002  SCPI         FREQ:CW 500 MHZ;:FM:DEV 9.9 KHZ;:FM:SOUR EXT
  3.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  3.004  TARGET       -m
  3.005  SCPI         FM:STAT OFF
  3.006  CALL         Sub Measure /HFCTR
  3.007  MATH         FMoff = MEM
  3.008  SCPI         FM:STAT ON
  3.009  CALL         Sub Measure /HFCTR
  3.010  MATH         MEM = FMoff - MEM
  3.011  ACC    0     H              L1P%
  3.012  MEMC         0H             100U

  4.001  RSLT         =
  4.002  HEAD         -2{Carrier Frequency: 1000 MHz}
  4.003  TARGET       -p
  4.004  TSET         TDESC = 1 kHz deviation
  4.005  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 1 KHZ;:FM:SOUR EXT
  4.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  4.007  TARGET       -m
  4.008  SCPI         FM:STAT OFF
  4.009  CALL         Sub Measure /HFCTR
  4.010  MATH         FMoff = MEM
  4.011  SCPI         FM:STAT ON
  4.012  CALL         Sub Measure /HFCTR
  4.013  MATH         MEM = FMoff - MEM
  4.014  ACC    0     H              L1P%
  4.015  MEMC         0H             100U

  5.001  TSET         TDESC = 5 kHz deviation
  5.002  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 5 KHZ;:FM:SOUR EXT
  5.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  5.004  TARGET       -m
  5.005  SCPI         FM:STAT OFF
  5.006  CALL         Sub Measure /HFCTR
  5.007  MATH         FMoff = MEM
  5.008  SCPI         FM:STAT ON
  5.009  CALL         Sub Measure /HFCTR
  5.010  MATH         MEM = FMoff - MEM
  5.011  ACC    0     H              L1P%
  5.012  MEMC         0H             100U

  6.001  TSET         TDESC = 9.9 kHz deviation
  6.002  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 9.9 KHZ;:FM:SOUR EXT
  6.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  6.004  TARGET       -m
  6.005  SCPI         FM:STAT OFF
  6.006  CALL         Sub Measure /HFCTR
  6.007  MATH         FMoff = MEM
  6.008  SCPI         FM:STAT ON
  6.009  CALL         Sub Measure /HFCTR
  6.010  MATH         MEM = FMoff - MEM
  6.011  ACC    0     H              L1P%
  6.012  MEMC         0H             100U

  7.001  RSLT         =
  7.002  HEAD         -2{Carrier Frequency: 1500 MHz}
  7.003  TARGET       -p
  7.004  TSET         TDESC = 2 kHz deviation
  7.005  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 2 KHZ;:FM:SOUR EXT
  7.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  7.007  TARGET       -m
  7.008  SCPI         FM:STAT OFF
  7.009  CALL         Sub Measure /HFCTR
  7.010  MATH         FMoff = MEM
  7.011  SCPI         FM:STAT ON
  7.012  CALL         Sub Measure /HFCTR
  7.013  MATH         MEM = FMoff - MEM
  7.014  ACC    0     H              L1P%
  7.015  MEMC         0H             200U

  8.001  TSET         TDESC = 9.9 kHz deviation
  8.002  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 9.9 KHZ;:FM:SOUR EXT
  8.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  8.004  TARGET       -m
  8.005  SCPI         FM:STAT OFF
  8.006  CALL         Sub Measure /HFCTR
  8.007  MATH         FMoff = MEM
  8.008  SCPI         FM:STAT ON
  8.009  CALL         Sub Measure /HFCTR
  8.010  MATH         MEM = FMoff - MEM
  8.011  ACC    0     H              L1P%
  8.012  MEMC         0H             200U

  9.001  TSET         TDESC = 19.9 kHz deviation
  9.002  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
  9.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  9.004  TARGET       -m
  9.005  SCPI         FM:STAT OFF
  9.006  CALL         Sub Measure /HFCTR
  9.007  MATH         FMoff = MEM
  9.008  SCPI         FM:STAT ON
  9.009  CALL         Sub Measure /HFCTR
  9.010  MATH         MEM = FMoff - MEM
  9.011  ACC    0     H              L1P%
  9.012  MEMC         0H             200U

 10.001  RSLT         =
 10.002  HEAD         -2{Carrier Frequency: 2000 MHz}
 10.003  TARGET       -p
 10.004  TSET         TDESC = 2 kHz deviation
 10.005  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 2 KHZ;:FM:SOUR EXT
 10.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 10.007  TARGET       -m
 10.008  SCPI         FM:STAT OFF
 10.009  CALL         Sub Measure /HFCTR
 10.010  MATH         FMoff = MEM
 10.011  SCPI         FM:STAT ON
 10.012  CALL         Sub Measure /HFCTR
 10.013  MATH         MEM = FMoff - MEM
 10.014  ACC    0     H              L1P%
 10.015  MEMC         0H             200U

 11.001  TSET         TDESC = 9.9 kHz deviation
 11.002  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 9.9 KHZ;:FM:SOUR EXT
 11.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 11.004  TARGET       -m
 11.005  SCPI         FM:STAT OFF
 11.006  CALL         Sub Measure /HFCTR
 11.007  MATH         FMoff = MEM
 11.008  SCPI         FM:STAT ON
 11.009  CALL         Sub Measure /HFCTR
 11.010  MATH         MEM = FMoff - MEM
 11.011  ACC    0     H              L1P%
 11.012  MEMC         0H             200U

 12.001  TSET         TDESC = 19.9 kHz deviation
 12.002  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
 12.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 12.004  TARGET       -m
 12.005  SCPI         FM:STAT OFF
 12.006  CALL         Sub Measure /HFCTR
 12.007  MATH         FMoff = MEM
 12.008  SCPI         FM:STAT ON
 12.009  CALL         Sub Measure /HFCTR
 12.010  MATH         MEM = FMoff - MEM
 12.011  ACC    0     H              L1P%
 12.012  MEMC         0H             200U

# The following tests apply to 8648C/D models only.
 13.001  IF           ZCMPI(MEM2, "8648C") || ZCMPI(MEM2, "8648D")
 13.002  RSLT         =
 13.003  HEAD         -2{Carrier Frequency: 2500 MHz}
 13.004  TARGET       -p
 13.005  TSET         TDESC = 4 kHz deviation
 13.006  SCPI         FREQ:CW 2500 MHZ;:FM:DEV 4 KHZ;:FM:SOUR EXT
 13.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 13.008  TARGET       -m
 13.009  SCPI         FM:STAT OFF
 13.010  CALL         Sub Measure /HFCTR
 13.011  MATH         FMoff = MEM
 13.012  SCPI         FM:STAT ON
 13.013  CALL         Sub Measure /HFCTR
 13.014  MATH         MEM = FMoff - MEM
 13.015  ACC    0     H              L1P%
 13.016  MEMC         0H             400U

 14.001  TSET         TDESC = 19.9 kHz deviation
 14.002  SCPI         FREQ:CW 2500 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
 14.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 14.004  TARGET       -m
 14.005  SCPI         FM:STAT OFF
 14.006  CALL         Sub Measure /HFCTR
 14.007  MATH         FMoff = MEM
 14.008  SCPI         FM:STAT ON
 14.009  CALL         Sub Measure /HFCTR
 14.010  MATH         MEM = FMoff - MEM
 14.011  ACC    0     H              L1P%
 14.012  MEMC         0H             400U

 15.001  TSET         TDESC = 39.9 kHz deviation
 15.002  SCPI         FREQ:CW 2500 MHZ;:FM:DEV 39.9 KHZ;:FM:SOUR EXT
 15.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 15.004  TARGET       -m
 15.005  SCPI         FM:STAT OFF
 15.006  CALL         Sub Measure /HFCTR
 15.007  MATH         FMoff = MEM
 15.008  SCPI         FM:STAT ON
 15.009  CALL         Sub Measure /HFCTR
 15.010  MATH         MEM = FMoff - MEM
 15.011  ACC    0     H              L1P%
 15.012  MEMC         0H             400U

 16.001  RSLT         =
 16.002  HEAD         -2{Carrier Frequency: 3200 MHz}
 16.003  TARGET       -p
 16.004  TSET         TDESC = 4 kHz deviation
 16.005  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 4 KHZ;:FM:SOUR EXT
 16.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 16.007  TARGET       -m
 16.008  SCPI         FM:STAT OFF
 16.009  CALL         Sub Measure /HFCTR
 16.010  MATH         FMoff = MEM
 16.011  SCPI         FM:STAT ON
 16.012  CALL         Sub Measure /HFCTR
 16.013  MATH         MEM = FMoff - MEM
 16.014  ACC    0     H              L1P%
 16.015  MEMC         0H             400U

 17.001  TSET         TDESC = 19.9 kHz deviation
 17.002  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
 17.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 17.004  TARGET       -m
 17.005  SCPI         FM:STAT OFF
 17.006  CALL         Sub Measure /HFCTR
 17.007  MATH         FMoff = MEM
 17.008  SCPI         FM:STAT ON
 17.009  CALL         Sub Measure /HFCTR
 17.010  MATH         MEM = FMoff - MEM
 17.011  ACC    0     H              L1P%
 17.012  MEMC         0H             400U

 18.001  TSET         TDESC = 39.9 kHz deviation
 18.002  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 39.9 KHZ;:FM:SOUR EXT
 18.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 18.004  TARGET       -m
 18.005  SCPI         FM:STAT OFF
 18.006  CALL         Sub Measure /HFCTR
 18.007  MATH         FMoff = MEM
 18.008  SCPI         FM:STAT ON
 18.009  CALL         Sub Measure /HFCTR
 18.010  MATH         MEM = FMoff - MEM
 18.011  ACC    0     H              L1P%
 18.012  MEMC         0H             400U
 19.001  ENDIF

# The following tests apply to 8648D models only.
 19.002  IF           ZCMPI(@ModelNum, "8648D")
 19.003  RSLT         =
 19.004  HEAD         -2{Carrier Frequency: 3500 MHz}
 19.005  TARGET       -p
 19.006  TSET         TDESC = 4 kHz deviation
 19.007  SCPI         FREQ:CW 3500 MHZ;:FM:DEV 4 KHZ;:FM:SOUR EXT
 19.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 19.009  TARGET       -m
 19.010  SCPI         FM:STAT OFF
 19.011  CALL         Sub Measure /HFCTR
 19.012  MATH         FMoff = MEM
 19.013  SCPI         FM:STAT ON
 19.014  CALL         Sub Measure /HFCTR
 19.015  MATH         MEM = FMoff - MEM
 19.016  ACC    0     H              L1P%
 19.017  MEMC         0H             400U

 20.001  TSET         TDESC = 19.9 kHz deviation
 20.002  SCPI         FREQ:CW 3500 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
 20.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 20.004  TARGET       -m
 20.005  SCPI         FM:STAT OFF
 20.006  CALL         Sub Measure /HFCTR
 20.007  MATH         FMoff = MEM
 20.008  SCPI         FM:STAT ON
 20.009  MATH         MEM = FMoff - MEM
 20.010  ACC    0     H              L1P%
 20.011  MEMC         0H             400U

 21.001  TSET         TDESC = 39.9 kHz deviation
 21.002  SCPI         FREQ:CW 3500 MHZ;:FM:DEV 39.9 KHZ;:FM:SOUR EXT
 21.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 21.004  TARGET       -m
 21.005  SCPI         FM:STAT OFF
 21.006  CALL         Sub Measure /HFCTR
 21.007  MATH         FMoff = MEM
 21.008  SCPI         FM:STAT ON
 21.009  CALL         Sub Measure /HFCTR
 21.010  MATH         MEM = FMoff - MEM
 21.011  ACC    0     H              L1P%
 21.012  MEMC         0H             400U

 22.001  RSLT         =
 22.002  HEAD         -2{Carrier Frequency: 4000 MHz}
 22.003  TARGET       -p
 22.004  TSET         TDESC = 4 kHz deviation
 22.005  SCPI         FREQ:CW 4000 MHZ;:FM:DEV 4 KHZ;:FM:SOUR EXT
 22.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 22.007  TARGET       -m
 22.008  SCPI         FM:STAT OFF
 22.009  CALL         Sub Measure /HFCTR
 22.010  MATH         FMoff = MEM
 22.011  SCPI         FM:STAT ON
 22.012  CALL         Sub Measure /HFCTR
 22.013  MATH         MEM = FMoff - MEM
 22.014  ACC    0     H              L1P%
 22.015  MEMC         0H             400U

 23.001  TSET         TDESC = 19.9 kHz deviation
 23.002  SCPI         FREQ:CW 4000 MHZ;:FM:DEV 19.9 KHZ;:FM:SOUR EXT
 23.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 23.004  TARGET       -m
 23.005  SCPI         FM:STAT OFF
 23.006  CALL         Sub Measure /HFCTR
 23.007  MATH         FMoff = MEM
 23.008  SCPI         FM:STAT ON
 23.009  CALL         Sub Measure /HFCTR
 23.010  MATH         MEM = FMoff - MEM
 23.011  ACC    0     H              L1P%
 23.012  MEMC         0H             400U

 24.001  TSET         TDESC = 39.9 kHz deviation
 24.002  SCPI         FREQ:CW 4000 MHZ;:FM:DEV 39.9 KHZ;:FM:SOUR EXT
 24.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 24.004  TARGET       -m
 24.005  SCPI         FM:STAT OFF
 24.006  CALL         Sub Measure /HFCTR
 24.007  MATH         FMoff = MEM
 24.008  SCPI         FM:STAT ON
 24.009  CALL         Sub Measure /HFCTR
 24.010  MATH         MEM = FMoff - MEM
 24.011  ACC    0     H              L1P%
 24.012  MEMC         0H             400U
 25.001  ENDIF

 25.002  HEAD         -2
 25.003  HEAD
 25.004  SCPI         *RST
 25.005  CALL         Sub Reset /HFCTR
 25.006  END
