﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) DC FM Freq Error VER /LFCTR
DATE:                  2016-06-28 07:43:09
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       98
CONFIGURATION:         Low Frequency Counter
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8648B/C/D
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Dummy statements so procedure header contains CONFIGURATION: lines for
# instrument used in subprocedures called.
  1.001  IF           0
  1.002  IEEE         [@LFCTR]
  1.003  ENDIF

  1.004  CALL         Sub Reset /LFCTR
  1.005  MATH         @LFCTR_Func     = "FreqCh1"
  1.006  MATH         @LFCTR_Ch1Imp   = "LoZ"
  1.007  MATH         @LFCTR_MeasTime = "2s"
  1.008  MATH         L[1] = @FreqRefAcc

  1.009  RSLT         =
  1.010  HEAD         {DC FM FREQUENCY ERROR PERFORMANCE}
  1.011  RSLT         =
  1.012  HEAD         -2{Carrier Frequency: 100 MHz}
  1.013  TARGET       -p
  1.014  TSET         TDESC = 1 kHz deviation
  1.015  CALL         Sub Reset /LFCTR
  1.016  SCPI         FREQ:CW 100 MHZ;:FM:DEV 1 KHZ;:FM:SOUR EXT
  1.017  SCPI         FM:EXT:COUP DC;:FM:STAT ON
  1.018  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
# Perform DC FM calibration.
  1.019  SCPI         CAL:DCFM
  1.020  TARGET       -m
# Turn off FM.
  1.021  SCPI         FM:STAT OFF
# Take initial measurement.
  1.022  CALL         Sub Measure /LFCTR
# Store measured value (in Hz) with EXT FM off.
  1.023  MATH         FMoff = MEM
# Turn on EXT FM.
  1.024  SCPI         FM:STAT ON
# Take measurement with EXT DC FM turned on (nothing applied).
  1.025  CALL         Sub Measure /LFCTR
  1.026  MATH         MEM = FMoff - MEM
  1.027  ACC    0     H              L1P%
  1.028  MEMC         0H             100U

  2.001  TSET         TDESC = 5 kHz deviation
  2.002  SCPI         FREQ:CW 100 MHZ;:FM:DEV 5 KHZ;:FM:SOUR EXT
  2.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  2.004  TARGET       -m
  2.005  SCPI         FM:STAT OFF
  2.006  CALL         Sub Measure /LFCTR
  2.007  MATH         FMoff = MEM
  2.008  SCPI         FM:STAT ON
  2.009  CALL         Sub Measure /LFCTR
  2.010  MATH         MEM = FMoff - MEM
  2.011  ACC    0     H              L1P%
  2.012  MEMC         0H             100U

  3.001  TSET         TDESC = 9.9 kHz deviation
  3.002  SCPI         FREQ:CW 100 MHZ;:FM:DEV 9.9 KHZ;:FM:SOUR EXT
  3.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  3.004  TARGET       -m
  3.005  SCPI         FM:STAT OFF
  3.006  CALL         Sub Measure /LFCTR
  3.007  MATH         FMoff = MEM
  3.008  SCPI         FM:STAT ON
  3.009  CALL         Sub Measure /LFCTR
  3.010  MATH         MEM = FMoff - MEM
  3.011  ACC    0     H              L1P%
  3.012  MEMC         0H             100U

  4.001  HEAD         -2
  4.002  HEAD
  4.003  SCPI         *RST
  4.004  CALL         Sub Reset /LFCTR
  4.005  END
