﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) FM Res VER /8902S,8903,LO
DATE:                  2016-06-28 07:42:56
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       16
NUMBER OF LINES:       217
CONFIGURATION:         HP 8902A
CONFIGURATION:         HP 8903B
CONFIGURATION:         Local Oscillator
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        HP/Agilent 11792A Sensor Module
#        HP/Agilent 11793A Microwave Converter
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LO]
  1.003  ENDIF

  1.004  CALL         Sub Initialize /LO
  1.005  CALL         Sub Reset /LO

  1.006  RSLT         =
  1.007  HEAD         {RESIDUAL FM PERFORMANCE}
  1.008  RSLT         =(50 Hz to 15 kHz Bandwidth)
  1.009  RSLT         =
  1.010  HEAD         -2 Carrier Frequency: 10 MHz
  1.011  TARGET       -p
  1.012  TSET         TDESC = 10 MHz Carrier
  1.013  SCPI         FREQ:CW 10 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
# Take frequency measurement to yank 8902A out of the ozone after offset mode.
  1.014  8902         10MH                         4D                FA N
  1.015  M8902        1kH                                         H1 L2    P+
  1.016  TARGET       -m
  1.017  8902         0.007kH                      10MH              FM N
# Engage 8903B CCITT Weighting and 30 kHz low-pass filter.
  1.018  M8903                                                    H2 L1    RMS
  1.019  8903         7.0mV                        1kH               AL N
  1.020  MEMC         0H             +0U -7U

  2.001  HEAD         -2 Carrier Frequency: 100 MHz
  2.002  TSET         TDESC = 100 MHz Carrier
  2.003  SCPI         FREQ:CW 100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  2.004  TARGET       -m
  2.005  8902         0.007kH                      100MH             FM N
  2.006  8903         7.0mV                        1kH               AL N
  2.007  MEMC         0H             +0U -7U

  3.001  HEAD         -2 Carrier Frequency: 248 MHz
  3.002  TSET         TDESC = 248 MHz Carrier
  3.003  SCPI         FREQ:CW 248 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  3.004  TARGET       -m
  3.005  8902         0.007kH                      248MH             FM N
  3.006  8903         7.0mV                        1kH               AL N
  3.007  MEMC         0H             +0U -7U

  4.001  HEAD         -2 Carrier Frequency: 251 MHz
  4.002  TSET         TDESC = 251 MHz Carrier
  4.003  SCPI         FREQ:CW 251 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  4.004  TARGET       -m
  4.005  8902         0.004kH                      251MH             FM N
  4.006  8903         4.0mV                        1kH               AL N
  4.007  MEMC         0H             +0U -4U

  5.001  HEAD         -2 Carrier Frequency: 400 MHz
  5.002  TSET         TDESC = 400 MHz Carrier
  5.003  SCPI         FREQ:CW 400 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  5.004  TARGET       -m
  5.005  8902         0.004kH                      400MH             FM N
  5.006  8903         4.0mV                        1kH               AL N
  5.007  MEMC         0H             +0U -4U

  6.001  HEAD         -2 Carrier Frequency: 501 MHz
  6.002  TSET         TDESC = 501 MHz Carrier
  6.003  SCPI         FREQ:CW 501 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  6.004  TARGET       -m
  6.005  8902         0.007kH                      501MH             FM N
  6.006  8903         7.0mV                        1kH               AL N
  6.007  MEMC         0H             +0U -7U

  7.001  HEAD         -2 Carrier Frequency: 750 MHz
  7.002  TSET         TDESC = 750 MHz Carrier
  7.003  SCPI         FREQ:CW 750 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  7.004  TARGET       -m
  7.005  8902         0.007kH                      750MH             FM N
  7.006  8903         7.0mV                        1kH               AL N
  7.007  MEMC         0H             +0U -7U

  8.001  HEAD         -2 Carrier Frequency: 1000 MHz
  8.002  TSET         TDESC = 1000 MHz Carrier
  8.003  SCPI         FREQ:CW 1000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  8.004  TARGET       -m
  8.005  8902         0.007kH                      1000MH            FM N
  8.006  8903         7.0mV                        1kH               AL N
  8.007  MEMC         0H             +0U -7U

# 11793A Downconverter required for the following tests.

  9.001  HEAD         -2 Carrier Frequency: 1500 MHz
  9.002  TSET         TDESC = 1500 MHz Carrier
  9.003  MATH         @LO_Freq = "1620.53MHz"; @LO_Ampl = "+8dBm"
  9.004  TARGET       -p
  9.005  SCPI         FREQ:CW 1500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  9.006  CALL         Sub Apply /LO
  9.007  M8902        1620.53MH      27.3SP                       H0 L0
  9.008  M8902        1kH                                         H1 L2    P+
  9.009  TARGET       -m
  9.010  8902         0.014kH                      1500MH            FM N
  9.011  8903         14.0mV                       1kH               AL N
  9.012  MEMC         0H             +0U -14U

# The following tests apply to 8648C/D models only.
 10.001  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
 10.002  HEAD         -2 Carrier Frequency: 2500 MHz
 10.003  TSET         TDESC = 2500 MHz Carrier
 10.004  MATH         @LO_Freq = "2620.53MHz"; @LO_Ampl = "+8dBm"
 10.005  TARGET       -p
 10.006  SCPI         FREQ:CW 2500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 10.007  CALL         Sub Apply /LO
 10.008  M8902        2620.53MH      27.3SP                       H0 L0
 10.009  M8902        1kH                                         H1 L2    P+
 10.010  TARGET       -m
 10.011  8902         0.028kH                      2500MH            FM N
 10.012  8903         28.0mV                       1kH               AL N
 10.013  MEMC         0H             +0U -28U
 11.001  ENDIF

# The following tests apply to 8648D models only.
 11.002  IF           ZCMPI(@ModelNum, "8648D")
 11.003  HEAD         -2 Carrier Frequency: 2750 MHz
 11.004  TSET         TDESC = 2750 MHz Carrier
 11.005  MATH         @LO_Freq = "2870.53MHz"; @LO_Ampl = "+8dBm"
 11.006  TARGET       -p
 11.007  SCPI         FREQ:CW 2750 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 11.008  CALL         Sub Apply /LO
 11.009  M8902        2870.53MH      27.3SP                       H0 L0
 11.010  M8902        1kH                                         H1 L2    P+
 11.011  TARGET       -m
 11.012  8902         0.028kH                      2750MH            FM N
 11.013  8903         28.0mV                       1kH               AL N
 11.014  MEMC         0H             +0U -28U

 12.001  HEAD         -2 Carrier Frequency: 3000 MHz
 12.002  TSET         TDESC = 3000 MHz Carrier
 12.003  MATH         @LO_Freq = "3120.53MHz"; @LO_Ampl = "+8dBm"
 12.004  TARGET       -p
 12.005  SCPI         FREQ:CW 3000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 12.006  CALL         Sub Apply /LO
 12.007  M8902        3120.53MH      27.3SP                       H0 L0
 12.008  M8902        1kH                                         H1 L2    P+
 12.009  TARGET       -m
 12.010  8902         0.028kH                      3000MH            FM N
 12.011  8903         28.0mV                       1kH               AL N
 12.012  MEMC         0H             +0U -28U

 13.001  HEAD         -2 Carrier Frequency: 3200 MHz
 13.002  TSET         TDESC = 3200 MHz Carrier
 13.003  MATH         @LO_Freq = "3320.53MHz"; @LO_Ampl = "+8dBm"
 13.004  TARGET       -p
 13.005  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 13.006  CALL         Sub Apply /LO
 13.007  M8902        3320.53MH      27.3SP                       H0 L0
 13.008  M8902        1kH                                         H1 L2    P+
 13.009  TARGET       -m
 13.010  8902         0.028kH                      3200MH            FM N
 13.011  8903         28.0mV                       1kH               AL N
 13.012  MEMC         0H             +0U -28U

 14.001  HEAD         -2 Carrier Frequency: 3450 MHz
 14.002  TSET         TDESC = 3450 MHz Carrier
 14.003  MATH         @LO_Freq = "3570.53MHz"; @LO_Ampl = "+8dBm"
 14.004  TARGET       -p
 14.005  SCPI         FREQ:CW 3450 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 14.006  CALL         Sub Apply /LO
 14.007  M8902        3570.53MH      27.3SP                       H0 L0
 14.008  M8902        1kH                                         H1 L2    P+
 14.009  TARGET       -m
 14.010  8902         0.028kH                      3450MH            FM N
 14.011  8903         28.0mV                       1kH               AL N
 14.012  MEMC         0H             +0U -28U

 15.001  HEAD         -2 Carrier Frequency: 3700 MHz
 15.002  TSET         TDESC = 3700 MHz Carrier
 15.003  MATH         @LO_Freq = "3820.53MHz"; @LO_Ampl = "+8dBm"
 15.004  TARGET       -p
 15.005  SCPI         FREQ:CW 3700 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 15.006  CALL         Sub Apply /LO
 15.007  M8902        3820.53MH      27.3SP                       H0 L0
 15.008  M8902        1kH                                         H1 L2    P+
 15.009  TARGET       -m
 15.010  8902         0.028kH                      3700MH            FM N
 15.011  8903         28.0mV                       1kH               AL N
 15.012  MEMC         0H             +0U -28U
 16.001  ENDIF

 16.002  HEAD         -2
 16.003  HEAD
 16.004  SCPI         *RST
 16.005  CALL         Sub Reset /LO
 16.006  M8902        *
 16.007  8902         *                                                 S
 16.008  M8903        *
 16.009  8903         *                                                 S
 16.010  END
