﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) FM Accy VER /8902S,LO
INSTRUMENT:            Sub 8648B/C/D (2 yr) FM Dist VER /8902S,LO
DATE:                  2016-06-28 07:42:46
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       54
NUMBER OF LINES:       655
CONFIGURATION:         HP 8902A
CONFIGURATION:         Local Oscillator
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        HP/Agilent 11792A Sensor Module
#        HP/Agilent 11793A Microwave Converter
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LO]
  1.003  ENDIF

  1.004  CALL         Sub Initialize /LO
  1.005  CALL         Sub Reset /LO

  1.006  JMPL         FM_ACCURACY                  PSUBI("FM Accy")
  1.007  JMPL         FM_DISTORTION                PSUBI("FM Dist")
  1.008  DISP         Subprocedure not found!
  1.009  END

  1.010  EVAL   Increment step number

# =====  Sub 8648B/C/D (2 yr) FM Accy VER /8902S,LO  =========================

  2.001  LABEL        FM_ACCURACY
  2.002  RSLT         =
  2.003  HEAD         {FM ACCURACY PERFORMANCE}
  2.004  RSLT         =Modulation Source: INT 1 kHz
  2.005  RSLT         =
  2.006  HEAD         -2{Carrier Frequency: 0.25 MHz}
  2.007  TARGET       -p
  2.008  TSET         TDESC = 5 kHz Deviation
  2.009  SCPI         FREQ:CW .25 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
  2.010  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  2.011  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  2.012  M8902        1kH                                         H2 L2    P+
  2.013  TARGET       -m
  2.014  8902         5.000kH        0.180U        0.25MH            FM

  3.001  TSET         TDESC = 10 kHz Deviation
  3.002  SCPI         FREQ:CW .25 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
  3.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  3.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  3.005  TARGET       -m
  3.006  8902         10.000kH       0.330U        0.25MH            FM

  4.001  RSLT         =
  4.002  HEAD         -2{Carrier Frequency: 100 MHz}
  4.003  TARGET       -p
  4.004  TSET         TDESC = 5 kHz Deviation
  4.005  SCPI         FREQ:CW 100 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
  4.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  4.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  4.008  TARGET       -m
  4.009  8902         5.000kH        0.180U        100MH             FM

  5.001  TSET         TDESC = 10 kHz Deviation
  5.002  SCPI         FREQ:CW 100 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
  5.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  5.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  5.005  TARGET       -m
  5.006  8902         10.000kH       0.330U        100MH             FM

  6.001  RSLT         =
  6.002  HEAD         -2{Carrier Frequency: 250 MHz}
  6.003  TARGET       -p
  6.004  TSET         TDESC = 5 kHz Deviation
  6.005  SCPI         FREQ:CW 250 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
  6.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  6.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  6.008  TARGET       -m
  6.009  8902         5.000kH        0.180U        250MH             FM

  7.001  TSET         TDESC = 10 kHz Deviation
  7.002  SCPI         FREQ:CW 250 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
  7.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  7.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  7.005  TARGET       -m
  7.006  8902         10.000kH       0.330U        250MH             FM

  8.001  RSLT         =
  8.002  HEAD         -2{Carrier Frequency: 375 MHz}
  8.003  TARGET       -p
  8.004  TSET         TDESC = 5 kHz Deviation
  8.005  SCPI         FREQ:CW 375 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
  8.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  8.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  8.008  TARGET       -m
  8.009  8902         5.000kH        0.180U        375MH             FM

  9.001  TSET         TDESC = 10 kHz Deviation
  9.002  SCPI         FREQ:CW 375 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
  9.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
  9.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  9.005  TARGET       -m
  9.006  8902         10.000kH       0.330U        375MH             FM

 10.001  RSLT         =
 10.002  HEAD         -2{Carrier Frequency: 500 MHz}
 10.003  TARGET       -p
 10.004  TSET         TDESC = 5 kHz Deviation
 10.005  SCPI         FREQ:CW 500 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 10.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 10.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 10.008  TARGET       -m
 10.009  8902         5.000kH        0.180U        500MH             FM

 11.001  TSET         TDESC = 10 kHz Deviation
 11.002  SCPI         FREQ:CW 500 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 11.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 11.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 11.005  TARGET       -m
 11.006  8902         10.000kH       0.330U        500MH             FM

 12.001  RSLT         =
 12.002  HEAD         -2{Carrier Frequency: 756.25 MHz}
 12.003  TARGET       -p
 12.004  TSET         TDESC = 5 kHz Deviation
 12.005  SCPI         FREQ:CW 756.25 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 12.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 12.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 12.008  TARGET       -m
 12.009  8902         5.000kH        0.180U        756.25MH          FM

 13.001  TSET         TDESC = 10 kHz Deviation
 13.002  SCPI         FREQ:CW 756.25 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 13.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 13.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 13.005  TARGET       -m
 13.006  8902         10.000kH       0.330U        756.25MH          FM

 14.001  RSLT         =
 14.002  HEAD         -2{Carrier Frequency: 1000 MHz}
 14.003  TARGET       -p
 14.004  TSET         TDESC = 5 kHz Deviation
 14.005  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 14.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 14.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 14.008  TARGET       -m
 14.009  8902         5.000kH        0.180U        1000MH            FM

 15.001  TSET         TDESC = 10 kHz Deviation
 15.002  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 15.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 15.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 15.005  TARGET       -m
 15.006  8902         10.000kH       0.330U        1000MH            FM

# 11793A Downconverter required for the following tests.
 16.001  RSLT         =
 16.002  HEAD         -2{Carrier Frequency: 1500 MHz}
 16.003  MATH         @LO_Freq = "1620.53MHz"; @LO_Ampl = "+8dBm"
 16.004  TARGET       -p
 16.005  TSET         TDESC = 5 kHz Deviation
 16.006  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 16.007  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 16.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
# Set LO output to required frequency (1620.53 MHz) and level (+8 dBm).
 16.009  CALL         Sub Apply /LO
 16.010  M8902        1620.53MH      27.3SP                       H0 L0
 16.011  M8902        1kH                                         H2 L2    P+
 16.012  TARGET       -m
 16.013  8902         5.000kH        0.210U        1500MH            FM

 17.001  TSET         TDESC = 10 kHz Deviation
 17.002  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 17.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 17.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 17.005  CALL         Sub Apply /LO
 17.006  M8902        1620.53MH      27.3SP                       H0 L0
 17.007  M8902        1kH                                         H2 L2    P+
 17.008  TARGET       -m
 17.009  8902         10.000kH       0.360U        1500MH            FM

 18.001  RSLT         =
 18.002  HEAD         -2{Carrier Frequency: 2000 MHz}
 18.003  MATH         @LO_Freq = "2120.53MHz"; @LO_Ampl = "+8dBm"
 18.004  TARGET       -p
 18.005  TSET         TDESC = 5 kHz Deviation
 18.006  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 18.007  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 18.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 18.009  CALL         Sub Apply /LO
 18.010  M8902        2120.53MH      27.3SP                       H0 L0
 18.011  M8902        1kH                                         H2 L2    P+
 18.012  TARGET       -m
 18.013  8902         5.000kH        0.210U        2000MH            FM

 19.001  TSET         TDESC = 10 kHz Deviation
 19.002  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 19.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 19.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 19.005  CALL         Sub Apply /LO
 19.006  M8902        2120.53MH      27.3SP                       H0 L0
 19.007  M8902        1kH                                         H2 L2    P+
 19.008  TARGET       -m
 19.009  8902         10.000kH       0.360U        2000MH            FM

# The following tests apply to all EXCEPT 8648B (8648C/D) models.
 20.001  IF           NOT(ZCMPI(@ModelNum, "8648B"))
 20.002  RSLT         =
 20.003  HEAD         -2 ({Carrier Frequency: 2500 MHz}
 20.004  MATH         @LO_Freq = "2620.53MHz"; @LO_Ampl = "+8dBm"
 20.005  TARGET       -p
 20.006  TSET         TDESC = 5 kHz Deviation
 20.007  SCPI         FREQ:CW 2500 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 20.008  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 20.009  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 20.010  CALL         Sub Apply /LO
 20.011  M8902        2620.53MH      27.3SP                       H0 L0
 20.012  M8902        1kH                                         H2 L2    P+
 20.013  TARGET       -m
 20.014  8902         5.000kH        0.270U        2500MH            FM

 21.001  TSET         TDESC = 10 kHz Deviation
 21.002  SCPI         FREQ:CW 2500 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 21.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 21.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 21.005  CALL         Sub Apply /LO
 21.006  M8902        2620.53MH      27.3SP                       H0 L0
 21.007  M8902        1kH                                         H2 L2    P+
 21.008  TARGET       -m
 21.009  8902         10.000kH       0.420U        2500MH            FM

 22.001  RSLT         =
 22.002  HEAD         -2{Carrier Frequency: 3200 MHz}
 22.003  MATH         @LO_Freq = "3320.53MHz"; @LO_Ampl = "+8dBm"
 22.004  TARGET       -p
 22.005  TSET         TDESC = 5 kHz Deviation
 22.006  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 22.007  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 22.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 22.009  CALL         Sub Apply /LO
 22.010  M8902        3320.53MH      27.3SP                       H0 L0
 22.011  M8902        1kH                                         H2 L2    P+
 22.012  TARGET       -m
 22.013  8902         5.000kH        0.270U        3200MH            FM

 23.001  TSET         TDESC = 10 kHz Deviation
 23.002  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 23.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 23.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 23.005  CALL         Sub Apply /LO
 23.006  M8902        3320.53MH      27.3SP                       H0 L0
 23.007  M8902        1kH                                         H2 L2    P+
 23.008  TARGET       -m
 23.009  8902         10.000kH       0.420U        3200MH            FM
 24.001  ENDIF

# The following tests apply to 8648D models only.
 24.002  IF           ZCMPI(@ModelNum, "8648D")
 24.003  RSLT         =
 24.004  HEAD         -2{Carrier Frequency: 3800 MHz}
 24.005  MATH         @LO_Freq = "3920.53MHz"; @LO_Ampl = "+8dBm"
 24.006  TARGET       -p
 24.007  TSET         TDESC = 5 kHz Deviation
 24.008  SCPI         FREQ:CW 3800 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 24.009  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 24.010  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 24.011  CALL         Sub Apply /LO
 24.012  M8902        3920.53MH      27.3SP                       H0 L0
 24.013  M8902        1kH                                         H2 L2    P+
 24.014  TARGET       -m
 24.015  8902         5.000kH        0.270U        3800MH            FM

 25.001  TSET         TDESC = 10 kHz Deviation
 25.002  SCPI         FREQ:CW 3800 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 25.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 25.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 25.005  CALL         Sub Apply /LO
 25.006  M8902        3920.53MH      27.3SP                       H0 L0
 25.007  M8902        1kH                                         H2 L2    P+
 25.008  TARGET       -m
 25.009  8902         10.000kH       0.420U        3800MH            FM
 26.001  ENDIF

 26.002  HEAD         -2
 26.003  HEAD
 26.004  SCPI         *RST
 26.005  CALL         Sub Reset /LO
 26.006  M8902        *
 26.007  8902         *                                                 S
 26.008  END

 26.009  EVAL   Increment Test Number

# =====  Sub 8648B/C/D (2 yr) FM Dist VER /8902S,LO  =========================

 27.001  LABEL        FM_DISTORTION
 27.002  RSLT         =
 27.003  HEAD         {FM DISTORTION PERFORMANCE}
 27.004  RSLT         =Modulation Source: INT 1 kHz
 27.005  RSLT         =
 27.006  HEAD         -2{Carrier Frequency: 10 MHz}
 27.007  TARGET       -p
 27.008  TSET         TDESC = 5 kHz Deviation
 27.009  SCPI         FREQ:CW 10 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 27.010  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 27.011  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
# Initially setup 8902A mod frequency, high and low pass filters, detector.
 27.012  M8902        1kH                                         H2 L2    P+
# Take an FM (deviation) measurement
 27.013  8902         5.000kH                      10MH              FM N
# Now setup 8902A for high and low pass filters, mod frequency, FM distortion.
 27.014  M8902                                                    H2 L2    D5
 27.015  TARGET       -m
# Take audio distortion measurement.
 27.016  8902         0.01pct        1.00U         1kH               AD

 28.001  TSET         TDESC = 50 kHz Deviation
 28.002  SCPI         FREQ:CW 10 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 28.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 28.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 28.005  M8902        1kH                                         H2 L2    P+
 28.006  8902         50.00kH                      10MH              FM N
 28.007  M8902                                                    H2 L2    D5
 28.008  TARGET       -m
 28.009  8902         0.01pct        1.00U         1kH               AD

 29.001  TSET         TDESC = 100 kHz Deviation
 29.002  SCPI         FREQ:CW 10 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 29.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 29.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 29.005  M8902        1kH                                         H2 L2    P+
 29.006  8902         100.0kH                      10MH              FM N
 29.007  M8902                                                    H2 L2    D5
 29.008  TARGET       -m
 29.009  8902         0.01pct        1.00U         1kH               AD

 30.001  RSLT         =
 30.002  HEAD         -2{Carrier Frequency: 100 MHz}
 30.003  TARGET       -p
 30.004  TSET         TDESC = 5 kHz Deviation
 30.005  SCPI         FREQ:CW 100 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 30.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 30.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 30.008  M8902        1kH                                         H2 L2    P+
 30.009  8902         5.000kH                      100MH             FM N
 30.010  M8902                                                    H2 L2    D5
 30.011  TARGET       -m
 30.012  8902         0.01pct        1.00U         1kH               AD

 31.001  TSET         TDESC = 50 kHz Deviation
 31.002  SCPI         FREQ:CW 100 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 31.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 31.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 31.005  M8902        1kH                                         H2 L2    P+
 31.006  8902         50.00kH                      100MH             FM N
 31.007  M8902                                                    H2 L2    D5
 31.008  TARGET       -m
 31.009  8902         0.01pct        1.00U         1kH               AD

 32.001  TSET         TDESC = 100 kHz Deviation
 32.002  SCPI         FREQ:CW 100 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 32.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 32.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 32.005  M8902        1kH                                         H2 L2    P+
 32.006  8902         100.0kH                      100MH             FM N
 32.007  M8902                                                    H2 L2    D5
 32.008  TARGET       -m
 32.009  8902         0.01pct        1.00U         1kH               AD

 33.001  RSLT         =
 33.002  HEAD         -2{Carrier Frequency: 400 MHz}
 33.003  TARGET       -p
 33.004  TSET         TDESC = 5 kHz Deviation
 33.005  SCPI         FREQ:CW 400 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 33.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 33.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 33.008  M8902        1kH                                         H2 L2    P+
 33.009  8902         5.000kH                      400MH             FM N
 33.010  M8902                                                    H2 L2    D5
 33.011  TARGET       -m
 33.012  8902         0.01pct        1.00U         1kH               AD

 34.001  TSET         TDESC = 30 kHz Deviation
 34.002  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 34.003  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 34.004  M8902        1kH                                         H2 L2    P+
 34.005  8902         30.00kH                      400MH             FM N
 34.006  M8902                                                    H2 L2    D5
 34.007  TARGET       -m
 34.008  8902         0.01pct        1.00U         1kH               AD

 35.001  TSET         TDESC = 50 kHz Deviation
 35.002  SCPI         FREQ:CW 400 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 35.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 35.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 35.005  M8902        1kH                                         H2 L2    P+
 35.006  8902         50.00kH                      400MH             FM N
 35.007  M8902                                                    H2 L2    D5
 35.008  TARGET       -m
 35.009  8902         0.01pct        1.00U         1kH               AD

 36.001  RSLT         =
 36.002  HEAD         {Carrier Frequency: 756.25 MHz}
 36.003  TARGET       -p
 36.004  TSET         TDESC = 5 kHz Deviation
 36.005  SCPI         FREQ:CW 756.25 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 36.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 36.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 36.008  M8902        1kH                                         H2 L2    P+
 36.009  8902         5.000kH                      756.25MH          FM N
 36.010  M8902                                                    H2 L2    D5
 36.011  TARGET       -m
 36.012  8902         0.01pct        1.00U         1kH               AD

 37.001  TSET         TDESC = 50 kHz Deviation
 37.002  SCPI         FREQ:CW 756.25 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 37.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 37.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 37.005  M8902        1kH                                         H2 L2    P+
 37.006  8902         50.00kH                      756.25MH          FM N
 37.007  M8902                                                    H2 L2    D5
 37.008  TARGET       -m
 37.009  8902         0.01pct        1.00U         1kH               AD

 38.001  TSET         TDESC = 100 kHz Deviation
 38.002  SCPI         FREQ:CW 756.25 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 38.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 38.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 38.005  M8902        1kH                                         H2 L2    P+
 38.006  8902         100.0kH                      756.25MH          FM N
 38.007  M8902                                                    H2 L2    D5
 38.008  TARGET       -m
 38.009  8902         0.01pct        1.00U         1kH               AD

 39.001  RSLT         =
 39.002  HEAD         {Carrier Frequency: 1000 MHz}
 39.003  TARGET       -p
 39.004  TSET         TDESC = 5 kHz Deviation
 39.005  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 5 KHZ;:FM:SOUR INT
 39.006  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 39.007  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 39.008  M8902        1kH                                         H2 L2    P+
 39.009  8902         5.000kH                      1000MH            FM N
 39.010  M8902                                                    H2 L2    D5
 39.011  TARGET       -m
 39.012  8902         0.01pct        1.00U         1kH               AD

 40.001  TSET         TDESC = 50 kHz Deviation
 40.002  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 40.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 40.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 40.005  M8902        1kH                                         H2 L2    P+
 40.006  8902         50.00kH                      1000MH            FM N
 40.007  M8902                                                    H2 L2    D5
 40.008  TARGET       -m
 40.009  8902         0.01pct        1.00U         1kH               AD

 41.001  TSET         TDESC = 100 kHz Deviation
 41.002  SCPI         FREQ:CW 1000 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 41.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 41.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 41.005  M8902        1kH                                         H2 L2    P+
 41.006  8902         100.0kH                      1000MH            FM N
 41.007  M8902                                                    H2 L2    D5
 41.008  TARGET       -m
 41.009  8902         0.01pct        1.00U         1kH               AD

# 11793A Downconverter required for the following tests.

 42.001  RSLT         =
 42.002  HEAD         {Carrier Frequency: 1500 MHz}
 42.003  MATH         @LO_Freq = "1620.53MHz"; @LO_Ampl = "+8dBm"
 42.004  TARGET       -p
 42.005  TSET         TDESC = 10 kHz Deviation
 42.006  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 42.007  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 42.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 42.009  CALL         Sub Apply /LO
 42.010  M8902        1620.53MH      27.3SP                       H0 L0
 42.011  M8902        1kH                                         H2 L2    P+
 42.012  8902         10.00kH                      1500MH            FM N
 42.013  M8902                                                    H2 L2    D5
 42.014  TARGET       -m
 42.015  8902         0.01pct        1.00U         1kH               AD

 43.001  TSET         TDESC = 50 kHz Deviation
 43.002  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 43.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 43.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 43.005  CALL         Sub Apply /LO
 43.006  M8902        1620.53MH      27.3SP                       H0 L0
 43.007  M8902        1kH                                         H2 L2    P+
 43.008  8902         50.00kH                      1500MH            FM N
 43.009  M8902                                                    H2 L2    D5
 43.010  TARGET       -m
 43.011  8902         0.01pct        1.00U         1kH               AD

 44.001  TSET         TDESC = 100 kHz Deviation
 44.002  SCPI         FREQ:CW 1500 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 44.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 44.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 44.005  CALL         Sub Apply /LO
 44.006  M8902        1620.53MH      27.3SP                       H0 L0
 44.007  M8902        1kH                                         H2 L2    P+
 44.008  8902         100.0kH                      1500MH            FM N
 44.009  M8902                                                    H2 L2    D5
 44.010  TARGET       -m
 44.011  8902         0.01pct        1.00U         1kH               AD

 45.001  RSLT         =
 45.002  HEAD         -2{Carrier Frequency: 2000 MHz}
 45.003  MATH         @LO_Freq = "2120.53MHz"; @LO_Ampl = "+8dBm"
 45.004  TARGET       -p
 45.005  TSET         TDESC = 10 kHz Deviation
 45.006  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 10 KHZ;:FM:SOUR INT
 45.007  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 45.008  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 45.009  CALL         Sub Apply /LO
 45.010  M8902        2120.53MH      27.3SP                       H0 L0
 45.011  M8902        1kH                                         H2 L2    P+
 45.012  8902         10.00kH                      2000MH            FM N
 45.013  M8902                                                    H2 L2    D5
 45.014  TARGET       -m
 45.015  8902         0.01pct        1.00U         1kH               AD

 46.001  TSET         TDESC = 50 kHz Deviation
 46.002  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 46.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 46.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 46.005  CALL         Sub Apply /LO
 46.006  M8902        2120.53MH      27.3SP                       H0 L0
 46.007  M8902        1kH                                         H2 L2    P+
 46.008  8902         50.00kH                      2000MH            FM N
 46.009  M8902                                                    H2 L2    D5
 46.010  TARGET       -m
 46.011  8902         0.01pct        1.00U         1kH               AD

 47.001  TSET         TDESC = 100 kHz Deviation
 47.002  SCPI         FREQ:CW 2000 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 47.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 47.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 47.005  CALL         Sub Apply /LO
 47.006  M8902        2120.53MH      27.3SP                       H0 L0
 47.007  M8902        1kH                                         H2 L2    P+
 47.008  8902         100.0kH                      2000MH            FM N
 47.009  M8902                                                    H2 L2    D5
 47.010  TARGET       -m
 47.011  8902         0.01pct        1.00U         1kH               AD

# The following tests apply to 8648C/D models only.
 48.001  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
 48.002  RSLT         =
 48.003  HEAD         -2{Carrier Frequency: 3200 MHz}
 48.004  MATH         @LO_Freq = "3320.53MHz"; @LO_Ampl = "+8dBm"
 48.005  TARGET       -p
 48.006  TSET         TDESC = 20 kHz Deviation
 48.007  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 20 KHZ;:FM:SOUR INT
 48.008  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 48.009  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 48.010  CALL         Sub Apply /LO
 48.011  M8902        3320.53MH      27.3SP                       H0 L0
 48.012  M8902        1kH                                         H2 L2    P+
 48.013  8902         20.00kH                      3200MH            FM N
 48.014  M8902                                                    H2 L2    D5
 48.015  TARGET       -m
 48.016  8902         0.01pct        1.00U         1kH               AD

 49.001  TSET         TDESC = 50 kHz Deviation
 49.002  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 49.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 49.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 49.005  CALL         Sub Apply /LO
 49.006  M8902        3320.53MH      27.3SP                       H0 L0
 49.007  M8902        1kH                                         H2 L2    P+
 49.008  8902         50.00kH                      3200MH            FM N
 49.009  M8902                                                    H2 L2    D5
 49.010  TARGET       -m
 49.011  8902         0.01pct        1.00U         1kH               AD

 50.001  TSET         TDESC = 100 kHz Deviation
 50.002  SCPI         FREQ:CW 3200 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 50.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 50.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 50.005  CALL         Sub Apply /LO
 50.006  M8902        3320.53MH      27.3SP                       H0 L0
 50.007  M8902        1kH                                         H2 L2    P+
 50.008  8902         100.0kH                      3200MH            FM N
 50.009  M8902                                                    H2 L2    D5
 50.010  TARGET       -m
 50.011  8902         0.01pct        1.00U         1kH               AD
 51.001  ENDIF

# The following tests apply to 8648D models only.
 51.002  IF           ZCMPI(@ModelNum, "8648D")
 51.003  RSLT         =
 51.004  HEAD         -2{Carrier Frequency: 3800 MHz}
 51.005  MATH         @LO_Freq = "3920.53MHz"; @LO_Ampl = "+8dBm"
 51.006  TARGET       -p
 51.007  TSET         TDESC = 20 kHz Deviation
 51.008  SCPI         FREQ:CW 3800 MHZ;:FM:DEV 20 KHZ;:FM:SOUR INT
 51.009  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 51.010  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 51.011  CALL         Sub Apply /LO
 51.012  M8902        3920.53MH      27.3SP                       H0 L0
 51.013  M8902        1kH                                         H2 L2    P+
 51.014  8902         20.00kH                      3800MH            FM N
 51.015  M8902                                                    H2 L2    D5
 51.016  TARGET       -m
 51.017  8902         0.01pct        1.00U         1kH               AD

 52.001  TSET         TDESC = 50 kHz Deviation
 52.002  SCPI         FREQ:CW 3800 MHZ;:FM:DEV 50 KHZ;:FM:SOUR INT
 52.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 52.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 52.005  CALL         Sub Apply /LO
 52.006  M8902        3920.53MH      27.3SP                       H0 L0
 52.007  M8902        1kH                                         H2 L2    P+
 52.008  8902         50.00kH                      3800MH            FM N
 52.009  M8902                                                    H2 L2    D5
 52.010  TARGET       -m
 52.011  8902         0.01pct        1.00U         1kH               AD

 53.001  TSET         TDESC = 100 kHz Deviation
 53.002  SCPI         FREQ:CW 3800 MHZ;:FM:DEV 100 KHZ;:FM:SOUR INT
 53.003  SCPI         FM:INT:FREQ 1 KHZ;:FM:STAT ON
 53.004  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 53.005  CALL         Sub Apply /LO
 53.006  M8902        3920.53MH      27.3SP                       H0 L0
 53.007  M8902        1kH                                         H2 L2    P+
 53.008  8902         100.0kH                      3800MH            FM N
 53.009  M8902                                                    H2 L2    D5
 53.010  TARGET       -m
 53.011  8902         0.01pct        1.00U         1kH               AD
 54.001  ENDIF

 54.002  HEAD         -2
 54.003  HEAD
 54.004  SCPI         *RST
 54.005  CALL         Sub Reset /LO
 54.006  M8902        *
 54.007  8902         *                                                 S
 54.008  END
