﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) Harmonics VER /8560
INSTRUMENT:            Sub 8648B/C/D (2 yr) Spurious VER /8560
DATE:                  2016-06-28 07:42:37
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       51
NUMBER OF LINES:       975
CONFIGURATION:         HP 8560
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         HARMONICS                    PSUBI("Harmonics")
  1.002  JMPL         SPURIOUS                     PSUBI("Spurious")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment step number

# =====  Sub 8648B/C/D (2 yr) Harmonics VER /8560  ==========================

  2.001  LABEL        HARMONICS
  2.002  RSLT         =
  2.003  HEAD         {HARMONICS PERFORMANCE}
  2.004  TARGET       -p
  2.005  TSET         TDESC = 1 MHz, 2nd harmonic
# Set UUT output parameters.
  2.006  SCPI         FREQ:CW 1 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  2.007  M8560  ATTEN 20dB
# Set Span.
  2.008  M8560  SPAN  500kH
# Set Resolution Bandwidth.
  2.009  M8560  RESBW 10kH
# Set Video Bandwidth to 30 kHz, Reference Level to +10 dBm, 10 MHz EXT REF.
  2.010  M8560  VIDBW 30kH                         10D                  X
# Measure amplitude of fundamental (1 MHz).
  2.011  8560         4D                           1MH                  N
# Store fundamental reference level in L[1].
  2.012  MATH         L[1] = MEM
# Retrieve confidence interval for HP 856x spectrum analyzer.
  2.013  MATH         L[2] = CONF("HP 8560")
# Specify correct 856x frequency response mode string for unit being used.
  2.014  CALL         Sub Specify HP856X Frequency Response
  2.015  JMPL         END                          @Abort
# Retrieve uncertainty for above measurement and normalize.
  2.016  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1E+6) / L[2]
  2.017  TARGET       -m
# Measure amplitude of 2nd harmonic (2 MHz).
  2.018  8560         -26D                         2MH                  N
# Compute harmonic level (dBc).
  2.019  MATH         MEM = MEM - L[1]
# Specify correct 856x scale fidelity mode string for unit being used.
  2.020  CALL         Sub Specify HP856X Log Scale Fidelity
  2.021  JMPL         END                          @Abort
# Retrieve scale fidelity uncertainty for above measurements and normalize.
  2.022  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2E+6) / L[2]
# RSS all individual measurement uncertainty components and expand.
  2.023  MATH         L[6] = RSS_L(3, 5) * 2
# Computed expanded uncertainty shown in ACC.
  2.024  ACC          -30.0dBc       L6U
  2.025  MEMC         -30.0dBc       -0.0U +100.0U 2MH

  3.001  TSET         TDESC = 2 MHz, 2nd harmonic
  3.002  SCPI         FREQ:CW 2 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  3.003  8560         4D                           2MH                  N
  3.004  MATH         L[1] = MEM
  3.005  CALL         Sub Specify HP856X Frequency Response
  3.006  JMPL         END                          @Abort
  3.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 2E+6) / L[2]
  3.008  TARGET       -m
  3.009  8560         -26D                         4MH                  N
  3.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 4E+6) / L[2]
  3.011  MATH         MEM = MEM - L[1]
  3.012  CALL         Sub Specify HP856X Log Scale Fidelity
  3.013  JMPL         END                          @Abort
  3.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 4E+6) / L[2]
  3.015  MATH         L[6] = RSS_L(3, 5) * 2
  3.016  ACC          -30.0dBc       L6U
  3.017  MEMC         -30.0dBc       -0.0U +100.0U 4MH

  4.001  TSET         TDESC = 5 MHz, 2nd harmonic
  4.002  SCPI         FREQ:CW 5 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  4.003  8560         4D                           5MH                  N
  4.004  MATH         L[1] = MEM
  4.005  CALL         Sub Specify HP856X Frequency Response
  4.006  JMPL         END                          @Abort
  4.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 5E+6) / L[2]
  4.008  TARGET       -m
  4.009  8560         -26D                         10MH                 N
  4.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 10E+6) / L[2]
  4.011  MATH         MEM = MEM - L[1]
  4.012  CALL         Sub Specify HP856X Log Scale Fidelity
  4.013  JMPL         END                          @Abort
  4.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 10E+6) / L[2]
  4.015  MATH         L[6] = RSS_L(3, 5) * 2
  4.016  ACC          -30.0dBc       L6U
  4.017  MEMC         -30.0dBc       -0.0U +100.0U 10MH

  5.001  TSET         TDESC = 10 MHz, 2nd harmonic
  5.002  SCPI         FREQ:CW 10 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  5.003  8560         4D                           10MH                 N
  5.004  MATH         L[1] = MEM
  5.005  TARGET       -m
  5.006  8560         -26D                         20MH                 N
  5.007  MATH         MEM = MEM - L[1]
  5.008  ACC          -30.0dBc       1.2U
  5.009  MEMC         -30.0dBc       -0.0U +100.0U 20MH

  6.001  TSET         TDESC = 20 MHz, 2nd harmonic
  6.002  SCPI         FREQ:CW 20 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  6.003  8560         4D                           20MH                 N
  6.004  MATH         L[1] = MEM
  6.005  CALL         Sub Specify HP856X Frequency Response
  6.006  JMPL         END                          @Abort
  6.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 20E+6) / L[2]
  6.008  TARGET       -m
  6.009  8560         -26D                         40MH                 N
  6.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 40E+6) / L[2]
  6.011  MATH         MEM = MEM - L[1]
  6.012  CALL         Sub Specify HP856X Log Scale Fidelity
  6.013  JMPL         END                          @Abort
  6.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 40E+6) / L[2]
  6.015  MATH         L[6] = RSS_L(3, 5) * 2
  6.016  ACC          -30.0dBc       L6U
  6.017  MEMC         -30.0dBc       -0.0U +100.0U 40MH

  7.001  TSET         TDESC = 100 MHz, 2nd harmonic
  7.002  SCPI         FREQ:CW 100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  7.003  8560         4D                           100MH                N
  7.004  MATH         L[1] = MEM
  7.005  CALL         Sub Specify HP856X Frequency Response
  7.006  JMPL         END                          @Abort
  7.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 100E+6) / L[2]
  7.008  TARGET       -m
  7.009  8560         -26D                         200MH                N
  7.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 200E+6) / L[2]
  7.011  MATH         MEM = MEM - L[1]
  7.012  CALL         Sub Specify HP856X Log Scale Fidelity
  7.013  JMPL         END                          @Abort
  7.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 200E+6) / L[2]
  7.015  MATH         L[6] = RSS_L(3, 5) * 2
  7.016  ACC          -30.0dBc       L6U
  7.017  MEMC         -30.0dBc       -0.0U +100.0U 200MH

  8.001  TSET         TDESC = 100 MHz, 3rd harmonic
  8.002  SCPI         FREQ:CW 100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  8.003  8560         4D                           100MH                N
  8.004  MATH         L[1] = MEM
  8.005  CALL         Sub Specify HP856X Frequency Response
  8.006  JMPL         END                          @Abort
  8.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 100E+6) / L[2]
  8.008  TARGET       -m
  8.009  8560         -26D                         300MH                N
  8.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 300E+6) / L[2]
  8.011  MATH         MEM = MEM - L[1]
  8.012  CALL         Sub Specify HP856X Log Scale Fidelity
  8.013  JMPL         END                          @Abort
  8.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 300E+6) / L[2]
  8.015  MATH         L[6] = RSS_L(3, 5) * 2
  8.016  ACC          -30.0dBc       L6U
  8.017  MEMC         -30.0dBc       -0.0U +100.0U 300MH

  9.001  TSET         TDESC = 300 MHz, ½ harmonic
  9.002  SCPI         FREQ:CW 300 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  9.003  8560         4D                           300MH                N
  9.004  MATH         L[1] = MEM
  9.005  CALL         Sub Specify HP856X Frequency Response
  9.006  JMPL         END                          @Abort
  9.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 300E+6) / L[2]
  9.008  TARGET       -m
  9.009  8560         -26D                         150MH                N
  9.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
  9.011  MATH         MEM = MEM - L[1]
  9.012  CALL         Sub Specify HP856X Log Scale Fidelity
  9.013  JMPL         END                          @Abort
  9.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
  9.015  MATH         L[6] = RSS_L(3, 5) * 2
  9.016  ACC          -30.0dBc       L6U
  9.017  MEMC         -30.0dBc       -0.0U +100.0U 150MH

 10.001  TSET         TDESC = 500 MHz, 2nd harmonic
 10.002  SCPI         FREQ:CW 500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 10.003  8560         4D                           500MH                N
 10.004  MATH         L[1] = MEM
 10.005  CALL         Sub Specify HP856X Frequency Response
 10.006  JMPL         END                          @Abort
 10.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 500E+6) / L[2]
 10.008  TARGET       -m
 10.009  8560         -26D                         1000MH               N
 10.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 10.011  MATH         MEM = MEM - L[1]
 10.012  CALL         Sub Specify HP856X Log Scale Fidelity
 10.013  JMPL         END                          @Abort
 10.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 10.015  MATH         L[6] = RSS_L(3, 5) * 2
 10.016  ACC          -30.0dBc       L6U
 10.017  MEMC         -30.0dBc       -0.0U +100.0U 1000MH

 11.001  TSET         TDESC = 500 MHz, 3rd harmonic
 11.002  SCPI         FREQ:CW 500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 11.003  8560         4D                           500MH                N
 11.004  MATH         L[1] = MEM
 11.005  CALL         Sub Specify HP856X Frequency Response
 11.006  JMPL         END                          @Abort
 11.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 500E+6) / L[2]
 11.008  TARGET       -m
 11.009  8560         -26D                         1500MH               N
 11.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1500E+6) / L[2]
 11.011  MATH         MEM = MEM - L[1]
 11.012  CALL         Sub Specify HP856X Log Scale Fidelity
 11.013  JMPL         END                          @Abort
 11.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1500E+6) / L[2]
 11.015  MATH         L[6] = RSS_L(3, 5) * 2
 11.016  ACC          -30.0dBc       L6U
 11.017  MEMC         -30.0dBc       -0.0U +100.0U 1500MH

 12.001  TSET         TDESC = 600 MHz, 2nd harmonic
 12.002  SCPI         FREQ:CW 600 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 12.003  8560         4D                           600MH                N
 12.004  MATH         L[1] = MEM
 12.005  CALL         Sub Specify HP856X Frequency Response
 12.006  JMPL         END                          @Abort
 12.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 600E+6) / L[2]
 12.008  TARGET       -m
 12.009  8560         -26D                         1200MH               N
 12.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1200E+6) / L[2]
 12.011  MATH         MEM = MEM - L[1]
 12.012  CALL         Sub Specify HP856X Log Scale Fidelity
 12.013  JMPL         END                          @Abort
 12.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1200E+6) / L[2]
 12.015  MATH         L[6] = RSS_L(3, 5) * 2
 12.016  ACC          -30.0dBc       L6U
 12.017  MEMC         -30.0dBc       -0.0U +100.0U 1200MH

 13.001  TSET         TDESC = 600 MHz, 3rd harmonic
 13.002  SCPI         FREQ:CW 600 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 13.003  8560         4D                           600MH                N
 13.004  MATH         L[1] = MEM
 13.005  CALL         Sub Specify HP856X Frequency Response
 13.006  JMPL         END                          @Abort
 13.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 600E+6) / L[2]
 13.008  TARGET       -m
 13.009  8560         -26D                         1800MH               N
 13.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 13.011  MATH         MEM = MEM - L[1]
 13.012  CALL         Sub Specify HP856X Log Scale Fidelity
 13.013  JMPL         END                          @Abort
 13.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 13.015  MATH         L[6] = RSS_L(3, 5) * 2
 13.016  ACC          -30.0dBc       L6U
 13.017  MEMC         -30.0dBc       -0.0U +100.0U 1800MH

 14.001  TSET         TDESC = 700 MHz, 2nd harmonic
 14.002  SCPI         FREQ:CW 700 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 14.003  8560         4D                           700MH                N
 14.004  MATH         L[1] = MEM
 14.005  CALL         Sub Specify HP856X Frequency Response
 14.006  JMPL         END                          @Abort
 14.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 700E+6) / L[2]
 14.008  TARGET       -m
 14.009  8560         -26D                         1400MH               N
 14.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1400E+6) / L[2]
 14.011  MATH         MEM = MEM - L[1]
 14.012  CALL         Sub Specify HP856X Log Scale Fidelity
 14.013  JMPL         END                          @Abort
 14.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1400E+6) / L[2]
 14.015  MATH         L[6] = RSS_L(3, 5) * 2
 14.016  ACC          -30.0dBc       L6U
 14.017  MEMC         -30.0dBc       -0.0U +100.0U 1400MH

 15.001  TSET         TDESC = 700 MHz, 3rd harmonic
 15.002  SCPI         FREQ:CW 700 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 15.003  8560         4D                           700MH                N
 15.004  MATH         L[1] = MEM
 15.005  CALL         Sub Specify HP856X Frequency Response
 15.006  JMPL         END                          @Abort
 15.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 700E+6) / L[2]
 15.008  TARGET       -m
 15.009  8560         -26D                         2100MH               N
 15.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2100E+6) / L[2]
 15.011  MATH         MEM = MEM - L[1]
 15.012  CALL         Sub Specify HP856X Log Scale Fidelity
 15.013  JMPL         END                          @Abort
 15.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2100E+6) / L[2]
 15.015  MATH         L[6] = RSS_L(3, 5) * 2
 15.016  ACC          -30.0dBc       L6U
 15.017  MEMC         -30.0dBc       -0.0U +100.0U 2100MH

 16.001  TSET         TDESC = 800 MHz, 2nd harmonic
 16.002  SCPI         FREQ:CW 800 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 16.003  8560         4D                           800MH                N
 16.004  MATH         L[1] = MEM
 16.005  CALL         Sub Specify HP856X Frequency Response
 16.006  JMPL         END                          @Abort
 16.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 800E+6) / L[2]
 16.008  TARGET       -m
 16.009  8560         -26D                         1600MH               N
 16.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1600E+6) / L[2]
 16.011  MATH         MEM = MEM - L[1]
 16.012  CALL         Sub Specify HP856X Log Scale Fidelity
 16.013  JMPL         END                          @Abort
 16.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1600E+6) / L[2]
 16.015  MATH         L[6] = RSS_L(3, 5) * 2
 16.016  ACC          -30.0dBc       L6U
 16.017  MEMC         -30.0dBc       -0.0U +100.0U 1600MH

 17.001  TSET         TDESC = 800 MHz, 3rd harmonic
 17.002  SCPI         FREQ:CW 800 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 17.003  8560         4D                           800MH                N
 17.004  MATH         L[1] = MEM
 17.005  CALL         Sub Specify HP856X Frequency Response
 17.006  JMPL         END                          @Abort
 17.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 800E+6) / L[2]
 17.008  TARGET       -m
 17.009  8560         -26D                         2400MH               N
 17.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2400E+6) / L[2]
 17.011  MATH         MEM = MEM - L[1]
 17.012  CALL         Sub Specify HP856X Log Scale Fidelity
 17.013  JMPL         END                          @Abort
 17.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2400E+6) / L[2]
 17.015  MATH         L[6] = RSS_L(3, 5) * 2
 17.016  ACC          -30.0dBc       L6U
 17.017  MEMC         -30.0dBc       -0.0U +100.0U 2400MH

 18.001  TSET         TDESC = 900 MHz, 2nd harmonic
 18.002  SCPI         FREQ:CW 900 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 18.003  8560         4D                           900MH                N
 18.004  MATH         L[1] = MEM
 18.005  CALL         Sub Specify HP856X Frequency Response
 18.006  JMPL         END                          @Abort
 18.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 900E+6) / L[2]
 18.008  TARGET       -m
 18.009  8560         -26D                         1800MH               N
 18.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 18.011  MATH         MEM = MEM - L[1]
 18.012  CALL         Sub Specify HP856X Log Scale Fidelity
 18.013  JMPL         END                          @Abort
 18.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 18.015  MATH         L[6] = RSS_L(3, 5) * 2
 18.016  ACC          -30.0dBc       L6U
 18.017  MEMC         -30.0dBc       -0.0U +100.0U 1800MH

 19.001  TSET         TDESC = 1000 MHz, 2nd harmonic
 19.002  SCPI         FREQ:CW 1000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 19.003  8560         4D                           1000MH               N
 19.004  MATH         L[1] = MEM
 19.005  CALL         Sub Specify HP856X Frequency Response
 19.006  JMPL         END                          @Abort
 19.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 19.008  TARGET       -m
 19.009  8560         -26D                         2000MH               N
 19.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2000E+6) / L[2]
 19.011  MATH         MEM = MEM - L[1]
 19.012  CALL         Sub Specify HP856X Log Scale Fidelity
 19.013  JMPL         END                          @Abort
 19.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2000E+6) / L[2]
 19.015  MATH         L[6] = RSS_L(3, 5) * 2
 19.016  ACC          -30.0dBc       L6U
 19.017  MEMC         -30.0dBc       -0.0U +100.0U 2000MH

 20.001  TSET         TDESC = 1100 MHz, 2nd harmonic
 20.002  SCPI         FREQ:CW 1100 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 20.003  8560         4D                           1100MH               N
 20.004  MATH         L[1] = MEM
 20.005  CALL         Sub Specify HP856X Frequency Response
 20.006  JMPL         END                          @Abort
 20.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1100E+6) / L[2]
 20.008  TARGET       -m
 20.009  8560         -26D                         2200MH               N
 20.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2200E+6) / L[2]
 20.011  MATH         MEM = MEM - L[1]
 20.012  CALL         Sub Specify HP856X Log Scale Fidelity
 20.013  JMPL         END                          @Abort
 20.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2200E+6) / L[2]
 20.015  MATH         L[6] = RSS_L(3, 5) * 2
 20.016  ACC          -30.0dBc       L6U
 20.017  MEMC         -30.0dBc       -0.0U +100.0U 2200MH

 21.001  TSET         TDESC = 1200 MHz, 2nd harmonic
 21.002  SCPI         FREQ:CW 1200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 21.003  8560         4D                           1200MH               N
 21.004  MATH         L[1] = MEM
 21.005  CALL         Sub Specify HP856X Frequency Response
 21.006  JMPL         END                          @Abort
 21.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1200E+6) / L[2]
 21.008  TARGET       -m
 21.009  8560         -26D                         2400MH               N
 21.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2400E+6) / L[2]
 21.011  MATH         MEM = MEM - L[1]
 21.012  CALL         Sub Specify HP856X Log Scale Fidelity
 21.013  JMPL         END                          @Abort
 21.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2400E+6) / L[2]
 21.015  MATH         L[6] = RSS_L(3, 5) * 2
 21.016  ACC          -30.0dBc       L6U
 21.017  MEMC         -30.0dBc       -0.0U +100.0U 2400MH

 22.001  TSET         TDESC = 1500 MHz, 2nd harmonic
 22.002  SCPI         FREQ:CW 1500 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 22.003  8560         4D                           1500MH               N
 22.004  MATH         L[1] = MEM
 22.005  CALL         Sub Specify HP856X Frequency Response
 22.006  JMPL         END                          @Abort
 22.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1500E+6) / L[2]
 22.008  TARGET       -m
 22.009  8560         -26D                         3000MH               N
 22.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 3000E+6) / L[2]
 22.011  MATH         MEM = MEM - L[1]
 22.012  CALL         Sub Specify HP856X Log Scale Fidelity
 22.013  JMPL         END                          @Abort
 22.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 3000E+6) / L[2]
 22.015  MATH         L[6] = RSS_L(3, 5) * 2
 22.016  ACC          -30.0dBc       L6U
 22.017  MEMC         -30.0dBc       -0.0U +100.0U 3000MH

 23.001  TSET         TDESC = 1990 MHz, ½ harmonic
 23.002  SCPI         FREQ:CW 1990 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 23.003  8560         4D                           1990MH               N
 23.004  MATH         L[1] = MEM
 23.005  CALL         Sub Specify HP856X Frequency Response
 23.006  JMPL         END                          @Abort
 23.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1990E+6) / L[2]
 23.008  TARGET       -m
 23.009  8560         -26D                         995MH                N
 23.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 995E+6) / L[2]
 23.011  MATH         MEM = MEM - L[1]
 23.012  CALL         Sub Specify HP856X Log Scale Fidelity
 23.013  JMPL         END                          @Abort
 23.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 995E+6) / L[2]
 23.015  MATH         L[6] = RSS_L(3, 5) * 2
 23.016  ACC          -30.0dBc       L6U
 23.017  MEMC         -30.0dBc       -0.0U +100.0U 995MH

 24.001  TSET         TDESC = 2000 MHz, 1½ harmonic
 24.002  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 24.003  8560         4D                           2000MH               N
 24.004  MATH         L[1] = MEM
 24.005  CALL         Sub Specify HP856X Frequency Response
 24.006  JMPL         END                          @Abort
 24.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 2000E+6) / L[2]
 24.008  TARGET       -m
 24.009  8560         -26D                         3000MH               N
 24.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 3000E+6) / L[2]
 24.011  MATH         MEM = MEM - L[1]
 24.012  CALL         Sub Specify HP856X Log Scale Fidelity
 24.013  JMPL         END                          @Abort
 24.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 3000E+6) / L[2]
 24.015  MATH         L[6] = RSS_L(3, 5) * 2
 24.016  ACC          -30.0dBc       L6U
 24.017  MEMC         -30.0dBc       -0.0U +100.0U 3000MH

# The following tests apply to 8648C/D models only.
 25.001  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
 25.002  TARGET       -p
 25.003  TSET         TDESC = 3200 MHz, ½ harmonic
 25.004  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 25.005  8560         4D                           3200MH               N
 25.006  MATH         L[1] = MEM
 25.007  CALL         Sub Specify HP856X Frequency Response
 25.008  JMPL         END                          @Abort
 25.009  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 3200E+6) / L[2]
 25.010  TARGET       -m
 25.011  8560         -26D                         1600MH               N
 25.012  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1600E+6) / L[2]
 25.013  MATH         MEM = MEM - L[1]
 25.014  CALL         Sub Specify HP856X Log Scale Fidelity
 25.015  JMPL         END                          @Abort
 25.016  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1600E+6) / L[2]
 25.017  MATH         L[6] = RSS_L(3, 5) * 2
 25.018  ACC          -30.0dBc       L6U
 25.019  MEMC         -30.0dBc       -0.0U +100.0U 1600MH
 26.001  ENDIF

# The following tests apply to 8648D models only.

 26.002  IF           ZCMPI(@ModelNum, "8648D")
 26.003  TARGET       -p
 26.004  TSET         TDESC = 3400 MHz, ½ harmonic
 26.005  SCPI         FREQ:CW 3400 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 26.006  8560         4D                           3400MH               N
 26.007  MATH         L[1] = MEM
 26.008  CALL         Sub Specify HP856X Frequency Response
 26.009  JMPL         END                          @Abort
 26.010  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 3400E+6) / L[2]
 26.011  TARGET       -m
 26.012  8560         -26D                         1700MH               N
 26.013  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1700E+6) / L[2]
 26.014  MATH         MEM = MEM - L[1]
 26.015  CALL         Sub Specify HP856X Log Scale Fidelity
 26.016  JMPL         END                          @Abort
 26.017  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1700E+6) / L[2]
 26.018  MATH         L[6] = RSS_L(3, 5) * 2
 26.019  ACC          -30.0dBc       L6U
 26.020  MEMC         -30.0dBc       -0.0U +100.0U 1700MH

 27.001  TSET         TDESC = 3550 MHz, ½ harmonic
 27.002  SCPI         FREQ:CW 3550 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 27.003  8560         4D                           3550MH               N
 27.004  MATH         L[1] = MEM
 27.005  CALL         Sub Specify HP856X Frequency Response
 27.006  JMPL         END                          @Abort
 27.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 3550E+6) / L[2]
 27.008  TARGET       -m
 27.009  8560         -26D                         1800MH               N
 27.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 27.011  MATH         MEM = MEM - L[1]
 27.012  CALL         Sub Specify HP856X Log Scale Fidelity
 27.013  JMPL         END                          @Abort
 27.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1800E+6) / L[2]
 27.015  MATH         L[6] = RSS_L(3, 5) * 2
 27.016  ACC          -30.0dBc       L6U
 27.017  MEMC         -30.0dBc       -0.0U +100.0U 1800MH

 28.001  TSET         TDESC = 4000 MHz, ½ harmonic
 28.002  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 28.003  8560         4D                           4000MH               N
 28.004  MATH         L[1] = MEM
 28.005  CALL         Sub Specify HP856X Frequency Response
 28.006  JMPL         END                          @Abort
 28.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 4000E+6) / L[2]
 28.008  TARGET       -m
 28.009  8560         -26D                         2000MH               N
 28.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 2000E+6) / L[2]
 28.011  MATH         MEM = MEM - L[1]
 28.012  CALL         Sub Specify HP856X Log Scale Fidelity
 28.013  JMPL         END                          @Abort
 28.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 2000E+6) / L[2]
 28.015  MATH         L[6] = RSS_L(3, 5) * 2
 28.016  ACC          -30.0dBc       L6U
 28.017  MEMC         -30.0dBc       -0.0U +100.0U 2000MH
 29.001  ENDIF

 29.002  HEAD
 29.003  SCPI         *RST
 29.004  M8560        *
 29.005  8560         *                                                 S
 29.006  END

 29.007  EVAL   Increment step number

# =====  Sub 8648B/C/D (2 yr) Spurious VER /8560  ===========================

 30.001  LABEL        SPURIOUS
 30.002  RSLT         =
 30.003  HEAD         {SPURIOUS PERFORMANCE}
 30.004  RSLT         =
 30.005  RSLT         = Output Level: +4 dBm
 30.006  TARGET       -p
 30.007  TSET         TDESC = 242 MHz (274 MHz Spur)
# Set UUT output parameters.
 30.008  SCPI         FREQ:CW 242 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
# Set RF Input attenuation.
 30.009  M8560  ATTEN 20dB
# Set Span.
 30.010  M8560  SPAN  500kH
# Set Resolution Bandwidth.
 30.011  M8560  RESBW 1kH
# Set Video Bandwidth to 1 kHz, Reference Level to +10 dBm, 10 MHz EXT REF.
 30.012  M8560  VIDBW 1kH                          10D                  X
# Measure amplitude of fundamental (242 MHz).
 30.013  8560         4D                           242MH                N
# Store fundamental reference level in L[1].
 30.014  MATH         L[1] = MEM
# Retrieve confidence interval for HP 856x spectrum analyzer.
 30.015  MATH         L[2] = CONF("HP 8560")
# Specify correct 856x frequency response mode string for unit being used.
 30.016  CALL         Sub Specify HP856X Frequency Response
 30.017  JMPL         END                          @Abort
# Retrieve uncertainty for above measurement and normalize.
 30.018  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 242E+6) / L[2]
 30.019  TARGET       -m
# Measure amplitude of spur (274 MHz).
 30.020  8560         -51D                         274MH                N
# Retrieve uncertainty for above measurement and normalize.
 30.021  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 274E+6) / L[2]
# Compute harmonic level (dBc).
 30.022  MATH         MEM = MEM - L[1]
# Specify correct 856x scale fidelity mode string for unit being used.
 30.023  CALL         Sub Specify HP856X Log Scale Fidelity
 30.024  JMPL         END                          @Abort
# Retrieve scale fidelity uncertainty for above measurements.
 30.025  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 274E+6) / L[2]
# RSS all individual measurement uncertainty componenets
 30.026  MATH         L[6] = RSS_L(3, 5) * 2
# Computed expanded uncertainty shown in ACC.
 30.027  ACC          -55.0dBc       L6U
 30.028  MEMC         -55.0dBc       -0.0U +75.0U  274MH

 31.001  TSET         TDESC = 247 MHz (259 MHz Spur)
 31.002  SCPI         FREQ:CW 247 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 31.003  8560         4D                           247MH                N
 31.004  MATH         L[1] = MEM
 31.005  CALL         Sub Specify HP856X Frequency Response
 31.006  JMPL         END                          @Abort
 31.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 247E+6) / L[2]
 31.008  TARGET       -m
 31.009  8560         -51D                         259MH                N
 31.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 259E+6) / L[2]
 31.011  MATH         MEM = MEM - L[1]
 31.012  CALL         Sub Specify HP856X Log Scale Fidelity
 31.013  JMPL         END                          @Abort
 31.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 259E+6) / L[2]
 31.015  MATH         L[6] = RSS_L(3, 5) * 2
 31.016  ACC          -55.0dBc       L6U
 31.017  MEMC         -55.0dBc       -0.0U +75.0U  259MH

 32.001  RSLT         =
 32.002  RSLT         = Output Level: -6 dBm
 32.003  TARGET       -p
 32.004  TSET         TDESC = 1 MHz (999 MHz Spur)
 32.005  SCPI         FREQ:CW 1 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 32.006  M8560  ATTEN 10dB                         0D                   X
 32.007  8560         -6D                          1MH                  N
 32.008  MATH         L[1] = MEM
 32.009  CALL         Sub Specify HP856X Frequency Response
 32.010  JMPL         END                          @Abort
 32.011  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1E+6) / L[2]
 32.012  TARGET       -m
 32.013  8560         -61D                         999MH                N
 32.014  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 999E+6) / L[2]
 32.015  MATH         MEM = MEM - L[1]
 32.016  CALL         Sub Specify HP856X Log Scale Fidelity
 32.017  JMPL         END                          @Abort
 32.018  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 999E+6) / L[2]
 32.019  MATH         L[6] = RSS_L(3, 5) * 2
 32.020  ACC          -55.0dBc       L6U
 32.021  MEMC         -55.0dBc       -0.0U +75.0U  999MH

 33.001  TSET         TDESC = 1 MHz (1000 MHz Spur)
 33.002  SCPI         FREQ:CW 1 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 33.003  8560         -6D                          1MH                  N
 33.004  MATH         L[1] = MEM
 33.005  CALL         Sub Specify HP856X Frequency Response
 33.006  JMPL         END                          @Abort
 33.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 1E+6) / L[2]
 33.008  TARGET       -m
 33.009  8560         -61D                         1000MH               N
 33.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 33.011  MATH         MEM = MEM - L[1]
 33.012  CALL         Sub Specify HP856X Log Scale Fidelity
 33.013  JMPL         END                          @Abort
 33.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 33.015  MATH         L[6] = RSS_L(3, 5) * 2
 33.016  ACC          -55.0dBc       L6U
 33.017  MEMC         -55.0dBc       -0.0U +75.0U  1000MH

 34.001  TSET         TDESC = 41 MHz (1000 MHz Spur)
 34.002  SCPI         FREQ:CW 41 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 34.003  8560         -6D                          41MH                 N
 34.004  MATH         L[1] = MEM
 34.005  CALL         Sub Specify HP856X Frequency Response
 34.006  JMPL         END                          @Abort
 34.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 41E+6) / L[2]
 34.008  TARGET       -m
 34.009  8560         -61D                         1000MH               N
 34.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 34.011  MATH         MEM = MEM - L[1]
 34.012  CALL         Sub Specify HP856X Log Scale Fidelity
 34.013  JMPL         END                          @Abort
 34.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 34.015  MATH         L[6] = RSS_L(3, 5) * 2
 34.016  ACC          -55.0dBc       L6U
 34.017  MEMC         -55.0dBc       -0.0U +75.0U  1000MH

 35.001  TSET         TDESC = 61 MHz (1000 MHz Spur)
 35.002  SCPI         FREQ:CW 61 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 35.003  8560         -6D                          61MH                 N
 35.004  MATH         L[1] = MEM
 35.005  CALL         Sub Specify HP856X Frequency Response
 35.006  JMPL         END                          @Abort
 35.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 61E+6) / L[2]
 35.008  TARGET       -m
 35.009  8560         -61D                         1000MH               N
 35.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 35.011  MATH         MEM = MEM - L[1]
 35.012  CALL         Sub Specify HP856X Log Scale Fidelity
 35.013  JMPL         END                          @Abort
 35.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 35.015  MATH         L[6] = RSS_L(3, 5) * 2
 35.016  ACC          -55.0dBc       L6U
 35.017  MEMC         -55.0dBc       -0.0U +75.0U  1000MH

 36.001  TSET         TDESC = 91 MHz (1000 MHz Spur)
 36.002  SCPI         FREQ:CW 91 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 36.003  8560         -6D                          91MH                 N
 36.004  MATH         L[1] = MEM
 36.005  CALL         Sub Specify HP856X Frequency Response
 36.006  JMPL         END                          @Abort
 36.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 91E+6) / L[2]
 36.008  TARGET       -m
 36.009  8560         -61D                         1000MH               N
 36.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 36.011  MATH         MEM = MEM - L[1]
 36.012  CALL         Sub Specify HP856X Log Scale Fidelity
 36.013  JMPL         END                          @Abort
 36.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 36.015  MATH         L[6] = RSS_L(3, 5) * 2
 36.016  ACC          -55.0dBc       L6U
 36.017  MEMC         -55.0dBc       -0.0U +75.0U  1000MH

 37.001  TSET         TDESC = 102 MHz (286 MHz Spur)
 37.002  SCPI         FREQ:CW 102 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 37.003  8560         -6D                          102MH                N
 37.004  MATH         L[1] = MEM
 37.005  CALL         Sub Specify HP856X Frequency Response
 37.006  JMPL         END                          @Abort
 37.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 102E+6) / L[2]
 37.008  TARGET       -m
 37.009  8560         -61D                         286MH                N
 37.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 286E+6) / L[2]
 37.011  MATH         MEM = MEM - L[1]
 37.012  CALL         Sub Specify HP856X Log Scale Fidelity
 37.013  JMPL         END                          @Abort
 37.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 286E+6) / L[2]
 37.015  MATH         L[6] = RSS_L(3, 5) * 2
 37.016  ACC          -55.0dBc       L6U
 37.017  MEMC         -55.0dBc       -0.0U +75.0U  286MH

 38.001  TSET         TDESC = 137 MHz (315 MHz Spur)
 38.002  SCPI         FREQ:CW 137 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 38.003  8560         -6D                          137MH                N
 38.004  MATH         L[1] = MEM
 38.005  CALL         Sub Specify HP856X Frequency Response
 38.006  JMPL         END                          @Abort
 38.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 137E+6) / L[2]
 38.008  TARGET       -m
 38.009  8560         -61D                         315MH                N
 38.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 315E+6) / L[2]
 38.011  MATH         MEM = MEM - L[1]
 38.012  CALL         Sub Specify HP856X Log Scale Fidelity
 38.013  JMPL         END                          @Abort
 38.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 315E+6) / L[2]
 38.015  MATH         L[6] = RSS_L(3, 5) * 2
 38.016  ACC          -55.0dBc       L6U
 38.017  MEMC         -55.0dBc       -0.0U +75.0U  315MH

 39.001  TSET         TDESC = 150 MHz (148 MHz Spur)
 39.002  SCPI         FREQ:CW 150 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 39.003  8560         -6D                          150MH                N
 39.004  MATH         L[1] = MEM
 39.005  CALL         Sub Specify HP856X Frequency Response
 39.006  JMPL         END                          @Abort
 39.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
 39.008  TARGET       -m
 39.009  8560         -61D                         148MH                N
 39.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 148E+6) / L[2]
 39.011  MATH         MEM = MEM - L[1]
 39.012  CALL         Sub Specify HP856X Log Scale Fidelity
 39.013  JMPL         END                          @Abort
 39.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 148E+6) / L[2]
 39.015  MATH         L[6] = RSS_L(3, 5) * 2
 39.016  ACC          -55.0dBc       L6U
 39.017  MEMC         -55.0dBc       -0.0U +75.0U  148MH

 40.001  TSET         TDESC = 150 MHz (149 MHz Spur)
 40.002  SCPI         FREQ:CW 150 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 40.003  8560         -6D                          150MH                N
 40.004  MATH         L[1] = MEM
 40.005  CALL         Sub Specify HP856X Frequency Response
 40.006  JMPL         END                          @Abort
 40.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
 40.008  TARGET       -m
 40.009  8560         -61D                         149MH                N
 40.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 149E+6) / L[2]
 40.011  MATH         MEM = MEM - L[1]
 40.012  CALL         Sub Specify HP856X Log Scale Fidelity
 40.013  JMPL         END                          @Abort
 40.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 149E+6) / L[2]
 40.015  MATH         L[6] = RSS_L(3, 5) * 2
 40.016  ACC          -55.0dBc       L6U
 40.017  MEMC         -55.0dBc       -0.0U +75.0U  149MH

 41.001  TSET         TDESC = 150 MHz (151 MHz Spur)
 41.002  SCPI         FREQ:CW 150 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 41.003  8560         -6D                          150MH                N
 41.004  MATH         L[1] = MEM
 41.005  CALL         Sub Specify HP856X Frequency Response
 41.006  JMPL         END                          @Abort
 41.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
 41.008  TARGET       -m
 41.009  8560         -61D                         151MH                N
 41.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 151E+6) / L[2]
 41.011  MATH         MEM = MEM - L[1]
 41.012  CALL         Sub Specify HP856X Log Scale Fidelity
 41.013  JMPL         END                          @Abort
 41.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 151E+6) / L[2]
 41.015  MATH         L[6] = RSS_L(3, 5) * 2
 41.016  ACC          -55.0dBc       L6U
 41.017  MEMC         -55.0dBc       -0.0U +75.0U  151MH

 42.001  TSET         TDESC = 150 MHz (152 MHz Spur)
 42.002  SCPI         FREQ:CW 150 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 42.003  8560         -6D                          150MH                N
 42.004  MATH         L[1] = MEM
 42.005  CALL         Sub Specify HP856X Frequency Response
 42.006  JMPL         END                          @Abort
 42.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 150E+6) / L[2]
 42.008  TARGET       -m
 42.009  8560         -61D                         152MH                N
 42.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 152E+6) / L[2]
 42.011  MATH         MEM = MEM - L[1]
 42.012  CALL         Sub Specify HP856X Log Scale Fidelity
 42.013  JMPL         END                          @Abort
 42.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 152E+6) / L[2]
 42.015  MATH         L[6] = RSS_L(3, 5) * 2
 42.016  ACC          -55.0dBc       L6U
 42.017  MEMC         -55.0dBc       -0.0U +75.0U  152MH

 43.001  IF           ZCMPI(@ModelNum, "8648D")
 43.002  TARGET       -p
 43.003  TSET         TDESC = 167 MHz (169 MHz Spur)
 43.004  SCPI         FREQ:CW 167 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 43.005  8560         -6D                          167MH                N
 43.006  MATH         L[1] = MEM
 43.007  CALL         Sub Specify HP856X Frequency Response
 43.008  JMPL         END                          @Abort
 43.009  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 167E+6) / L[2]
 43.010  TARGET       -m
 43.011  8560         -61D                         169MH                N
 43.012  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 169E+6) / L[2]
 43.013  MATH         MEM = MEM - L[1]
 43.014  CALL         Sub Specify HP856X Log Scale Fidelity
 43.015  JMPL         END                          @Abort
 43.016  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 169E+6) / L[2]
 43.017  MATH         L[6] = RSS_L(3, 5) * 2
 43.018  ACC          -55.0dBc       L6U
 43.019  MEMC         -55.0dBc       -0.0U +75.0U  169MH
 44.001  ELSE
 44.002  TARGET       -p
 44.003  TSET         TDESC = 167 MHz (7 MHz Spur)
 44.004  SCPI         FREQ:CW 167 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 44.005  8560         -6D                          167MH                N
 44.006  MATH         L[1] = MEM
 44.007  CALL         Sub Specify HP856X Frequency Response
 44.008  JMPL         END                          @Abort
 44.009  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 167E+6) / L[2]
 44.010  TARGET       -m
 44.011  8560         -61D                         7MH                  N
 44.012  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 7E+6) / L[2]
 44.013  MATH         MEM = MEM - L[1]
 44.014  CALL         Sub Specify HP856X Log Scale Fidelity
 44.015  JMPL         END                          @Abort
 44.016  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 7E+6) / L[2]
 44.017  MATH         L[6] = RSS_L(3, 5) * 2
 44.018  ACC          -55.0dBc       L6U
 44.019  MEMC         -55.0dBc       -0.0U +75.0U  7MH
 45.001  ENDIF

 45.002  TSET         TDESC = 172 MHz (312 MHz Spur)
 45.003  SCPI         FREQ:CW 172 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 45.004  8560         -6D                          172MH                N
 45.005  MATH         L[1] = MEM
 45.006  CALL         Sub Specify HP856X Frequency Response
 45.007  JMPL         END                          @Abort
 45.008  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 172E+6) / L[2]
 45.009  TARGET       -m
 45.010  8560         -61D                         312MH                N
 45.011  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 312E+6) / L[2]
 45.012  MATH         MEM = MEM - L[1]
 45.013  CALL         Sub Specify HP856X Log Scale Fidelity
 45.014  JMPL         END                          @Abort
 45.015  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 312E+6) / L[2]
 45.016  MATH         L[6] = RSS_L(3, 5) * 2
 45.017  ACC          -55.0dBc       L6U
 45.018  MEMC         -55.0dBc       -0.0U +75.0U  312MH

 46.001  TSET         TDESC = 227 MHz (92 MHz Spur)
 46.002  SCPI         FREQ:CW 227 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 46.003  8560         -6D                          227MH                N
 46.004  MATH         L[1] = MEM
 46.005  CALL         Sub Specify HP856X Frequency Response
 46.006  JMPL         END                          @Abort
 46.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 227E+6) / L[2]
 46.008  TARGET       -m
 46.009  8560         -61D                         92MH                 N
 46.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 92E+6) / L[2]
 46.011  MATH         MEM = MEM - L[1]
 46.012  CALL         Sub Specify HP856X Log Scale Fidelity
 46.013  JMPL         END                          @Abort
 46.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 92E+6) / L[2]
 46.015  MATH         L[6] = RSS_L(3, 5) * 2
 46.016  ACC          -55.0dBc       L6U
 46.017  MEMC         -55.0dBc       -0.0U +75.0U  92MH

 47.001  TSET         TDESC = 232 MHz (304 MHz Spur)
 47.002  SCPI         FREQ:CW 232 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 47.003  8560         -6D                          232MH                N
 47.004  MATH         L[1] = MEM
 47.005  CALL         Sub Specify HP856X Frequency Response
 47.006  JMPL         END                          @Abort
 47.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 232E+6) / L[2]
 47.008  TARGET       -m
 47.009  8560         -61D                         304MH                N
 47.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 304E+6) / L[2]
 47.011  MATH         MEM = MEM - L[1]
 47.012  CALL         Sub Specify HP856X Log Scale Fidelity
 47.013  JMPL         END                          @Abort
 47.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 304E+6) / L[2]
 47.015  MATH         L[6] = RSS_L(3, 5) * 2
 47.016  ACC          -55.0dBc       L6U
 47.017  MEMC         -55.0dBc       -0.0U +75.0U  304MH

 48.001  TSET         TDESC = 241 MHz (759 MHz Spur)
 48.002  SCPI         FREQ:CW 241 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 48.003  8560         -6D                          241MH                N
 48.004  MATH         L[1] = MEM
 48.005  CALL         Sub Specify HP856X Frequency Response
 48.006  JMPL         END                          @Abort
 48.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 241E+6) / L[2]
 48.008  TARGET       -m
 48.009  8560         -61D                         759MH                N
 48.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 759E+6) / L[2]
 48.011  MATH         MEM = MEM - L[1]
 48.012  CALL         Sub Specify HP856X Log Scale Fidelity
 48.013  JMPL         END                          @Abort
 48.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 759E+6) / L[2]
 48.015  MATH         L[6] = RSS_L(3, 5) * 2
 48.016  ACC          -55.0dBc       L6U
 48.017  MEMC         -55.0dBc       -0.0U +75.0U  759MH

 49.001  TSET         TDESC = 241 MHz (1000 MHz Spur)
 49.002  SCPI         FREQ:CW 241 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 49.003  8560         -6D                          241MH                N
 49.004  MATH         L[1] = MEM
 49.005  CALL         Sub Specify HP856X Frequency Response
 49.006  JMPL         END                          @Abort
 49.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 241E+6) / L[2]
 49.008  TARGET       -m
 49.009  8560         -61D                         1000MH               N
 49.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 49.011  MATH         MEM = MEM - L[1]
 49.012  CALL         Sub Specify HP856X Log Scale Fidelity
 49.013  JMPL         END                          @Abort
 49.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 1000E+6) / L[2]
 49.015  MATH         L[6] = RSS_L(3, 5) * 2
 49.016  ACC          -55.0dBc       L6U
 49.017  MEMC         -55.0dBc       -0.0U +75.0U  1000MH

 50.001  TSET         TDESC = 242 MHz (274 MHz Spur)
 50.002  SCPI         FREQ:CW 242 MHZ;:POW:AMPL -6 DBM;:OUTP:STAT ON
 50.003  8560         -6D                          242MH                N
 50.004  MATH         L[1] = MEM
 50.005  CALL         Sub Specify HP856X Frequency Response
 50.006  JMPL         END                          @Abort
 50.007  MATH         L[3] = ACCV2("HP 8560", S[1], MEM, 242E+6) / L[2]
 50.008  TARGET       -m
 50.009  8560         -61D                         274MH                N
 50.010  MATH         L[4] = ACCV2("HP 8560", S[1], MEM, 274E+6) / L[2]
 50.011  MATH         MEM = MEM - L[1]
 50.012  CALL         Sub Specify HP856X Log Scale Fidelity
 50.013  JMPL         END                          @Abort
 50.014  MATH         L[5] = ACCV2("HP 8560", S[1], MEM, 274E+6) / L[2]
 50.015  MATH         L[6] = RSS_L(3, 5) * 2
 50.016  ACC          -55.0dBc       L6U
 50.017  MEMC         -55.0dBc       -0.0U +75.0U  274MH

 51.001  LABEL        END
 51.002  HEAD
 51.003  SCPI         *RST
 51.004  M8560        *
 51.005  8560         *                                                 S
 51.006  END
