﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D (2 yr) PM Dist VER /8902S,LO
DATE:                  2016-06-28 07:42:27
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       12
NUMBER OF LINES:       206
CONFIGURATION:         HP 8902A
CONFIGURATION:         Local Oscillator
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        HP/Agilent 11792A Sensor Module
#        HP/Agilent 11793A Microwave Converter
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LO]
  1.003  ENDIF

  1.004  CALL         Sub Initialize /LO
  1.005  CALL         Sub Reset /LO

  1.006  RSLT         =
  1.007  HEAD         {PHASE MODULATION DISTORTION PERFORMANCE}
  1.008  RSLT         =Modulation Source: INT 1 kHz
  1.009  RSLT         =
  1.010  RSLT         =5 Radians Deviation
  1.011  HEAD         -2 Carrier Frequency: 0.25 MHz
  1.012  TARGET       -p
  1.013  TSET         TDESC = 0.25 MHz Carrier
  1.014  SCPI         FREQ:CW 0.25 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  1.015  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  1.016  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  1.017  M8902        1kH                                         H2 L2    P+
  1.018  8902         5.00rad                      0.25MH            PM N
  1.019  M8902                                                    H2 L2    D5
  1.020  TARGET       -m
  1.021  8902         0.01pct        1.00U         1kH               AD

  2.001  HEAD         -2 Carrier Frequency: 100 MHz
  2.002  TARGET       -p
  2.003  TSET         TDESC = 100 MHz Carrier
  2.004  SCPI         FREQ:CW 100 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  2.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  2.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  2.007  M8902        1kH                                         H2 L2    P+
  2.008  8902         5.00rad                      100MH             PM N
  2.009  M8902                                                    H2 L2    D5
  2.010  TARGET       -m
  2.011  8902         0.01pct        1.00U         1kH               AD

  3.001  HEAD         -2 Carrier Frequency: 400 MHz
  3.002  TARGET       -p
  3.003  TSET         TDESC = 400 MHz Carrier
  3.004  SCPI         FREQ:CW 400 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  3.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  3.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  3.007  M8902        1kH                                         H2 L2    P+
  3.008  8902         5.00rad                      400MH             PM N
  3.009  M8902                                                    H2 L2    D5
  3.010  TARGET       -m
  3.011  8902         0.01pct        1.00U         1kH               AD

  4.001  HEAD         -2 Carrier Frequency: 500 MHz
  4.002  TARGET       -p
  4.003  TSET         TDESC = 500 MHz Carrier
  4.004  SCPI         FREQ:CW 500 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  4.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  4.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  4.007  M8902        1kH                                         H2 L2    P+
  4.008  8902         5.00rad                      500MH             PM N
  4.009  M8902                                                    H2 L2    D5
  4.010  TARGET       -m
  4.011  8902         0.01pct        1.00U         1kH               AD

  5.001  HEAD         -2 Carrier Frequency: 750 MHz
  5.002  TARGET       -p
  5.003  TSET         TDESC = 750 MHz Carrier
  5.004  SCPI         FREQ:CW 750 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  5.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  5.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  5.007  M8902        1kH                                         H2 L2    P+
  5.008  8902         5.00rad                      750MH             PM N
  5.009  M8902                                                    H2 L2    D5
  5.010  TARGET       -m
  5.011  8902         0.01pct        1.00U         1kH               AD

  6.001  HEAD         -2 Carrier Frequency: 1000 MHz
  6.002  TARGET       -p
  6.003  TSET         TDESC = 1000 MHz Carrier
  6.004  SCPI         FREQ:CW 1000 MHZ;:PM:DEV 5 RAD;:PM:SOUR INT
  6.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  6.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  6.007  M8902        1kH                                         H2 L2    P+
  6.008  8902         5.00rad                      1040MH            PM N
  6.009  M8902                                                    H2 L2    D5
  6.010  TARGET       -m
  6.011  8902         0.01pct        1.00U         1kH               AD

# 11793A Downconverter required for the following tests.

  7.001  RSLT         =
  7.002  RSLT         =7 Radians Deviation

  7.003  HEAD         -2 Carrier Frequency: 1500 MHz
  7.004  MATH         @LO_Freq = "1620.53MHz"; @LO_Ampl = "+8dBm"
  7.005  TARGET       -p
  7.006  TSET         TDESC = 1500 MHz Carrier
  7.007  SCPI         FREQ:CW 1500 MHZ;:PM:DEV 7 RAD;:PM:SOUR INT
  7.008  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  7.009  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
# Set LO output to required frequency (1620.53 MHz) and level (+8 dBm).
  7.010  CALL         Sub Apply /LO
  7.011  M8902        1620.53MH      27.3SP                       H0 L0
  7.012  M8902        1kH                                         H2 L2    P+
  7.013  8902         7.00rad                      1500MH            PM N
  7.014  M8902                                                    H2 L2    D5
  7.015  TARGET       -m
  7.016  8902         0.01pct        1.00U         1kH               AD

  8.001  HEAD         -2 Carrier Frequency: 2000 MHz
  8.002  TARGET       -p
  8.003  TSET         TDESC = 2000 MHz Carrier
  8.004  SCPI         FREQ:CW 2000 MHZ;:PM:DEV 7 RAD;:PM:SOUR INT
  8.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  8.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  8.007  CALL         Sub Apply /LO
  8.008  M8902        2120.53MH      27.3SP                       H0 L0
  8.009  M8902        1kH                                         H2 L2    P+
  8.010  8902         7.00rad                      2000MH            PM N
  8.011  M8902                                                    H2 L2    D5
  8.012  TARGET       -m
  8.013  8902         0.01pct        1.00U         1kH               AD

# The following tests apply to 8648C/D models only.
  9.001  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
  9.002  RSLT         =
  9.003  RSLT         =14 Radians Deviation

  9.004  HEAD         -2 Carrier Frequency: 2500 MHz
  9.005  MATH         @LO_Freq = "2620.53MHz"; @LO_Ampl = "+8dBm"
  9.006  TARGET       -p
  9.007  TSET         TDESC = 2500 MHz Carrier
  9.008  SCPI         FREQ:CW 2500 MHZ;:PM:DEV 14 RAD;:PM:SOUR INT
  9.009  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
  9.010  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
  9.011  CALL         Sub Apply /LO
  9.012  M8902        2620.53MH      27.3SP                       H0 L0
  9.013  M8902        1kH                                         H2 L2    P+
  9.014  8902         14.00rad                     2500MH            PM N
  9.015  M8902                                                    H2 L2    D5
  9.016  TARGET       -m
  9.017  8902         0.01pct        1.00U         1kH               AD

 10.001  HEAD         -2 Carrier Frequency: 3200 MHz
 10.002  TARGET       -p
 10.003  TSET         TDESC = 3200 MHz Carrier
 10.004  SCPI         FREQ:CW 3200 MHZ;:PM:DEV 14 RAD;:PM:SOUR INT
 10.005  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
 10.006  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 10.007  CALL         Sub Apply /LO
 10.008  M8902        3320.53MH      27.3SP                       H0 L0
 10.009  M8902        1kH                                         H2 L2    P+
 10.010  8902         14.00rad                     3200MH            PM N
 10.011  M8902                                                    H2 L2    D5
 10.012  TARGET       -m
 10.013  8902         0.01pct        1.00U         1kH               AD
 11.001  ENDIF

# The following tests apply to 8648D models only.
 11.002  IF           ZCMPI(@ModelNum, "8648D")
 11.003  HEAD         -2 Carrier Frequency: 3800 MHz
 11.004  MATH         @LO_Freq = "3920.53MHz"; @LO_Ampl = "+8dBm"
 11.005  TARGET       -p
 11.006  TSET         TDESC = 3800 MHz Carrier
 11.007  SCPI         FREQ:CW 3800 MHZ;:PM:DEV 14 RAD;:PM:SOUR INT
 11.008  SCPI         PM:INT:FREQ 1 KHZ;:PM:STAT ON
 11.009  SCPI         POW:AMPL 4 DBM;:OUTP:STAT ON
 11.010  CALL         Sub Apply /LO
 11.011  M8902        3920.53MH      27.3SP                       H0 L0
 11.012  M8902        1kH                                         H2 L2    P+
 11.013  8902         14.00rad                     3800MH            PM N
 11.014  M8902                                                    H2 L2    D5
 11.015  TARGET       -m
 11.016  8902         0.01pct        1.00U         1kH               AD
 12.001  ENDIF

 12.002  HEAD         -2
 12.003  HEAD
 12.004  SCPI         *RST
 12.005  CALL         Sub Reset /LO
 12.006  M8902        *
 12.007  8902         *                                                 S
 12.008  END
