﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8648B/C/D RF Level VER /8902S,11792,LO
DATE:                  2016-06-28 07:42:09
AUTHOR:                Fluke
REVISION:              $Revision: 16367 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       37
NUMBER OF LINES:       293
CONFIGURATION:         HP 8902A
CONFIGURATION:         Local Oscillator
STANDARD:              HP 11792A
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LO]
  1.003  ENDIF

  1.004  CALL         Sub Reset /LO

  1.005  STD          HP 11792A

  1.006  RSLT         =
  1.007  HEAD         RF LEVEL ACCURACY
  1.008  HEAD         -2{Carrier Frequency: 2000 MHz}
  1.009  MATH         @LO_Freq = "2120.53MHz"; @LO_Ampl = "+8dBm"
  1.010  TARGET       -p
  1.011  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 13 DBM;:OUTP:STAT ON
# Specify and energize LO output for downconverting signal.
  1.012  CALL         Sub Apply /LO
# Specify LO frequency for 8902A and enter/enable external LO mode.
  1.013  M8902        2120.53MH      27.3SP                       H0 L0
# Take a frequency reading with 8902A to facilitate a tuning operation.
  1.014  8902         2000MH                       13D               FA N
  1.015  TARGET       -m
# Take RF power measurement using cal factor in frequency offset table.
  1.016  8902         13.0D                        2000MH            RF N
  1.017  MEMC   130   13.0D          1.0U

  2.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 10 DBM;:OUTP:STAT ON
  2.002  CALL         Sub Apply /LO
  2.003  TARGET       -m
  2.004  8902         10.0D                        2000MH            RF N
  2.005  MEMC   130   10.0D          1.0U

  3.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
  3.002  CALL         Sub Apply /LO
  3.003  TARGET       -m
  3.004  8902         4.0D                         2000MH            RF N
  3.005  MEMC   130   4.0D           1.0U

  4.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -5.9 DBM;:OUTP:STAT ON
  4.002  CALL         Sub Apply /LO
  4.003  TARGET       -m
# Select Tuned RF Level mode and center tuning using "TU" attribute.
  4.004  8902         -5.9D                        2000MH         TU TL N
  4.005  MEMC   130   -5.9D          1.0U

  5.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -15.9 DBM;:OUTP:STAT ON
  5.002  CALL         Sub Apply /LO
  5.003  TARGET       -m
  5.004  8902         -15.9D                       2000MH            TL N
  5.005  MEMC   130   -15.9D         1.0U

  6.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -25.9 DBM;:OUTP:STAT ON
  6.002  CALL         Sub Apply /LO
  6.003  TARGET       -m
  6.004  8902         -25.9D                       2000MH            TL N
  6.005  MEMC   130   -25.9D         1.0U

  7.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -35.9 DBM;:OUTP:STAT ON
  7.002  CALL         Sub Apply /LO
  7.003  TARGET       -m
  7.004  8902         -35.9D                       2000MH            TL N
  7.005  MEMC   130   -35.9D         1.0U

  8.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -45.9 DBM;:OUTP:STAT ON
  8.002  CALL         Sub Apply /LO
  8.003  TARGET       -m
  8.004  8902         -45.9D                       2000MH            TL N
  8.005  MEMC   130   -45.9D         1.0U

  9.001  SCPI         FREQ:CW 2000 MHZ;:POW:AMPL -55.9 DBM;:OUTP:STAT ON
  9.002  CALL         Sub Apply /LO
  9.003  TARGET       -m
  9.004  8902         -55.9D                       2000MH            TL N
  9.005  MEMC   130   -55.9D         1.0U

# The following tests apply to 8648C/D models only.
 10.001  IF           ZCMPI(@ModelNum, "8648C") || ZCMPI(@ModelNum, "8648D")
 10.002  RSLT         =
 10.003  HEAD         -2{Carrier Frequency: 2499 MHz}
 10.004  MATH         @LO_Freq = "2619.53MHz"; @LO_Ampl = "+8dBm"
 10.005  TARGET       -p
 10.006  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL 13 DBM;:OUTP:STAT ON
 10.007  CALL         Sub Apply /LO
 10.008  M8902        2619.53MH      27.3SP                       H0 L0
 10.009  8902         2499MH                       13D               FA N
 10.010  TARGET       -m
 10.011  8902         13.0D                        2499MH            RF N
 10.012  MEMC   130   13.0D          1.0U

 11.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL 10 DBM;:OUTP:STAT ON
 11.002  CALL         Sub Apply /LO
 11.003  TARGET       -m
 11.004  8902         10.0D                        2499MH            RF N
 11.005  MEMC   130   10.0D          1.0U

 12.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 12.002  CALL         Sub Apply /LO
 12.003  TARGET       -m
 12.004  8902         4.0D                         2499MH            RF N
 12.005  MEMC   130   4.0D           1.0U

 13.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -5.9 DBM;:OUTP:STAT ON
 13.002  CALL         Sub Apply /LO
 13.003  TARGET       -m
 13.004  8902         -5.9D                        2499MH         TU TL N
 13.005  MEMC   130   -5.9D          1.0U

 14.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -15.9 DBM;:OUTP:STAT ON
 14.002  CALL         Sub Apply /LO
 14.003  TARGET       -m
 14.004  8902         -15.9D                       2499MH            TL N
 14.005  MEMC   130   -15.9D         1.0U

 15.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -25.9 DBM;:OUTP:STAT ON
 15.002  CALL         Sub Apply /LO
 15.003  TARGET       -m
 15.004  8902         -25.9D                       2499MH            TL N
 15.005  MEMC   130   -25.9D         1.0U

 16.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -35.9 DBM;:OUTP:STAT ON
 16.002  CALL         Sub Apply /LO
 16.003  TARGET       -m
 16.004  8902         -35.9D                       2499MH            TL N
 16.005  MEMC   130   -35.9D         1.0U

 17.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -45.9 DBM;:OUTP:STAT ON
 17.002  CALL         Sub Apply /LO
 17.003  TARGET       -m
 17.004  8902         -45.9D                       2499MH            TL N
 17.005  MEMC   130   -45.9D         1.0U

 18.001  SCPI         FREQ:CW 2499 MHZ;:POW:AMPL -55.9 DBM;:OUTP:STAT ON
 18.002  CALL         Sub Apply /LO
 18.003  TARGET       -m
 18.004  8902         -55.9D                       2499MH            TL N
 18.005  MEMC   130   -55.9D         1.0U

 19.001  RSLT         =
 19.002  HEAD         -2{Carrier Frequency: 3200 MHz}
 19.003  MATH         @LO_Freq = "3320.53MHz"; @LO_Ampl = "+8dBm"
 19.004  TARGET       -p
 19.005  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 13 DBM;:OUTP:STAT ON
 19.006  CALL         Sub Apply /LO
 19.007  M8902        3320.53MH      27.3SP                       H0 L0
 19.008  8902         3200MH                       13D               FA N
 19.009  TARGET       -m
 19.010  8902         13.0D                        3200MH            RF N
 19.011  MEMC   130   13.0D          1.5U

 20.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 10 DBM;:OUTP:STAT ON
 20.002  CALL         Sub Apply /LO
 20.003  TARGET       -m
 20.004  8902         10.0D                        3200MH            RF N
 20.005  MEMC   130   10.0D          1.5U

 21.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 21.002  CALL         Sub Apply /LO
 21.003  TARGET       -m
 21.004  8902         4.0D                         3200MH            RF N
 21.005  MEMC   130   4.0D           1.5U

 22.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -5.9 DBM;:OUTP:STAT ON
 22.002  CALL         Sub Apply /LO
 22.003  TARGET       -m
 22.004  8902         -5.9D                        3200MH         TU TL N
 22.005  MEMC   130   -5.9D          1.5U

 23.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -15.9 DBM;:OUTP:STAT ON
 23.002  CALL         Sub Apply /LO
 23.003  TARGET       -m
 23.004  8902         -15.9D                       3200MH            TL N
 23.005  MEMC   130   -15.9D         1.5U

 24.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -25.9 DBM;:OUTP:STAT ON
 24.002  CALL         Sub Apply /LO
 24.003  TARGET       -m
 24.004  8902         -25.9D                       3200MH            TL N
 24.005  MEMC   130   -25.9D         1.5U

 25.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -35.9 DBM;:OUTP:STAT ON
 25.002  CALL         Sub Apply /LO
 25.003  TARGET       -m
 25.004  8902         -35.9D                       3200MH            TL N
 25.005  MEMC   130   -35.9D         1.5U

 26.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -45.9 DBM;:OUTP:STAT ON
 26.002  CALL         Sub Apply /LO
 26.003  TARGET       -m
 26.004  8902         -45.9D                       3200MH            TL N
 26.005  MEMC   130   -45.9D         1.5U

 27.001  SCPI         FREQ:CW 3200 MHZ;:POW:AMPL -55.9 DBM;:OUTP:STAT ON
 27.002  CALL         Sub Apply /LO
 27.003  TARGET       -m
 27.004  8902         -55.9D                       3200MH            TL N
 27.005  MEMC   130   -55.9D         1.5U
 28.001  ENDIF

# The following tests apply to 8648D models only.
 28.002  IF           ZCMPI(@ModelNum, "8648D")
 28.003  RSLT         =
 28.004  HEAD         -2{Carrier Frequency: 4000 MHz}
 28.005  MATH         @LO_Freq = "4120.53MHz"; @LO_Ampl = "+8dBm"
 28.006  TARGET       -p
 28.007  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 13 DBM;:OUTP:STAT ON
 28.008  CALL         Sub Apply /LO
 28.009  M8902        4120.53MH      27.3SP                       H0 L0
 28.010  8902         4000MH                       13D               FA N
 28.011  TARGET       -m
 28.012  8902         13.0D                        4000MH            RF N
 28.013  MEMC   130   13.0D          2.0U

 29.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 10 DBM;:OUTP:STAT ON
 29.002  CALL         Sub Apply /LO
 29.003  TARGET       -m
 29.004  8902         10.0D                        4000MH            RF N
 29.005  MEMC   130   10.0D          2.0U

 30.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL 4 DBM;:OUTP:STAT ON
 30.002  CALL         Sub Apply /LO
 30.003  TARGET       -m
 30.004  8902         4.0D                         4000MH            RF N
 30.005  MEMC   130   4.0D           2.0U

 31.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -5.9 DBM;:OUTP:STAT ON
 31.002  CALL         Sub Apply /LO
 31.003  TARGET       -m
 31.004  8902         -5.9D                        4000MH         TU TL N
 31.005  MEMC   130   -5.9D          2.0U

 32.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -15.9 DBM;:OUTP:STAT ON
 32.002  CALL         Sub Apply /LO
 32.003  TARGET       -m
 32.004  8902         -15.9D                       4000MH            TL N
 32.005  MEMC   130   -15.9D         2.0U

 33.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -25.9 DBM;:OUTP:STAT ON
 33.002  CALL         Sub Apply /LO
 33.003  TARGET       -m
 33.004  8902         -25.9D                       4000MH            TL N
 33.005  MEMC   130   -25.9D         2.0U

 34.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -35.9 DBM;:OUTP:STAT ON
 34.002  CALL         Sub Apply /LO
 34.003  TARGET       -m
 34.004  8902         -35.9D                       4000MH            TL N
 34.005  MEMC   130   -35.9D         2.0U

 35.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -45.9 DBM;:OUTP:STAT ON
 35.002  CALL         Sub Apply /LO
 35.003  TARGET       -m
 35.004  8902         -45.9D                       4000MH            TL N
 35.005  MEMC   130   -45.9D         2.0U

 36.001  SCPI         FREQ:CW 4000 MHZ;:POW:AMPL -55.9 DBM;:OUTP:STAT ON
 36.002  CALL         Sub Apply /LO
 36.003  TARGET       -m
 36.004  8902         -55.9D                       4000MH            TL N
 36.005  MEMC   130   -55.9D         2.0U
 37.001  ENDIF

 37.002  HEAD         -2
 37.003  HEAD
 37.004  CALL         Sub Reset /LO
 37.005  M8902        *
 37.006  8902         *                                                 S
 37.007  END
