﻿© 2009 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8902A Cal Factor Utility
DATE:                  2009-03-04 07:12:17
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       221
CONFIGURATION:         HP 8902A
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8902A (11722A), 8902S (11792A)
#
#  Source(s):
#        HP 8902A Measuring Receiver, Operation and Calibration Manual,
#        HP Part No. 08902-90029, November 1994, Section 3, Operation,
#        "RF Power Calibration Factor Entry Example Program"
#
#        Agilent 8902A Measuring Receiver, Product Note, "Operation of the
#        Agilent 8902A Measuring Receiver for Microwave Frequencies",
#        Agilent Technologies Part No. 5968-6296E, September 2000
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub 8902A Enter Cal Factors
#        Sub 8902A Review Cal Factors
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The Procedure was tested using:
#
#        Model No.    : 8902A
#        Serial No.   : 3226A03346
#        Options      : None
#        Firmware Rev.: 94.1991
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
#  This procedure is used to download 11722A/11792A Sensor Module or
#  8480-series Power Sensor calibration factors to an 8902A Measuring
#  Receiver.
#
#  Rules:
#        RF Frequency Range:              0-42 GHz RF Frequency
#        Frequency Resolution:            50 kHz
#        Cal Factor Range:                40-120%
#        Cal Factor Resolution:           0.1%
#        Maximum number of entries/table: 17, 1st ("Normal") table
#                                         23, 2nd ("Frequency Offset") table
#
#  To streamline entry, the calling procedure may optionally specify the
#  sensor desired using the following example:
#
#  Global input variables:
#
#    @8902CalFactorAction: "Review", "Enter", undefined
#    @8902CalFactorTable:  "Normal", "FreqOffset", undefined
#    @8902SensorModule:    "11722A", "11792A", undefined
#
#  When either of the these variables is undefined when the subprocedure
#  is called.  The operator is prompted for the value.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  HEAD         8902A CAL FACTOR TABLE INFORMATION
# Preset the 8902A.
  1.002  IEEE         [@8902]41.0SP[D1000]
  1.003  MATH         @Abort = 0;
  1.004  MATH         IsVarAction = ISVAR("@8902CalFactorAction")
  1.005  MATH         IsVarTbl    = ISVAR("@8902CalFactorTable")
  1.006  MATH         IsVarSM     = ISVAR("@8902SensorModule")

  1.007  IF           NOT(IsVarTbl)|| NOT(IsVarSM)
  1.008  DISP         The 8902A supports two Cal Factor tables: a "Normal"
  1.008  DISP         table and a "Frequency Offset" table. Typically, the
  1.008  DISP         Normal table is used for a stand-alone unit while the
  1.008  DISP         Frequency Offset table is used in conjunction with an
  1.008  DISP         HP 11793A Microwave Converter (8902S system).
  1.008  DISP
  1.008  DISP         Either table may be used with the 11722A, 11792A, or
  1.008  DISP         8480-series Power Sensor calibration factors.
  1.008  DISP
  1.008  DISP         This utility allows the operator to enter new or
  1.008  DISP         review existing 11722A/11792A Sensor Module or 8480
  1.008  DISP         series Power Sensor calibration factors into either
  1.008  DISP         available table (Normal or Frequency Offset).
  1.009  ENDIF

# Determine cal factor table (Normal or Frequency Offset).
  1.010  IF           IsVarTbl
  1.011  MATH         T = @8902CalFactorTable

  1.012  IF           NOT(ZCMPI(T, "Normal")) && NOT(ZCMPI(T, "FreqOffset"))
  1.013  HEAD         -2 ERROR IN CALLING PROCEDURE
  1.014  DISP         @8902CalFactorTable must be "Normal" or "FreqOffset".
  1.015  HEAD         -2
  1.016  MATH         @Abort = 1
  1.017  END
  1.018  ENDIF

  1.019  ELSE
  1.020  MATH         Id = LBNEW("8902A")
  1.021  MATH         LBTEXT(Id, "Select cal factor table.")
  1.022  MATH         LBCONF(Id, "+SelReq,+term,-border")
  1.023  MATH         LBADDV(Id, "Normal", "Normal")
  1.024  MATH         LBADDV(Id, "Frequency Offset", "FreqOffset")
  1.025  MATH         LBSHOW(Id)

  1.026  IF           FreqOffset
  1.027  MATH         @8902CalFactorTable = "FreqOffset"
  1.028  ELSE
  1.029  MATH         @8902CalFactorTable = "Normal"
  1.030  ENDIF

  1.031  ENDIF

  1.032  MATH         Table = @8902CalFactorTable

# Determine sensor module (11722A or 11792A).
  1.033  IF           IsVarSM
  1.034  MATH         SM = @8902SensorModule

  1.035  IF           NOT(ZCMPI(SM, "11722A")) && NOT(ZCMPI(SM, "11792A"))
  1.036  HEAD         -2 ERROR IN CALLING PROCEDURE
  1.037  DISP
  1.037  DISP         @8902SensorModule must be one of the following:
  1.037  DISP
  1.037  DISP         [32] "11722A" or
  1.037  DISP         [32] "11792A"
  1.038  MATH         @Abort = 1
  1.039  END
  1.040  ENDIF

  1.041  MATH         Table = @8902CalFactorTable
  1.042  ELSE
  1.043  MEM2         =8902A [V Table] Table
  1.044  MATH         Id = LBNEW(MEM2)
  1.045  MATH         LBTEXT(Id, "Select sensor module.")
  1.046  MATH         LBCONF(Id, "+SelReq,+term,-border")
  1.047  MATH         LBADD(Id, "11722A")
  1.048  MATH         LBADD(Id, "11792A")

  1.049  IF           ZCMPI(Table, "FreqOffset")
  1.050  MATH         LBSEL(Id, "11792A")
  1.051  ENDIF

  1.052  MATH         LBSHOW(Id)
  1.053  MATH         @8902SensorModule = lbGetSel(Id, 1)
  1.054  MATH         SM = @8902SensorModule
  1.055  ENDIF

# Determine action (Review or Enter).
  1.056  IF           IsVarAction
  1.057  MATH         L[1] = ZCMPI(@8902CalFactorAction, "Review")
  1.058  MATH         L[2] = ZCMPI(@8902CalFactorAction, "Enter")

  1.059  IF           NOT(L[1]) && NOT(L[2])
  1.060  HEAD         -2 ERROR IN CALLING PROCEDURE
  1.061  DISP         @8902CalFactorAction must be "Review" or "Enter".
  1.062  HEAD         -2
  1.063  MATH         @Abort = 1
  1.064  END
  1.065  ENDIF

  1.066  MATH         Action = @8902CalFactorAction
  1.067  ELSE
  1.068  MEM2         =8902A [V Table] Table: [V SM]
  1.069  MATH         Id = LBNEW(MEM2)
  1.070  MATH         LBTEXT(Id, "Select desired action.           ")
  1.071  MATH         LBCONF(Id, "+SelReq,+term,-border")
  1.072  MATH         LBADD(Id, "Review")
  1.073  MATH         LBADD(Id, "Enter")
  1.074  MATH         LBSHOW(Id)
  1.075  MATH         Action = lbGetSel(Id, 1)
  1.076  ENDIF

# Routine to upload cal factors to the 8902A follows.
  1.077  IF           ZCMPI(Action, "Enter")
  1.078  CALL         Sub 8902A Enter Cal Factors
  1.079  ENDIF

  1.080  IF           @Abort
  1.081  END
  1.082  ENDIF

  1.083  DO
  1.084  CALL         Sub 8902A Review Cal Factors

  1.085  IF           NOT(@8902CalFactorsOk) && NOT(@Abort)
  1.086  CALL         Sub 8902A Enter Cal Factors
  1.087  ENDIF

  1.088  UNTIL        @8902CalFactorsOk || @Abort

  1.089  END
