﻿© 2008 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8902A Enter Cal Factors
INSTRUMENT:            Sub 8902A Review Cal Factors
DATE:                  2009-03-02 14:49:51
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       334
CONFIGURATION:         HP 8902A
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8902A (11722A), 8902S (11792A)
#
#  Source(s):
#        HP 8902A Measuring Receiver, Operation and Calibration Manual,
#        HP Part No. 08902-90029, November 1994, Section 3, Operation,
#        "RF Power Calibration Factor Entry Example Program"
#
#        Agilent 8902A Measuring Receiver, Product Note, "Operation of the
#        Agilent 8902A Measuring Receiver for Microwave Frequencies",
#        Agilent Technologies Part No. 5968-6296E, September 2000
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
#  This procedure is used to download 11722A/11792A Sensor Module or
#  8480-series Power Sensor calibration factors to an 8902A Measuring
#  Receiver.
#
#  Rules:
#        RF Frequency Range:              0-42 GHz RF Frequency
#        Frequency Resolution:            50 kHz
#        Cal Factor Range:                40-120%
#        Cal Factor Resolution:           0.1%
#        Maximum number of entries/table: 17, 1st ("Normal") table
#                                         23, 2nd ("Frequency Offset") table
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Check input global variables.
  1.001  MATH         L[1] = ZCMPI(@8902SensorModule, "11722A")
  1.002  MATH         L[2] = ZCMPI(@8902SensorModule, "11792A")
  1.003  MATH         SensorModuleOk = L[1] || L[2]

  1.004  MATH         L[1] = ZCMPI(@8902CalFactorTable, "Normal")
  1.005  MATH         L[2] = ZCMPI(@8902CalFactorTable, "FreqOffset")
  1.006  MATH         TableOk = L[1] || L[2]

  1.007  IF           NOT(SensorModuleOk) || NOT(TableOk)
  1.008  HEAD         -2 ERROR IN CALLING PROCEDURE

  1.009  IF           NOT(SensorModuleOk)
  1.010  DISP         @8902SensorModule must be "11722A" or "11792A".
  1.011  ENDIF

  1.012  IF           NOT(TableOk)
  1.013  DISP         @8902CalFactorTable must be "Normal" or "FreqOffset"".
  1.014  ENDIF

  1.015  HEAD         -2
  1.016  MATH         @Abort = 1
  1.017  END
  1.018  ENDIF

  1.019  MATH         SM     = @8902SensorModule
  1.020  MATH         Table  = @8902CalFactorTable
  1.021  MATH         @Abort = 0
  1.022  JMPL         ENTER_CAL_FACTORS            PSUBI("Enter")
  1.023  JMPL         REVIEW_CAL_FACTORS           PSUBI("Review")
  1.024  END

  1.025  EVAL   Increment step number

# =====  Sub 8902A Enter Cal Factors  =======================================

  2.001  LABEL        ENTER_CAL_FACTORS
  2.002  HEAD         ENTER CAL FACTORS

  2.003  IF           ZCMP(Table, "Normal")
  2.004  MATH         MaxCalFactors = 17
  2.005  ELSE         ;           "FreqOffset")
  2.006  MATH         MaxCalFactors = 23
  2.007  ENDIF

  2.008  DO

  2.009  HEAD         -2 Number of [V SM] Cal Factors
  2.010  MEMI         Enter the number of [V SM] cal factors to be entered
  2.010  MEMI         into the cal factor [V Table] table:
  2.010  MEMI
  2.010  MEMI         Note, this is the total of the reference cal factor plus
  2.010  MEMI         cal factors for each discrete frequency.
  2.011  MATH         NumCalFactorsOk = (MEM <= MaxCalFactors)

  2.012  IF           NOT(NumCalFactorsOk)
  2.013  OPBR         -z You have exceeded the maximum number of cal factors
  2.013  OPBR         allowed for the [V Table] Cal Factor table.
  2.013  OPBR
  2.013  OPBR         [V Table] table: [V MaxCalFactors] cal factors MAX
  2.013  OPBR         (including ReferenceCal Factor)
  2.013  OPBR
  2.013  OPBR         Do you wish to re-enter the number of cal factors?
  2.014  MATH         @Abort = NOT(MEM1)
  2.015  ENDIF

  2.016  UNTIL        NumCalFactorsOk || @Abort

  2.017  HEAD         -2

  2.018  IF           @Abort
  2.019  HEAD         -2
  2.020  END
  2.021  ENDIF

  2.022  MATH         NumCalFactors = MEM

# Determine frequency input units.
  2.023  MATH         Id = LBNEW("8902A")
  2.024  MATH         LBTEXT(Id, "Select frequency units.")
  2.025  MATH         LBCONF(Id, "+SelReq,+term,-border")
  2.026  MATH         LBADDV(Id, "megahertz (MHz)", "MHz")
  2.027  MATH         LBADDV(Id, "gigahertz (GHz)", "GHz")
  2.028  MATH         LBSHOW(Id)

  2.029  IF           MHz
  2.030  MATH         FreqUnits = "MHz"
  2.031  ELSE
  2.032  MATH         FreqUnits = "GHz"
  2.033  ENDIF

  2.034  HEAD         -2 [V SM] Cal Factor Entry
  2.035  DISP         Upon selecting "Advance," the non-volatile cal factor
  2.035  DISP         table will be cleared, causing "Error 15" to be shown
  2.035  DISP         on the 8902A display.  Error 15 will continue to be
  2.035  DISP         shown, following the entry of each cal factor, until
  2.035  DISP         all cal factors are entered.

  2.036  IF           ZCMP(Table, "FreqOffset")
# Invoke 27.1 Special to allow subsequent entry of cal factors into the 8902A
# Frequency Offset Cal Factor table.
  2.037  IEEE         [@8902]IP27.1SP[D1000]
  2.038  ENDIF

# Set to RF POWER mode & clear the non-volatile cal factor storage table.
  2.039  IEEE         [@8902]M4T037.9SP[D1000]

  2.040  HEAD         -2 [V SM] Reference Cal Factor

  2.041  DO
  2.042  MEMI         Enter [V SM] (50 MHz) Reference Cal Factor (in %):
  2.043  UNTIL        (MEM >= 50) && (MEM <= 100)

  2.044  MATH         RefCalFactor = FMT(MEM, "%6.1f")
  2.045  IEEE         [@8902]37.3SP[V RefCalFactor]CF[D1000]

  2.046  HEAD         -2 [V SM] Cal Factors
  2.047  MATH         n = 1; U = FreqUnits

  2.048  IF           ZCMP(SM, "11722A")
  2.049  MATH         MinFreqMHz = 0.1E+6; MaxFreqMHz = 1300E+6
  2.050  ELSE         ;        "11792A")
  2.051  MATH         MinFreqMHz = 50E+6; MaxFreqMHz = 26500E+6
  2.052  ENDIF

  2.053  IF           ZCMPI(FreqUnits, "MHz")
  2.054  MATH         Min = MinFreqMHz; Max = MaxFreqMHz
  2.055  ELSE
  2.056  MATH         Min = MinFreqMHz / 1000; Max = MaxFreqMHz / 1000
  2.057  ENDIF

# Enter cal factors...
  2.058  DO

  2.059  DO
  2.060  MEMI         Enter frequency for [V SM] Cal Factor #[V n] in [V U]:

# Convert gigahertz to megahertz for entry into table.
  2.061  IF           ZCMPI(Units, "GHz")
  2.062  MATH         MEM = MEM * 1000
  2.063  ENDIF

  2.064  MATH         FreqOk = (MEM >= MinFreqMHz) && (MaxFreqMHz <= 100)

  2.065  IF           NOT(FreqOk)
  2.066  DISP         Frequency must be between [V Min] and [V Max] [V U].
  2.067  ENDIF

  2.068  UNTIL        FreqOk

  2.069  MATH         FreqMHz = FMT(MEM, "%7.2f")

  2.070  DO
  2.071  MEMI         Enter Cal Factor (in %) for [V Freq] [V Units]:
  2.072  MATH         CalFactorOk = (MEM >= 50) && (MEM <= 100)

  2.073  IF           NOT(CalFactorOk)
  2.074  DISP         Cal Factor must be between 50 and 100 %.
  2.075  ENDIF

  2.076  UNTIL        CalFactorOk

  2.077  MATH         CF = FMT(MEM, "%6.1f")
  2.078  IEEE         [@8902]37.3SP[V FreqMHz]MZ[V CF]CF[D1000]
  2.079  MATH         n = n + 1
  2.080  UNTIL        n >= NumCalFactors

  2.081  HEAD         -2
  2.082  HEAD
  2.083  8902         *                                                 S
  2.084  END

  2.085  EVAL   Increment step number

# =====  Sub 8902A Review Cal Factors  ======================================

  3.001  LABEL        REVIEW_CAL_FACTORS
  3.002  HEAD         REVIEW CAL FACTORS
# Routine to download cal factors from the 8902A for review follows.

# If sensor model is a 11792A...
  3.003  IF           ZCMP(Table, "FreqOffset")
# Invoke 27.1 Special to allow subsequent reading of cal factors from the
# 8902A Frequency Offset Cal Factor table.
  3.004  IEEE         [@8902]IP27.1SP[D1000]
  3.005  MATH         FreqUnits = "GHz"
  3.006  ELSE
  3.007  MATH         FreqUnits = "MHz"
  3.008  ENDIF

# Set to RF POWER mode.
  3.009  IEEE         [@8902]M4T0[D1000]
# Query for number of frequency/cal factor pairs currently stored in table.
  3.009  IEEE         [@8902][TERM LF]M4T037.4SP[I][D1000]
# Store number of frequency/cal factor pairs currently stored in table.
  3.010  MATH         NumCalFactors = MEM

  3.011  MEM2         =[V Table]: [V SM]
  3.012  MATH         Id = LBNEW(MEM2)
  3.013  MATH         LBCONF(Id, "-border")

  3.014  MEM2         =FREQ [V FreqUnits]  CAL FACTOR %
  3.015  MATH         LBTEXT(Id, MEM2)
  3.016  MATH         n = 1

# Retrieve cal factors...
  3.017  DO
  3.018  HEAD         -2 Retrieving [V Table] Cal Factor #[V n]
  3.019  IEEE         [@8902][TERM LF]37.6SPFR[I]
  3.020  MATH         MEM = MEM / 1E+6

  3.021  IF           ZCMPI(FreqUnits, "MHz")

  3.022  IF           MEM < 1.0
  3.023  MATH         Freq = FMT(MEM, "%4.2f") & " "
  3.024  ELSEIF       MEM < 10
  3.025  MATH         Freq = FMT(MEM, "%3.1f") & "   "
  3.026  ELSEIF       MEM < 100
  3.027  MATH         Freq = FMT(MEM, "%2.0f") & "    "
  3.028  ELSEIF       MEM < 1000
  3.029  MATH         Freq = FMT(MEM, "%3.0f") & "  "
  3.030  ELSE
  3.031  MATH         Freq = FMT(MEM, "%4.0f")
  3.032  ENDIF

  3.033  ELSE
  3.034  MATH         MEM = MEM / 1000

  3.035  IF           MEM < 10
  3.036  MATH         Freq = "  " & FMT(MEM, "%3.1f")
  3.037  ELSE
  3.038  MATH         Freq = FMT(MEM, "%4.1f")
  3.039  ENDIF

  3.040  ENDIF

  3.041  IEEE         [@8902][TERM LF]CF[I]
  3.042  MATH         CF = FMT(MEM, "%5.1f")
  3.043  MEM2         =      [V Freq]             [V CF]
  3.044  MATH         LBTEXT(Id, MEM2)

# Increment frequency/cal factor pair counter.
  3.045  MATH         n = n + 1
  3.046  UNTIL        n >= NumCalFactors

  3.047  HEAD         -2 Retrieving [V Table] Reference Cal Factor
  3.048  IEEE         [@8902][TERM LF]37.5SPCF[I]
  3.049  MATH         LBTEXT(Id, " ")
  3.050  MEM2         =REF CAL FAC:     [MEM] %
  3.051  MATH         LBTEXT(Id, MEM2)

  3.052  HEAD         -2
  3.053  MATH         LBTEXT(Id, " ")
  3.054  MATH         LBTEXT(Id, "Are these correct?")
  3.055  MATH         lbButton(Id, "Yes")
  3.056  MATH         lbButton(Id, "No")
  3.057  MATH         Op = LBSHOW(Id)
  3.058  MATH         @8902CalFactorsOk = (Op == 1)

  3.059  HEAD
  3.060  8902         *                                                 S
  3.061  END

