﻿© Fluke Corporation. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Initialize /HFCTR
INSTRUMENT:            Sub Reset /HFCTR
INSTRUMENT:            Sub Measure /HFCTR
INSTRUMENT:            Sub Setup /HFCTR
INSTRUMENT:            Sub Read /HFCTR
DATE:                  2007-12-14
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       248
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 7.2 or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        user_config_instr.ini
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  Example Usage:
#
#    Initialize HF Counter parameters
#
#      CALL         Sub Initialize /HFCTR
#
#  Parameters        Values
#  ----------------  ---------------------------------------------------------
#  @HFCTR_Func       FreqChHF
#
#  @HFCTR_MeasTime   <NR3>[][<prefix>]s
#
#  @HFCTR_ROSC       Int | Ext
#
#
#  Example Usage:
#
#    Reset
#
#      CALL         Sub Reset /HFCTR
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INITIALIZE                   PSUBI("Initialize")
  1.002  JMPL         RESET                        PSUBI("Reset")
  1.003  JMPL         SETUP                        PSUBI("Measure")
  1.004  JMPL         SETUP                        PSUBI("Setup")
  1.005  JMPL         READ                         PSUBI("Read")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =============================== Initialize =================================

  2.001  LABEL        INITIALIZE
# Get and store device name.
  2.002  MATH         @HFCTR_DevName = INSTR("HFCTR")

# Get and store programming section name.
  2.003  MATH         Parameter = "ProgSecName"
  2.004  MATH         @HFCTR_ProgSecName = RINFE(@HFCTR_DevName, Parameter)

# Get and store FSC.
  2.005  MATH         @HFCTR_FSC = RINFE(@HFCTR_ProgSecName, "FSC")

# Get and store terminal names.
  2.006  MATH         @HFCTR_ChHF   = RINFE(@HFCTR_ProgSecName, "ChHF")
  2.007  MATH         @HFCTR_RefIn  = RINFE(@HFCTR_ProgSecName, "RefIn")
  2.008  MATH         @HFCTR_RefOut = RINFE(@HFCTR_ProgSecName, "RefOut")
  2.009  MATH         @HFCTR_ExtArm = RINFE(@HFCTR_ProgSecName, "ExtArm")

# Initialize parameters to the empty string (unset).
  2.010  MATH         @HFCTR_Func     = ""
  2.011  MATH         @HFCTR_MeasTime = ""
  2.012  MATH         @HFCTR_ROSC     = ""
# Unset flag to trigger operator message to manually select reference source.
  2.013  MATH         @HFCTR_ROSC_Set = 0

# Get programming string for RESET FSC.
  2.014  MATH         ResetCmd = RINF(@HFCTR_ProgSecName, "ResetFSC")

# If RESET_FSC is defined, establish the RESET FSC.
  2.015  IF           NOT(EMPTY(ResetCmd))

  2.016  IF           ZCMPI(ResetCmd, "[SDC]")
  2.017  RESET        [@HFCTR][SDC]
  2.018  ELSE
  2.019  RESET        [@HFCTR][V ResetCmd]
  2.020  ENDIF

  2.021  ENDIF

# See if input termination other than EOI is specified.
  2.022  MATH         InputTerm = RINF(@HFCTR_ProgSecName, "TERM")

# See CR or LF termination was specified...
  2.023  IF           ZCMPI(InputTerm, "CR")
  2.024  IEEE         [@HFCTR][TERM CR]
  2.025  ELSEIF       ZCMPI(InputTerm, "LF")
  2.026  IEEE         [@HFCTR][TERM LF]
  2.027  ENDIF

  2.028  END

  2.029  EVAL   Increment step number

# ================================= Reset ====================================

  3.001  LABEL        RESET
  3.002  MATH         @HFCTR_Cmd = RINFE(@HFCTR_ProgSecName, "Reset")
  3.003  CALL         Sub Send Command /HFCTR
  3.004  END

  3.005  EVAL   Increment step number

# ============================== Setup or Measure ============================

  4.001  LABEL        SETUP

# -----  Function

  4.002  MATH         @HFCTR_Cmd = RINFE(@HFCTR_ProgSecName, @HFCTR_Func)
  4.003  CALL         Sub Send Command /HFCTR

# -----  Reference Oscillator

  4.004  IF           NOT(EMPTY(@HFCTR_ROSC))

  4.005  IF           ZCMPI(@HFCTR_ROSC, "Int")
  4.006  MATH         RefOsc = "RefOscInt"
  4.007  ELSE
  4.008  MATH         RefOsc = "RefOscExt"
  4.009  ENDIF

  4.010  MATH         RefSelect = RINF(@HFCTR_ProgSecName, "RefSelect")

  4.011  IF           ZCMPI(RefSelect, "Manual")

  4.012  IF           NOT(@HFCTR_ROSC_Set)
  4.013  MATH         Switch = RINFE(@HFCTR_ProgSecName, "RefOscSwitch")
  4.014  MATH         Setting = RINFE(@HFCTR_ProgSecName, RefOsc)
  4.015  DISP         Set [V @HFCTR_DevName] [V Switch] switch to [V Setting].
  4.016  MATH         @HFCTR_ROSC_Set = 1
  4.017  ENDIF        ; Prompt to set Reference Oscillator switch

  4.018  ELSEIF       ZCMPI(RefSelect, "Auto")
#                     Automatic selection.  Nothing to do.
  4.019  ELSE
  4.020  MATH         @HFCTR_Cmd = RINFE(@HFCTR_ProgSecName, RefOsc)
  4.021  CALL         Sub Send Command /HFCTR
  4.022  ENDIF

  4.023  ENDIF        ; IF Reference Oscillator

# -----  Measuring Time

  4.024  MATH         ModeStr = RINF(@HFCTR_ProgSecName, "MeasTime")

# If mode string was found, use it. If not, use default and skip.
  4.025  IF           NOT(EMPTY(ModeStr))

  4.026  IF           NOT(EMPTY(@HFCTR_MeasTime))
# Convert to base units and insert in programming string.
  4.027  MATH         MeasTime = BASE(@HFCTR_MeasTime)
  4.028  MATH         MeasTimeCmd = RINFE(@HFCTR_ProgSecName, "MeasTime")
  4.029  MATH         @HFCTR_Cmd = REPL("<val>", MeasTime, MeasTimeCmd)
  4.030  CALL         Sub Send Command /HFCTR
  4.031  ENDIF

  4.032  ENDIF

# Exit here if Setup.
  4.033  IF           PSUBI("Setup")
  4.034  END
  4.035  ENDIF

# Drop through for Measure.

# ============================== Read or Measure ============================

  4.036  LABEL        READ
# See if there is an initiate command.
  4.037  MATH         @HFCTR_Cmd = RINF(@HFCTR_ProgSecName, "Initiate")

# If there is an initiate command, send it.
  4.038  IF           NOT(EMPTY(@HFCTR_Cmd))
  4.039  CALL         Sub Send Command /HFCTR
  4.040  ENDIF

# See if there is an input terminator.
  4.041  MATH         InputTerm = RINF(@HFCTR_ProgSecName, "InputTerminator")

  4.042  IF           NOT(ZCMP(InputTerm, ""))

  4.043  IF           ZCMPI(InputTerm, "CR")
  4.044  IEEE         [TERM CR]
  4.045  ELSEIF       ZCMPI(InputTerm, "LF") || ZCMPI(InputTerm, "CRLF")
  4.046  IEEE         [TERM LF]
  4.047  ELSE
  4.048  DISP         Flexible driver "HFCTR" does not
  4.048  DISP         support "InputTerminator = [V InputTerm]"
  4.048  DISP         in [91][V @HFCTR_ProgSecName][93] section of
  4.048  DISP         "user_config_instr.ini".
  4.049  ENDIF

  4.050  ENDIF

# See if there is a fetch command.
  4.051  MATH         @HFCTR_Cmd = RINF(@HFCTR_ProgSecName, "Fetch")

# If there is no fetch command simply get the reading.
  4.052  IF           EMPTY(@HFCTR_Cmd)
  4.053  IEEE         [@HFCTR][I]
# Otherwise send the fetch command and get the reading.
  4.054  ELSEIF       ZCMPI(@HFCTR_FSC, "SCPI")
  4.055  SCPI         [@HFCTR][V @HFCTR_Cmd][I]
  4.056  ELSEIF       ZCMPI(@HFCTR_FSC, "IEEE2")
  4.057  IEEE2        [@HFCTR][V @HFCTR_Cmd][I]
  4.058  ELSE
  4.059  IEEE         [@HFCTR][V @HFCTR_Cmd][I]
  4.060  ENDIF

  4.061  END
