﻿© Fluke. All Rights Reserved.                               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Initialize /LO
INSTRUMENT:            Sub Reset /LO
INSTRUMENT:            Sub Output Off /LO
INSTRUMENT:            Sub Apply /LO
INSTRUMENT:            Sub Setup /LO
DATE:                  2011-07-25 14:06:26
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       260
CONFIGURATION:         Local Oscillator
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, CAD
#
#  Compatibility:
#        MET/CAL 7.2 or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        user_config_instr.ini
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  Parameters       Values
#  ---------------  ---------------------------------------------------------
#  @LO_Freq          <NR3>[][<prefix>]Hz
#
#  @LO_Ampl          <NR3>[]dBm
#
#  @LO_ROSC *        Int | Ext
#
#  NOTES:
#  * Manual selection prompts for rear panel switches will ONLY be displayed
#    when explicitly requesting "Int" or "Ext".  Leaving @LO_ROSC blank
#    after calling Sub Initialize will NOT prompt the operator for a change.
#
#  Example Usage:
#
#      CALL         Sub Initialize /LO
#      CALL         Sub Reset /LO
#      CALL         Sub Output Off /LO
#
#      MATH         @LO_Freq = "2120.53 MHz"
#      MATH         @LO_Ampl = "+8 dBm"
#      CALL         Sub Apply /LO
#
#      CALL         Sub Output Off /LO
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INITIALIZE                   PSUBI("Initialize")
  1.002  JMPL         RESET                        PSUBI("Reset")
  1.003  JMPL         OUTPUT_OFF                   PSUBI("Output Off")
  1.004  JMPL         SETUP                        PSUBI("Setup")
  1.005  JMPL         SETUP                        PSUBI("Apply")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub Initialize /LO  ================================================

  2.001  LABEL        INITIALIZE
# Get and store:
#   device name
#   converage factor
#   programming section name for looking up programming codes in .ini file.
#   FSC used for IEEE-488 I/O
#   Connection terminal names
  2.002  MATH         @LO_DevName = INSTR("LO")

  2.003  IF           0
  2.004  MATH         @LO_Conf = CONF(@LO_DevName)
  2.005  ENDIF

  2.006  MATH         @LO_ProgSecName = RINFE(@LO_DevName, "ProgSecName")
  2.007  MATH         @LO_FSC     = RINFE(@LO_ProgSecName, "FSC")
  2.008  MATH         @LO_Output  = RINFE(@LO_ProgSecName, "Output50_Ohm")
  2.009  MATH         @LO_RefIn   = RINFE(@LO_ProgSecName, "RefIn")
  2.010  MATH         @LO_RefOut  = RINFE(@LO_ProgSecName, "RefOut")

# Initialize parameters to the empty string (unset).
  2.011  MATH         @LO_CPT      = ""
  2.012  MATH         @LO_Freq     = ""
  2.013  MATH         @LO_Ampl     = ""
  2.014  MATH         @LO_ROSC     = ""

# Check for the flag that triggers operator message to manually select
# frequency reference source.  Initialize variable if does not exist, else
# retain existing switch position.
  2.015  IF           NOT(ISVAR("@LO_ROSC_Set"))
  2.016  MATH         @LO_ROSC_Set = ""
  2.017  ENDIF

# Get programming string for RESET FSC.
  2.018  MATH         ResetCmd = RINF(@LO_ProgSecName, "ResetFSC")

# If ResetFSC is defined, establish the RESET FSC.
  2.019  IF           NOT(EMPTY(ResetCmd))

  2.020  IF           ZCMPI(ResetCmd, "[SDC]")
  2.021  RESET        [@LO][SDC]
  2.022  ELSE
  2.023  RESET        [@LO][V ResetCmd]
  2.024  ENDIF

  2.025  ENDIF

  2.026  END

  2.027  EVAL   Increment step number


# =====  Sub Reset /LO  =====================================================

  3.001  LABEL        RESET

  3.002  MATH         @LO_Cmd = RINFE(@LO_ProgSecName, "Reset")
  3.003  CALL         Sub Send Command /LO
  3.004  END

  3.005  EVAL   Increment step number


# =====  Sub Output Off /LO  ================================================

  4.001  LABEL        OUTPUT_OFF

  4.002  MATH         @LO_Cmd = RINF(@LO_ProgSecName, "OutputOff")

# If "Output_Off" is defined, send the command.
  4.003  IF           NOT(EMPTY(@LO_Cmd))
  4.004  CALL         Sub Send Command /LO
  4.005  ENDIF

  4.006  END

  4.007  EVAL   Increment step number

# =====  Sub Setup /LO  =====================================================

  5.001  LABEL        SETUP

# -----  Frequency  -------------------------------

# Get the command string.
  5.002  MATH         FreqCmd = RINFE(@LO_ProgSecName, "Freq")
# Convert frequency to base units and insert value in programming string.
  5.003  MATH         @LO_Cmd = REPL("<val>", BASE(@LO_Freq), FreqCmd)
  5.004  CALL         Sub Send Command /LO

# -----  Amplitude  -------------------------------

  5.005  MATH         Ampl = BASE(@LO_Ampl); AmplUnits = UNIT(@LO_Ampl)
  5.006  MATH         AmplCmd = ""

  5.007  IF           NOT(ZCMPI(AmplUnits, "dBm"))
  5.008  DISP         LO currently only supports dBm.
  5.009  END
  5.010  ENDIF

# Use discrete command for negative dBm, if one exists.
  5.011  IF           Ampl < 0
  5.012  MATH         AmplCmd = RINF(@LO_ProgSecName, "Ampl_dBmNeg")
  5.013  ELSE
# Otherwise use discrete command for positive dBm, if one exists.
  5.014  MATH         AmplCmd = RINF(@LO_ProgSecName, "Ampl_dBmPos")
  5.015  ENDIF

# Otherwise use the general command.
  5.016  IF           EMPTY(AmplCmd)
  5.017  MATH         AmplCmd = RINFE(@LO_ProgSecName, "Ampl_dBm")
  5.018  ELSE
  5.019  MATH         Ampl = ABS(Ampl)
  5.020  ENDIF

  5.021  MATH         @LO_Cmd = REPL("<val>", Ampl, AmplCmd)
  5.022  CALL         Sub Send Command /LO

# -----  Reference Oscillator  --------------------

  5.023  IF           NOT(EMPTY(@LO_ROSC))

  5.024  IF           ZCMPI(@LO_ROSC, "Int")
  5.025  MATH         RefOsc = "RefOscInt"
  5.026  ELSE
  5.027  MATH         RefOsc = "RefOscExt"
  5.028  ENDIF

  5.029  MATH         RefSelect = RINF(@LO_ProgSecName, "RefSelect")

  5.030  IF           ZCMPI(RefSelect, "Manual")

# Only prompt for switch selection when the desired setting does not match the
# current setting.
  5.031  IF           NOT(ZCMPI(@LO_ROSC, @LO_ROSC_Set))
  5.032  MATH         Switch = RINFE(@LO_ProgSecName, "RefOscSwitch")
  5.033  MATH         Setting = RINFE(@LO_ProgSecName, RefOsc)
  5.034  DISP         Set [V @LO_DevName] [V Switch] switch to [V Setting].
  5.035  MATH         @LO_ROSC_Set = @LO_ROSC
  5.036  ENDIF        ; Prompt to set Reference Oscillator switch

  5.037  ELSEIF       ZCMPI(RefSelect, "Auto")
# Automatic selection; nothing to do.

  5.038  ELSE
  5.039  MATH         @LO_Cmd = RINFE(@LO_ProgSecName, RefOsc)
  5.040  CALL         Sub Send Command /LO
  5.041  ENDIF

  5.042  ENDIF        ; IF Reference Oscillator

# Exit here if Setup, ensuring output is off, if possible.
  5.043  IF           PSUBI("Setup")
  5.044  MATH         @LO_Cmd = RINF(@LO_ProgSecName, "OutputOff")

# If "Output_Off" is defined, send the command.
  5.045  IF           NOT(EMPTY(@LO_Cmd))
  5.046  CALL         Sub Send Command /LO
  5.047  ENDIF

  5.048  END
  5.049  ENDIF

# Drop through for Apply.

# =====  Sub Apply /LO  =====================================================

# -----  Output On  -------------------------------

  5.050  MATH         @LO_Cmd = RINF(@LO_ProgSecName, "OutputOn")

# If "Output_On" is defined, send the command.
  5.051  IF           NOT(EMPTY(@LO_Cmd))
  5.052  CALL         Sub Send Command /LO
  5.053  ENDIF

  5.054  END
