﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Specify HP856x Model Number
INSTRUMENT:            Sub Specify HP856X Frequency Response
INSTRUMENT:            Sub Specify HP856X Log Scale Fidelity 300
INSTRUMENT:            Sub Specify HP856X Log Scale Fidelity 100
INSTRUMENT:            Sub Specify HP856X Log Scale Fidelity
INSTRUMENT:            Sub Specify HP856X Lin Scale Fidelity
DATE:                  2013-12-02 09:58:55
AUTHOR:                Fluke
REVISION:              $Revision: 5844 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       233
CONFIGURATION:         HP 8560
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Compatibility:
#        MET/CAL 7.3.38 or later
#
#  Additional Equipment Required:
#        None
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
# This multi-faceted procedure performs several functions pertinent to the
# use of an HP 856x() spectrum analyzer as a reference.
#
# 1. It identifies the specific model by suffix and saves it to variable.dat
#    for future recall.
# 2. It assigns the correct accuracy file mode string for frequency response
#    specification look up based on model.
# 3. It assigns the correct accuracy file mode string for log scale fidelity
#    (300 Hz resolution bandwidth) specification look up based on model.
# 4. It assigns the correct accuracy file mode string for log scale fidelity
#    (100 Hz resolution bandwidth) specification look up based on model.
# 5. It assigns the correct accuracy file mode string for log scale fidelity
#    specification look up based on model.
# 6. It assigns the correct accuracy file mode string for linear scale
#    fidelity.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         @Abort = 0

  1.002  JMPL         MODEL_ID                     PSUBI("Model")
  1.003  JMPL         FREQUENCY_RESPONSE           PSUBI("Frequency")
  1.004  JMPL         LOG_SCALE_FIDELITY_300       PSUBI("Fidelity 300")
  1.005  JMPL         LOG_SCALE_FIDELITY_100       PSUBI("Fidelity 100")
  1.006  JMPL         LOG_SCALE_FIDELITY           PSUBI("Log Scale")
  1.007  JMPL         LIN_SCALE_FIDELITY           PSUBI("Lin Scale")
  1.008  DISP         Subprocedure not found!
  1.009  END

  1.010  EVAL   Increment test number

# =====  Sub Specify HP856x Model Number  ===================================

  2.001  LABEL        MODEL_ID
# Query 8560-series analyzer ID string to get model data.
  2.002  IEEE         [@8560]ID?[I$]

  2.003  IF           FIND(MEM2, "HP8560A", 1) || FIND(MEM2, "HP8560B", 1)
# For accuracy file purposes, an 8560B is the same as an 8560A.
  2.004  MATH         S[1] = PUTV("Spec_An_Model", "HP8560A")
  2.005  ELSEIF       FIND(MEM2, "HP8561A", 1) || FIND(MEM2, "HP8561B", 1)
# For accuracy file purposes, an 8561A or 8561B is the same as an 8560A.
  2.006  MATH         S[1] = PUTV("Spec_An_Model", "HP8560A")
  2.007  ELSEIF       FIND(MEM2, "HP8562A", 1) || FIND(MEM2, "HP8563A", 1)
# For accuracy file purposes, an 8562A or 8563A is the same as an 8560A.
  2.008  MATH         S[1] = PUTV("Spec_An_Model", "HP8560A")
  2.009  ELSEIF       FIND(MEM2, "HP8562B", 1)
  2.010  MATH         S[1] = PUTV("Spec_An_Model", "HP8562B")
  2.011  ELSEIF       FIND(MEM2, "HP8560E/EC", 1)
  2.012  MATH         S[1] = PUTV("Spec_An_Model", "HP8560E")
  2.013  ELSEIF       FIND(MEM2, "HP8561E/EC", 1)
  2.014  MATH         S[1] = PUTV("Spec_An_Model", "HP8561E")
  2.015  ELSEIF       FIND(MEM2, "HP8562E/EC", 1)
  2.016  MATH         S[1] = PUTV("Spec_An_Model", "HP8562E")
  2.017  ELSEIF       FIND(MEM2, "HP8563E", 1)
  2.018  MATH         S[1] = PUTV("Spec_An_Model", "HP8563E")
  2.019  ELSEIF       FIND(MEM2, "HP8563E/EC", 1)
  2.020  MATH         S[1] = PUTV("Spec_An_Model", "HP8563E")
  2.021  ELSEIF       FIND(MEM2, "HP8564E/EC", 1)
  2.022  MATH         S[1] = PUTV("Spec_An_Model", "HP8564E")
  2.023  ELSEIF       FIND(MEM2, "HP8565E/EC", 1)
  2.024  MATH         S[1] = PUTV("Spec_An_Model", "HP8565E")
  2.025  ELSE
  2.026  DISP         Unsupported 856x model number: "[MEM2]"
  2.027  MATH         @Abort = 1
  2.028  ENDIF

  2.029  END

  2.030  EVAL   Increment test number

# =====  Sub Specify HP856X Frequency Response  =============================

  3.001  LABEL        FREQUENCY_RESPONSE
  3.002  MATH         MEM2 = GETV("Spec_An_Model")

  3.003  IF           ZCMPI(MEM2, "HP8560A") || ZCMPI(MEM2, "HP8560B")
# For accuracy file purposes, an 8560B is the same as an 8560A.
  3.004  MATH         S[1] = "FREQ RESP dB 8560A"
  3.005  ELSEIF       ZCMPI(MEM2, "HP8560E")
  3.006  MATH         S[1] = "FREQ RESP dB 8560E"
  3.007  ELSEIF       ZCMPI(MEM2, "HP8561A") || ZCMPI(MEM2, "HP8561B")
# For accuracy file purposes, an 8561A is the same as an 8560A.
  3.008  MATH         S[1] = "FREQ RESP dB 8560A"
  3.009  ELSEIF       ZCMPI(MEM2, "HP8561E")
  3.010  MATH         S[1] = "FREQ RESP dB 8561E"
  3.011  ELSEIF       ZCMPI(MEM2, "HP8562A") || ZCMPI(MEM2, "HP8563A")
  3.012  MATH         S[1] = "FREQ RESP dB 8560A"
  3.013  ELSEIF       ZCMPI(MEM2, "HP8562B")
  3.014  MATH         S[1] = "FREQ RESP dB 8562B"
  3.015  ELSEIF       ZCMPI(MEM2, "HP8562E")
  3.016  MATH         S[1] = "FREQ RESP dB 8562E"
  3.017  ELSEIF       ZCMPI(MEM2, "HP8563E")
  3.018  MATH         S[1] = "FREQ RESP dB 8563E"
  3.019  ELSEIF       ZCMPI(MEM2, "HP8564E")
  3.020  MATH         S[1] = "FREQ RESP dB 8564E"
  3.021  ELSEIF       ZCMPI(MEM2, "HP8565E")
  3.022  MATH         S[1] = "FREQ RESP dB 8565E"
  3.023  ELSE
  3.024  DISP         Unsupported 856x model number: "[MEM2]"
  3.025  MATH         @Abort = 1
  3.026  ENDIF

  3.027  END

  3.028  EVAL   Increment test number

# =====  Sub Specify HP856X Log Scale Fidelity 300  =========================

  4.001  LABEL        LOG_SCALE_FIDELITY_300
  4.002  MATH         MEM2 = GETV("Spec_An_Model")

  4.003  IF           FINDI(MEM2, "E", 1) == 0
  4.004  DISP         This parameter is not specified for the model of
  4.004  DISP         spectrum analyzer being used.
  4.004  DISP
  4.004  DISP         Select "Advance" to terminate the procedure.
  4.005  END

  4.006  ELSEIF       ZCMPI(MEM2, "HP8560E") || ZCMPI(MEM2, "HP8561E")
  4.007  MATH         S[1] = "Scale FI LOG 300 E"
  4.008  ELSEIF       ZCMPI(MEM2, "HP8562E") || ZCMPI(MEM2, "HP8563E")
  4.009  MATH         S[1] = "Scale FI LOG 300 E"
  4.010  ELSEIF       ZCMPI(MEM2, "HP8564E") || ZCMPI(MEM2, "HP8565E")
  4.011  MATH         S[1] = "Scale FI LOG 300 E"
  4.012  ELSE
  4.013  DISP         Unsupported 856x model number: "[MEM2]"
  4.014  MATH         @Abort = 1
  4.015  ENDIF

  4.016  END

  4.017  EVAL   Increment test number

# =====  Sub Specify HP856X Log Scale Fidelity 100  =========================

  5.001  LABEL        LOG_SCALE_FIDELITY_100
  5.002  MATH         MEM2 = GETV("Spec_An_Model")

  5.003  IF           FINDI(MEM2, "E", 1) == 0
  5.004  DISP         This parameter is not specified for the model of
  5.004  DISP         spectrum analyzer being used.
  5.004  DISP
  5.004  DISP         Select "Advance" to terminate the procedure.
  5.005  END

  5.006  ELSEIF       ZCMPI(MEM2, "HP8560E") || ZCMPI(MEM2, "HP8561E")
  5.007  MATH         S[1] = "Scale FI LOG 100 E"
  5.008  ELSEIF       ZCMPI(MEM2, "HP8562E") || ZCMPI(MEM2, "HP8563E")
  5.009  MATH         S[1] = "Scale FI LOG 100 E"
  5.010  ELSEIF       ZCMPI(MEM2, "HP8564E") || ZCMPI(MEM2, "HP8565E")
  5.011  MATH         S[1] = "Scale FI LOG 100 E"
  5.012  ELSE
  5.013  DISP         Unsupported 856x model number: "[MEM2]"
  5.014  MATH         @Abort = 1
  5.015  ENDIF

  5.016  END

  5.017  EVAL   Increment test number

# =====  Sub Specify HP856X Log Scale Fidelity  =============================

  6.001  LABEL        LOG_SCALE_FIDELITY
  6.002  MATH         MEM2 = GETV("Spec_An_Model")

  6.003  IF           ZCMPI(MEM2, "HP8560A") || ZCMPI(MEM2, "HP8560B")
  6.004  MATH         S[1] = "Scale FI LOG A"
  6.005  ELSEIF       ZCMPI(MEM2, "HP8561A") || ZCMPI(MEM2, "HP8561B")
  6.006  MATH         S[1] = "Scale FI LOG A"
  6.007  ELSEIF       ZCMPI(MEM2, "HP8562A") || ZCMPI(MEM2, "HP8562B")
  6.008  MATH         S[1] = "Scale FI LOG A"
  6.009  ELSEIF       ZCMPI(MEM2, "HP8563A")
  6.010  MATH         S[1] = "Scale FI LOG A"
  6.011  ELSEIF       ZCMPI(MEM2, "HP8560E") || ZCMPI(MEM2, "HP8561E")
  6.012  MATH         S[1] = "Scale FI LOG E"
  6.013  ELSEIF       ZCMPI(MEM2, "HP8562E") || ZCMPI(MEM2, "HP8563E")
  6.014  MATH         S[1] = "Scale FI LOG E"
  6.015  ELSEIF       ZCMPI(MEM2, "HP8564E") || ZCMPI(MEM2, "HP8565E")
  6.016  MATH         S[1] = "Scale FI LOG E"
  6.017  ELSE
  6.018  DISP         Unsupported 856x model number: "[MEM2]"
  6.019  MATH         @Abort = 1
  6.020  ENDIF

  6.021  END

  6.022  EVAL   Increment test number

# =====  Sub Specify HP856X Lin Scale Fidelity  =============================

  7.001  LABEL        LIN_SCALE_FIDELITY
  7.002  MATH         S[1] = "Scale FI LIN"
  7.003  END
