﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8648D: (2 yr) VER/8902S,8903,8560,LO,LFCTR,HFCTR
DATE:                  2016-06-28 08:22:29
AUTHOR:                Fluke
REVISION:              $Revision: 16374 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       515
CONFIGURATION:         HP 8902A
CONFIGURATION:         HP 8903B
CONFIGURATION:         HP 8560
CONFIGURATION:         Local Oscillator
CONFIGURATION:         Low Frequency Counter
CONFIGURATION:         High Frequency Counter
STANDARD:              HP 11722A
STANDARD:              HP 11792A
=============================================================================
#
#  Procedure Author:
#        DFM
#
#  Source:
#        HP 8648A/B/C/D Operation and Service Guide, Part No. 08648-90048,
#        April 1999
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Flexible Standard(s) Required:
#        Local Oscillator (LO):
#
#          Frequency Range: 11.5 MHz to 2500 MHz, CW
#            Accuracy: ±0.02% (Internal); External Reference capable
#
#          Amplitude: +8 dBm
#            Accuracy: ±1 dB or less
#
#          Example: HP 8340B or equivalent
#
#        LF Counter (LFCTR):
#
#          Frequency Range: 500 kHz to 100 MHz
#            Accuracy: Based on external frequency standard
#
#          Example: Fluke PM 6690/6xx Ch A or equivalent
#
#        HF Counter (HFCTR):
#
#          Frequency Range: 500 MHz to 4 GHz
#            Accuracy: Based on external frequency standard
#
#          Example: Fluke PM 6690/6xx CH C or equivalent
#
#        Frequency Standard:
#
#          Frequency Range: Suitable for use with configured LF & HF counters
#            Accuracy: ±0.001 ppm or better
#
#  Additional Equipment Required:
#        HP/Agilent 11722A Sensor Module
#        HP/Agilent 11792A Sensor Module
#        HP/Agilent 11793A Microwave Converter
#        HP/Agilent 8903B Option 051 (CCITT Weighting filter)
#        HP 8340() Synthesized Sweeper
#        Cable assy., 12", BNC(m)-(m), 50 Ω
#        Cable assy., 24", Type "N"(m)-(m), 50 Ω
#        Cable assy., 36", BNC(m)-(m), 50 Ω, 2 ea.
#        Cable assembly, 24", APC 3.5(f)-(f), 50 Ω
#        Adapter, APC 3.5(f) to Type N (m)
#        Adapter, Type "N"(f) to BNC(m)
#        Adapter, tee, coaxial, BNC(f)-(m)-(f)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  GLOBAL NUMERIC REGISTERS USED:
#
#  Local Numeric Variables:
#       L[1]  = System spectrum analyzer model number
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  8902         *                                                 S
  1.003  8903         *                                                 S
  1.004  8560         *                                                 S
  1.005  IEEE         [@LO]
  1.005  IEEE         [@LFCTR]
  1.005  IEEE         [@HFCTR]
  1.006  STD          HP 11722A
  1.007  STD          HP 11792A
  1.008  ENDIF

  1.009  ASK-   R   Q N              P                            A        V

  1.010  IF           NOT(VERSIONCHECK("8.0"))
  1.011  END
  1.012  ENDIF

  1.013  CALL         Sub Display Copyright
  1.014  CALL         Sub UUT Connection GPIB

  1.015  MATH         @UUT_Manufacturer  = "HEWLETT-PACKARD"
  1.016  MATH         @UUT_Manufacturer2 = "Agilent Technologies"
  1.017  MATH         @UUT_Model         = "8648D"
  1.018  CALL         Sub IEEE-488.2 Identification Query IEEE
  1.019  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.020  JMPL         END                          @Abort

# Query spectrum analyzer for model information.
  1.021  CALL         Sub HP 856x Model Number
  1.022  JMPL         END                          @Abort

  1.023  CALL         Sub Select Failed Test Mode
  1.024  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.025  HEAD         PRELIMINARY INSTRUCTIONS
  1.026  DISP         Prior to beginning verification, a UUT warm-up time
  1.026  DISP         of 30 minutes (minimum) must have been allowed to
  1.026  DISP         elapse.

# Query UUT for system language selection.
  1.027  IEEE         SYST:LANG?[I$]
  1.028  MATH         @SystemLang = MEM2

  1.029  IF           ZCMPI(@SystemLang, "COMP")
# Ensure UUT language is set to SCPI for the remainder of the procedure.
  1.030  IEEE         SYST:LANG "SCPI"
  1.031  ENDIF

  1.032  RESET        *SRE 0;:OUTP:STAT OFF;*OPC?[I!]

# Ensure UUT reset to default conditions prior to beginning tests.
  1.033  SCPI         *RST

# Query UUT for installed timebase option.
  1.034  SCPI         *OPT?[I$]
  1.035  MATH         @Opt1E5 = ZCMPI(FLD(MEM2, 1, ","), "HIGH STABILITY REF")

  1.036  IF           @Opt1E5
  1.037  RSLT         = Option 1E5:      Installed
  1.038  ENDIF

# Test to ensure MET/CAL initialization file parameter "acc_check" = "yes"
  1.039  IF           ZCMPI(INI("startup", "acc_check"), "no")
  1.040  HEAD         INCORRECT MET/CAL® INITIALIZATION FILE SETTING!
  1.041  DISP         The file parameter setting is: "acc_check=no"
  1.041  DISP
  1.041  DISP         For correct procedure execution, this parameter
  1.041  DISP         MUST be set to: "acc_check=yes"
  1.041  DISP
  1.041  DISP         Select "Advance" to terminate the procedure, exit
  1.041  DISP         MET/CAL, change the initialization file parameter,
  1.041  DISP         restart MET/CAL, then restart the procedure.
  1.042  END
  1.043  ENDIF

# An 8561() or higher analyzer is required. If not, advise operator.
  1.044  IF           FIND(@856x_ModelNum, "8561", 1)
  1.045  HEAD         INCORRECT SPECTRUM ANALYZER CONNECTED!
  1.046  DISP         An [V @856x_ModelNum] Spectrum Analyzer is currently
  1.046  DISP         connected to the test system.
  1.046  DISP
  1.046  DISP         In this procedure, an HP/Agilent 8561() or higher
  1.046  DISP         spectrum analyzer is required to perform UUT tests.
  1.046  DISP
  1.046  DISP         Select "Advance" to terminate the procedure, connect
  1.046  DISP         the required model spectrum analyzer, and restart.
  1.047  END
  1.048  ENDIF

  1.049  HEAD         HP 8560 ACCURACY FILE REQUIREMENTS
  1.050  DISP         This procedure requires HP 8560 accuracy file
  1.050  DISP         "8560.acc" revision 1.12 or later.
  1.050  DISP
  1.050  DISP         Please confirm the revision of the accuracy
  1.050  DISP         file in use prior to proceeding.
  1.050  DISP
  1.050  DISP         Visit the website at: http://support.fluke.com
  1.050  DISP         for the latest accuracy file, if necessary.

  1.051  CALL         Sub Initialize /LO
  1.052  CALL         Sub Initialize /LFCTR
  1.053  CALL         Sub Initialize /HFCTR
# Look up instrument name of external frequency reference.
  1.054  MATH         FreqRef = INI("startup", "FreqRefDevName")
# Required timebase uncertainty (in ppm).
  1.055  MATH         @FreqRefAcc = 0.001

  1.056  IF           EMPTY(FreqRef)
  1.057  DISP         No Frequency Reference configured.
  1.057  DISP
  1.057  DISP         Select Configure=>Instrument and ensure that the device
  1.057  DISP         you intend to use as the frequency refenence is
  1.057  DISP         configured.
  1.057  DISP
  1.057  DISP         Then select Configure=>Frequency Reference, and select
  1.057  DISP         that device.
  1.058  END
  1.059  ENDIF

  1.060  HEAD         EQUIPMENT REQUIREMENTS
  1.061  OPBR         -z Do you want to review the list of flexible standards,
  1.061  OPBR         additional equipment and/or accessories required?

  1.062  IF           MEM1
  1.063  HEAD         FLEXIBLE STANDARDS
  1.064  MATH         LF = @LFCTR_Ch1; HF = @HFCTR_ChHF
  1.065  DISP         The minimum use specifications of the following devices,
  1.065  DISP         configured as flexible standards, must be satisfied.
  1.065  DISP
  1.065  DISP         [32]NOMENCLATURE       ALIAS   DEVICE NAME
  1.065  DISP         [32]Local Oscillator   LO      [V @LO_DevName]
  1.065  DISP         [32]LF Counter         LFCTR   [V @LFCTR_DevName] [V LF]
  1.065  DISP         [32]HF Counter         HFCTR   [V @HFCTR_DevName] [V HF]

  1.066  HEAD         -2 Local Oscillator (LO)
  1.067  OPBR         -z LO: [V @LO_DevName]
  1.067  OPBR
  1.067  OPBR         Minimum Use Specifications:
  1.067  OPBR         [32] Frequency Range: 11.5 MHz to 2500 MjHz, CW
  1.067  OPBR         [32]   Accuracy: ±0.02% (Internal); Ext Ref capable
  1.067  OPBR
  1.067  OPBR         [32] Amplitude: +8 dBm
  1.067  OPBR         [32]   Accuracy: ±1 dB or less
  1.067  OPBR
  1.067  OPBR         Does the [V @LO_DevName] satisfy the above Minimum
  1.067  OPBR         Use Specifications?
  1.068  MATH         LO = MEM1

  1.069  HEAD         -2 LF Counter (LFCTR)
  1.070  OPBR         -z LFCTR: [V @LFCTR_DevName]
  1.070  OPBR
  1.070  OPBR         Minimum Use Specifications:
  1.070  OPBR         [32] [V @LFCTR_Ch1] Frequency Range: 500 kHz to 100 MHz
  1.070  OPBR         [32]   Accuracy: Based on external frequency reference
  1.070  OPBR
  1.070  OPBR         Does the [V @LFCTR_DevName] satisfy the above Minimum
  1.070  OPBR         Use Specifications?
  1.071  MATH         LFCTR = MEM1

  1.072  HEAD         -2 HF Counter (HFCTR)
  1.073  OPBR         -z HFCTR: [V @HFCTR_DevName]
  1.073  OPBR
  1.073  OPBR         Minimum Use Specifications:
  1.073  OPBR         [32] [V @HFCTR_ChHF] Frequency Range: 500 MHz to 4 GHz
  1.073  OPBR         [32]   Accuracy: Based on external frequency reference
  1.073  OPBR
  1.073  OPBR         Does the [V @HFCTR_DevName] satisfy the above Minimum
  1.073  OPBR         Use Specifications?
  1.074  MATH         HFCTR = MEM1

  1.075  HEAD         -2 External Frequency Reference
  1.076  OPBR         -z External Frequency Reference: [V FreqRef]
  1.076  OPBR
  1.076  OPBR         Minimum Use Specifications:
  1.076  OPBR         [32]   Accuracy: [V @RefFreqAcc] ppm/year
  1.076  OPBR
  1.076  OPBR         Does the [V FreqRef] satisfy the above Minimum Use
  1.076  OPBR         Specifications?
  1.077  MATH         XREF = MEM1

  1.078  HEAD         -2

  1.079  IF           NOT(LO)
  1.080  DISP         Configured [V @LO_DevName] (Local Oscillator) LO
  1.080  DISP         does not satisfy the Minimum Use Specifications.
  1.081  ENDIF

  1.082  IF           NOT(LFCTR)
  1.083  DISP         Configured [V @LFCTR_DevName] (LF Counter) LFCTR does
  1.083  DISP         not satisfy the Minimum Use Specifications.
  1.084  ENDIF

  1.085  IF           NOT(HFCTR)
  1.086  DISP         Configured [V @HFCTR_DevName] (HF Counter) HFCTR does
  1.086  DISP         not satisfy the Minimum Use Specifications.
  1.087  ENDIF

  1.088  IF           NOT(XREF)
  1.089  DISP         Configured [V FreqRef] External Frequency Reference
  1.089  DISP         does not satisfy the Minimum Use Specifications.
  1.090  ENDIF

  1.091  IF           NOT(LO) || NOT(LFCTR) || NOT(HFCTR) || NOT(XREF)
  1.092  DISP         Procedure aborted.
  1.093  END
  1.094  ENDIF

  1.095  HEAD         ADDITIONAL EQUIPMENT REQUIREMENTS
  1.096  DISP         Additional equipment/accessories required (1 of 2):
  1.096  DISP
  1.096  DISP         - HP/Agilent 11722A Sensor Module
  1.096  DISP         - HP/Agilent 11792A Sensor Module
  1.096  DISP         - HP/Agilent 11793A Microwave Converter, functional
  1.096  DISP         - HP/Agilent 8903B Option 051 (CCITT Weighting filter)
  1.096  DISP         - Cable assembly, 12", BNC(m)-(m), 50 Ω

  1.097  DISP         Additional equipment/accessories required (2 of 2):
  1.097  DISP
  1.097  DISP         - Cable assembly, 24", Type "N"(m)-(m), 50 Ω
  1.097  DISP         - Cable assembly, 36", BNC(m)-(m), 50 Ω, 2 ea.
  1.097  DISP         - Cable assembly, 24", APC 3.5(f)-(f), 50 Ω
  1.097  DISP         - Adapter, APC 3.5(f) to Type N (m)
  1.097  DISP         - Adapter, coaxial, Type "N"(f) to BNC(m), 2 ea.
  1.097  DISP         - Adapter, tee, coaxial, BNC(f)-(m)-(f)
  1.098  ENDIF

  1.099  OPBR         -z This procedure REQUIRES the following for execution:
  1.099  OPBR
  1.099  OPBR         - 8903B Option 051 (CCITT WEIGHTING FILTER) installed in
  1.099  OPBR         [32] the 8903B "Right-Most Optional Plug-In Filter" slot
  1.099  OPBR
  1.099  OPBR         Is the above requirement satisfied?

  1.100  IF           NOT(MEM1)
  1.101  HEAD         HP 8903B DOES NOT CONTAIN REQUIRED FILTER (Option 051)!
  1.102  DISP         PROCEDURE ABORTED!
  1.103  END
  1.104  ENDIF

  1.105  HEAD         CONNECTION PRECAUTIONS
  1.106  OPBR         -z Do you wish to review connector information and
  1.106  OPBR         precautions for the various types of connections
  1.106  OPBR         employed throughout this procedure?

  1.107  IF           MEM1
  1.108  CALL         Sub Connector Precautions (Type N)
  1.109  CALL         Sub Connector Precautions (3.5 mm)
  1.110  ENDIF

  1.111  HEAD         INITIAL CONNECTIONS
  1.112  PIC          8903b_8902s_11792a.jpg

  1.113  DISP         [32]                     NOTE
  1.113  DISP         During the course of the verification, manipulating
  1.113  DISP         the 11792A Sensor Module may cause its connection to
  1.113  DISP         the 11793A Microwave Converter RF INPUT APC 3.5 (f)
  1.113  DISP         jack to work loose. Ensure this connection remains
  1.113  DISP         properly torqued to avoid measurement degradation.

  1.114  HEAD         PRELIMINARY OPERATIONS
  1.115  OPBR         -z Have the Calibration Factors for the Sensor Module
  1.115  OPBR         being used previously been entered into the 8902A?
  1.115  OPBR
  1.115  OPBR         NOTE that BOTH the 11722A and 11792A Sensor Modules
  1.115  OPBR         are required to perform RF Level Accuracy Tests.
  1.115  OPBR
  1.115  OPBR         (Answering "No" will also allow you to review the
  1.115  OPBR         existing cal factors.)

  1.116  IF           NOT(MEM1)
  1.117  MATH         @8902CalFactorAction = "Review"
  1.118  MATH         @8902SensorModule    = "11722A"
  1.119  MATH         @8902CalFactorTable  = "Normal"
  1.120  CALL         Sub 8902A Cal Factor Utility

  1.121  IF           @Abort
  1.122  END
  1.123  ENDIF

  1.124  MATH         @8902SensorModule   = "11792A"
  1.125  MATH         @8902CalFactorTable = "FreqOffset"
  1.126  CALL         Sub 8902A Cal Factor Utility

  1.127  IF           @Abort
  1.128  END
  1.129  ENDIF

  1.130  ENDIF

  1.131  DISP         Connect the 11792A Sensor Module input to the 8902A
  1.131  DISP         RF POWER connector.
  1.132  HEAD         -2 11792A ZERO/CAL
  1.133  M8902        0MH            27.3SP                       H0 L0
  1.134  8902         1mW                          50MH              CP N
  1.135  M8902        *
  1.136  8902         *                                                 S
  1.137  HEAD         -2
  1.138  PIC          8902s_11792a_uut.jpg

  1.139  MATH         @LO_ROSC = "Ext"

  1.140  DISP         Ensure the UUT 10 MHz REF OUTPUT (rear panel) is
  1.140  DISP         connected to the following:
  1.140  DISP
  1.140  DISP         [32] HP 8902A TIMEBASE 10 MHz INPUT
  1.140  DISP         [32] HP [V @856x_ModelNum] 10 MHz IN/OUT
  1.140  DISP         [32] [V @LO_DevName] [V @LO_RefIn]

  1.141  IF           ZCMPI(@LFCTR_DevName, @HFCTR_DevName)
  1.142  DISP         Connect [V FreqRef] 10 MHz Out to
  1.142  DISP         [V @LFCTR_DevName] [V @LFCTR_RefIn].
  1.143  ELSE
  1.144  DISP         Connect [V FreqRef] 10 MHz Out to
  1.144  DISP         [V @LFCTR_DevName] [V @LFCTR_RefIn] and
  1.144  DISP         [V @HFCTR_DevName] [V @HFCTR_RefIn].
  1.145  ENDIF

  1.146  IF           ZCMPI(@MeasMode, "MU")

  1.147  IF           PSUBI("8648B")
  1.148  DISP         The next routine operator intervention occurs in
  1.148  DISP         approximately 49 minutes.
  1.149  ELSEIF       PSUBI("8648C")
  1.150  DISP         The next routine operator intervention occurs in
  1.150  DISP         approximately 58 minutes.
  1.151  ELSE
  1.152  DISP         The next routine operator intervention occurs in
  1.152  DISP         approximately 1 hour, 7 minutes.
  1.153  ENDIF

  1.154  ELSEIF       ZCMPI(@MeasMode, "TUR")

  1.155  IF           PSUBI("8648B")
  1.156  DISP         The next routine operator intervention occurs in
  1.156  DISP         approximately 19 minutes.
  1.157  ELSEIF       PSUBI("8648C")
  1.158  DISP         The next routine operator intervention occurs in
  1.158  DISP         approximately 20 minutes.
  1.159  ELSE
  1.160  DISP         The next routine operator intervention occurs in
  1.160  DISP         approximately 21 minutes.
  1.161  ENDIF

  1.162  ENDIF

  1.163  CALL         Sub 8648B/C/D (2 yr) FM Accy VER /8902S,LO
  1.164  CALL         Sub 8648B/C/D (2 yr) FM Dist VER /8902S,LO
  1.165  CALL         Sub 8648B/C/D (2 yr) AM Accy VER /8902
  1.166  CALL         Sub 8648B/C/D (2 yr) AM Dist VER /8902
  1.167  CALL         Sub 8648B/C/D (2 yr) PM Dist VER /8902S,LO
  1.168  CALL         Sub 8648B/C/D (2 yr) FM Res VER /8902S,8903,LO
  1.169  JMPL         RF_LEVEL

  1.170  LABEL        HARMONICS
  1.171  HEAD         HARMONICS PERFORMANCE
  1.172  DISP         Connect the UUT RF OUTPUT to the [V @856x_ModelNum]
  1.172  DISP         Spectrum Analyzer INPUT 50 Ωs.
  1.173  CALL         Sub 8648B/C/D (2 yr) Harmonics VER /8560
  1.174  CALL         Sub 8648B/C/D (2 yr) Spurious VER /8560
  1.175  DISP         Disconnect the UUT RF OUTPUT from the [V @856x_ModelNum]
  1.175  DISP         Spectrum Analyzer INPUT 50 Ωs.
  1.176  JMPL         END

  1.177  LABEL        DC_FM
  1.178  DISP         Make the following connections:
  1.178  DISP
  1.178  DISP         [32]       UUT          to    [V @LFCTR_DevName]
  1.178  DISP         [32] RF OUTPUT 50 Ohm ------> [V @LFCTR_Ch1]
  1.178  DISP
  1.178  DISP         Use a Type N to BNC adapter at the UUT RF OUTPUT.
  1.179  CALL         Sub 8648B/C/D (2 yr) DC FM Freq Error VER /LFCTR
  1.180  JMPL         CW_FREQ

  1.181  LABEL        DC_FM_HF
  1.182  CALL         Sub 8648B/C/D (2 yr) DC FM Freq Error VER /HFCTR
  1.183  CALL         Sub Reset /HFCTR
  1.184  DISP         Disconnect the [V @HFCTR_DevName] from the UUT.
  1.185  JMPL         HARMONICS

  1.186  LABEL        CW_FREQ
  1.187  CALL         Sub 8648A/B/C/D (2 yr) CW Freq VER /LFCTR
  1.188  DISP         Make the following connections:
  1.188  DISP
  1.188  DISP         [32]       UUT          to    [V @HFCTR_DevName]
  1.188  DISP         [32] RF OUTPUT -------------> [V @HFCTR_ChHF]

  1.189  IF           ZCMPI(GET("Meas_Mode"), "TUR")
  1.190  DISP         The next routine operator intervention occurs in
  1.190  DISP         approximately 2 minute.
  1.191  ELSEIF       ZCMPI(GET("Meas_Mode"), "MU")
  1.192  DISP         The next routine operator intervention occurs in
  1.192  DISP         approximately 6 minutes.
  1.193  ENDIF

  1.194  CALL         Sub 8648A/B/C/D (2 yr) CW Freq VER /HFCTR
  1.195  JMPL         DC_FM_HF

  1.196  LABEL        RF_LEVEL
  1.197  RSLT         =
  1.198  HEAD         {RF LEVEL ACCURACY}
  1.199  CALL         Sub 8648B/C/D RF Level VER /8902S,11792,LO
  1.200  M8902        *
  1.201  PIC          8903b_8902s_11722a.jpg
  1.202  DISP         Connect the 11722A Sensor Module input to the 8902A
  1.202  DISP         RF POWER connector.
  1.203  HEAD         -2 11722A ZERO/CAL
  1.204  8902         1mW                          50MH              CP N
  1.205  M8902        *
  1.206  8902         *                                                 S
  1.207  HEAD         -2
  1.208  PIC          8902s_11722a_uut.jpg
  1.209  CALL         Sub 8648B/C/D RF Level VER /8902S,11722
  1.210  DISP         Disconnect the 11722A Sensor Module from the UUT.
  1.211  JMPL         DC_FM

  1.212  LABEL        END

  1.213  IF           @Abort
  1.214  HEAD         V E R I F I C A T I O N   A B O R T E D !
  1.215  ENDIF

  1.216  END
