﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Fluke 45: CAL ADJ RS-232 /5522
DATE:                  2013-10-18 08:24:40
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       128
CONFIGURATION:         Fluke 5522A
=============================================================================
#
#  Procedure Author:
#        DAC, GMO
# 
#  Source:
#        Fluke 45, Dual Display Multimeter Service Manual
#        PN 609203, March 1999 Rev.1, 1/04
# 
#  Compatibility:
#        MET/CAL 8.1.4 or later
# 
#  Additional Equipment Required:
#        None
# 
#  The Procedure was tested using:
#        Model No.    : 45
#        Serial No.   : 6204006
#        Options      : None
#        Firmware Rev.: 1.7 D1.0
#
#  The average run time during testing was 8 minutes.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5522A        Reset
  1.003  ENDIF

  1.004  ASK-   R     N              P                            F        W

  1.005  IF           NOT(VERSIONCHECK("8.1.7"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub High Voltage Safety Warning

  1.010  HEAD         TEST CONDITIONS
  1.011  DISP         Ensure that the UUT has been allowed to warm-up
  1.011  DISP         in an environment with an ambient temperature of
  1.011  DISP         18 to 28 °C and a relative humidity of less than
  1.011  DISP         70 % (MOhm ranges) or less than 90 % for all other
  1.011  DISP         functions and ranges for at least one hour prior
  1.011  DISP         to adjustment.

  1.012  HEAD         EQUIPMENT SETUP
  1.013  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5520
  1.014  CALL         Sub Fluke 45 Setup RS-232

  1.015  MATH         @UUT_Manufacturer  = "FLUKE"
  1.016  MATH         @UUT_Model         = "45"
  1.017  MATH         @UUT_AssetNum      = UUT()

  1.018  IF           NOT(EMPTY(@UUT_AssetNum))
  1.019  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
  1.020  ENDIF

  1.021  CALL         Sub Fluke 45 Query Identification RS-232
  1.022  JMPL         END                     @Abort
  1.023  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.024  JMPL         END                     @Abort

  1.025  MATH         @UUTCommand = "*RST;LOCS"
  1.026  CALL         Sub Fluke 45 Send Command RS-232
  1.027  JMPL         END                          @Abort

  1.028  CALL         Sub Fluke 45 Cal Enable

  1.029  MATH         @UUTCommand = "REMS"
  1.030  CALL         Sub Fluke 45 Send Command RS-232
  1.031  JMPL         END                          @Abort

  1.032  DISP         ***************************************************
  1.032  DISP         To reduce noise pickup by test leads, particularly
  1.032  DISP         during high Ohms calibration, use shielded test
  1.032  DISP         cables between the Fluke 5502 and Fluke 45.
  1.032  DISP         ***************************************************

  1.033  CALL         Sub Fluke 45 DC Volts ADJ RS-232 /5502
  1.034  JMPL         END                          @Abort
  1.035  CALL         Sub Fluke 45 AC Volts ADJ RS-232 /5502
  1.036  JMPL         END                          @Abort
  1.037  CALL         Sub Fluke 45 DC Milliamps ADJ RS-232 /5502
  1.038  JMPL         END                          @Abort
  1.039  CALL         Sub Fluke 45 AC Milliamps ADJ RS-232 /5502
  1.040  JMPL         END                          @Abort
  1.041  CALL         Sub Fluke 45 DC Amps ADJ RS-232 /5502
  1.042  JMPL         END                          @Abort
  1.043  CALL         Sub Fluke 45 AC Amps ADJ RS-232 /5502
  1.044  JMPL         END                          @Abort
  1.045  CALL         Sub Fluke 45 Ohms ADJ RS-232 /5502
  1.046  JMPL         END                          @Abort
  1.047  CALL         Sub Fluke 45 Frequency ADJ RS-232 /5502
  1.048  JMPL         END                          @Abort
  1.049  CALL         Sub Fluke 45 Continuity ADJ RS-232 /5502

  1.050  LABEL        END
  1.051  PORT         *RST;LOCS

  1.052  IF           @Abort
  1.053  HEAD         A D J U S T M E N T   A B O R T E D
  1.054  ENDIF

  1.055  END
