﻿Copyright Fluke Calibration. All Rights Reserved.           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 45 DC Milliamps ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 AC Milliamps ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 DC Amps ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 AC Amps ADJ RS-232 /5502
DATE:                  2012-11-08 09:24:08
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       267
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Models covered:
#        45
#
#  Compatibility:
#        MET/CAL or 8.0.51 or later
#
#  Subprocedures:
#        Sub Fluke 45 Cal Enable
#        Sub Fluke 45 Send Command RS-232
#        Sub Fluke 45 Check Acknowledge RS-232
#        Sub Fluke 45 Query Response RS-232
#
#  Required Files:
#        5502e_45_mA_10A.jpg
#
#  Required Equipment:
#        None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         DC_MILLIAMPS                 PSUBI("DC Milliamps")
  1.002  JMPL         AC_MILLIAMPS                 PSUBI("AC Milliamps")
  1.003  JMPL         DC_AMPS                      PSUBI("DC Amps")
  1.004  JMPL         AC_AMPS                      PSUBI("AC Amps")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment step number

# =====  Sub Fluke 45 DC Milliamps ADJ RS-232 /5502  ========================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  2.001  TARGET
  2.002  MATH         @UUTCommand = "*RST;LOCS"
  2.003  CALL         Sub Fluke 45 Send Command RS-232
  2.004  JMPL         END                          @Abort

  2.005  CALL         Sub Fluke 45 Cal Enable

  2.006  MATH         @UUTCommand = "REMS"
  2.007  CALL         Sub Fluke 45 Send Command RS-232
  2.008  JMPL         END                          @Abort

  2.009  LABEL        DC_MILLIAMPS
  2.010  HEAD         DC MILLIAMPS CALIBRATION STEPS 18-19
# Start DC Amps Calibration
  2.011  MATH         @UUTCommand = "CAL 3"
  2.012  CALL         Sub Fluke 45 Send Command RS-232
  2.013  JMPL         END                          @Abort

  2.014  DO
# Query the present calibration reference.
  2.015  MATH         @QueryCommand = "CALREF?"
  2.016  CALL         Sub Fluke 45 Query Response RS-232

  2.017  IF           @Abort
  2.018  END
  2.019  ENDIF

# Setup calibration input according the present calibration reference.
  2.020  IF           ZCMPI(@Response, "+29.000E-3")
  2.021  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]
  2.022  PIC          5502e_45_mA_10A
  2.023  DISP         The next operator intervention occurs in
  2.023  DISP         approximately 2½ minute...
  2.024  ENDIF

  2.025  5502E        +Current = [V @Response] A; CurrentTerminal = Aux
  2.026  WAIT         -t 3 System Settling...
# Perform the calibration and query the calibrated value of input.
  2.027  MATH         @QueryCommand = "CALSTEP?"
  2.028  CALL         Sub Fluke 45 Query Response RS-232

  2.029  IF           @Abort
  2.030  END
  2.031  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  2.032  UNTIL        ZCMPI(@Response, "+100.00E-3")

  2.033  HEAD
  2.034  5502E        Standby
  2.035  END

  2.036  EVAL   Increment step number

# =====  Sub Fluke 45 AC Milliamps ADJ RS-232 /5502  ========================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  3.001  TARGET
  3.002  MATH         @UUTCommand = "*RST;LOCS"
  3.003  CALL         Sub Fluke 45 Send Command RS-232
  3.004  JMPL         END                          @Abort

  3.005  CALL         Sub Fluke 45 Cal Enable

  3.006  MATH         @UUTCommand = "REMS"
  3.007  CALL         Sub Fluke 45 Send Command RS-232
  3.008  JMPL         END                          @Abort

  3.009  LABEL        AC_MILLIAMPS
  3.010  HEAD         AC MILLIAMPS CALIBRATION STEPS 20-21
# Start DC Amps Calibration
  3.011  MATH         @UUTCommand = "CAL 4"
  3.012  CALL         Sub Fluke 45 Send Command RS-232
  3.013  JMPL         END                          @Abort

  3.014  DO
# Query the present calibration reference.
  3.015  MATH         @QueryCommand = "CALREF?"
  3.016  CALL         Sub Fluke 45 Query Response RS-232

  3.017  IF           @Abort
  3.018  END
  3.019  ENDIF

# Setup calibration input according the present calibration reference.
  3.020  5502E        +Curr = [V @Response] A; Freq = 1 kHz; CurrTerm = Aux
  3.021  WAIT         -t 3 System settling...
# Perform the calibration and query the calibrated value of input.
  3.022  MATH         @QueryCommand = "CALSTEP?"
  3.023  CALL         Sub Fluke 45 Query Response RS-232

  3.024  IF           @Abort
  3.025  END
  3.026  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  3.027  UNTIL        ZCMPI(@Response, "+100.00E-3")

  3.028  HEAD
  3.029  5502E        Standby
  3.030  END

  3.031  EVAL   Increment step number

# =====  Sub Fluke 45 DC Amps ADJ RS-232 /5502  =============================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  4.001  TARGET
  4.002  MATH         @UUTCommand = "*RST;LOCS"
  4.003  CALL         Sub Fluke 45 Send Command RS-232
  4.004  JMPL         END                          @Abort

  4.005  CALL         Sub Fluke 45 Cal Enable

  4.006  MATH         @UUTCommand = "REMS"
  4.007  CALL         Sub Fluke 45 Send Command RS-232
  4.008  JMPL         END                          @Abort

  4.009  LABEL        DC_AMPS
  4.010  HEAD         DC AMPS CALIBRATION STEP 22
# Start DC Amps Calibration
  4.011  MATH         @UUTCommand = "CAL 5"
  4.012  CALL         Sub Fluke 45 Send Command RS-232
  4.013  JMPL         END                          @Abort

  4.014  DO
  4.015  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]
  4.016  5502E        +Current = 10 A; CurrentTerminal = 20A
  4.017  WAIT         -t 3 System Settling...
# Perform the calibration and query the calibrated value of input.
  4.018  MATH         @QueryCommand = "CALSTEP?"
  4.019  CALL         Sub Fluke 45 Query Response RS-232

  4.020  IF           @Abort
  4.021  END
  4.022  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  4.023  UNTIL        ZCMPI(@Response, "+10.000E+0")

  4.024  HEAD
  4.025  5502E        Standby
  4.026  END

  4.027  EVAL   Increment step number

# =====  Sub Fluke 45 AC Amps ADJ RS-232 /5502  =============================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  5.001  TARGET
  5.002  MATH         @UUTCommand = "*RST;LOCS"
  5.003  CALL         Sub Fluke 45 Send Command RS-232
  5.004  JMPL         END                          @Abort

  5.005  CALL         Sub Fluke 45 Cal Enable

  5.006  MATH         @UUTCommand = "REMS"
  5.007  CALL         Sub Fluke 45 Send Command RS-232
  5.008  JMPL         END                          @Abort

  5.009  LABEL        AC_AMPS
  5.010  HEAD         AC AMPS CALIBRATION STEPS 23-24
# Start DC Amps Calibration
  5.011  MATH         @UUTCommand = "CAL 6"
  5.012  CALL         Sub Fluke 45 Send Command RS-232
  5.013  JMPL         END                          @Abort

  5.014  DO
# Query the present calibration reference.
  5.015  MATH         @QueryCommand = "CALREF?"
  5.016  CALL         Sub Fluke 45 Query Response RS-232

  5.017  IF           @Abort
  5.018  END
  5.019  ENDIF

  5.020  IF           @Response < 3
  5.021  MATH         Terminal = "Aux"
  5.022  PIC          5502e_45_2A_2w.jpg
  5.023  DISP         The next operator intervention occurs in
  5.023  DISP         approximately ½ minute...
  5.024  ELSEIF       @Response > 3
  5.025  5502E        Standby
  5.026  PIC          5502e_45_10A_2w.jpg
  5.027  DISP         The next operator intervention occurs in
  5.027  DISP         approximately ½ minute...
  5.028  MATH         Terminal = "20A"
  5.029  ENDIF

  5.030  5502E        CurrTerm = [V Terminal]
  5.030  5502E        +Current = [V @Response] A; Frequency = 1 kHz
  5.031  WAIT         -t 5 System settling...
# Perform the calibration and query the calibrated value of input.
  5.032  MATH         @QueryCommand = "CALSTEP?"
  5.033  CALL         Sub Fluke 45 Query Response RS-232

  5.034  IF           @Abort
  5.035  END
  5.036  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  5.037  UNTIL        ZCMPI(@Response, "+10.000E+0")

  5.038  LABEL        END
  5.039  HEAD
  5.040  5502E        Standby
  5.041  END
