﻿Copyright Fluke Calibration. All Rights Reserved.           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 45 DC Volts ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 AC Volts ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 Ohms ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 Continuity ADJ RS-232 /5502
INSTRUMENT:            Sub Fluke 45 Frequency ADJ RS-232 /5502
DATE:                  2012-11-08 09:24:09
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       326
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Models covered:
#         45
#
#  Compatibility:
#        MET/CAL or 8.0.51 or later
#
#  Subprocedures:
#        Sub Fluke 45 Cal Enable
#        Sub Fluke 45 Send Command RS-232
#        Sub Fluke 45 Check Acknowledge RS-232
#        Sub Fluke 45 Query Response RS-232
#
#  Required Files:
#        5502e_45_2w.jpg
#        5502e_45_4w.jpg
#
#  Required Equipment:
#        None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         DC_VOLTS                     PSUBI("DC Volts")
  1.002  JMPL         AC_VOLTS                     PSUBI("AC Volts")
  1.003  JMPL         OHMS                         PSUBI("Ohms")
  1.004  JMPL         CONTINUITY                   PSUBI("Continuity")
  1.005  JMPL         FREQUENCY                    PSUBI("Frequency")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub Fluke 45 DC Volts ADJ RS-232 /5502  =============================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  2.001  TARGET
  2.002  MATH         @UUTCommand = "*RST;LOCS"
  2.003  CALL         Sub Fluke 45 Send Command RS-232
  2.004  JMPL         END                          @Abort

  2.005  CALL         Sub Fluke 45 Cal Enable

  2.006  MATH         @UUTCommand = "REMS"
  2.007  CALL         Sub Fluke 45 Send Command RS-232
  2.008  JMPL         END                          @Abort

  2.009  LABEL        DC_VOLTS
  2.010  HEAD         DC VOLTS CALIBRATION STEPS 1-10
# Start DC Volts Calibration
  2.011  MATH         @UUTCommand = "CAL 1"
  2.012  CALL         Sub Fluke 45 Send Command RS-232
  2.013  JMPL         END                          @Abort

  2.014  DO
# Query the present calibration reference.
  2.015  MATH         @QueryCommand = "CALREF?"
  2.016  CALL         Sub Fluke 45 Query Response RS-232

  2.017  IF           @Abort
  2.018  END
  2.019  ENDIF

# Setup calibration input according the present calibration reference.
  2.020  IF           ZCMPI(@Response, "+0.000E-3")
  2.021  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]
  2.022  PIC          5502e_45_2w
  2.023  DISP         The next operator intervention occurs in
  2.023  DISP         approximately 3 minutes...
  2.024  ENDIF

  2.025  5502E        +Voltage = [V @Response] V

  2.026  IF           NUM(@Response) < 1
  2.027  WAIT         -t 5 System Settling...
  2.028  ELSE
  2.029  WAIT         [D1000]
  2.030  ENDIF

# Perform the calibration and query the calibrated value of input.
  2.031  MATH         @QueryCommand = "CALSTEP?"
  2.032  CALL         Sub Fluke 45 Query Response RS-232

  2.033  IF           @Abort
  2.034  END
  2.035  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  2.036  UNTIL        ZCMPI(@Response, "+1000.0E+0")

  2.037  JMPL         END

  2.038  EVAL   Increment step number

# =====  Sub Fluke 45 AC Volts ADJ RS-232 /5502  =============================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  3.001  TARGET
  3.002  MATH         @UUTCommand = "*RST;LOCS"
  3.003  CALL         Sub Fluke 45 Send Command RS-232
  3.004  JMPL         END                          @Abort

  3.005  CALL         Sub Fluke 45 Cal Enable

  3.006  MATH         @UUTCommand = "REMS"
  3.007  CALL         Sub Fluke 45 Send Command RS-232
  3.008  JMPL         END                          @Abort

  3.009  LABEL        AC_VOLTS
  3.010  HEAD         AC VOLTS CALIBRATION STEPS 11-17
# Start DC Volts Calibration
  3.011  MATH         @UUTCommand = "CAL 2"
  3.012  CALL         Sub Fluke 45 Send Command RS-232
  3.013  JMPL         END                          @Abort

  3.014  DO
# Query the present calibration reference.
  3.015  MATH         @QueryCommand = "CALREF?"
  3.016  CALL         Sub Fluke 45 Query Response RS-232

  3.017  IF           @Abort
  3.018  END
  3.019  ENDIF

# Setup calibration input according the present calibration reference.
  3.020  5502E        +Voltage = [V @Response] V; Frequency = 1 kHz
  3.021  WAIT         -t 3 System settling...
# Perform the calibration and query the calibrated value of input.
  3.022  MATH         @QueryCommand = "CALSTEP?"
  3.023  CALL         Sub Fluke 45 Query Response RS-232

  3.024  IF           @Abort
  3.025  END
  3.026  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  3.027  UNTIL        ZCMPI(@Response, "+750.0E+0")

  3.028  JMPL         END

  3.029  EVAL   Increment step number

# =====  Sub Fluke 45 Ohms ADJ RS-232 /5502  =================================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  4.001  TARGET
  4.002  MATH         @UUTCommand = "*RST;LOCS"
  4.003  CALL         Sub Fluke 45 Send Command RS-232
  4.004  JMPL         END                          @Abort

  4.005  CALL         Sub Fluke 45 Cal Enable

  4.006  MATH         @UUTCommand = "REMS"
  4.007  CALL         Sub Fluke 45 Send Command RS-232
  4.008  JMPL         END                          @Abort

  4.009  LABEL        OHMS
  4.010  HEAD         OHMS CALIBRATION STEPS 25-29
# Start 4-Wire Ohms Calibration
  4.011  MATH         @UUTCommand = "CAL 7"
  4.012  CALL         Sub Fluke 45 Send Command RS-232
  4.013  JMPL         END                          @Abort

  4.014  DO
# Query the present calibration reference.
  4.015  MATH         @QueryCommand = "CALREF?"
  4.016  CALL         Sub Fluke 45 Query Response RS-232

  4.017  IF           @Abort
  4.018  END
  4.019  ENDIF

# Setup calibration input according the present calibration reference.

  4.020  IF           ZCMPI(@Response, "+290.00E+0")
  4.021  5502E        Standby
  4.022  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]
  4.023  PIC          5502e_45_4w
  4.024  DISP         The next operator intervention occurs in
  4.024  DISP         approximately ½ minute...

  4.025  ELSEIF       ZCMPI(@Response, "+290.00E+3")
  4.026  5502E        Standby
  4.027  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]
  4.028  PIC          5502e_45_2w
  4.029  DISP         The next operator intervention occurs in
  4.029  DISP         approximately 1 minute...
  4.030  ENDIF

  4.031  IF           NUM(@Response) < 100E+3
  4.032  MATH         Comp = "2Wire"
  4.033  ELSE
  4.034  MATH         Comp = "Off"
  4.035  ENDIF

  4.036  5502E        +Resistance = [V @Response] Ohms; LeadComp = [V Comp]
  4.037  WAIT         -t 5 System settling...

# Perform the calibration and query the calibrated value of input.
  4.038  MATH         @QueryCommand = "CALSTEP?"
  4.039  CALL         Sub Fluke 45 Query Response RS-232

  4.040  IF           @Abort
  4.041  END
  4.042  ENDIF

# If the calibrated value is last step expected response, this function
# adjustment is finished.
  4.043  UNTIL        ZCMPI(@Response, "+2.9000E+6")

  4.044  JMPL         END

  4.045  EVAL   Increment step number

# =====  Sub Fluke 45 Continuity ADJ RS-232 /5502  ===========================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  5.001  TARGET
  5.002  MATH         @UUTCommand = "*RST;LOCS"
  5.003  CALL         Sub Fluke 45 Send Command RS-232
  5.004  JMPL         END                          @Abort

  5.005  CALL         Sub Fluke 45 Cal Enable

  5.006  MATH         @UUTCommand = "REMS"
  5.007  CALL         Sub Fluke 45 Send Command RS-232
  5.008  JMPL         END                          @Abort

  5.009  LABEL        CONTINUITY
  5.010  HEAD         CONTINUITY/HYSTERESIS THRESHOLD CALIBRATION STEPS 30-31
# Start Continuity/Hysteresis Threshold Calibration
  5.011  MATH         @UUTCommand = "CAL 8"
  5.012  CALL         Sub Fluke 45 Send Command RS-232
  5.013  JMPL         END                          @Abort

  5.014  DO
# Query the present calibration reference.
  5.015  MATH         @QueryCommand = "CALREF?"
  5.016  CALL         Sub Fluke 45 Query Response RS-232

  5.017  IF           @Abort
  5.018  END
  5.019  ENDIF

# Setup calibration input according the present calibration reference.
  5.020  5502E        +Voltage = [V @Response] V
  5.021  WAIT         -t 3 System settling...
# Perform the calibration and query the calibrated value of input.
  5.022  MATH         @QueryCommand = "CALSTEP?"
  5.023  CALL         Sub Fluke 45 Query Response RS-232

  5.024  IF           @Abort
  5.025  END
  5.026  ENDIF

# If the calibrated value is expected response, the calibration is finished.
  5.027  UNTIL        ZCMPI(@Response, "+0.020E+0")

  5.028  JMPL         END

  5.029  EVAL   Increment step number

# =====  Sub Fluke 45 Frequency ADJ RS-232 /5502  ============================

# This TARGET and JMPL are here so "Repeat" will perform a new calibration.
  6.001  TARGET
  6.002  MATH         @UUTCommand = "*RST;LOCS"
  6.003  CALL         Sub Fluke 45 Send Command RS-232
  6.004  JMPL         END                          @Abort

  6.005  CALL         Sub Fluke 45 Cal Enable

  6.006  MATH         @UUTCommand = "REMS"
  6.007  CALL         Sub Fluke 45 Send Command RS-232
  6.008  JMPL         END                          @Abort

  6.009  LABEL        FREQUENCY
  6.010  HEAD         FREQUENCY CALIBRATION STEP 32
# Start Frequency Calibration
  6.011  MATH         @UUTCommand = "CAL 9"
  6.012  CALL         Sub Fluke 45 Send Command RS-232
  6.013  JMPL         END                          @Abort

  6.014  DO
  6.015  5502E        +Frequency = 10 kHz; Voltage = 2 Vpp
  6.016  WAIT         -t 3 System settling...
# Perform the calibration and query the calibrated value of input.
  6.017  MATH         @QueryCommand = "CALSTEP?"
  6.018  CALL         Sub Fluke 45 Query Response RS-232

  6.019  IF           @Abort
  6.020  END
  6.021  ENDIF

# If the calibrated value is expected response, the calibration is finished.
  6.022  UNTIL        ZCMPI(@Response, "+10.000E+3")

  6.023  LABEL        END
  6.024  HEAD
  6.025  5502E        Standby
  6.026  END
