﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 50 Series II ADJ /7526
DATE:                  2014-04-30 08:44:03
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       139
CONFIGURATION:         Fluke 7526A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        50 Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Type K extension cable
#        Copper TC extension cable
#        Fluke 80AK SMP to dual banana adapter
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-                                                              V

  1.002  IF           NOT(VERSIONCHECK("8.0"))
  1.003  END
  1.004  ENDIF

  1.005  CALL         Sub Display Copyright

  1.006  HEAD         EQUIPMENT REQUIREMENTS
  1.007  OPBR         -z Do you want to REVIEW the list of additional
  1.007  OPBR         equipment and/or accessories required?

  1.008  IF           MEM1
  1.009  DISP         The following additional equipment is required:
  1.009  DISP         - Type K extension cable (1)
  1.009  DISP         - Copper TC extension cable (1)
  1.009  DISP         - Fluke 80AK SMP to dual banana adapter
  1.009  DISP
  1.009  DISP         1. Included in 5500A/LEADS, Lead Set
  1.010  ENDIF

  1.011  HEAD         PRELIMINARY INSTRUCTIONS
  1.012  DISP         Turn the UUT on.

  1.013  DO
  1.014  DISP         With a small, blunt probe, press the calibration button
  1.014  DISP         located on the back and in the center of the UUT.
  1.015  OPBR         -z Is the menu displaying "CAL A-d"?
  1.016  UNTIL        MEM1

  1.017  DISP         Note, keep hand and body motion to a minimum while the
  1.017  DISP         thermometer takes A/D readings.

  1.018  DO
  1.019  HEAD         A/D CALIBRATION
  1.020  DISP         Press ENTER on the UUT.
  1.021  DISP         Connect 7526A VOLTS OUTPUT HI and LO terminals to the
  1.021  DISP         UUT using a SMP to Dual Banana Adapter and a copper TC
  1.021  DISP         extension cable and a Fluke 80AK.
  1.022  7526A        +Voltage = 80 mV
  1.023  DISP         Press ENTER on the UUT.
  1.024  DISP         Select Advance when the UUT displays "-8".
  1.025  7526A        Standby

  1.026  DISP         Disconnect the SMP cable from the 80AK adapter and
  1.026  DISP         connect it to the 7526A TC Terminals.
  1.027  7526A        +Voltage = -8 mV; TC_Type = _1mVdegC
  1.028  DISP         Press ENTER on the UUT and wait while it takes A/D
  1.028  DISP         readings.  The UUT now shows the measured value in the
  1.028  DISP         bottom portion. of the display.  Millivolt appears on
  1.028  DISP         the left side and microvolt appears on the right side.
  1.029  MEMI         Enter UUT reading.
  1.030  DISP         Press ENTER on the UUT.
  1.031  7526A        Standby

  1.032  IF           (MEM < -8.005) || (MEM > -7.995)
  1.033  DISP         UUT reading is out-of-range.
  1.033  DISP         Use the up or down arrow key to select "CAL A-d".
  1.034  ENDIF

  1.035  UNTIL        (MEM >= -8.005) && (MEM <= -7.995)

  1.036  DISP         Use the up or down arrow key to select "CAL donE" and
  1.036  DISP         press ENTER.
  1.037  DISP         Disconnect the 7526A from the UUT.

  1.038  HEAD         REFERENCE_JUNCTION_CALIBRATION
  1.039  DISP         Connect 7526A TC terminals to UUT using a
  1.039  DISP         type K extension cable.
  1.040  OPBR         -z Is "TYPE K" displayed in the lower left-hand corner
  1.040  OPBR         of the UUT display?

  1.041  IF           NOT(MEM1)
  1.042  DISP         Press SETUP button.
  1.042  DISP         Press the down arrow button to select TYPE.
  1.042  DISP         Press ENTER button.
  1.042  DISP         Press up or down arrow key until "K" is flashing.
  1.042  DISP         Press ENTER button.
  1.042  DISP         Press SETUP button to exit Setup menu.
  1.043  ENDIF

  1.044  DO
  1.045  DISP         With a small, blunt probe, press the calibration button
  1.045  DISP         located on the back and in the center of the UUT.
  1.046  OPBR         -z Is the menu displaying "CAL A-d"?
  1.047  UNTIL        MEM1

  1.048  7526A        +Temperature = 0 degC; TC_Type = K
  1.049  DISP         Use the up or down arrow key to select "CAL rEF" and
  1.049  DISP         press ENTER.
  1.049  DISP         Press the up or down arrow key until the display is
  1.049  DISP         0.0 °C.
  1.050  DISP         Press ENTER on the UUT.
  1.051  DISP         Use the up or down arrow key to select "CAL donE" and
  1.051  DISP         press ENTER.

  1.052  HEAD         C A L I B R A T I O N   C O M P L E T E
  1.053  END
