﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Fluke 190-104: (1 year) CAL VER RS-232 /5502+SC600
DATE:                  2013-12-17 07:41:07
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       123
CONFIGURATION:         Fluke 5502A
CONFIGURATION:         Fluke Ocal (600MHz,VID,WG)
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#@
#@ This procedure contains tests whose Test Uncertainty Ratios are less
#@ than 4:1, based on 5520A (1 year) specifications.
#@
#@       AC VOLTAGE ACCURACY (HF) & BANDWIDTH TEST
#@              900 mV @ 1 MHz;    TUR 2.0566
#@
#@ Source:
#@       ScopeMeter 190 Series II
#@       Fluke 190-062, -102, -104, -202, -204, -502 Service Manual
#@       PN 4822 872 05405, July 2011, Rev. 4, March 2013
#@
#@ Compatibility:
#@       MET/CAL 8.1.4 or later
#@
#@ Required Equipment:
#@       Adapter, dual banana plug to BNC(f), Pomona 1269
#@       Adapter, dual BNC(f) to BNC(m), Fluke PM 9093, 3 ea
#@       Termination, feedthrough, BNC, 50 Ω, Fluke PM 9585
#@       Cable, 50 Ω, BNC(m)-(m), Pomona 2249-C-6, 1 ea.
#@       Cable, USB Type A (Host) to USB MINI Type B (Device)
#@
#@       Accessories supplied with UUT
#@       - Power Adapter, BC190
#@       - VPS210 Voltage Probe (200 MHz, 10:1), any color
#@
#  This procedure was tested using:
#        Model No.    :  190-204
#        Serial No.   :  19752826
#        Options      :  na
#        Firmware Rev.:  V10.40
#
#@ The average run time during testing was:
#@       60 minutes (using procedure default values for NTHROW and NMEAS)
#
# This procedure is intended for use with MET/CAL® calibration software;
# the terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables:
#
#    UUT Identification Expected by Procedure (see below)
#        @UUT_Manufacturer
#        @UUT_ModelNum
#
#    UUT Identification Returned by Device
#        @Manufacturer
#        @ModelNum
#        @FirmwareRev
#        @FirmwareDate
#
#    UUT Parameters
#        @Bandwidth      - Base units of Hertz (Ex. 60E-6)
#        @BitNum         - Bit number to be checked in status byte
#        @BW_Setup       - Bandwidth limit (Ex. "FULL BW")
#        @Chan           - Channel being tested (1, 2, 3, or 4)
#        @Cmd            - Command string
#        @DC_Coupling    - Coupling (1 = DC, 0 = AC)
#        @Error          - Boolean: 0 (False) or 1 (True)
#        @ErrorMsg       - Message based on status returned
#        @HPos           - Horizontal trigger position
#        @Input          - Channel name designator ("A", "B", "C", or "D")
#        @NumChan        - Number of channels
#        @Range(1)       - Scope range (Ex. "50 mV/div")
#        @Reading        - Parameter to be read (Ex. "Phase")
#        @Status         - Status byte returned
#        @Timebase(1)    - Scope timebase (Ex. "20 ns/div")
#
#   1. Set to "Auto" each time "Sub Fluke 190II Setup Scope Channel RS-232"
#      is called
#
#   Misc
#        @Abort          - Boolean: 0 or 1 procedure will be aborted
#        @Ampl           - Calibrator amplitude for test
#        @Freq           - Calibrator frequency for test
#        @MeasMode       - Guardbanding method used
#        @Nominal        - Nominal value of test
#        @SysAcc         - System accuracy
#        @VertDiv        - Vertical division value of test signal
#        @Wait           - Measurement delay in seconds
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5502A        Reset
  1.003  O_CAL        Mode = LeveledSine
  1.003  O_CAL        +Frequency = 600 MHz; Voltage = 600 mVpp;
  1.004  O_CAL        Mode = WaveGen; Waveform = Sine; OutputImp = 1 MOhm
  1.004  O_CAL        +Frequency = 16.00 Hz; Voltage = 600 mVpp
  1.005  O_CAL        Mode = Video; Format = NTSC; Field = Even
  1.005  O_CAL        +Amplitude = +100 %; LineMarker = 262
  1.006  ENDIF

  1.007  MATH         @CalDev           = "Fluke 5502A"
  1.008  MATH         @UUT_Manufacturer = "FLUKE"
  1.009  MATH         @UUT_Model        = "190-104"
  1.010  CALL         Sub Fluke 190II 4Ch (1yr) VER RS-232 /5502,O_CAL+VID+WG

  1.011  END
