﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II (1 yr) A Time Base VER RS-232 /O_CAL
DATE:                  2013-12-12 14:32:38
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       107
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables
#        @NumChan        - Number of UUT's Scope Channel
#        @Chan           - Name of Channel under tested
#        @Input          - Name of Channel calibrator input connected
#        @BW_Setup       - Channel bandwidth limit setup
#        @Cmd            - Command string sent to UUT
#        @Range          - Channel Scope range
#        @Timebase       - UUT timebase setting
#        @HPos           - UUT horizontal (Trigger) position
#
#  Global String Variables:
#        @Wait           - Measurement delay value (seconds)
#        @DC_Coupling    - Channel coupling mode (1 = DC, 0 = AC)
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         THS3000 = ZCMPI(SUB(@ModelNum, 1, 3), "THS")

  1.002  RSLT         =
  1.003  HEAD         {TIME BASE ACCURACY}
  1.004  MATH         @Input = @Chan; @DC_Coupling = 1

  1.005  IF           THS3000
  1.006  MATH         @BW_Setup = "FULL BW"
  1.007  ELSE
  1.008  MATH         @BW_Setup = "20 MHz"
  1.009  ENDIF

  1.010  HEAD         -2 10 µs/div
  1.011  MATH         @HPos     = "7990 us"
  1.012  TARGET
# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets:
#  @Range    = "Auto"
#  @Timebase = "Auto"
  1.013  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  1.014  MATH         @Range    = "500 mV/div"
  1.015  CALL         Sub Fluke 190II Setup Scope Range RS-232
  1.016  MATH         @Timebase = "10 us/div"
  1.017  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232

  1.018  IF           THS3000
  1.019  PIC          THS3000_a_input_55_scope.png
  1.020  ELSE
  1.021  PIC          190II_a_input_55_scope.png
  1.022  ENDIF

  1.023  O_CAL        Mode = Marker
  1.023  O_CAL        +Period = 8 ms
# Make the trigger delay setting displayed in the screen.
# Press "Trigger" button.
  1.024  MATH         @Cmd = "KY 21"
  1.025  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CURSOR LEFT" button once.
  1.026  MATH         @Cmd = "KY 28"
  1.027  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CURSOR RIGHT" button once.
  1.028  MATH         @Cmd = "KY 26"
  1.029  CALL         Sub Fluke ScopeMeter Send Command RS-232
  1.030  PICE         -s " 10 µs/div" : 190II_tb_10us.png

  2.001  HEAD         -2 1 µs/div
  2.002  MATH         @Timebase = "1 us/div"
  2.003  MATH         @HPos     = "799 us"
  2.004  TARGET
  2.005  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  2.006  O_CAL        Mode = Marker
  2.006  O_CAL        +Period = 0.8 ms
  2.007  PICE         -s " 1 µs/div" : 190II_tb_1us.png

  3.001  HEAD         -2
  3.002  HEAD
  3.003  O_CAL        Standby
  3.004  END
