﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II (1 yr) A Video VER RS-232 /O_CAL+VID
DATE:                  2013-12-13 09:53:27
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       10
NUMBER OF LINES:       244
CONFIGURATION:         Fluke Ocal (VID)
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Set measurement delay to 3 seconds.
  1.001  MATH         @Wait = 3
  1.002  MATH         @Input = @Chan

  1.003  RSLT         =
  1.004  HEAD         {VIDEO}
  1.005  MATH         @DC_Coupling = 1
  1.006  MATH         @BW_Setup    = "FULL BW"
  1.007  MATH         @HPos        = "1 div"
  1.008  TARGET
# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets @Timebase = "Auto".
  1.009  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  1.010  MATH         @Timebase    = "20 us/div"
  1.011  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
# A: 2V/div, Manual, Video on A, +NTSC, line 525, Trigger Pos 1 div
  1.012  MATH         @Cmd = "PS"
  1.013  CALL         Sub Fluke ScopeMeter Send Command RS-232
  1.014  PORT         #0[32][11][0][1][3][3]
  1.014  PORT         [32][13][0][2][0][0][0]
  1.015  PORT         [32][14][0][5][0][0][0][16][255][15]
  1.016  PORT         [32][35][0][2][128][3][131]
  1.017  PORT         [32][100][0][1][1][1]
  1.018  PORT         [32][103][0][2][2][10][12]
  1.019  PORT         [32][105][0][2][0][0][0]
  1.020  PORT         [32][106][0][7][1][128][1][2][13][2][0][147]
  1.021  PORT         [32][107][0][8][192][2][0][0][0][0][8][251][197]
  1.022  PORT         [32][109][0][1][128][128]
  1.023  PORT         [32][115][0][1][0][0]
  1.024  PORT         [32][140][0][3][2][45][9][56]
  1.025  PORT         [32][70][0][7][128][1][0][0][0][0][0][129]
  1.026  PORT         [160][71][0][2][0][55][55][13]
  1.027  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Initalize variables for identifying which video formats have been tested.
  1.028  MATH         Tested_SECAM = 0
  1.029  MATH         Tested_PAL   = 0
  1.030  MATH         Tested_NTSC  = 0

  1.031  DO
# Present list box to facilitate video format test selection.
  1.032  MATH         Id = LBNEW("Video Format Test Selection")
  1.033  MATH         LBCONF(Id, "+selreq")
  1.034  MATH         LBTEXT(Id, "It is only necessary to test one video")
  1.035  MATH         LBTEXT(Id, "format to verify proper instrument")
  1.036  MATH         LBTEXT(Id, "operation.")
  1.037  MATH         LBTEXT(Id, "")
  1.038  MATH         LBTEXT(Id, "NOTE: the NTSC video format is most")
  1.039  MATH         LBTEXT(Id, "commonly used in the United States.")
  1.040  MATH         LBTEXT(Id, "")
  1.041  MATH         LBTEXT(Id, "Select the video format to be tested:")

# Only add a video format to the selection list if it has not already been
# tested.
  1.042  IF           NOT(Tested_SECAM)
  1.043  MATH         LBADD(Id, "SECAM")
  1.044  ENDIF

  1.045  IF           NOT(Tested_PAL)
  1.046  MATH         LBADD(Id, "PAL")
  1.047  ENDIF

  1.048  IF           NOT(Tested_NTSC)
  1.049  MATH         LBADD(Id, "NTSC")
  1.050  ENDIF

# Display list box and store selection.
  1.051  MATH         LBSHOW(Id)
  1.052  MATH         Format = LBGETSEL(Id, 1)

  1.053  IF           ZCMPI(Format, "SECAM")
  1.054  RSLT         =
  1.055  HEAD         -2{SECAM Line 622}: Positive
  1.056  TARGET
  1.057  MATH         @Cmd = "PS"
  1.058  CALL         Sub Fluke ScopeMeter Send Command RS-232
  1.059  PORT         #0[160][106][0][7][1][128][1][2][110][3][0][245][13]
  1.060  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  1.061  O_CAL        Mode = Video; Format = SECAM
  1.061  O_CAL        +Amplitude = +100 %; LineMarker = 622
  1.062  MATH         @Cmd = "QM 74"
  1.063  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  1.064  EVAL   -e (MEM > 6) : Positive Trigger

  2.001  RSLT         =
  2.002  HEAD         -2{SECAM Line 310}: Positive
  2.003  TARGET
  2.004  MATH         @Cmd = "PS"
  2.005  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.006  PORT         #0[160][106][0][7][1][128][1][1][54][3][0][188][13]
  2.007  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  2.008  O_CAL        Mode = Video; Format = SECAM
  2.008  O_CAL        +Amplitude = +100 %; LineMarker = 310
  2.009  MATH         @Cmd = "QM 74"
  2.010  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  2.011  EVAL   -e (MEM > 6) : Positive Trigger

  3.001  HEAD         -2 SECAM Line 310: Negative
  3.002  TARGET
  3.003  MATH         @Cmd = "PS"
  3.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  3.005  PORT         #0[160][106][0][7][1][0][1][1][54][3][0][60][13]
  3.006  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  3.007  O_CAL        Mode = Video; Format = SECAM
  3.007  O_CAL        +Amplitude = -100 %; LineMarker = 310
  3.008  MATH         @Cmd = "QM 74"
  3.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  3.010  EVAL   -e (MEM <= -6) : Negative Trigger

  4.001  MATH         Tested_SECAM = 1

  4.002  ELSEIF       ZCMPI(Format, "PAL")
  4.003  RSLT         =
  4.004  HEAD         -2{PAL Line 622}: Positive
  4.005  TARGET
  4.006  MATH         @Cmd = "PS"
  4.007  CALL         Sub Fluke ScopeMeter Send Command RS-232
  4.008  PORT         #0[160][106][0][7][1][128][1][2][110][0][0][242][13]
  4.009  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  4.010  O_CAL        Mode = Video; Format = PAL
  4.010  O_CAL        +Amplitude = +100 %; LineMarker = 622
  4.011  MATH         @Cmd = "QM 74"
  4.012  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  4.013  EVAL   -e (MEM > 6) : Positive Trigger

  5.001  RSLT         =
  5.002  HEAD         -2{PAL Line 310}: Positive
  5.003  TARGET
  5.004  MATH         @Cmd = "PS"
  5.005  CALL         Sub Fluke ScopeMeter Send Command RS-232
  5.006  PORT         #0[160][106][0][7][1][128][1][1][54][0][0][185][13]
  5.007  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  5.008  O_CAL        Mode = Video; Format = PAL
  5.008  O_CAL        +Amplitude = +100 %; LineMarker = 310
  5.009  MATH         @Cmd = "QM 74"
  5.010  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  5.011  EVAL   -e (MEM > 6) : Positive Trigger

  6.001  HEAD         -2 PAL Line 310: Negative
  6.002  TARGET
  6.003  MATH         @Cmd = "PS"
  6.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  6.005  PORT         #0[160][106][0][7][1][0][1][1][54][0][0][57][13]
  6.006  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  6.007  O_CAL        Mode = Video; Format = PAL
  6.007  O_CAL        +Amplitude = -100 %; LineMarker = 310
  6.008  MATH         @Cmd = "QM 74"
  6.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  6.010  EVAL   -e (MEM <= -6) : Negative Trigger

  7.001  MATH         Tested_PAL   = 1

  7.002  ELSE         ; ZCMPI(Format, "NTSC")
  7.003  RSLT         =
  7.004  HEAD         -2{NTSC Line 525}: Positive
  7.005  TARGET
  7.006  MATH         @Cmd = "PS"
  7.007  CALL         Sub Fluke ScopeMeter Send Command RS-232
  7.008  PORT         #0[160][106][0][7][1][128][1][2][13][2][0][147][13]
  7.009  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  7.010  O_CAL        Mode = Video; Format = NTSC; Field = Even
  7.010  O_CAL        +Amplitude = +100 %; LineMarker = 262
  7.011  MATH         @Cmd = "QM 74"
  7.012  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  7.013  EVAL   -e (MEM > 6) : Positive Trigger

  8.001  RSLT         =
  8.002  HEAD         -2{NTSC Line 262}: Positive
  8.003  TARGET
  8.004  MATH         @Cmd = "PS"
  8.005  CALL         Sub Fluke ScopeMeter Send Command RS-232
  8.006  PORT         #0[160][106][0][7][1][128][1][1][6][2][0][139][13]
  8.007  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  8.008  O_CAL        Mode = Video; Format = NTSC; Field = Odd
  8.008  O_CAL        +Amplitude = +100 %; LineMarker = 262
  8.009  MATH         @Cmd = "QM 74"
  8.010  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  8.011  EVAL   -e (MEM > 6) : Positive Trigger

  9.001  HEAD         -2 NTSC Line 262: Negative
  9.002  TARGET
  9.003  MATH         @Cmd = "PS"
  9.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  9.005  PORT         #0[160][106][0][7][1][0][1][1][6][2][0][11][13]
  9.006  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  9.007  O_CAL        Mode = Video; Format = NTSC; Field = Odd
  9.007  O_CAL        +Amplitude = -100 %; LineMarker = 262
  9.008  MATH         @Cmd = "QM 74"
  9.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  9.010  EVAL   -e (MEM <= -6) : Negative Trigger

 10.001  MATH         Tested_NTSC  = 1
 10.002  ENDIF

 10.003  HEAD         -2
 10.004  O_CAL        Standby
 10.005  MATH         Tested_All = (Tested_SECAM && Tested_PAL && Tested_NTSC)

 10.006  IF           NOT(Tested_All)
 10.007  OPBR         -z Would you like to test another video format?[NO]
 10.008  ENDIF

 10.009  UNTIL        NOT(MEM1) || Tested_All

 10.010  HEAD
 10.011  END
