﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL+WG
INSTRUMENT:            Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL+WG
DATE:                  2013-12-17 10:53:19
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       8
NUMBER OF LINES:       265
CONFIGURATION:         Fluke Ocal (WG)
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables
#        @MeasMode       - Guardbanding method used
#        @Chan           - Name of Channel under tested
#        @Input          - Name of Channel calibrator input connected
#        @BW_Setup       - Channel bandwidth limit setup
#        @Cmd            - Command string sent to UUT
#        @Range          - Channel Scope range
#        @Reading        - Channel reading type
#        @Timebase       - UUT timebase setting
#        @HPos           - UUT horizontal (Trigger) position
#
#  Global String Variables:
#        @Wait           - Measurement delay value (seconds)
#        @DC_Coupling    - Channel coupling mode (1 = DC, 0 = AC)
#        @VertDiv        - Vertical division value of test signal
#        @Ampl           - Amplitue value of test signal
#        @Freq           - Frequency value of test signal
#        @NumChan        - Number of Scope Channel of UUT
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Set measurement delay to 3 seconds.
  1.001  MATH         @Wait = 3

  1.002  IF           ZCMPI(@Chan, "A")
  1.003  MATH         QueryCmd = "QM 11"; ChKeyCmd = "KY 11"
  1.004  ELSEIF       ZCMPI(@Chan, "B")
  1.005  MATH         QueryCmd = "QM 21"; ChKeyCmd = "KY 18"
  1.006  ELSEIF       ZCMPI(@Chan, "C")
  1.007  MATH         QueryCmd = "QM 31"; ChKeyCmd = "KY 19"
  1.008  ELSEIF       ZCMPI(@Chan, "D")
  1.009  MATH         QueryCmd = "QM 41"; ChKeyCmd = "KY 20"
  1.010  ELSE
  1.011  DISP         @Chan must be A, B, C, or D!
  1.012  END
  1.013  ENDIF

  1.014  IF           @NumChan > 2
  1.015  MATH         @Input = "A&B&C&D"
  1.016  ELSE
  1.017  MATH         @Input = "A&B"
  1.018  ENDIF

  1.019  JMPL         FREQUENCY                    PSUBI("Freq Meas")
  1.020  JMPL         PHASE                        PSUBI("Phase Meas")
  1.021  DISP         Called subprocedure not found!
  1.022  END

  1.023  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL  ================

  2.001  LABEL        FREQUENCY

  2.002  IF           ZCMPI(@Chan, "A")
  2.003  RSLT         =
  2.004  RSLT         =FREQUENCY MEASUREMENT ACCURACY
  2.005  ENDIF

  2.006  RSLT         =
  2.007  HEAD         FREQUENCY MEASUREMENT ACCURACY: {Input [V @Chan]}

  2.008  IF           ZCMPI(@Chan, "A")
  2.009  MATH         @DC_Coupling = 1
  2.010  MATH         @BW_Setup    = "FULL BW"
  2.011  MATH         @HPos        = "2 div"
  2.012  MATH         @Reading     = "Frequency"
  2.013  ENDIF

  2.014  TARGET       -p

# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets:
#  @Range    = "Auto"
#  @Timebase = "Auto"
  2.015  IF           ZCMPI(@Chan, "A")
  2.016  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  2.017  CALL         Sub Fluke 190II Setup Scope Reading RS-232

  2.018  IF           @NumChan > 2

  2.019  IF           ZCMPI(SUB(@ModelNum, 1, 3), "THS")
  2.020  PIC          THS3000_abcd_input_55_scope.png
  2.021  ELSE
  2.022  PIC          190II_abcd_input_55_scope.jpg
  2.023  ENDIF

  2.024  DISP         The next routine operator intervention will occur
  2.024  DISP         in approximately 4 minutes...
  2.024  DISP
  2.024  DISP         Note: The time estimate assumes that the procedure
  2.024  DISP         default values for NTHROW and NMEAS are being used. Any
  2.024  DISP         changes made to your workstation configuration may
  2.024  DISP         affect the time interval between connection changes.

  2.025  ELSE
  2.026  PIC          190II_ab_input_55_scope.png
  2.027  DISP         The next routine operator intervention will occur
  2.027  DISP         in approximately 2 minutes...
  2.027  DISP
  2.027  DISP         Note: The time estimate assumes that the procedure
  2.027  DISP         default values for NTHROW and NMEAS are being used. Any
  2.027  DISP         changes made to your workstation configuration may
  2.027  DISP         affect the time interval between connection changes.
  2.028  ENDIF

  2.029  ENDIF        ; ZCMPI(@Chan, "A")

  2.030  MATH         @Cmd = ChKeyCmd
  2.031  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
  2.032  MATH         @Cmd = "KY 34"
  2.033  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.034  MATH         @Range       = "100 mV/div"
  2.035  CALL         Sub Fluke 190II Setup Scope Range RS-232
  2.036  MATH         @Timebase    = "20 ms/div"
  2.037  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  2.038  O_CAL        Mode = WaveGen; Waveform = Sine; OutputImp = 1 MOhm
  2.038  O_CAL        +Frequency = 16.00 Hz; Voltage = 600 mVpp
  2.039  MATH         @Cmd = QueryCmd
  2.040  TARGET       -m
  2.041  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  2.042  MEMCX        16.00Hz        0.5% 0.02U    600mVpp

  3.001  O_CAL        Standby

  3.002  MATH         @Range    = "50 mV/div"
  3.003  MATH         @Timebase = "20 ns/div"
  3.004  TARGET       -p
  3.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  3.006  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232

  3.007  IF           @Bandwidth == 60E+6
  3.008  MATH         FreqMHz = 100
  3.009  ELSEIF       @Bandwidth == 100E+6
  3.010  MATH         FreqMHz = 100
  3.011  ELSEIF       @Bandwidth == 200E+6
  3.012  MATH         FreqMHz = 200
  3.013  ELSE
  3.014  MATH         FreqMHz = 500.0
  3.015  ENDIF

  3.016  O_CAL        Mode = LeveledSine
  3.016  O_CAL        +Frequency = [V FreqMHz] MHz; Voltage = 300 mVpp
  3.017  MATH         @Cmd = QueryCmd
  3.018  TARGET       -m
  3.019  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  3.020  MATH         MEM = MEM / 1E+6
  3.021  MEMCX        MHz            0.5% 0.2U     300mVpp

  4.001  HEAD
  4.002  O_CAL        Standby
  4.003  END

  4.004  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL  ===============

  5.001  LABEL        PHASE

  5.002  IF           ZCMPI(@Chan, "A")
  5.003  RSLT         =
  5.004  RSLT         =PHASE MEASUREMENT
  5.005  ENDIF

  5.006  RSLT         =
  5.007  HEAD         PHASE MEASUREMENT: {Input [V @Chan]}

  5.008  IF           ZCMPI(@Chan, "A")
  5.009  MATH         @DC_Coupling = 1
  5.010  MATH         @BW_Setup    = "FULL BW"
  5.011  MATH         @HPos        = "2 div"
  5.012  MATH         @Reading     = "Phase"
  5.013  ENDIF

  5.014  TARGET       -p

# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets:
#  @Range    = "Auto"
#  @Timebase = "Auto"
  5.015  IF           ZCMPI(@Chan, "A")
  5.016  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  5.017  MATH         @Range = "100 mV/div"
  5.018  CALL         Sub Fluke 190II Setup Scope Range RS-232
  5.019  CALL         Sub Fluke 190II Setup Scope Reading RS-232
  5.020  ENDIF

  5.021  MATH         @Cmd = ChKeyCmd
  5.022  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
  5.023  MATH         @Cmd = "KY 34"
  5.024  CALL         Sub Fluke ScopeMeter Send Command RS-232
  5.025  MATH         @Timebase    = "20 ms/div"
  5.026  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  5.027  O_CAL        Mode = WaveGen; OutputImpedance = 50 Ohms
  5.027  O_CAL        +Voltage = 300 mVpp; Frequency = 10 Hz; Waveform = Sine
  5.028  ACC          0deg           0.5U
  5.029  MATH         @Cmd = QueryCmd
  5.030  TARGET       -m
  5.031  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  5.032  MEMCX        0deg           2U            10Hz

  6.001  MATH         @Timebase = "200 ns/div"
  6.002  TARGET       -p
  6.003  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  6.004  O_CAL        Mode = LeveledSine
  6.004  O_CAL        +Voltage = 300 mVpp; Frequency = 1 MHz
  6.005  ACC          0deg           0.5U
  6.006  MATH         @Cmd = QueryCmd
  6.007  TARGET       -m
  6.008  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  6.009  MEMCX        0deg           2U            1MHz

  7.001  MATH         @Timebase = "20 ns/div"
  7.002  TARGET       -p
  7.003  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  7.004  O_CAL        Mode = LeveledSine
  7.004  O_CAL        +Voltage = 300 mVpp; Frequency = 10 MHz
  7.005  ACC          0deg           0.5U
  7.006  MATH         @Cmd = QueryCmd
  7.007  TARGET       -m
  7.008  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  7.009  MEMCX        0deg           3U            10MHz

  8.001  HEAD         -2
  8.002  HEAD
  8.003  O_CAL        Standby
  8.004  END
