﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL
INSTRUMENT:            Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL
DATE:                  2013-12-18 11:54:00
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       9
NUMBER OF LINES:       238
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables
#        @MeasMode       - Guardbanding method used
#        @Chan           - Name of Channel under tested
#        @Input          - Name of Channel calibrator input connected
#        @BW_Setup       - Channel bandwidth limit setup
#        @Cmd            - Command string sent to UUT
#        @Range          - Channel Scope range
#        @Reading        - Channel reading type
#        @Timebase       - UUT timebase setting
#        @HPos           - UUT horizontal (Trigger) position
#
#  Global String Variables:
#        @Wait           - Measurement delay value (seconds)
#        @DC_Coupling    - Channel coupling mode (1 = DC, 0 = AC)
#        @VertDiv        - Vertical division value of test signal
#        @Ampl           - Amplitue value of test signal
#        @Freq           - Frequency value of test signal
#        @NumChan        - Number of Scope Channel of UUT
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Set measurement delay to 3 seconds.
  1.001  MATH         @Wait = 3
  1.002  MATH         @Input = @Chan

  1.003  IF           ZCMPI(@Chan, "A")
  1.004  MATH         QueryCmd = "QM 11"; ChKeyCmd = "KY 11"
  1.005  ELSEIF       ZCMPI(@Chan, "B")
  1.006  MATH         QueryCmd = "QM 21"; ChKeyCmd = "KY 18"
  1.007  ELSEIF       ZCMPI(@Chan, "C")
  1.008  MATH         QueryCmd = "QM 31"; ChKeyCmd = "KY 19"
  1.009  ELSEIF       ZCMPI(@Chan, "D")
  1.010  MATH         QueryCmd = "QM 41"; ChKeyCmd = "KY 20"
  1.011  ELSE
  1.012  DISP         @Chan must be A, B, C, or D!
  1.013  END
  1.014  ENDIF

  1.015  JMPL         TRIG_SENS                    PSUBI("Trigger Sens")
  1.016  JMPL         VAC_HF                       PSUBI("Bandwidth")
  1.017  DISP         Called subprocedure not found!
  1.018  END

  1.019  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL  =============

  2.001  LABEL        TRIG_SENS

  2.002  IF           ZCMPI(@Chan, "A")
  2.003  RSLT         =
  2.004  RSLT         =TRIGGER SENSITIVITY
  2.005  ENDIF

  2.006  RSLT         =
  2.007  HEAD         TRIGGER SENSITIVITY: {Input [V @Chan]}
  2.008  MATH         @DC_Coupling = 1
  2.009  MATH         @BW_Setup    = "FULL BW"
  2.010  MATH         @Reading     = "AC Volts Rms"
  2.011  MATH         @HPos        = "2 div"
  2.012  MATH         @Freq        = "5 MHz"

  2.013  HEAD         -2 5 MHz, 0.5 divisions
  2.014  MATH         @VertDiv = 0.5; @Ampl = "100mV"
  2.015  TARGET
# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets:
#  @Range    = "Auto"
#  @Timebase = "Auto"
  2.016  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  2.017  MATH         @Range       = "200 mV/div"
  2.018  CALL         Sub Fluke 190II Setup Scope Range RS-232
  2.019  CALL         Sub Fluke 190II Setup Scope Reading RS-232

  2.020  IF           ZCMPI(@Chan, "B")

  2.021  IF           @NumChan > 2

  2.022  IF           ZCMPI(SUB(@ModelNum, 1, 3), "THS")
  2.023  PIC          THS3000_4ch_b_input_55_scope.png
  2.024  ELSE
  2.025  PIC          190II_4ch_b_input_55_scope.png
  2.026  ENDIF

  2.027  ELSE
  2.028  PIC          190II_2ch_b_input_55_scope.png
  2.029  ENDIF

  2.030  ELSEIF       ZCMPI(@Chan, "C")
  2.031  PIC          190II_c_input_55_scope.png
  2.032  ELSEIF       ZCMPI(@Chan, "D")
  2.033  PIC          190II_d_input_55_scope.png
  2.034  ENDIF

  2.035  MATH         @Cmd = ChKeyCmd
  2.036  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
  2.037  MATH         @Cmd = "KY 34"
  2.038  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.039  MATH         @Timebase    = "200 ns/div"
  2.040  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  2.041  CALL         Sub Fluke 190II Trigger Sens. Adjust RS-232 /O_CAL
  2.042  EVAL   -e @Status : Triggered: 5 MHz @ 0.5 div.

# Test 1 div trigger sensitivity.
  3.001  MATH         @Freq = FMT(@Bandwidth / 1E+6, "%.0f") & " MHz"
  3.002  HEAD         -2 [V @Freq], 1 division
  3.003  MATH         @VertDiv = 1; @Ampl = "200mV"
  3.004  TARGET

  3.005  IF           @Bandwidth >= 500E+6
  3.006  MATH         @Timebase = "5 ns/div"
  3.007  ELSE
  3.008  MATH         @Timebase = "10 ns/div"
  3.009  ENDIF

  3.010  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  3.011  CALL         Sub Fluke 190II Trigger Sens. Adjust RS-232 /O_CAL
  3.012  EVAL   -e @Status : Triggered: [V @Freq] @ 1 div.

# Test 2 div trigger sensitivity.
  4.001  IF           @Bandwidth == 60E+6
  4.002  MATH         @Freq = "100 MHz"
  4.003  ELSEIF       @Bandwidth == 100E+6
  4.004  MATH         @Freq = "150 MHz"
  4.005  ELSEIF       @Bandwidth == 200E+6
  4.006  MATH         @Freq = "250 MHz"
  4.007  ELSE         ; @Bandwidth == 500E+6
  4.008  MATH         @Freq = "600 MHz"
  4.009  ENDIF

  4.010  HEAD         -2 [V @Freq], 2 divisions
  4.011  MATH         @VertDiv = 2; @Ampl = "400mV"
  4.012  TARGET
  4.013  CALL         Sub Fluke 190II Trigger Sens. Adjust RS-232 /O_CAL
  4.014  EVAL   -e @Status : Triggered: [V @Freq] @ 2 div.

  5.001  HEAD         -2
  5.002  HEAD
  5.003  O_CAL        Standby
  5.004  END

  5.005  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL  ================

  6.001  LABEL        VAC_HF

  6.002  IF           ZCMPI(@Chan, "A")
  6.003  RSLT         =
  6.004  RSLT         =AC VOLTAGE ACCURACY (HF) & BANDWIDTH
  6.005  ENDIF

  6.006  RSLT         =
  6.007  HEAD         ACV ACCURACY (HF) & BANDWIDTH: {Input [V @Chan]}
  6.008  MATH         @DC_Coupling = 1
  6.009  MATH         @BW_Setup    = "FULL BW"
  6.010  MATH         @Reading     = "AC Volts Rms"
  6.011  TARGET       -p
# Note, "Sub Fluke 190II Setup Scope Channel RS-232" sets:
#  @Range    = "Auto"
#  @Timebase = "Auto"
  6.012  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  6.013  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  6.014  MATH         @Range       = "500 mV/div"
  6.015  CALL         Sub Fluke 190II Setup Scope Range RS-232
  6.016  CALL         Sub Fluke 190II Setup Scope Reading RS-232
  6.017  MATH         @Cmd = ChKeyCmd
  6.018  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
  6.019  MATH         @Cmd = "KY 34"
  6.020  CALL         Sub Fluke ScopeMeter Send Command RS-232
  6.021  O_CAL        Mode = LeveledSine
  6.021  O_CAL        +Voltage = 900 mV; Frequency = 1 MHz
  6.022  MATH         @Cmd = QueryCmd
  6.023  TARGET       -m
  6.024  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  6.025  MATH         MEM = MEM / 1E-3
  6.026  MEMCX  900   900mV          5/ 20U        1MHz

  7.001  O_CAL        Mode = LeveledSine
  7.001  O_CAL        +Voltage = 900 mV; Frequency = 25 MHz
  7.002  TARGET       -m
  7.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  7.004  MATH         MEM = MEM / 1E-3
  7.005  MEMCX  900   900mV          10/ 20U       25MHz

  8.001  MATH         Frequency = FMT(@Bandwidth / 1E+6, "%.0f") & " MHz"
  8.002  HEAD         -2 [V Frequency]
  8.003  TARGET
  8.004  O_CAL        Mode = LeveledSine
  8.004  O_CAL        +Frequency = [V @Bandwidth] Hz; Voltage = 900 mV
  8.005  TARGET       -m
  8.006  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
  8.007  MATH         MEM = MEM / 1E-3
  8.008  EVAL   -e  MEM > 630 : [32] [MEM] mV @ [V Frequency]

  9.001  HEAD         -2
  9.002  HEAD
  9.003  O_CAL        Standby
  9.004  END
