﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502
INSTRUMENT:            Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502
INSTRUMENT:            Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502
INSTRUMENT:            Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502
INSTRUMENT:            Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502
DATE:                  2013-12-17 11:45:46
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       70
NUMBER OF LINES:       977
CONFIGURATION:         Fluke 5502A
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables
#        @MeasMode       - Guardbanding method used
#        @Chan           - Name of Channel under tested
#        @Input          - Name of Channel calibrator input connected
#        @BW_Setup       - Channel bandwidth limit setup
#        @Cmd            - Command string sent to UUT
#        @Range          - Channel Scope range
#        @Reading        - Channel reading type
#        @Timebase       - UUT timebase setting
#        @HPos           - UUT horizontal (Trigger) position
#        @Nominal        - Nominal value of test
#
#  Global String Variables:
#        @Wait           - Measurement delay value (seconds)
#        @DC_Coupling    - Channel coupling mode (1 = DC, 0 = AC)
#        @SysAcc         - System accuracy
#        @NumChan        - Number of Scope Channel of UUT
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         THS3000 = ZCMPI(SUB(@ModelNum, 1, 3), "THS")

# Set measurement delay to 1 seconds.
  1.002  MATH         @Wait = 1

  1.003  IF           ZCMPI(@Chan, "A")
  1.004  MATH         QueryCmd = "QM 11"; ChKeyCmd = "KY 11"
  1.005  ELSEIF       ZCMPI(@Chan, "B")
  1.006  MATH         QueryCmd = "QM 21"; ChKeyCmd = "KY 18"
  1.007  ELSEIF       ZCMPI(@Chan, "C")
  1.008  MATH         QueryCmd = "QM 31"; ChKeyCmd = "KY 19"
  1.009  ELSEIF       ZCMPI(@Chan, "D")
  1.010  MATH         QueryCmd = "QM 41"; ChKeyCmd = "KY 20"
  1.011  ELSE
  1.012  DISP         @Chan must be A, B, C, or D!
  1.013  END
  1.014  ENDIF

  1.015  IF           @NumChan > 2
  1.016  MATH         @Input = "A&B&C&D"
  1.017  ELSE
  1.018  MATH         @Input = "A&B"
  1.019  ENDIF

  1.020  JMPL         VERTICAL                     PSUBI("Vertical Acc")
  1.021  JMPL         DCV                          PSUBI("DCV Acc")
  1.022  JMPL         ACV_DC_COUPLED               PSUBI("ACV DC Coup Acc")
  1.023  JMPL         ACV_AC_COUPLED               PSUBI("ACV AC Coup Acc")
  1.024  JMPL         VPK                          PSUBI("V Peak Meas")
  1.025  DISP         Subprocedure not found!
  1.026  END

  1.027  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502 ===============

  2.001  LABEL        VERTICAL

  2.002  IF           ZCMPI(@Chan, "A")
  2.003  RSLT         =
  2.004  RSLT         =VERTICAL (CURSOR) ACCURACY
  2.005  ENDIF

  2.006  RSLT         =
  2.007  HEAD         VERTICAL (CURSOR) ACCURACY: {Input [V @Chan]}
  2.008  TARGET       -p

  2.009  IF           ZCMPI(@Chan, "A")
  2.010  MATH         @DC_Coupling = 1; @BW_Setup = "20 kHz"
  2.011  CALL         Sub Fluke 190II Setup Scope Channel RS-232
  2.012  MATH         @Timebase = "10 ms/div"; @HPos = "2 div"
  2.013  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
  2.014  MATH         @Range = "100 mV/div"
  2.015  CALL         Sub Fluke 190II Setup Scope Range RS-232

  2.016  IF           @NumChan > 2

  2.017  IF           THS3000
  2.018  PIC          THS3000_abcd_input_55.png
  2.019  ELSE
  2.020  PIC          190ii_abcd_input_55.jpg
  2.021  ENDIF

  2.022  DISP         The next routine operator intervention will occur
  2.022  DISP         in approximately 46 minutes...
  2.022  DISP
  2.022  DISP         Note: The time estimate assumes that the procedure
  2.022  DISP         default values for NTHROW and NMEAS are being used. Any
  2.022  DISP         changes made to your workstation configuration may
  2.022  DISP         affect the time interval between connection changes.

  2.023  ELSE         ; @NumChan <= 2
  2.024  PIC          190II_ab_input_55.png
  2.025  DISP         The next routine operator intervention will occur
  2.025  DISP         in approximately 23 minutes...
  2.025  DISP
  2.025  DISP         Note: The time estimate assumes that the procedure
  2.025  DISP         default values for NTHROW and NMEAS are being used. Any
  2.025  DISP         changes made to your workstation configuration may
  2.025  DISP         affect the time interval between connection changes.
  2.026  ENDIF

  2.027  ENDIF        ; ZCMPI(@Chan, "A")

# Press the button of channel under test to make its trace
# displayed in the front and its backlight illuminated.
  2.028  MATH         @Cmd = ChKeyCmd
  2.029  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
  2.030  MATH         @Cmd = "KY 34"
  2.031  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.032  RSLT         =
  2.033  HEAD         -2{2 mV/div}
  2.034  MATH         @Range = "2 mV/div"; @Nominal = 12E-3
  2.035  TARGET       -p
  2.036  CALL         Sub Fluke 190II Setup Scope Cursor RS-232
  2.037  CALL         Sub Fluke 190II Setup Scope Range RS-232
  2.038  TARGET       -m
  2.039  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
# Convert system accuracy to millivolts.
  2.040  MATH         L[1] = @SysAcc / 1E-3
  2.041  ACC          12.00mV        L1U
# Convert measurement to millivolts.
  2.042  MATH         MEM = MEM / 1E-3
# The UUT % of range/div is doubled because 2 measurements are done
# for one accuracy check in the following tests.
  2.043  MEMCX  2     12.00mV        2.9% 16/

  3.001  RSLT         =
  3.002  HEAD         -2{5 mV/div}
  3.003  MATH         @Range = "5 mV/div"; @Nominal = 30E-3
  3.004  TARGET       -p
  3.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  3.006  TARGET       -m
  3.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  3.008  MATH         L[1] = @SysAcc / 1E-3
  3.009  ACC          30.00mV        L1U
  3.010  MATH         MEM = MEM / 1E-3
  3.011  MEMCX  5     30.00mV        2.1% 8/

  4.001  RSLT         =
  4.002  HEAD         -2{10 mV/div}
  4.003  MATH         @Range = "10 mV/div"; @Nominal = 60E-3
  4.004  TARGET       -p
  4.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  4.006  TARGET       -m
  4.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  4.008  MATH         L[1] = @SysAcc / 1E-3
  4.009  ACC          60.00mV        L1U
  4.010  MATH         MEM = MEM / 1E-3
  4.011  MEMCX  10    60.00mV        2.1% 8/

  5.001  RSLT         =
  5.002  HEAD         -2{20 mV/div}
  5.003  MATH         @Range = "20 mV/div"; @Nominal = 120E-3
  5.004  TARGET       -p
  5.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  5.006  TARGET       -m
  5.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  5.008  MATH         L[1] = @SysAcc / 1E-3
  5.009  ACC          120.0mV        L1U
  5.010  MATH         MEM = MEM / 1E-3
  5.011  MEMCX  20    120.0mV        2.1% 8/

  6.001  RSLT         =
  6.002  HEAD         -2{50 mV/div}
  6.003  MATH         @Range = "50 mV/div"; @Nominal = 300E-3
  6.004  TARGET       -p
  6.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  6.006  TARGET       -m
  6.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  6.008  MATH         L[1] = @SysAcc / 1E-3
  6.009  ACC          300.0mV        L1U
  6.010  MATH         MEM = MEM / 1E-3
  6.011  MEMCX  50    300.0mV        2.1% 8/

  7.001  RSLT         =
  7.002  HEAD         -2{100 mV/div}
  7.003  MATH         @Range = "100 mV/div"; @Nominal = 600E-3
  7.004  TARGET       -p
  7.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  7.006  TARGET       -m
  7.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  7.008  MATH         L[1] = @SysAcc / 1E-3
  7.009  ACC          600.0mV        L1U
  7.010  MATH         MEM = MEM / 1E-3
  7.011  MEMCX  100   600.0mV        2.1% 8/

  8.001  RSLT         =
  8.002  HEAD         -2{200 mV/div}
  8.003  MATH         @Range = "200 mV/div"; @Nominal = 1.2
  8.004  TARGET       -p
  8.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  8.006  TARGET       -m
  8.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  8.008  MATH         L[1] = @SysAcc
  8.009  ACC          1.200V         L1U
  8.010  MEMCX  0.2   1.200V         2.1% 8/

  9.001  RSLT         =
  9.002  HEAD         -2{500 mV/div}
  9.003  MATH         @Range = "500 mV/div"; @Nominal = 3
  9.004  TARGET       -p
  9.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
  9.006  TARGET       -m
  9.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
  9.008  MATH         L[1] = @SysAcc
  9.009  ACC          3.000V         L1U
  9.010  MEMCX  0.5   3.000V         2.1% 8/

 10.001  RSLT         =
 10.002  HEAD         -2{1 V/div}
 10.003  MATH         @Range = "1 V/div"; @Nominal = 6
 10.004  TARGET       -p
 10.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 10.006  TARGET       -m
 10.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 10.008  MATH         L[1] = @SysAcc
 10.009  ACC          6.000V         L1U
 10.010  MEMCX  1     6.000V         2.1% 8/

 11.001  RSLT         =
 11.002  HEAD         -2{2 V/div}
 11.003  MATH         @Range = "2 V/div"; @Nominal = 12
 11.004  TARGET       -p
 11.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 11.006  TARGET       -m
 11.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 11.008  MATH         L[1] = @SysAcc
 11.009  ACC          12.00V         L1U
 11.010  MEMCX  2     12.00V         2.1% 8/

 12.001  RSLT         =
 12.002  HEAD         -2{5 V/div}
 12.003  MATH         @Range = "5 V/div"; @Nominal = 30
 12.004  TARGET       -p
 12.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 12.006  TARGET       -m
 12.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 12.008  MATH         L[1] = @SysAcc
 12.009  ACC          30.00V         L1U
 12.010  MEMCX  5     30.00V         2.1% 8/

 13.001  RSLT         =
 13.002  HEAD         -2{10 V/div}
 13.003  MATH         @Range = "10 V/div"; @Nominal = 60
 13.004  TARGET       -p
 13.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 13.006  TARGET       -m
 13.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 13.008  MATH         L[1] = @SysAcc
 13.009  ACC          60.00V         L1U
 13.010  MEMCX  10    60.00V         2.1% 8/

 14.001  RSLT         =
 14.002  HEAD         -2{20 V/div}
 14.003  MATH         @Range = "20 V/div"; @Nominal = 120
 14.004  TARGET       -p
 14.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 14.006  TARGET       -m
 14.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 14.008  MATH         L[1] = @SysAcc
 14.009  ACC          120.0V         L1U
 14.010  MEMCX  20    120.0V         2.1% 8/

 15.001  RSLT         =
 15.002  HEAD         -2{50 V/div}
 15.003  MATH         @Range = "50 V/div"; @Nominal = 300
 15.004  TARGET       -p
 15.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 15.006  TARGET       -m
 15.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 15.008  MATH         L[1] = @SysAcc
 15.009  ACC          300.0V         L1U
 15.010  MEMCX  50    300.0V         2.1% 8/

 16.001  RSLT         =
 16.002  HEAD         -2{100 V/div}
 16.003  MATH         @Range = "100 V/div"; @Nominal = 600
 16.004  TARGET       -p
 16.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 16.006  TARGET       -m
 16.007  CALL         Sub Fluke 190II Check Vertical Gain RS-232 /5502
 16.008  MATH         L[1] = @SysAcc
 16.009  ACC          600.0V         L1U
 16.010  MEMCX  100   600.0V         2.1% 8/

 17.001  HEAD         -2
 17.002  HEAD
 17.003  5502A        Standby
 17.004  END

 17.005  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502  ===================

 18.001  LABEL        DCV

 18.002  IF           ZCMPI(@Chan, "A")
 18.003  RSLT         =
 18.004  RSLT         =DC VOLTAGE ACCURACY
 18.005  ENDIF

 18.006  RSLT         =
 18.007  HEAD         DC VOLTAGE ACCURACY: {Input [V @Chan]}
 18.008  RSLT         =
 18.009  HEAD         -2{2 mV/div}
 18.010  MATH         @Range = "2 mV/div"
 18.011  TARGET       -p

 18.012  IF           ZCMPI(@Chan, "A")
 18.013  MATH         @DC_Coupling = 1; @BW_Setup = "20 kHz"
 18.014  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 18.015  MATH         @Timebase = "10 ms/div"; @HPos = "2 div"
 18.016  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 18.017  MATH         @Reading = "DC Volts Mean"
 18.018  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 18.019  ENDIF

# Press the button of channel under test to make its trace
# displayed in the front and its backlight illuminated.
 18.020  MATH         @Cmd = ChKeyCmd
 18.021  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
 18.022  MATH         @Cmd = "KY 34"
 18.023  CALL         Sub Fluke ScopeMeter Send Command RS-232
 18.024  CALL         Sub Fluke 190II Setup Scope Range RS-232
 18.025  5502A        +Voltage = +6.0 mV
 18.026  MATH         @Cmd = QueryCmd
 18.027  TARGET       -m
 18.028  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 18.029  MATH         MEM = MEM / 1E-3
 18.030  MEMCX  2     +6.0mV         1.5% 1.0U

 19.001  5502A        +Voltage = -6.0 mV
 19.002  TARGET       -m
 19.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 19.004  MATH         MEM = MEM / 1E-3
 19.005  MEMCX  2     -6.0mV         1.5% 1.0U

 20.001  RSLT         =
 20.002  HEAD         -2{5 mV/div}
 20.003  MATH         @Range = "5 mV/div"
 20.004  TARGET       -p
 20.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 20.006  5502A        +Voltage = +15.0 mV
 20.007  MATH         @Cmd = QueryCmd
 20.008  TARGET       -m
 20.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 20.010  MATH         MEM = MEM / 1E-3
 20.011  MEMCX  5     +15.0mV        1.5% 0.5U

 21.001  5502A        +Voltage = -15.0 mV
 21.002  TARGET       -m
 21.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 21.004  MATH         MEM = MEM / 1E-3
 21.005  MEMCX  5     -15.0mV        1.5% 0.5U

 22.001  RSLT         =
 22.002  HEAD         -2{10 mV/div}
 22.003  MATH         @Range = "10 mV/div"
 22.004  TARGET       -p
 22.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 22.006  5502A        +Voltage = +30.0 mV
 22.007  MATH         @Cmd = QueryCmd
 22.008  TARGET       -m
 22.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 22.010  MATH         MEM = MEM / 1E-3
 22.011  MEMCX  10    +30.0mV        1.5% 0.5U

 23.001  5502A        +Voltage = -30.0 mV
 23.002  TARGET       -m
 23.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 23.004  MATH         MEM = MEM / 1E-3
 23.005  MEMCX  10    -30.0mV        1.5% 0.5U

 24.001  RSLT         =
 24.002  HEAD         -2{20 mV/div}
 24.003  MATH         @Range = "20 mV/div"
 24.004  TARGET       -p
 24.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 24.006  5502A        +Voltage = +60.0 mV
 24.007  MATH         @Cmd = QueryCmd
 24.008  TARGET       -m
 24.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 24.010  MATH         MEM = MEM / 1E-3
 24.011  MEMCX  60    +60.0mV        1.5% 0.5U

 25.001  5502A        +Voltage = -60.0 mV
 25.002  TARGET       -m
 25.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 25.004  MATH         MEM = MEM / 1E-3
 25.005  MEMCX  60    -60.0mV        1.5% 0.5U

 26.001  RSLT         =
 26.002  HEAD         -2{50 mV/div}
 26.003  MATH         @Range = "50 mV/div"
 26.004  TARGET       -p
 26.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 26.006  5502A        +Voltage = +100 mV
 26.007  MATH         @Cmd = QueryCmd
 26.008  TARGET       -m
 26.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 26.010  MATH         MEM = MEM / 1E-3
 26.011  MEMCX  50    +100mV         1.5% 5U

 27.001  5502A        +Voltage = -100 mV
 27.002  TARGET       -m
 27.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 27.004  MATH         MEM = MEM / 1E-3
 27.005  MEMCX  50    -100mV         1.5% 5U

 28.001  RSLT         =
 28.002  HEAD         -2{100 mV/div}
 28.003  MATH         @Range = "100 mV/div"
 28.004  TARGET       -p
 28.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 28.006  5502A        +Voltage = +300 mV
 28.007  MATH         @Cmd = QueryCmd
 28.008  TARGET       -m
 28.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 28.010  MATH         MEM = MEM / 1E-3
 28.011  MEMCX  100   +300mV         1.5% 5U

 29.001  5502A        +Voltage = -300 mV
 29.002  TARGET       -m
 29.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 29.004  MATH         MEM = MEM / 1E-3
 29.005  MEMCX  100   -300mV         1.5% 5U

 30.001  RSLT         =
 30.002  HEAD         -2{200 mV/div}
 30.003  MATH         @Range = "200 mV/div"
 30.004  TARGET       -p
 30.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 30.006  5502A        +Voltage = +600 mV
 30.007  MATH         @Cmd = QueryCmd
 30.008  TARGET       -m
 30.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 30.010  MATH         MEM = MEM / 1E-3
 30.011  MEMCX  200   +600mV         1.5% 5U

 31.001  5502A        +Voltage = -600 mV
 31.002  TARGET       -m
 31.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 31.004  MATH         MEM = MEM / 1E-3
 31.005  MEMCX  200   -600mV         1.5% 5U

 32.001  RSLT         =
 32.002  HEAD         -2{500 mV/div}
 32.003  MATH         @Range = "500 mV/div"
 32.004  TARGET       -p
 32.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 32.006  5502A        +Voltage = +1.00 V
 32.007  MATH         @Cmd = QueryCmd
 32.008  TARGET       -m
 32.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 32.010  MEMCX  500   +1.00V         1.5% 0.05U

 33.001  5502A        +Voltage = -1.00 V
 33.002  TARGET       -m
 33.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 33.004  MEMCX  500   -1.00V         1.5% 0.05U

 34.001  RSLT         =
 34.002  HEAD         -2{1 V/div}
 34.003  MATH         @Range = "1 V/div"
 34.004  TARGET       -p
 34.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 34.006  5502A        +Voltage = +3.00 V
 34.007  MATH         @Cmd = QueryCmd
 34.008  TARGET       -m
 34.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 34.010  MEMCX  1     +3.00V         1.5% 0.05U

 35.001  5502A        +Voltage = -3.00 V
 35.002  TARGET       -m
 35.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 35.004  MEMCX  1     -3.00V         1.5% 0.05U

 36.001  RSLT         =
 36.002  HEAD         -2{2 V/div}
 36.003  MATH         @Range = "2 V/div"
 36.004  TARGET       -p
 36.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 36.006  5502A        +Voltage = +6.00 V
 36.007  MATH         @Cmd = QueryCmd
 36.008  TARGET       -m
 36.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 36.010  MEMCX  2     +6.00V         1.5% 0.05U

 37.001  5502A        +Voltage = -6.00 V
 37.002  TARGET       -m
 37.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 37.004  MEMCX  2     -6.00V         1.5% 0.05U

 38.001  RSLT         =
 38.002  HEAD         -2{5 V/div}
 38.003  MATH         @Range = "5 V/div"
 38.004  TARGET       -p
 38.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 38.006  5502A        +Voltage = +10.0 V
 38.007  MATH         @Cmd = QueryCmd
 38.008  TARGET       -m
 38.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 38.010  MEMCX  5     +10.0V         1.5% 0.5U

 39.001  5502A        +Voltage = -10.0 V
 39.002  TARGET       -m
 39.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 39.004  MEMCX  5     -10.0V         1.5% 0.5U

 40.001  RSLT         =
 40.002  HEAD         -2{10 V/div}
 40.003  MATH         @Range = "10 V/div"
 40.004  TARGET       -p
 40.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 40.006  5502A        +Voltage = +30.0 V
 40.007  MATH         @Cmd = QueryCmd
 40.008  TARGET       -m
 40.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 40.010  MEMCX  10    +30.0V         1.5% 0.5U

 41.001  5502A        +Voltage = -30.0 V
 41.002  TARGET       -m
 41.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 41.004  MEMCX  10    -30.0V         1.5% 0.5U

 42.001  RSLT         =
 42.002  HEAD         -2{20 V/div}
 42.003  MATH         @Range = "20 V/div"
 42.004  TARGET       -p
 42.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 42.006  5502A        +Voltage = +60.0 V
 42.007  MATH         @Cmd = QueryCmd
 42.008  TARGET       -m
 42.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 42.010  MEMCX  20    +60.0V         1.5% 0.5U

 43.001  5502A        +Voltage = -60.0 V
 43.002  TARGET       -m
 43.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 43.004  MEMCX  20    -60.0V         1.5% 0.5U

 44.001  RSLT         =
 44.002  HEAD         -2{50 V/div}
 44.003  MATH         @Range = "50 V/div"
 44.004  TARGET       -p
 44.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 44.006  TARGET       -p
 44.007  5502A        +Voltage = +100 V
 44.008  MATH         @Cmd = QueryCmd
 44.009  TARGET       -m
 44.010  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 44.011  MEMCX  50    +100V          1.5% 5U

 45.001  5502A        +Voltage = -100 V
 45.002  TARGET       -m
 45.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 45.004  MEMCX  50    -100V          1.5% 5U

 46.001  RSLT         =
 46.002  HEAD         -2{100 V/div}
 46.003  MATH         @Range = "100 V/div"
 46.004  TARGET       -p
 46.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 46.006  5502A        +Voltage = +300 V
 46.007  MATH         @Cmd = QueryCmd
 46.008  TARGET       -m
 46.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 46.010  MEMCX  300   +300V          1.5% 5U

 47.001  5502A        +Voltage = -300 V
 47.002  TARGET       -m
 47.003  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 47.004  MEMCX  300   -300V          1.5% 5U

 48.001  HEAD         -2
 48.002  HEAD
 48.003  5502A        Standby
 48.004  END

 48.005  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502  ===========

 49.001  LABEL        ACV_DC_COUPLED

 49.002  IF           ZCMPI(@Chan, "A")
 49.003  RSLT         =
 49.004  RSLT         =AC VOLTAGE ACCURACY (LF)
 49.005  RSLT         =
 49.006  RSLT         =DC Coupled
 49.007  ENDIF

 49.008  RSLT         =
 49.009  HEAD         AC VOLTAGE ACCURACY (LF): {Input [V @Chan]}
 49.010  MATH         @DC_Coupling = 1
 49.011  MATH         @HPos        = "2 div"
 49.012  MATH         @Reading     = "AC Volts Rms"

 49.013  RSLT         =
 49.014  HEAD         -2{2 mV/div}
 49.015  MATH         @Range    = "2 mV/div"
 49.016  MATH         @Timebase = "10 ms/div"
 49.017  MATH         @BW_Setup = "20 kHz"
 49.018  TARGET       -p
 49.019  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 49.020  CALL         Sub Fluke 190II Setup Scope Range RS-232
 49.021  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 49.022  CALL         Sub Fluke 190II Setup Scope Reading RS-232
# Press the button of channel under test to make its trace
# displayed in the front and its backlight illuminated.
 49.023  MATH         @Cmd = ChKeyCmd
 49.024  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
 49.025  MATH         @Cmd = "KY 34"
 49.026  CALL         Sub Fluke ScopeMeter Send Command RS-232
 49.027  5502A        +Voltage = 4.0 mV; Frequency = 60 Hz
 49.028  CALL         Sub Fluke 190II Setup Scope Range RS-232
 49.029  MATH         @Cmd = QueryCmd
 49.030  TARGET       -m
 49.031  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 49.032  MATH         MEM = MEM / 1E-3
 49.033  MEMCX  2     4.0mV          1.5% 1.0U     60Hz

 50.001  RSLT         =
 50.002  HEAD         -2{5 mV/div}
 50.003  MATH         @Range    = "5 mV/div"
 50.004  TARGET       -p
 50.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 50.006  5502A        +Voltage = 10.0 mV; Frequency = 60 Hz
 50.007  MATH         @Cmd = QueryCmd
 50.008  TARGET       -m
 50.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 50.010  MATH         MEM = MEM / 1E-3
 50.011  MEMCX  5     10.0mV         2.5% 1.5U     60Hz

 51.001  5502A        Standby

 51.002  RSLT         =
 51.003  HEAD         -2{10 mV/div}
 51.004  MATH         @Range    = "10 mV/div"
 51.005  MATH         @BW_Setup = "20 MHz"
 51.006  MATH         @Timebase = "20 us/div"
 51.007  TARGET       -p
 51.008  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 51.009  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 51.010  CALL         Sub Fluke 190II Setup Scope Range RS-232
 51.011  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 51.012  MATH         @Cmd = ChKeyCmd
 51.013  CALL         Sub Fluke ScopeMeter Send Command RS-232
 51.014  MATH         @Cmd = "KY 34"
 51.015  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Waveform glitch off.
 51.016  MATH         @Cmd = "PS"
 51.017  CALL         Sub Fluke ScopeMeter Send Command RS-232
 51.018  PORT         #0[160][35][0][1][0][0][13]
 51.019  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
 51.020  5502A        +Voltage = 20.0 mV; Frequency = 20 kHz
 51.021  MATH         @Cmd = QueryCmd
 51.022  TARGET       -m
 51.023  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 51.024  MATH         MEM = MEM / 1E-3
 51.025  MEMCX  10    20.0mV         2.5% 1.5U     20kHz

 52.001  RSLT         =
 52.002  HEAD         -2{20 mV/div}
 52.003  MATH         @Range = "20 mV/div"
 52.004  TARGET       -p
 52.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 52.006  5502A        +Voltage = 40.0 mV; Frequency = 20 kHz
 52.007  MATH         @Cmd = QueryCmd
 52.008  TARGET       -m
 52.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 52.010  MATH         MEM = MEM / 1E-3
 52.011  MEMCX  20    40.0mV         2.5% 1.5U     20kHz

 53.001  RSLT         =
 53.002  HEAD         -2{50 mV/div}
 53.003  MATH         @Range = "50 mV/div"
 53.004  TARGET       -p
 53.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 53.006  5502A        +Voltage = 100.0 mV; Frequency = 20 kHz
 53.007  MATH         @Cmd = QueryCmd
 53.008  TARGET       -m
 53.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 53.010  MATH         MEM = MEM / 1E-3
 53.011  MEMCX  50    100.0mV        2.5% 1.5U     20kHz

 54.001  RSLT         =
 54.002  HEAD         -2{100 mV/div}
 54.003  MATH         @Range = "100 mV/div"
 54.004  TARGET       -p
 54.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 54.006  5502A        +Voltage = 200 mV; Frequency = 20 kHz
 54.007  MATH         @Cmd = QueryCmd
 54.008  TARGET       -m
 54.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 54.010  MATH         MEM = MEM / 1E-3
 54.011  MEMCX  100   200mV          2.5% 15U      20kHz

 55.001  RSLT         =
 55.002  HEAD         -2{200 mV/div}
 55.003  MATH         @Range = "200 mV/div"
 55.004  TARGET       -p
 55.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 55.006  5502A        +Voltage = 400 mV; Frequency = 20 kHz
 55.007  MATH         @Cmd = QueryCmd
 55.008  TARGET       -m
 55.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 55.010  MATH         MEM = MEM / 1E-3
 55.011  MEMCX  200   400mV          2.5% 15U      20kHz

 56.001  5502A        Standby

 56.002  RSLT         =
 56.003  HEAD         -2{500 mV/div}
 56.004  MATH         @Range    = "500 mV/div"
 56.005  MATH         @Timebase = "10 ms/div"
 56.006  MATH         @BW_Setup = "20 kHz"
 56.007  TARGET       -p
 56.008  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 56.009  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 56.010  CALL         Sub Fluke 190II Setup Scope Range RS-232
 56.011  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 56.012  MATH         @Cmd = ChKeyCmd
 56.013  CALL         Sub Fluke ScopeMeter Send Command RS-232
 56.014  MATH         @Cmd = "KY 34"
 56.015  CALL         Sub Fluke ScopeMeter Send Command RS-232
 56.016  5502A        +Voltage = 900 mV; Frequency = 60 Hz
 56.017  MATH         @Cmd = QueryCmd
 56.018  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 56.019  MATH         MEM = MEM / 1E-3
 56.020  MEMCX  500   900mV          1.5% 10U      60Hz

 57.001  5502A        Standby

 57.002  MATH         @Timebase = "20 us/div"
 57.003  MATH         @BW_Setup = "20 MHz"
 57.004  TARGET       -p
 57.005  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 57.006  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 57.007  CALL         Sub Fluke 190II Setup Scope Range RS-232
 57.008  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 57.009  MATH         @Cmd = ChKeyCmd
 57.010  CALL         Sub Fluke ScopeMeter Send Command RS-232
 57.011  MATH         @Cmd = "KY 34"
 57.012  CALL         Sub Fluke ScopeMeter Send Command RS-232
 57.013  5502A        +Voltage = 900 mV; Frequency = 20 kHz
 57.014  MATH         @Cmd = QueryCmd
 57.015  TARGET       -m
 57.016  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 57.017  MATH         MEM = MEM / 1E-3
 57.018  MEMCX  500   900mV          2.5% 15U      20kHz

 58.001  RSLT         =
 58.002  HEAD         -2{1 V/div}
 58.003  MATH         @Range = "1 V/div"
 58.004  TARGET       -p
 58.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 58.006  5502A        +Voltage = 2.00 V; Frequency = 20 kHz
 58.007  MATH         @Cmd = QueryCmd
 58.008  TARGET       -m
 58.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 58.010  MEMCX  1     2.00V          2.5% 0.15U    20kHz

 59.001  RSLT         =
 59.002  HEAD         -2{2 V/div}
 59.003  MATH         @Range = "2 V/div"
 59.004  TARGET       -p
 59.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 59.006  5502A        +Voltage = 4.00 V; Frequency = 20 kHz
 59.007  MATH         @Cmd = QueryCmd
 59.008  TARGET       -m
 59.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 59.010  MEMCX  2     4.00V          2.5% 0.15U    20kHz

 60.001  RSLT         =
 60.002  HEAD         -2{5 V/div}
 60.003  MATH         @Range = "5 V/div"
 60.004  TARGET       -p
 60.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 60.006  5502A        +Voltage = 9.00 V; Frequency = 20 kHz
 60.007  MATH         @Cmd = QueryCmd
 60.008  TARGET       -m
 60.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 60.010  MEMCX  5     9.00V          2.5% 0.15U    20kHz

 61.001  RSLT         =
 61.002  HEAD         -2{10 V/div}
 61.003  MATH         @Range = "10 V/div"
 61.004  TARGET       -p
 61.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 61.006  5502A        +Voltage = 20.0 V; Frequency = 20 kHz
 61.007  MATH         @Cmd = QueryCmd
 61.008  TARGET       -m
 61.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 61.010  MEMCX  10    20.0V          2.5% 1.5U     20kHz

 62.001  RSLT         =
 62.002  HEAD         -2{20 V/div}
 62.003  MATH         @Range = "20 V/div"
 62.004  TARGET       -p
 62.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 62.006  5502A        +Voltage = 40.0 V; Frequency = 20 kHz
 62.007  MATH         @Cmd = QueryCmd
 62.008  TARGET       -m
 62.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 62.010  MEMCX  20    40.0V          2.5% 1.5U     20kHz

 63.001  RSLT         =
 63.002  HEAD         -2{50 V/div}
 63.003  MATH         @Range = "50 V/div"
 63.004  TARGET       -p
 63.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 63.006  5502A        +Voltage = 90.0 V; Frequency = 20 kHz
 63.007  MATH         @Cmd = QueryCmd
 63.008  TARGET       -m
 63.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 63.010  MEMCX  50    90.0V          2.5% 1.5U     20kHz

 64.001  RSLT         =
 64.002  HEAD         -2{100 V/div}
 64.003  MATH         @Range = "100 V/div"
 64.004  TARGET       -p
 64.005  CALL         Sub Fluke 190II Setup Scope Range RS-232
 64.006  5502A        +Voltage = 200 V; Frequency = 20 kHz
 64.007  MATH         @Cmd = QueryCmd
 64.008  TARGET       -m
 64.009  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 64.010  MEMCX  100   200V           2.5% 15U      20kHz

 65.001  HEAD         -2
 65.002  HEAD
 65.003  5502A        Standby
 65.004  END

 65.005  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502  ===========

 66.001  LABEL        ACV_AC_COUPLED

 66.002  IF           ZCMPI(@Chan, "A")
 66.003  RSLT         =
 66.004  RSLT         =AC COUPLED LF TEST (500 mV/div)
 66.005  ENDIF

 66.006  RSLT         =
 66.007  HEAD         AC COUPLED LF TEST: {Input [V @Chan]}
 66.008  MATH         @HPos = "2 div"
 66.009  TARGET

 66.010  IF           ZCMPI(@Chan, "A")
 66.011  MATH         @DC_Coupling = 0; @BW_Setup = "20 kHz"
 66.012  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 66.013  MATH         @Range = "500 mV/div"
 66.014  CALL         Sub Fluke 190II Setup Scope Range RS-232
 66.015  MATH         @Reading = "AC Volts Rms"
 66.016  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 66.017  ENDIF

 66.018  MATH         @Cmd = ChKeyCmd
 66.019  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
 66.020  MATH         @Cmd = "KY 34"
 66.021  CALL         Sub Fluke ScopeMeter Send Command RS-232
 66.022  MATH         @Timebase = "10 ms/div"
 66.023  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 66.024  5502A        +Voltage = 900 mV; Frequency = 60 Hz
 66.025  MATH         @Cmd = QueryCmd
 66.026  TARGET       -m
 66.027  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 66.028  MATH         MEM = MEM / 1E-3
 66.029  MEMCX  500   900mV          1.9% 10U      60Hz

 67.001  MATH         @Timebase = "100 ms/div"
 67.002  TARGET       -p
 67.003  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 67.004  5502A        +Voltage = 900 mV; Frequency = 5 Hz
 67.005  MATH         @Cmd = QueryCmd
 67.006  TARGET       -m
 67.007  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
 67.008  MATH         MEM = MEM / 1E-3
 67.009  EVAL   -e MEM > 630 : [32] [MEM] mV @ 5 Hz, Limit > 630 mV

 68.001  HEAD
 68.002  5502A        Standby
 68.003  END

 68.004  EVAL   Increment Test Number

# =====  Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502  ===============

 69.001  LABEL        VPK

 69.002  IF           ZCMPI(@Chan, "A")
 69.003  RSLT         =
 69.004  RSLT         =PEAK MEASUREMENT
 69.005  ENDIF

 69.006  RSLT         =
 69.007  HEAD         PEAK MEASUREMENT: {Input [V @Chan]}
 69.008  RSLT         =
 69.009  HEAD         -2{100 mV/div}
 69.010  TARGET       -p

 69.011  IF           ZCMPI(@Chan, "A")
 69.012  MATH         @DC_Coupling = 1; @BW_Setup = "20 kHz"
 69.013  CALL         Sub Fluke 190II Setup Scope Channel RS-232
 69.014  MATH         @Timebase = "1 ms/div"; @HPos = "2 div"
 69.015  CALL         Sub Fluke 190II Setup Scope Timebase & Pos RS-232
 69.016  MATH         @Range = "100 mV/div"
 69.017  CALL         Sub Fluke 190II Setup Scope Range RS-232
 69.018  MATH         @Reading = "AC Volts Peak to Peak"
 69.019  CALL         Sub Fluke 190II Setup Scope Reading RS-232
 69.020  ENDIF

 69.021  MATH         @Cmd = ChKeyCmd
 69.022  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "CLEAR" button to close the softkey menu.
 69.023  MATH         @Cmd = "KY 34"
 69.024  CALL         Sub Fluke ScopeMeter Send Command RS-232
 69.025  5502A        +Voltage = 0.60 Vpp; Frequency = 1 kHz
 69.026  MATH         @Cmd = QueryCmd
 69.027  TARGET       -m
 69.028  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
# UUT Peak to peak accuracy is ±0.4 div.
 69.029  MEMCX  0.1   0.60Vpp        0.04U         1kHz

 70.001  HEAD         -2
 70.002  HEAD
 70.003  5502A        Standby
 70.004  END
